      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. RENFILE.

       WORKING-STORAGE SECTION.
       COPY "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  opensave-status         pic s9.
       77  file-name               pic x(256).
       77  new-name                pic x(256).
       77  wstatus                 pic s9.
       77  file-len                pic 9(3) value 0.
       77  full-len                pic 9(3) value 0.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.
       77  e-client                pic 9.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              .
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 label
              line                 4
              col                  2
              size                 4 cells
              title                "File:"
              .
           03 file-ren
              entry-field
              line                 6 
              col                  2
              value                file-name
              size                 62
              max-text             256
              .
           03 pb-choose
              push-button
              line                 6 
              col                  + 2
              title                "..."
              size                 3
              exception-value      101
              enabled              e-client
              self-act
              .
           03 label
              line                 8
              col                  2
              title                "New name:"
              size                 10 cells
              .
           03 file-new
              entry-field
              line                 10 
              col                  2
              value                new-name
              size                 62
              max-text             256
              .
           03 push-button
              line                 12 
              col                  2
              title                "&Rename"
              size                 10
              exception-value      102
              self-act
              .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           move 1                        to e-client
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "RENAME Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept
              evaluate crt-status
              when 101
                   perform CHOOSE-FILE
              when 102
                   perform RENAME-FILE
              when 103
                   if rb-value = 2
                      set client-execution   to true
                      move 1                 to e-client
                   else
                      set server-execution   to true
                      move zero              to e-client
                   end-if
                   modify pb-choose enabled e-client
              end-evaluate
              move 4   to accept-control
           end-perform
             
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CHOOSE-FILE.
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box 
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              move opnsav-filename to file-name
              modify file-ren value file-name
              perform GET-NEW-NAME-PATH
              modify file-new value new-name
           end-if
           .

       GET-NEW-NAME-PATH.
           initialize full-len, file-len
           inspect opnsav-filename tallying full-len for characters
                                   before initial trailing space
           inspect opnsav-basename tallying file-len for characters
                                   before initial trailing space
           move opnsav-filename(1:full-len - file-len) to new-name
           .

       RENAME-FILE.
           evaluate true
           when client-execution
                call client "RENAME" using file-name, 
                                           new-name
                                    giving wstatus
           when standalone-execution
           when server-execution
                call "RENAME" using file-name, 
                                    new-name
                             giving wstatus
           end-evaluate

           if wstatus = 0
              display message "Your file has been correctly renamed"
              modify file-ren, value spaces
              modify file-new, value spaces
           else
              display message "An error occurred: " 
                               wstatus
                      icon    mb-error-icon
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
