      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WBITMAP-HANDLING.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  bitmap-path             pic x(256).
       77  h-bitmap                pic s9(9) comp-4.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.
       77  e-client                pic 9.
       77  v-bmp1                  pic 9 value 1.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 Bmp1 
              bitmap
              line 4
              col 3
              lines 13 cells
              size 66 cells
              layout-data          rlm-resize-both
              visible              v-bmp1
              .
           03 Ef1  
              entry-field 
              line                 18 
              col                  2 
              size                 48 cells
              value                bitmap-path
              .
           03 pb-choose  
              push-button
              line                 18 
              col                  50 
              size                 8 cells
              title                "..." 
              exception-value      101
              enabled              e-client
              self-act
              .
           03 Pb-image  
              push-button
              line                 18 
              col                  58
              size                 12 cells
              title                "Load image" 
              exception-value      102
              self-act
              .
           03 push-button
              line                 20
              col                  2
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move 0                     to e-standalone
              move 3                     to rb-value
              move 0                     to e-client
              set server-execution       to true
           else
              move 0                     to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              move 1                     to e-client
              set standalone-execution   to true
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$BITMAP Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           move "files/img.png" to bitmap-path

           display Mask

           perform SHOW-IMAGE

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-BITMAP.
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 2
                perform VIEW-SORG
           when 101
                perform CHOOSE-IMAGE
           when 102
                perform SHOW-IMAGE  
           when 103
                if rb-value = 2
                   set client-execution   to true
                   move 1                 to e-client
                else
                   set server-execution   to true
                   move zero              to e-client
                end-if
                modify pb-choose enabled e-client
           end-evaluate
           .

       DESTROY-BITMAP.
           if function handle-type (h-bitmap) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, h-bitmap
           end-if.

       CHOOSE-IMAGE.
           initialize opensave-data

           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png|"
                  "All images (*.bmp;*.jpg;*.gif;*.png)|"
                  "*.bmp;*.jpg;*.gif;*.png"
                  delimited by size
                  into opnsav-filters.

           move 5   to opnsav-default-filter

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data

           if return-code not < 0
              move opnsav-filename to bitmap-path
              modify Ef1 value bitmap-path  
              perform SHOW-IMAGE
           end-if
           .

       SHOW-IMAGE.
           perform DESTROY-BITMAP

           evaluate true
           when standalone-execution
           when server-execution
                call "W$BITMAP" using wbitmap-load, 
                                      bitmap-path
                               giving h-bitmap
           when client-execution
                call "W$BITMAP" using wbitmap-load-from-client, 
                                      bitmap-path
                               giving h-bitmap
           end-evaluate.

           evaluate h-bitmap
           when -1
                move 0 to v-bmp1 
                display message "File not found or not readable"
                                icon mb-error-icon
           when -2
                move 0 to v-bmp1 
                display message "Out of memory loading the bitmap"
                                icon mb-error-icon
           when -3
                move 0 to v-bmp1 
                display message "Not a valid bitmap"
                                icon mb-error-icon
 
           when -4
                move 0 to v-bmp1 
                display message "Format not supported"
                                icon mb-error-icon
           when other
                move 1 to v-bmp1 
           end-evaluate
           
           modify Bmp1 bitmap-handle h-bitmap
                       visible v-bmp1 
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path            delimited by trailing space
                  "s-routines"              delimited by space
                  "/WBITMAP-HANDLING.cbl"   delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
