      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    WD2REDIRECT.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  gui-factory-class       pic 9.
       77  browser-info            pic x any length.
       77  user-agent              pic x any length.
       77  s-field                 pic x(32).
       77  s-value                 pic x(128).
       77  g-field                 pic x(32).
       77  g-value                 pic x(128).

       01  js1 pic x any length.
       01  js2 pic x any length.
       01  url pic x any length value "http://www.veryant.com". 
       01  target pic x any length value "_blank". 

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 1
              col                  2
              lines                7  cells
              size                 68 cells
              title                "WD2$RUN_JS"
              .
           03 entry-field 
              line                 2
              lines                3
              col                  3
              size                 66 cells
              multiline 
              vscroll-bar 
              value                js1.
           03 push-button
              line                 6
              col                  52
              size                 16
              title                "Run javascript"
              exception-value      101
              .
           03 frame
              engraved
              line                 8
              col                  2
              lines                7  cells
              size                 68 cells
              title                "WD2$EXECJS"
              .
           03 entry-field 
              line                 9
              lines                3
              col                  3
              size                 66 cells
              multiline
              vscroll-bar
              value                js2.
           03 push-button
              line                 13
              col                  52
              size                 16
              title                "Execute javascript"
              exception-value      102
              .     
           03 frame
              engraved
              line                 15
              col                  2
              lines                5  cells
              size                 68 cells
              title                "WD2$REDIRECT"
              .
           03 label 
              line                 16
              col                  3 
              size                 30 cells
              title                "Url:"
              .
           03 entry-field 
              line                 16
              col                  10
              size                 59 cells
              value                url.
           03 label 
              line                 18
              col                  3 
              size                 10 cells
              title                "Target:"
              .
           03 Combo-box 
              line                 18
              col                  10
              size                 15 cells
              item-to-add         ("_blank",
                                   "_parent"
                                   "_self"
                                   "_top")
              unsorted
              value                target.
           03 push-button
              line                 18
              col                  52
              size                 16
              title                "Redirect"
              exception-value      103
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           string 'form = document.createElement("form");'
                  'form.method = "GET";'
                  'form.action = "http://www.veryant.com";'
                  'form.target = "_blank";'
                  'document.body.appendChild(form);'
                  'form.submit();'
                  into js2
           string '<script type="text/javascript"> '
                   js2  
                  '</script>'
                  into js1
           display standard graphical window
                   background-low
                   line 2
                   col 65
                   title  
                    "WD2$RUN_JS, WD2$EXECJS and WD2$REDIRECT routines"
                   lines 21
                   size 70 
                   handle hWin 
                   event  WIN-EVT

           call "C$GETRUNENV" GIVING gui-factory-class
           if gui-factory-class not = runenv-wd2
              display message 
              "This sample works only in Web Direct 2 environment"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if

           display Mask

           perform until crt-status = 27
              accept Mask
                 on  exception
                    continue
              end-accept
              evaluate crt-status
              when 101
                   call "WD2$RUN_JS" using js1
              when 102
                   call "WD2$EXECJS" using js2
              when 103
                   perform REDIRECT
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       REDIRECT.
           call "WD2$REDIRECT" using url, target
                         giving return-code

           evaluate return-code
           when 0
                continue
           when -1
                display message "The redirect function is not available"
           when -2
                display message 
                             "Invalid number of parameters parameters"
           end-evaluate. 

       WIN-EVT.
           if event-type = cmd-close   
              move 1 to close-win
           end-if
           .