      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. PRINTCUSTOMER.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select print-f assign to print "-P spooler-direct"
                      organization is line sequential
                      file status status-print-f.

       DATA DIVISION.
       FILE SECTION.
       fd  print-f.
       01  p-row pic x(80).
      
       WORKING-STORAGE SECTION.

       copy "constants.def".
       copy "customer.wrk".

       77  status-print-f          pic xx.

       01                          pic 9.
           88 first-record         value 1 false zero.
           
       01  header-row.
           05 filler               pic x(1) value space.
           05 hr-title             pic x(72).
           05 filler               pic x(5) value "Page ".
           05 hr-page              pic z9.

       01  detail-row.
           05 filler               pic x(1) value space.
           05 dr-cust-code         pic z(4).
           05 filler               pic x(1) value space.
           05 dr-Cust-First-Name   pic x(15).
           05 filler               pic x(1) value space.
           05 dr-Cust-Last-Name    pic x(15).
           05 filler               pic x(1) value space.
           05 dr-Cust-Street       pic x(25).
           05 filler               pic x(1) value space.
           05 dr-cust-city         pic x(20).

       77  prz-ed                  pic zzz.zz9,99.
       77  call-result             signed-int.
       77  num-row                 pic 9(3).
       78  78-page-rows            value 50.
       77  num-pag                 pic 99 value zero.
       77  cont                    pic 9(3).
 
       77  h-font-print            usage handle of font.
 
       screen section.

       PROCEDURE DIVISION.

       MAIN.
           perform OPEN-FILES.
           perform PRINT-LIST.
           perform EXIT-PRG.
           
           goback.

       PRINT-LIST.
           set first-record  to true
           move 200 to num-row
           move zero   to num-pag

           perform REC-FIRST

           if return-code > 9
              continue
           else
              perform until 1 = 2
                 perform REC-NEXT
                 if return-code > 9
                    exit perform
                 else
                    perform PRINT-RECORD
                    if call-result not = zero |first-record
                        exit perform
                    end-if
                 end-if
              end-perform
           end-if.

           if first-record
              display "No data to print"
              display "Press Enter to continue"   at 2540
              accept omitted at 2578
                 on exception
                    continue
              end-accept
              display omitted erase eol line 25
           else
              if call-result = zero
                 close print-f
              end-if
           end-if.

       REC-FIRST.
           move low-value to Cust-Code
           call "PCUSTOMER" using 78-start-great, Cust-Code
           call "PCUSTOMER" using 78-read-next, customer-rec.

       REC-NEXT.  
           call "PCUSTOMER" using 78-read-next, customer-rec
           .

       PRINT-RECORD.
           if first-record
              perform OPEN-PRINT
              if call-result < zero
                 set first-record  to false
              end-if
           end-if
           
           if call-result = zero
              if num-row > 78-page-rows
                 perform PRINT-HEADER
              end-if
           
              set first-record        to false
              move cust-code          to dr-cust-code
              move Cust-First-Name    to dr-Cust-First-Name
              move Cust-Last-Name     to dr-Cust-Last-Name
              move Cust-Street        to dr-Cust-Street
              move cust-city          to dr-cust-city

              write p-row from detail-row
              add 1 to num-row
           end-if.

       OPEN-PRINT.
           open output print-f
           move 0  to call-result
           .

       PRINT-HEADER.
           if num-pag not = zero
              write p-row from space after page
           end-if
           
           set first-record to false
           add 1 to num-pag
           move zero   to num-row
           
           move "Customer List"   to hr-title
           move num-pag   to hr-page
           write p-row from header-row
           add 1 to num-row.
           
           initialize p-row
           move all "="   to p-row(2:79).
           write p-row 
           add 1 to num-row.
           
           move "Code"          to dr-cust-code
           move "First Name"    to dr-Cust-First-Name
           move "Last Name"     to dr-Cust-Last-Name
           move "Address"       to dr-Cust-Street
           move "City"          to dr-cust-city

           write p-row from detail-row
           add 1 to num-row.
           
           initialize p-row
           move all "="   to p-row(2:79).
           write p-row 
           add 1 to num-row.
  
       OPEN-FILES.
           call "PCUSTOMER" using 78-open-input.

       EXIT-PRG.
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           call "PCUSTOMER" using 78-close.
     
