      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. lookup-state.

       WORKING-STORAGE SECTION.
       COPY "constants.def".
       COPY "state.wrk" replacing 
                                 leading "state" by "state-back".

       copy "isfonts.def".
       copy "iscrt.def".
       copy "isgui.def".
       copy "iscobol.def".
       copy "image-handling.wrk".

       77  key-status is special-names crt status pic 999.
       77  w-key                pic x(3).
       77  sub1                 handle of window.
       77  htoolbar-lookup      handle of window.

       77  key-pressed       pic x.
       77  selected          pic 9(5).

       01  lookup-record.
           05 lr-code        pic  x(3).
           05 lr-name  pic  x(20).

       LINKAGE SECTION.
       COPY "state.wrk".

       SCREEN SECTION.
       01  s-lookup.
           03 gd-lookup 
              grid 
              line                          5
              col                           2
              lines                         12
              size                          69
              display-columns               (1, 8)
              data-columns                  (1, 4)
              alignment                     ("L", "L")
              data-types                    ("X(3)", "X") 
              heading-color                 257
              border-color rgb              x#ACACAC
              cursor-frame-width            0
              row-Cursor-Background-Color   rgb x#6D8AD6
              row-Cursor-Foreground-Color   rgb x#FFFFFF
              boxed
              column-headings 
              centered-headings
              tiled-headings
              Adjustable-Columns
              reordering-columns
              sortable-columns
              Vscroll
              Row-Background-Color-Pattern  (0, -14675438)
              EVENT PROCEDURE               GD-LOOKUP-EVENT
              .
           03 label 
              col                           2 
              line                          2
              size                          68
              title "Select a state by double clicking on the row or pre
      -             "ssing 'Select' button"
              center
              .

       01  s-lookup-tool.
           03 Push-Button
              col                           + 1.2 
              line                          3
              lines                         2.2 
              cells
              size                          13 cells
              bitmap-handle                 h-tools
              bitmap-width                  78-tb-bmp-width
              bitmap-number                 78-nb-save
              exception-value               3
              title                         "&Select"
              hint                          "(F3)"
              title-position                2
              self-act
              .
           03 bar
              col                           + 1.2
              lines                         2 
              width                         2
              color                         16
              shading                       (-1, 1)
              .
           03 push-button 
              title                         "&Exit"
              hint                          "(Esc)"
              bitmap-handle                 h-tools
              bitmap-width                  78-tb-bmp-width
              bitmap-number                 78-nb-exit
              title-position                2
              lines                         2.2 cells
              size                          12 cells
              col                           + 1.2
              exception-value               27
              self-act
              .

       PROCEDURE DIVISION using state-rec.
       MAIN.

           move State-Rec to state-back-Rec 

           display floating graphical window
                   background-low  
                   title  "STATE LOOKUP"
                   size 75
                   lines 25
                   control font small-font
                   visible 0
                   handle sub1
                   .

           display s-lookup upon sub1

           display tool-bar lines 2.5 control font small-font 
                   handle htoolbar-lookup upon sub1
           display s-lookup-tool upon htoolbar-lookup.

           move 0 to selected
           modify gd-lookup(1, 1) cell-data "code"
           modify gd-lookup(1, 2) cell-data "Name"
           
           perform LOAD-TABLE
           modify sub1 visible 1

           perform until key-status = 27 or 13
              accept s-lookup
                 on exception 
                   continue
              end-accept
              perform LOOKUP-AFTER-ACCEPT
           end-perform
           destroy sub1

           if selected = 0
              move state-back-Code to state-Code
              call "PSTATE" using 78-read, state-rec
              move state-back-rec  to state-rec
              move 0               to return-code
           else
              call "PSTATE" using 78-read, state-rec
           end-if

           move 0 to key-status
           goback
           .

       LOOKUP-AFTER-ACCEPT.
           if key-status = 3|13
              inquire gd-lookup cursor-y selected
           end-if
           if selected > 0
              inquire gd-lookup(selected, 1) cell-data state-code
              move 27  to key-status
           end-if
           .

       GD-LOOKUP-EVENT.
           evaluate event-type
           when msg-begin-entry
                inquire gd-lookup entry-reason key-pressed
                if key-pressed = grer-enter or 
                   key-pressed = grer-dblclick
                   move event-data-2    to selected
                end-if
                set event-action to event-action-fail-terminate
           end-evaluate
           .

       MOVE-STATE-TO-W.
           move state-code         to lr-Code.
           move state-description  to lr-Name.
           modify gd-lookup record-to-add lookup-record
           .

       LOAD-TABLE.
           modify gd-lookup mass-update 1
           move low-value to w-key.
           call "pstate" using 78-start-great w-key.
           perform until 1 = 2
              call "pstate" using 78-read-next state-rec
              if return-code > 9
                 exit perform
              end-if
              perform MOVE-STATE-TO-W
           end-perform.
           modify gd-lookup mass-update 0.

