      *    Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.
      
       program-id. bridge.

       input-output section.
       file-control.

       data division.
       file section.

       working-storage section.
       copy "isfonts.def".
       copy "isgui.def".
       copy "image-handling.wrk".
       copy "font-handling.wrk".
       copy "iwc.wrk".
           
       77  h-sta    handle of window.

       77  h-font-awsome              handle of font.
       77  toolbar-characters         pic n any length.
       77  wrk-font-name              pic x any length.
       
       77  wrk-return-code            pic s9.
       
       77  path-font                  pic x any length.
       77  font-name                  pic x any length.

       77  env-code                   pic 9 external.

       linkage section.
       77  pgm-to-launch  pic x any length.

       procedure division using pgm-to-launch.
       MAIN.
           move pgm-to-launch   to name-of-main-pgm

           perform SET-IWC-COMUNICATION

           perform LOAD-FONTS.

           call "C$GETRUNENV" GIVING env-code

           display standard graphical window
                   background-low
                   lines 37
                   size 108
                   cell size is entry-field font 
                   control font window-font
                   handle h-sta
                   visible 0
                   .

           perform LOAD-BMP

           call name-of-main-pgm.

           perform CLOSE-IWC-COMUNICATION

           destroy h-sta
           call "W$BITMAP" using wbitmap-destroy 
                                 h-tools

           goback
           .

       SET-IWC-COMUNICATION.
      *    Start the iwc comunication
           call "IWC$INIT" using 78-iwc-crt-status 
                          giving wrk-return-code

           if wrk-return-code not = 0
              display message "Failed to activate IWC communication"
                      icon mb-error-icon
           end-if.

           set environment "hot_key.iwchotkey" to 78-iwc-crt-status
           .

       CLOSE-IWC-COMUNICATION.
           initialize iwc-struct.
           move 78-iwc-close-prog  to iwc-action
           move name-of-main-pgm   to iwc-data
           call "IWC$SEND" using iwc-struct
                          giving wrk-return-code

           if wrk-return-code not = 0
             display message "Failed send IWC communication"
                    icon mb-error-icon
           end-if
           .

       LOAD-FONTS.
           accept path-font from environment "font_folder"
           initialize font-name
           string path-font                    delimited by size
                  "/SourceSansPro-Regular.ttf" delimited by size
                  into font-name

           call "w$createfont" using font-name
                                     wrk-font-name

           initialize wfont-data
           move wrk-font-name   to wfont-name
           move 13              to wfont-size
           call "W$FONT" using wfont-get-font window-font wfont-data
           
           set status-bar-font  to window-font

           move wrk-font-name   to wfont-name
           move 13              to wfont-size
           call "W$FONT" using wfont-get-font tool-bar-font wfont-data

           .

       LOAD-BMP.
           initialize font-name
           string path-font                    delimited by size
                  "/Font Awesome 5 Free-Solid-900.otf"
                                               delimited by size
                  into font-name

           call "w$createfont" using font-name 
                                     wrk-font-name

           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move 10              to wfont-size
           call "W$FONT" using wfont-get-font
                               h-font-awsome
                               wfont-data

           string nx"f002" |search 
                  nx"f689" |search state
                  nx"f0c7" |save 
                  nx"f2ed" |delete 
                  nx"f100" |first
                  nx"f104" |previuous
                  nx"f105" |next
                  nx"f101" |last
                  nx"f2f5" |exit 
                  nx"f02f" |print
                  nx"f03e" |print preview
                  nx"f1c1" |pdf
                  into toolbar-characters.

           initialize wbitmap-lsf-data
           move h-font-awsome               to wbitmap-lsf-font(1)
                                               wbitmap-lsf-font(2)
           move toolbar-characters          to wbitmap-lsf-characters(1)
                                               wbitmap-lsf-characters(2)
           move 78-toolbar-color            to wbitmap-lsf-color(1)
           move 78-toolbar-rollover-color   to wbitmap-lsf-color(2)

           call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                 78-tb-bmp-width
                                 wbitmap-lsf-data
                          giving h-tools
           .

