      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. PCustomer.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           COPY "Customer.sel".
       DATA DIVISION.
       FILE SECTION.
           COPY "Customer.fd".

       WORKING-STORAGE SECTION.
       COPY "Constants.def".
       77  CUST-STATUS  PIC XX.
       77  STATUS-99    PIC 99.
       77  NUM-PARA     PIC 99 COMP-1.
       77  SIZE-PARA    PIC 9(5).

       LINKAGE SECTION.
       77  LK-OP-CODE   PIC X.
       77  LK-REC       PIC X(1000).

       PROCEDURE DIVISION USING LK-OP-CODE, LK-REC.
       MAIN.
           CALL "C$NARG" using NUM-PARA
           IF NUM-PARA > 1
              CALL "C$PARAMSIZE" USING 2 GIVING SIZE-PARA
           END-IF
           EVALUATE LK-OP-CODE
           WHEN 78-OPEN-INPUT
                OPEN INPUT Customer
           WHEN 78-OPEN-OUTPUT
                OPEN OUTPUT Customer
           WHEN 78-OPEN-I-O
                OPEN I-O Customer
                if cust-status = "05"
                   perform VAL-STD-CUSTOMER
                end-if
           WHEN 78-CLOSE
                CLOSE Customer
           WHEN 78-START
                MOVE LK-REC(1:SIZE-PARA) TO cust-code(1:)
                START Customer key is = cust-code
           WHEN 78-START-GREAT
                MOVE LK-REC(1:SIZE-PARA) TO cust-code(1:)
                START Customer key is > cust-code
           WHEN 78-START-LESS
                MOVE LK-REC(1:SIZE-PARA) TO cust-code(1:)
                START Customer key is < cust-code
           WHEN 78-READ
                MOVE LK-REC(1:SIZE-PARA) TO CUSTOMER-REC
                READ Customer key is cust-code
                MOVE CUSTOMER-REC TO LK-REC(1:SIZE-PARA)
           WHEN 78-READ-NEXT
                READ Customer NEXT
                MOVE CUSTOMER-REC TO LK-REC(1:SIZE-PARA)
           WHEN 78-READ-PREV
                READ Customer PREVIOUS
                MOVE CUSTOMER-REC TO LK-REC(1:SIZE-PARA)
           WHEN 78-WRITE
                MOVE LK-REC(1:SIZE-PARA) TO CUSTOMER-REC
                WRITE CUSTOMER-REC
           WHEN 78-REWRITE
                MOVE LK-REC(1:SIZE-PARA) TO CUSTOMER-REC
                REWRITE CUSTOMER-REC
           WHEN 78-DELETE
                MOVE LK-REC(1:SIZE-PARA) TO cust-code
                DELETE CUSTOMER RECORD
           END-EVALUATE
           MOVE CUST-STATUS TO STATUS-99
           GOBACK STATUS-99.
           
       VAL-STD-CUSTOMER.
       
           initialize Customer-Rec 
           move 1                                 to cust-code
           move "VERYANT LLC"                     to Cust-First-Name
           move "6390 Greenwich Dr., Suite 225"   to Cust-Street
           move "San Diego"                       to Cust-City
           move "California"                      to Cust-State
           move "92122"                           to Cust-Zip
           move "+1 619 797 1323"                 to Cust-Phone
       
           write Customer-Rec.

           initialize Customer-Rec 
           move 2                                 to cust-code
           move "VERYANT ITALIA S.R.L."           to Cust-First-Name
           move "Via Pirandello 29"               to Cust-Street
           move "Piacenza"                        to Cust-City
           move "Italia"                          to Cust-State
           move "29121"                           to Cust-Zip
           move "+39 0523 490770"                 to Cust-Phone
       
           write Customer-Rec.
           

