      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       program-id.  Prog1.

       configuration section.
       repository.
           class javabean   as "com.iscobol.gui.server.CobolGUIJavaBean"  
           class zk-upload-event  as "org.zkoss.zk.ui.event.UploadEvent"
           class zk-media         as "org.zkoss.util.media.Media"
           class j-event          as "java.util.EventObject"
           class j-string         as "java.lang.String"
           class j-fileoutput     as "java.io.FileOutputStream"

           class zk-html           as "org.zkoss.zul.Html"
           class zk-desktop        as "org.zkoss.zk.ui.Desktop"
           class zk-executions     as "org.zkoss.zk.ui.Executions"
           class j-map            as "java.util.HashMap"
           class j-boolean        as "java.lang.Boolean"
           .

       input-output section.
       file-control.
           select print-file assign to print
                  pdf-path 
                  organization line sequential
                  status print-status.
           select snippet assign to  snippet-path
                  organization is line sequential
                  status snippet-status.

       file section.
       fd  print-file.
       01  print-rec pic x(80).

       fd  snippet.
       01  rec-snippet pic x(32000).

       working-storage section.   
       01  js1 pic x any length value 
               'form = document.createElement("form");
      -        'form.method = "GET";
      -        'form.action = "http://www.veryant.com";
      -        'form.target = "_blank";
      -        'document.body.appendChild(form);
      -        'form.submit();'.

       copy "isfonts.def".
       copy "isgui.def".
       copy "iscobol.def".
       copy "iscrt.def".
       copy "isprint.def".
       copy "Customer.wrk".
       copy "Constants.def".
       77  factory-class     pic 9.
       77  flag-env          pic 9 value 0.
           88 is-wd2         value 1 false 0.
       77  client-info       pic x any length.
       77  user-agent        pic x any length.
       77  browser-name      pic x any length.
       77  desktop-width-px  pic x any length.
       77  desktop-height-px pic x any length.
       77  screen-width-px   pic x any length.
       77  screen-height-px  pic x any length. 
       77  floating-menu     pic s9(9) comp-4.
       77  pop-menu   pic s9(9) comp-4.
       77  W-KEY      PIC  9(5).
       77  hsta       handle of window.
       77  htool      handle of window.
       77  hflo       handle of window.
       77  h-id       handle.
       77  hfont      handle of font.
       77  hfont-big  handle of font.
       77  hfont-small  handle of font.
       77  key-status special-names crt status pic 9(4).
       77  h-ico      pic s9(9) comp-4.
       77  h-anim     pic s9(9) comp-4.
       77  h-roll     pic s9(9) comp-4.
       77  h-ve       pic s9(9) comp-4.
       77  h-tools    pic s9(9) comp-4.
       77  version    pic x(64).
       77  curr-page  pic 9.
       01  vis-pages.
           03 vis     pic 9 occurs 12.
       77  idx        pic 99.
       77  idx-prev   pic 99.
       77  resp       PIC  9.
       78  ZK-EVT-ONUPLOAD   value 1559815360.
       77  j-evt             special-names event object 
                             object reference j-event.
       77  jb-fileupload     object reference javabean.
       77  jb-colorbox       object reference javabean. 
       77  w-j-fileoutput    object reference j-fileoutput.
       77  w-zk-upload-event object reference zk-upload-event.
       77  w-zk-media        object reference zk-media.
       77  w-zk-media-name   object reference j-string.
       77  w-zk-media-url    object reference j-string.
       77  print-status      pic xx.
       77  snippet-status    pic xx.
       01  picker-color.
           03 filler         pic x.
           03 red-val        pic xx.
           03 green-val      pic xx.
           03 blue-val       pic xx.

       77  ind         pic 9.
       77  ind2        pic 9.
       77  wrk-item    pic x(10).
       77  pagedIdx    pic 99.
       77  pagedIdxL   pic s99.

       78  max-paged-element value 20.
       78  num-lines-lb      value 10.

       78  Simple-file-handler-page   value 10.

       01  record-paged-grid.
           03 rec-paged         occurs max-paged-element.
              05 code-paged     pic 99.
              05 descr-paged    pic x(50).

       77  i                    pic 999 value 0.

       01  lb2-read-direction   pic x.
           88 lb2-ff            value "F".
           88 lb2-rr            value "R".

       01  rgb-disp.
           03  red-disp         pic 9(3).
           03  green-disp       pic 9(3).
           03  blue-disp        pic 9(3).

       77  buffer-bk            pic s9(10).
       77  pdf-path             pic x(256).
       77  pdf-position         pic x any length.
       77  excel-position       pic x any length.
       77  upload-position      pic x any length.
       
       77  snippet-path         pic x(256).
       
       77  menu-page            pic 9(2).

       77  v-zul-div            object reference javabean.
       77  myhtml               object reference zk-html.
       77  bool                 object reference j-boolean.
       77  cke-config           object reference j-map.
       77  curr-desktop         object reference zk-desktop.

       77  cke-toolbar-setting  pic x any length.
       77  code-snippet         pic x any length.

       01  filler               pic 9 value 1.
           88 first-time        value 1 false zero.
           

       screen section.
       01  mask-menu.
           03 amenu 
              Tab-Control
              accordion
              line 4.2
              column 4.0
              size 25.0
              lines 23.0
              event procedure ACCORDION-EVENT
              value menu-page
              .           
           03 a-menu-client-info tab-group amenu tab-group-value 1.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 8
                 title "<HTML><span style='font-size:smaller'>You can ea
      -                "sily retrieve client information</span></HTML>"
                 .
           03 a-menu-radio-ckeck tab-group amenu tab-group-value 2.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 8
                 title "<HTML><span style='font-size:smaller'>Check-Boxe
      -                "s are options you can check on the screen <br>Ra
      -                "dio-button are option buttons that the user can 
      -                "check on the screen</span></HTML>"
                 .
           03 a-menu-push-button tab-group amenu tab-group-value 3.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 8
                 title "<HTML><span style='font-size:smaller'>The user c
      -                "an start operations by clicking on these control
      -                "s</span></HTML>"
                 .
           03 screen-1-ap-4 tab-group amenu tab-group-value 4.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 8
                 title "<HTML><span style='font-size:smaller'>Entry-fiel
      -                "ds are input elements in which users can enter d
      -                "ata<br>Date-entry allows users to select a date 
      -                "using a calendar</span></HTML>"
                 .
           03 screen-1-ap-5 tab-group amenu tab-group-value 5.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 5
                 title "<HTML><span style='font-size:smaller'>Combo-box 
      -                "allows users to select a value from a list<br> L
      -                "ist-Boxes show a list of values and allow the us
      -                "er to select one of them</span></HTML>".

           03 a-menu-grid tab-group amenu tab-group-value 6.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 5
                 title "<HTML><span style='font-size:smaller'>This is th
      -                "e standard grid used to display and accept data 
      -                "inside cells. It shows scroll-bars to show more 
      -                "data if required.</span></HTML>"
                 .

           03 a-menu-grid-paged tab-group amenu tab-group-value 7.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 5
                 title "<HTML><span style='font-size:smaller'>This is a 
      -                "particular grid suggested to handle huge amount 
      -                "of data saving memory and time. It loads only th
      -                "e data you see.</span></HTML>"
                 .
           03 screen-1-ap-8 tab-group amenu tab-group-value 8.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 5
                 title "<HTML><span style='font-size:smaller'>Java-beans
      -                " allow you to interact with third party JavaBean
      -                "s</span></HTML>"
                 .
           03 screen-1-ap-9 tab-group amenu tab-group-value 9.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 5
                 title "<HTML><span style='font-size:smaller'>This contr
      -                "ol allows you to group and organize some items</
      -                "span></HTML>"
                 .
           03 screen-1-ap-10 tab-group amenu tab-group-value 10.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 5
                 title "<HTML><span style='font-size:smaller'>This sampl
      -                "e shows how you can combine controls to provide
      -                "a friendly and modern user interface</span></HTM
      -                "L>"
                 .
           03 screen-1-ap-11 tab-group amenu tab-group-value 11.  
              05 Label
                 line 6.0
                 column 5
                 size 23
                 lines 5
                 title "<HTML><span style='font-size:smaller'>This sampl
      -                "e shows various operations easily accoplished</s
      -                "pan></HTML>"
                 .
           03 page1 visible vis(1).

              05  ef-info 
                  entry-field 
                  multiline, 
                  read-only
                  line 5, 
                  col 31
                  lines 32, 
                  size 56.

           03 page2 visible vis(2).
              05  Frame 
                  col 31
                  line 5
                  lines 8.0, size 57
                  title "Check-box" 
                  .  
              05  label
                  title "Standard"
                  line 7 col 33
                  size 8 cells
                  label-offset 0
                  .
              05  check-box
                  title "enabled-1"
                  line 7.0 col 42
                  size 10 
                  .
              05  check-box
                  title "enabled-2"
                  line 7.0 col 55
                  size 10 
                  value 1
                  .
              05  check-box
                  title "disabled"
                  line 7.0 col 71
                  size 10 
                  enabled 0
                  .
              05  label
                  title "Bitmap"
                  line 10.0 col 33
                  size 10 cells
                  label-offset 0
                  .
              05  check-box
                  bitmap-handle h-ico
                  bitmap-number 22
                  lines 18 size 18
                  line 10.0 col 42
                  .
              05  check-box
                  bitmap-handle h-ico
                  bitmap-number 23
                  lines 18 size 18
                  line 10.0 col 45
                  .
              05  Frame 
                  col 31
                  line 15.0
                  lines 8.5, size 57
                  title "Radio-button" 
                  .  
              05  label
                  title "Standard"
                  line 17.0 col 33
                  size 8 cells
                  label-offset 0
                  .
              05  radio-button
                  group 1
                  title "enabled-1"
                  line 17 col 42
                  size 10 
                  value 1
                  id 101
                  .
              05  radio-button
                  group 1
                  title "enabled-2"
                  line 17 col 55
                  size 10
                  .
              05  radio-button
                  group 1
                  title "disabled"
                  line 17 col 71
                  size 10 
                  enabled 0
                  .
              05  radio-button
                  group 2
                  title "Red"
                  line 19.0 col 42
                  size 10 lines 1.2
                  background-color rgb x#FF0000
                  foreground-color rgb x#FFFFFF
                  value 1
                  .
              05  radio-button
                  group 2
                  title "Green"
                  line 19.0 col 55
                  size 10 lines 1.2
                  background-color rgb x#00FF00
                  foreground-color rgb x#000000
                  .
              05  radio-button
                  group 2
                  title "Blue"
                  line 19.0 col 71
                  size 10 lines 1.2
                  background-color rgb x#0000FF
                  foreground-color rgb x#FFFFFF
                  .
              05  label
                  title "Bitmap"
                  line 21.0 col 33
                  size 8 cells
                  label-offset 0
                  .
              05  radio-button
                  group 3 group-value 1
                  bitmap-handle h-ico
                  bitmap-number 22
                  lines 18 size 18
                  line 21 col 42
                  .
              05  radio-button
                  group 3 group-value 2
                  bitmap-handle h-ico
                  bitmap-number 23
                  lines 18 size 18
                  line 21 col 45
                  .
              05  radio-button
                  group 3 group-value 3
                  bitmap-handle h-ico
                  bitmap-number 24
                  lines 18 size 18
                  line 21 col 48
                  .
           03 page3 visible vis(3).
              05  label
                  title "Standard Style"
                  line 5.0 col 31
                  size 14 cells
                  .
              05  push-button
                  title "enabled"
                  line 7.0 col 31
                  size 10
                  exception-value 301
                  .
              05  push-button
                  title "disabled"
                  line 7.0 col 43
                  size 10
                  enabled 0
                  exception-value 302
                  .
              05  pbversion push-button
                  title "Get Version"
                  line 7.0 col 55
                  size 10.5
                  exception-value 303
                  .
              05  efversion
                  entry-field
                  line 7.0 col 67
                  lines 6
                  size 20
                  foreground-color rgb x#0000C0
                  .
              05  label
                  title "Bootstrap Style"
                  line 10.0 col 31
                  size 14 cells
                  .
              05  push-button
                  title "enabled"
                  line 12 col 31
                  size 10
                  exception-value 301
                  css-base-style-name "btn btn-primary"
                  .
              05  push-button
                  title "disabled"
                  line 12 col 43
                  size 10
                  enabled 0
                  exception-value 302
                  css-base-style-name "btn btn-primary"
                  .
              05  push-button
                  title "enabled"
                  line 14 col 31
                  size 10
                  exception-value 301
                  css-base-style-name "btn btn-success"
                  .
              05  push-button
                  title "disabled"
                  line 14 col 43
                  size 10
                  enabled 0
                  exception-value 302
                  css-base-style-name "btn btn-success"
                  .
              05  push-button
                  title "enabled"
                  line 16 col 31
                  size 10
                  exception-value 301
                  css-base-style-name "btn btn-info"
                  .
              05  push-button
                  title "disabled"
                  line 16 col 43
                  size 10
                  enabled 0
                  exception-value 302
                  css-base-style-name "btn btn-info"
                  .
              05  label
                  title "With Bitmap"
                  line 20.0 col 31
                  size 14 cells
                  .
              05  push-button, 
                  line 22.0 col 31
                  size 18 lines 18
                  bitmap-handle h-ico
                  bitmap-number 2 
                  exception-value 203
                  .
              05  push-button, 
                  line 22.0 col 43
                  size 18 lines 18
                  bitmap-handle h-ico
                  bitmap-number 2 
                  enabled 0
                  exception-value 204
                  .
              05  push-button
                  bitmap-handle h-anim
                  bitmap-number 2
                  bitmap-rollover 1
                  bitmap-disabled 4
                  lines 75 size 75
                  line 20 col 54
                  .
           03 page4 visible vis(4).
              05  label
                  title "Entry-Fields"
                  line 7 col 31
                  size 14 cells
                  .
              05  label
                  title "Left"
                  line 5.0 col 44
                  size 5 cells
                  .
              05  Ef1 entry-field left
                  line 7.0 col 44
                  size 10 
                  color 2
                  value "abc"  
                  before BEF-EF
                  after  AFT-EF
                  event  EVT-EF 
                  id 301
                  .
              05  label
                  title "Center"
                  line 5.0 col 59
                  size 6 cells
                  .
              05  Ef2 entry-field center
                  line 7.0 col 59
                  size 10 
                  color 3
                  value "abc"
                  id 302
                  before BEF-EF
                  after  AFT-EF
                  event  EVT-EF
                  .
              05  label
                  title "Right"
                  line 5.0 col 74
                  size 6 cells
                  .
              05  Ef3 entry-field right
                  line 7.0 col 74
                  size 10 
                  color 4
                  value "abc"
                  id 303
                  before BEF-EF
                  after  AFT-EF
                  event  EVT-EF
                  .
              05  l-bef label
                  title "Before"
                  css-base-style-name "alert alert-warning"
                  line 9 col 44 size 11
                  center 
                  .
              05  l-aft label
                  title "After"
                  css-base-style-name "alert alert-warning"
                  line 9 col 59 size 11
                  center 
                  .
              05  l-evt label
                  title "Event"
                  css-base-style-name "alert alert-warning"
                  line 9 col 74 size 11
                  center 
                  .
              05  label
                  title "Secure-Field"
                  line 11 col 31    
                  size 12 cells
                  . 
              05  entry-field
                  secure
                  line 11.0 col 44
                  size 25
                  value "password"
                  .
              05  label
                  title "Multiline-Field"
                  line 13 col 31
                  size 15 cells 
                  .
              05  entry-field 
                  line 13.0 col 44
                  lines 5.2
                  size 23
                  multiline 
                  vscroll-bar 
                  value "a" & x"0a" & "b" & x"0a" & 
                        "c" & x"0a" & "d" & x"0a" & "e"
                  .
              05  label
                  title "Field with custom pop-up menu"
                  line 17.0 col 31
                  size 29 cells
                  .
              05  efp entry-field 
                  line 17  col 59
                  size 10
                  pop-up menu pop-menu
                  . 
              05  label
                  title "Auto-Spin"
                  line 19.0 col 31
                  size 9 cells
                  .
              05  entry-field
                  line 19.0  col 59
                  size 8.0
                  auto-spin
                  .
              05  label
                  title "Date-Entry Field"
                  line 21.0 col 31
                  size 16 cells
                  .
              05  date-entry
                  line 21.0  col 59
                  size 10.3 cells
                  .   
              05  label
                  title "Min/Max Val (5/15)"
                  line 23.0 col 31
                  size 16 cells
                  .     
              05  entry-field
                  line 23.0 col 59
                  size 10 
                  numeric 
                  right 
                  min-val 5, 
                  max-val 15
                  .
           03 page5 visible vis(5).
              05  label
                  title "Combo-Box"
                  line 5 
                  col 31 
                  lines 5 cells
                  size 10 cells  
                  .
              05  cb1 combo-box
                  line 5 col 44
                  size 15 
                  id 401
                  .
              05  label
                  title "List-Box"
                  line 7 col 31
                  size 8 cells
                  . 
              05  lb1 list-box
                  line 7 col 44
                  size 24  lines 5
                  data-columns (1, 3, 5)
                  display-columns (1, 7, 15)
                  notify-selchange
                  event EVENT-LB1
      *    to exclude some events
      *              EVENT-LIST (cmd-Goto Msg-Init-Menu Msg-Menu-Input)
      *              EXCLUDE-EVENT-LIST 1
                  .
              05  label 
                  line 8 col 71 
                  title "Selected row:"
                  size 11
                  .
              05  lb-list-row label
                  line 7.8 col 83
                  size 4 cells
                  css-base-style-name "alert alert-warning"
                  .
              05  push-button
                  title "Export to Excel"
                  line 10 col 71
                  size 15
                  exception-value 501
                  . 
              05  label
                  title "Paged List-Box"
                  line 13 col 31
                  size 12 cells
                  . 
              05  lb2 list-box
                  line 13 col 44
                  size 24  lines 10
                  data-columns (1, 3)
                  display-columns(1, 7)
                  notify-selchange
                  paged
                  event EVENT-LB2
                  .
           03 page6 visible vis(6).
              05  label
                  title "Editable Grid"
                  line 7 col 31
                  size 24 cells
                  . 
              05  gd1 grid
                  line 9 col 31
                  size 24  lines 5
                  column-headings
                  centered-headings
                  heading-color 257
                  heading-menu-popup 1
                  editor-show-always   (1, 1, 1)
                  data-columns (1, 3, 5)
                  display-columns (1, 7, 15)
                  alignment ("C", "R", "L")
                  divider-color 8
                  use-tab
                  .
              05  push-button
                  title "Export to Excel"
                  line 18 col 32
                  size 20
                  exception-value 601
                  . 
              05  label
                  title "Read-only Grid "
                  line 7 col 62
                  size 14 cells
                  . 
              05  gd2 grid
                  line 9 col 62
                  size 25  lines 5
                  column-headings
                  centered-headings 
                  heading-menu-popup 1
                  heading-color 257
                  data-columns (1, 3, 5)
                  display-columns (1, 7, 15)
                  alignment ("C", "R", "L")
                  protection 1
                  row-cursor-background-color rgb x#C8FFFF 
                  divider-color 8
                  .
           03 page7 visible vis(7).
              05  gd3 grid
                  paged
                  line 9.0 col 33
                  size 51  
                  lines 7
                  column-headings
                  row-headings
                  centered-headings 
                  heading-menu-popup 1
                  heading-color 257
                  data-columns (1, 3)
                  display-columns(1, 7)
                  alignment ( "C", "L")
                  protection 1
                  virtual-width 49
                  row-cursor-background-color rgb x#C8FFFF 
                  divider-color 8
                  event PAGED-GRID-EVENT
                  .
           03 page8 visible vis(8).
              05  Frame 
                  col 38
                  line 6.5
                  lines 7, size 45
                  title "File Upload" 
                  .  
              05  Java-Bean
                  clsid          "org.zkoss.zul.Fileupload"
                  event-list     ( "onUpload" )
                  init-params    ( "upload")
                  line 9
                  col  40
                  lines 2 cells
                  size  5 cells
                  id 701
                  object  jb-fileupload
                  event EV-FILEUP
                  .   
              05  Frame 
                  col 38
                  line 15
                  lines 7, size 45
                  title "Color Picker" 
                  .
              05  Java-Bean
                  clsid "org.zkoss.zkex.zul.Colorbox"  
                  col  40
                  line 17.5 
                  lines 3 cells
                  size  5 cells
                  object  jb-colorbox 
                  .  
               05 push-button
                  col 47
                  line 17.5
                  size 10 cells
                  title "Test RGB"
                  exception-value 801
                  .
              05  lb-result
                  Label
                  col 58
                  line 17.5
                  title "result"
                  center
                  size 20 cells
                  foreground-color rgb x#FFFFFF
                  background-color rgb x#000000
                  .
              05  label
                  col 48
                  line 19.5
                  title "red"
                  size 5 cells
                  .
              05  ef-red
                  entry-field
                  center
                  foreground-color rgb x#FF0000
                  line 19.5
                  col 52
                  size 4 cells
                  value red-disp
                  .
              05  Label
                  col 58
                  line 19.5
                  title "Green"
                  size 5 cells
                  .
              05  ef-green
                  entry-field
                  center
                  foreground-color rgb x#00CC33
                  line 19.5
                  col 63
                  size 4 cells
                  value green-disp
                  .
              05  label
                  col 68
                  line 19.5
                  title "blue"
                  size 5 cells
                  .
              05  ef-blue
                  entry-field
                  center
                  foreground-color rgb x#0000FF
                  line 19.5
                  col 73
                  size 4 cells
                  value blue-disp
                  .
           03 page9 visible vis(9).
              05  label
                  title "Tree-View"
                  line 5 col 35
                  size 11 cells  
                  .
              05  label
                  title "with no style"
                  line 6 col 35
                  size 11 cells  
                  .
              05  tv1 tree-view
                  line 8.5 col 35
                  size 17 lines 15 
                  id 501
                  .
              05  label
                  title "Tree-View"
                  line 5 col 68
                  size 11 cells
                  .
              05  label
                  title "with Bitmap"
                  line 6 col 68
                  size 11 cells  
                  .
              05  tv2 tree-view 
                  line 8.5 col 68
                  size 17 lines 15
                  Bitmap-Handle h-ico
                  Bitmap-Width 18
                  .
           03 page10 visible vis(10).
              05  Push-Button
                  col 32 line 4.5
                  lines 1 size 8
                  css-base-style-name "btn btn-success"
                  css-style-name "btn-sm"
                  css-icon "fa-save"
                  title-position 2
                  self-act
                  exception-value 9
                  title "Save" 
                  .
              05  Push-Button
                  col 41 line 4.5
                  lines 1 size 8
                  css-base-style-name "btn btn-danger"
                  css-style-name "btn-sm"
                  css-icon "fa-trash"
                  title-position 2
                  self-act
                  exception-value 3
                  title "Delete"
                  .
              05  Push-Button
                  col 50 line 4.5
                  lines 1 size 8
                  css-base-style-name "btn btn-info"
                  css-style-name "btn-sm"
                  css-icon "fa-angle-double-left"
                  title-position 2
                  self-act
                  exception-value 5
                  title "First"
                  .
              05  Push-Button
                  col 59 line 4.5
                  lines 1 size 8
                  css-base-style-name "btn btn-info"
                  css-style-name "btn-sm"
                  css-icon "fa-angle-left"
                  title-position 2
                  self-act
                  exception-value 6
                  title "Previous"
                  .
              05  Push-Button
                  col 68 line 4.5
                  lines 1 size 8
                  css-base-style-name "btn btn-info"
                  css-style-name "btn-sm"
                  css-icon "fa-angle-right"
                  title-position 2
                  self-act
                  exception-value 7
                  title "Next"
                  .
              05  Push-Button
                  col 77 line 4.5
                  lines 1 size 8
                  css-base-style-name "btn btn-info"
                  css-style-name "btn-sm"
                  css-icon "fa-angle-double-right"
                  title-position 2
                  exception-value 8
                  title "Last"
                  .
              05  label, 
                  col 32
                  line 7
                  title "Customer Code"
                  size 13 cells 
                  .
              05  label
                  col 32
                  line 9
                  title "First Name"
                  size 10 cells
                  .
              05  label
                  col 32
                  line 11
                  title "Last Name"
                  size 9 cells 
                  .
              05  label
                  col 32
                  line 13
                  title "Street"
                  size 6 cells
                  .
              05  Label
                  col 32
                  line 15
                  title "City"
                  size 4 cells
                  .
              05  Label
                  col 32
                  line 17
                  title "State"
                  size 5 cells
                  .
              05  label
                  col 32
                  line 19
                  title "Zip Code"
                  size 8 cells
                  .
              05  label,
                  col 32
                  line 21
                  title "PhoneNum"
                  size 8 cells
                  .
              05  label
                  col 32
                  line 23
                  title "CellphoneNum"
                  size 12 cells
                  .
              05  entry-field
                  col 54 
                  line 7
                  size 7
                  value cust-code  
                  id 601
                  .
              05  entry-field, 
                  col 54
                  line 9
                  size 20
                  value cust-first-name
                  .
              05  entry-field
                  col 54
                  line 11
                  size 20
                  value cust-second-name
                  .
              05  entry-field
                  col 54
                  line 13
                  size 20
                  value cust-street
                  .
              05  entry-field
                  col 54
                  line 15
                  size 20
                  value cust-city
                  .
              05  entry-field
                  col 54
                  line 17
                  value cust-state
                  size 20 cells
                  .
              05  entry-field
                  col 54
                  line 19
                  value cust-zip
                  size 7 cells
                  .
              05  entry-field
                  col 54
                  line 21
                  size 18
                  value cust-phone
                  size 15 cells
                  .
              05  entry-field
                  col 54
                  line 23
                  size 18
                  value cust-cellphone
                  size 15 cells
                  .
           03 page11 visible vis(11).
              05  push-button
                  line 8 col 40
                  lines 3
                  size 40
                  title "Open a sample floating Window with Tab-Control"
                  hint "Show a Window with Tab-Control"
                  css-base-style-name "btn btn-primary"
                  css-icon "fa-list-alt"
                  title-position 2
                  exception-value 1101  
                  .  
              05  push-button
                  line 13 col 40
                  lines 3
                  size 40
                  title "Call an external program"
                  hint "Call another program"
                  css-base-style-name "btn btn-primary"
                  css-icon "fa-cogs"
                  title-position 2
                  exception-value 1102
                  .
              05 pb-pdf 
                 push-button
                 line 18 col 40
                 lines 3
                 size 40
                 title "Print PDF"
                 hint "Create a PDF and show it into a new page"
                 css-base-style-name "btn btn-primary"
                 css-icon "fa-file-pdf-o"
                 title-position 2
                 exception-value 1103   
                 .

           03 Label
              line 2.0
              column 4.0
              size 25.0
              lines 2.00
              css-base-style-name "alert alert-info"
              center
              title "Widget"
              .

           03 Label
              line 2.0
              column 30.0
              size 59.0
              lines 2.00
              css-base-style-name "alert alert-info"
              center
              title "Control Samples"
              .

           03 Frame
              line 4.2
              column 30.0
              size 59.0
              lines 21.0
              full-height
              css-style-name "frame-border"
              .

           03 Label
              line 25.0
              column 30.00
              size 59.0
              lines 2.0
              css-base-style-name "alert alert-info"
              center
              title "Code Snippet"
              .

           03 Frame
              line 27.2
              column 30.00
              size 59.0
              lines 15.0
              full-height
              css-style-name "frame-border"
              .

           03 Bitmap
              line 31.0
              column 7.0
              size 168 pixels
              lines 76 pixels
              bitmap-handle h-ve
              bitmap-number 1
              .
           03 Push-Button
              exception-value 8000
              line 35.0
              column 3.0
              size 24.0
              lines 1.5
              css-base-style-name "btn btn-link btn-lg"
              no-tab
              hint "www.veryant.com"
              self-act
              title "go to website"
              css-icon "fa-link"
              title-position 2
              .
           03 snippet
              java-bean 
              clsid                "org.zkoss.zul.Div"
              line                 27.3 
              col                  30.1 
              size                 58.7
              lines                14.7
              object               v-zul-div
              css-style-name      "snippet"
              .


       01  mask-win.
           03 tdemo
              tab-control
              allow-container
              line 1 col 1
              lines 20 size 50
              value curr-page
              tab-to-add "Page-1"
              tab-to-add "Page-2"
              tab-to-add "Page-3"
              .
           03 mask-page-1 tab-group tdemo tab-group-value 1.
              05 label
                 title "Page 1"
                 line 4 col 4
                 size 6 cells
                 .
              05 entry-field
                 line 6 col 4
                 size 8 cells
                 .
           03 mask-page-2 tab-group tdemo tab-group-value 2.
              05 label
                 title "Page 2"
                 line 4 col 4
                 size 6 cells
                 .
              05 entry-field
                 line 6 col 4
                 size  8 cells
                 .
           03 mask-page-3 tab-group tdemo tab-group-value 3.
              05 label
                 title "Page 3"
                 line 4 col 4
                 size 6 cells
                 .
              05 push-button
                 title "Exit"
                 line 6 col 4 
                 size 5 cells
                 exception-value 27
                 .

       01  s-tool.
           03 push-button
              title "End"
              line 1 col 2  
              size 18 lines 18
              bitmap-handle h-ico
              bitmap-number 1 
              background-color rgb x#F4F4ED
              exception-value 27 
              self-act
              .

       PROCEDURE DIVISION.
       main.
           perform varying pagedIdx from 1 by 1 
                                   until pagedIdx > max-paged-element
              move pagedIdx  to code-paged(pagedIdx)
              initialize descr-paged(pagedIdx)
              string "Description "   delimited by size
                     pagedIdx         delimited by size
                     into descr-paged (pagedIdx)
           end-perform.

           call "C$GETRUNENV" GIVING factory-class
           if factory-class = runenv-wd2
              set is-wd2 to true
           else
              set is-wd2 to false
           end-if

           initialize wfont-data.
           move "Verdana" to wfont-name.
           move 8 to wfont-size.
           call "w$font" using wfont-get-font hfont-small wfont-data.
  
           initialize wfont-data.
           move "Verdana" to wfont-name.
           move 12 to wfont-size.
           call "w$font" using wfont-get-font hfont wfont-data.

           initialize wfont-data.
           move "Verdana" to wfont-name.
           move 20 to wfont-size.
           call "w$font" using wfont-get-font hfont-big wfont-data.

           call "w$bitmap" using wbitmap-load "tools.bmp" giving h-tools
           call "w$bitmap" using wbitmap-load "icon.png" giving h-ico
           call "w$bitmap" using wbitmap-load "anim.gif" giving h-anim
           call "w$bitmap" using wbitmap-load "veryant.png" giving h-ve.

           display standard graphical window
               title "Controls sample"
               lines 42 size 90
               font hfont
               control font hfont
               handle hsta.

           CALL "PCustomer" using 78-OPEN-I-O 

           initialize vis-pages
           move 1 to  vis(1) 
                    idx-prev.
           display mask-menu.

           perform LOAD-CONTROLS

           perform LOAD-MENU-POPUP

           perform RETRIEVE-CLIENT-INFO.
     
           perform until key-status = 27
              move 4 to accept-control
              accept mask-menu 
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 2   
                   continue
              when 3   
                   if vis(Simple-file-handler-page) = 1
                      PERFORM REC-DELETE
                   end-if
              when 5
                   if vis(Simple-file-handler-page) = 1
                      PERFORM REC-FIRST
                   end-if
              when 6
                   if vis(Simple-file-handler-page) = 1
                      PERFORM REC-PREV
                   end-if
              when 7
                   if vis(Simple-file-handler-page) = 1
                      PERFORM REC-NEXT
                   end-if
              when 8
                   if vis(Simple-file-handler-page) = 1
                      PERFORM REC-LAST
                   end-if
              when 9
                   if vis(Simple-file-handler-page) = 1
                      PERFORM REC-SAVE
                   end-if
              when 203
                   display message "Bitmap Push-Button enabled"
              when 204
                   display message "Bitmap Push-Button disabled"
              when 301
                   display message "Text Push-Button enabled"
              when 302
                   display message "Text Push-Button disabled"
              when 303 
                   initialize version
                   call "C$VERSION" using version
                   modify efversion value version       
              when 501
                   perform EXPORT-LISTBOX-TO-EXCEL
              when 601
                   perform EXPORT-GRID-TO-EXCEL
              when 801
                   perform SHOW-PICKER-RGB
              when 1103 
                   perform PRINT-PDF
              when 1101 
                   perform CREATE-WIN
              when 1102 
                   perform CALL-PRG
              when 8000
                   call "WD2$EXECJS" using js1
              when 5701 
                   modify efp value "item 1"
              when 5702 
                   modify efp value "item 2"
              when 5703 
                   modify efp value "item 3"
              end-evaluate
           end-perform.

           CALL "PCustomer" using 78-CLOSE

           display message "The program is terminated!"

           goback
           .

       LOAD-CONTROLS.

           modify amenu tab-to-add ( "Client Information"
                                     "Check / Radio" 
                                     "Push-Button"
                                     "Entry-Field / Date-Entry"
                                     "Combo-box / List-box" 
                                     "Grid"
                                     "Paged Grid"
                                     "ZK Java-bean" 
                                     "Tree-view" 
                                     "Simple File handler" 
                                     "Others")

           modify cb1 item-to-add "item1"
                      item-to-add "item2"
                      item-to-add "item3"
                      item-to-add "item4"
           modify lb1 item-to-add "01AABB"
                      item-to-add "02CCDD"
                      item-to-add "03EEFF"
                      item-to-add "04IILL"
           perform LB2-FIRST-PAGE-PAGED.

           perform varying ind from 1 by 1 until ind > 5
              initialize wrk-item
              string "item " delimited by size
                     ind     delimited by size
                     into wrk-item
              modify tv1  parent null
                          item-to-add  wrk-item
                          giving h-id
              perform varying ind2 from 1 by 1 until ind2 > 5
                 initialize wrk-item
                 string "item " delimited by size
                        ind     delimited by size
                        "-"     delimited by size
                        ind2    delimited by size
                        into wrk-item
                 modify tv1  parent h-id
                             item-to-add  wrk-item
              end-perform
           end-perform.

           perform varying ind from 1 by 1 until ind > 5
              initialize wrk-item
              string "item " delimited by size
                     ind     delimited by size
                     into wrk-item
              modify tv2  parent null
                          item-to-add  wrk-item
                          giving h-id
                          bitmap-number 14
                          bitmap-width 18 
              perform varying ind2 from 1 by 1 until ind2 > 5
                 initialize wrk-item
                 string "item " delimited by size
                        ind     delimited by size
                        "-"     delimited by size
                        ind2    delimited by size
                        into wrk-item
                 modify tv2  parent h-id
                             item-to-add  wrk-item
                             bitmap-number 17
                             bitmap-width 18 
                 end-perform
           end-perform.

           modify gd1(1, 1) cell-data "Col1"
           modify gd1(1, 2) cell-data "Col2"
           modify gd1(1, 3) cell-data "Col3"
           display entry-field numeric upon gd1(-1, 1) size 1
           display entry-field upon gd1(-1, 2) size 1
           display entry-field upon gd1(-1, 3) size 1
           modify gd1 record-to-add "01AABB"
                      record-to-add "02XXYY" 
                      record-to-add "03FFGG"
                      record-to-add "04HJKL"

           modify gd2(1, 1) cell-data "Col1"
           modify gd2(1, 2) cell-data "Col2"
           modify gd2(1, 3) cell-data "Col3"
           modify gd2 record-to-add "01AABB"
                      record-to-add "02XXYY" 
                      record-to-add "03FFGG"
                      record-to-add "04HJKL"

           modify gd3(1, 1) cell-data "Num"
           modify gd3(1, 2) cell-data "Description"

           perform GD3-FIRST-PAGE-PAGED
           
           move 1   to idx
           perform LOAD-SNIPPET.
           .

       LOAD-SNIPPET.
           evaluate idx
           when 1 
                move "client-info-snippet.html"    to snippet-path
           when 2 
                move "radio-check-snippet.html"    to snippet-path
           when 3
                move "push-button-snippet.html"    to snippet-path
           when 4
                move "entry-date-snippet.html"     to snippet-path
           when 5
                move "combo-list-box-snippet.html" to snippet-path
           when 6
                move "grid-snippet.html"           to snippet-path
           when 7
                move "paged-grid-snippet.html"     to snippet-path
           when 8
                move "java-bean-snippet.html"      to snippet-path
           when 9
                move "tree-view-snippet.html"      to snippet-path
           when 10
                move "file-handler-snippet.html"   to snippet-path
           when 11
                move "others-snippet.html"         to snippet-path
           end-evaluate

           open input snippet
           
           initialize code-snippet 
           if snippet-status = "00"
              perform until 1 = 2
                 read snippet
                    at end
                       exit perform
                 end-read
                 string code-snippet delimited by size
                        " "          delimited by size
                        rec-snippet  delimited by trailing space
                        into code-snippet 
              end-perform
              close snippet
           else
              string "<p>Code snippet not found. </p>"
                     "<p>Please review your installation.</p>"  
                     into code-snippet
           end-if.

           perform ACTIVATE-ZUL-DIV-JB.

           v-zul-div:>callMethod("setStyle" "overflow:auto;" 
                                   as string)

           if first-time
              set first-time to false
           else 
              v-zul-div:>callMethod("removeChild" myhtml)
           end-if

           set myhtml to zk-html:>new(code-snippet)

           v-zul-div:>callMethod("appendChild" myhtml)
            perform DEACTIVATE-ZUL-DIV-JB.
           .

       ACTIVATE-ZUL-DIV-JB.
           set curr-desktop to 
               v-zul-div:>callMethod("getDesktop",  null as string) 
                                           as zk-desktop
           try      
              zk-Executions:>activate(curr-desktop)
           catch exception
              exception-object:>printStackTrace
           end-try
           .
        
       DEACTIVATE-ZUL-DIV-JB.
           try
              zk-Executions:>deactivate(curr-desktop)
           catch exception
              exception-object:>printStackTrace
           end-try
           .

       BEF-EF.
           evaluate control-id
           when 301  modify l-bef title "Before Ef1"
           when 302  modify l-bef title "Before Ef2"
           when 303  modify l-bef title "Before Ef3"
           end-evaluate
           .

       AFT-EF.
           evaluate control-id
           when 301  modify l-aft title "After Ef1"
           when 302  modify l-aft title "After Ef2"
           when 303  modify l-aft title "After Ef3"
           end-evaluate
           .

       EVT-EF.
           if event-type = cmd-goto
              evaluate event-control-id
              when 301  modify l-evt title "cmd-goto Ef1"
              when 302  modify l-evt title "cmd-goto Ef2"
              when 303  modify l-evt title "cmd-goto Ef3"
              end-evaluate
           end-if
           .

       EVENT-LB1.
           evaluate event-type
           when ntf-selchange
                modify lb-list-row title event-data-1
           end-evaluate
           .

       EVENT-LB2.
           evaluate event-type
           when ntf-pl-next
                perform NEXT-LB-ELEMENT
           when ntf-pl-prev
                perform PREV-LB-ELEMENT
           when ntf-pl-nextpage
                perform NEXT-PAGE-LB-ELEMENT
           when ntf-pl-prevpage
                perform PREV-PAGE-LB-ELEMENT
           when ntf-pl-first
                perform LB2-FIRST-PAGE-PAGED
           when ntf-pl-last
                perform LB2-LAST-PAGE-PAGED
           end-evaluate.

       LB2-FIRST-PAGE-PAGED.
           modify lb2, mass-update = 1
           set lb2-ff  to true.
           move zero   to pagedIdxL
           perform NEXT-LB-ELEMENT num-lines-lb   times.
           modify lb2, mass-update = zero.

       LB2-LAST-PAGE-PAGED.
           modify lb2, mass-update = 1
           set lb2-rr  to true.
           compute pagedIdxL = max-paged-element + 1 
           perform prev-LB-ELEMENT num-lines-lb   times.
           modify lb2, mass-update = zero.

       NEXT-LB-ELEMENT.
           evaluate true
           when lb2-ff
                add 1  to pagedIdxL
           when lb2-rr
                compute pagedIdxL = pagedIdxL + num-lines-lb
           end-evaluate.

           set lb2-ff to true

           if pagedIdxL > max-paged-element
              set event-action to event-action-fail-terminate
              move max-paged-element  to pagedIdxL
           end-if
           if event-action not = event-action-fail-terminate
              modify LB2 item-to-add rec-paged(pagedIdxL)
           end-if.

       PREV-LB-ELEMENT.
           evaluate true
           when lb2-ff
                compute pagedIdxL = pagedIdxL - num-lines-lb
           when lb2-rr
                subtract 1  from pagedIdxL
           end-evaluate.
           
           set lb2-rr to true.

           if pagedIdxL < 1 
              set event-action to event-action-fail-terminate
              move 1           to pagedIdxL
           end-if
           if event-action not = event-action-fail-terminate
               modify lb2 insertion-index 1
               modify lb2 item-to-add rec-paged(pagedIdxL)
           end-if.

       NEXT-PAGE-LB-ELEMENT.
           modify lb2, mass-update = 1
           perform NEXT-LB-ELEMENT num-lines-lb times
           modify lb2, mass-update = 0.

       PREV-PAGE-LB-ELEMENT.
           modify lb2, mass-update = 1
           perform PREV-LB-ELEMENT num-lines-lb times
           modify lb2, mass-update = 0.

       CREATE-WIN.
           display floating window title "Sample Window"
                   line 6 col 30
                   lines 20 size 50
                   font hfont control font hfont
                   handle hflo
           display mask-win

           display tool-bar lines 3 
               upon hflo handle htool.
           display s-tool upon htool.

           perform LOAD-MENU-FLOATING.
           CALL "W$MENU" USING WMENU-SHOW, floating-menu.
           
           perform until key-status = 27
              accept mask-win 
                 on exception
                    continue
              end-accept
              evaluate key-status
              when 1001
              when 1002
              when 1003
                   compute curr-page = key-status - 1000
                   modify tdemo value=curr-page
              end-evaluate
           end-perform
           destroy mask-win htool
           destroy hflo
           move 0 to key-status 
           .

       LOAD-MENU-POPUP.
           CALL "W$MENU" USING WMENU-NEW-POPUP GIVING MENU-HANDLE   
           CALL "W$MENU" USING WMENU-ADD, MENU-HANDLE, 0, 0, "item 1", 
                               5701
           CALL "W$MENU" USING WMENU-ADD, MENU-HANDLE, 0, 0, "item 2", 
                               5702
           CALL "W$MENU" USING WMENU-ADD, MENU-HANDLE, 0, 0, "item 3", 
                               5703
           MOVE MENU-HANDLE TO POP-MENU
           .

       LOAD-MENU-FLOATING.
           CALL "W$MENU" USING WMENU-NEW GIVING MENU-HANDLE
           CALL "W$MENU" USING WMENU-NEW GIVING SUB-HANDLE-1
           CALL "W$MENU" USING WMENU-ADD, MENU-HANDLE, 0, 0,
                               "&Demo", 0, SUB-HANDLE-1
           CALL "W$MENU" USING WMENU-ADD, SUB-HANDLE-1, 0, 0,
                               "Page-1", 1001
           CALL "W$MENU" USING WMENU-ADD, SUB-HANDLE-1, 0, 0,
                               "Page-2", 1002
           CALL "W$MENU" USING WMENU-ADD, SUB-HANDLE-1, 0, 0,
                               "Page-3", 1003
           CALL "W$MENU" USING WMENU-NEW GIVING SUB-HANDLE-2
           CALL "W$MENU" USING WMENU-ADD, MENU-HANDLE, 0, 0,
                               "&Terminate", 0, SUB-HANDLE-2
           CALL "W$MENU" USING WMENU-ADD, SUB-HANDLE-2, 0, 0,
                               "&End", 27
           CALL "W$MENU" USING WMENU-ADD-BITMAP, SUB-HANDLE-2, 27
                               H-ICO, 1, 18
           MOVE MENU-HANDLE TO FLOATING-MENU.


       CALL-PRG.
           CALL "PROG2" USING "ABC"
           .

       REC-FIRST.
           MOVE LOW-VALUE TO W-KEY(1:)
           CALL "PCustomer" using 78-START-GREAT, W-KEY
           CALL "PCustomer" using 78-READ-NEXT, Customer-Rec
           IF RETURN-CODE > 9
              PERFORM SHOW-ERROR
           ELSE
              DISPLAY page10
           END-IF.

       REC-PREV.  
           CALL "PCustomer" using 78-READ-PREV, Customer-Rec
           IF RETURN-CODE > 9
              PERFORM SHOW-ERROR
           ELSE
              DISPLAY page10
           END-IF.

       REC-NEXT.  
           CALL "PCustomer" using 78-READ-NEXT, Customer-Rec
           IF RETURN-CODE > 9
              PERFORM SHOW-ERROR
           ELSE
              DISPLAY page10
           END-IF.

       REC-LAST.  
           MOVE HIGH-VALUE TO W-KEY
           CALL "PCustomer" using 78-START-LESS, W-KEY
           CALL "PCustomer" using 78-READ-NEXT, Customer-Rec
           IF RETURN-CODE > 9
              PERFORM SHOW-ERROR
           ELSE
              DISPLAY page10
           END-IF.

       REC-DELETE.
           DISPLAY MESSAGE 
                   "ARE YOU SURE YOU WANT TO DELETE THIS RECORD?" 
                   TYPE MB-YES-NO GIVING RESP
           IF RESP = 1
              CALL "PCustomer" using 78-DELETE, Cust-code
              IF RETURN-CODE > 9
                 PERFORM SHOW-ERROR
              ELSE
                 INITIALIZE Customer-Rec
                 DISPLAY page10
              END-IF
           END-IF.

       REC-SAVE.
           CALL "PCustomer" using 78-WRITE, Customer-Rec.
           IF RETURN-CODE = 22
              CALL "PCustomer" using 78-REWRITE, Customer-Rec
              IF RETURN-CODE > 9
                 PERFORM SHOW-ERROR
              END-IF
           END-IF.

       RETRIEVE-CLIENT-INFO.
           if not is-wd2
              modify ef-info value "Not available outside Web Direct 2.0
      -                            " environment"
           else
              call "WD2$CLIENT-INFO" using wd2-get-user-agent
                                              user-agent
              call "WD2$CLIENT-INFO" using wd2-get-browser-name
                                              browser-name

              perform until exit
                 call "WD2$SESSION"  using wd2-get-session-value 
                                           "iscobol.wd2.on_client_info.d
      -                                    "esktop.width" 
                                           desktop-width-px
                 call "WD2$SESSION"  using wd2-get-session-value 
                                           "iscobol.wd2.on_client_info.d
      -                                    "esktop.height" 
                                           desktop-height-px
                 call "WD2$SESSION"  using wd2-get-session-value 
                                           "iscobol.wd2.on_client_info.s
      -                                    "creen.width" 
                                           screen-width-px
                 call "WD2$SESSION"  using wd2-get-session-value 
                                           "iscobol.wd2.on_client_info.s
      -                                    "creen.height" 
                                           screen-height-px
                 if desktop-width-px  not = spaces and
                    desktop-height-px not = spaces and
                    screen-width-px   not = spaces and
                    screen-height-px  not = spaces
                    exit perform
                 else
                    call "C$SLEEP" using "0.3"
                 end-if
              end-perform
              string "User Agent: " user-agent x"0a"
                     "Browser: "    browser-name x"0a"
                     "Desktop: "    desktop-width-px "x"
                                    desktop-height-px x"0a"
                     "Screen: "     screen-width-px "x"
                                    screen-height-px x"0a"
                                    delimited by size into client-info
              modify ef-info value client-info
           end-if
           .

       PRINT-PDF.
           modify pb-pdf css-icon "fa-spinner fa-spin"
           accept pdf-position from environment "pdf.prefix" 
           string pdf-position  delimited by trailing space
                  "/output.pdf" delimited by size
                  into pdf-position

           string "-P PDF "     delimited by size
                  pdf-position  delimited by trailing space
                  into pdf-path

           open output print-file
           write print-rec from 
                 "This line has been printed by isCOBOL Web Direct 2.0"
           close print-file   
           modify pb-pdf css-icon "fa-file-pdf-o"
           if print-status = "00"
              accept pdf-position from environment "pdf.js.prefix"
              string pdf-position  delimited by trailing space
                     "/output.pdf" delimited by size
                     into pdf-position
              
              call "WD2$REDIRECT" using pdf-position, "_blank"
                         giving return-code
           else
              display message "An error occurred, " x"0a"
                              "Status: " print-status
                              icon mb-warning-icon
           end-if
           .

       EV-FILEUP.
           if event-type = msg-jb-event
              if event-data-2 = ZK-EVT-ONUPLOAD 
                 accept upload-position from environment "upload.prefix" 
                 try
                    set w-zk-upload-event 
                        to j-evt:>getSource as zk-upload-event
                    set w-zk-media to w-zk-upload-event:>getMedia
                    set w-zk-media-name to w-zk-media:>getName
                    if w-zk-media-name not = null
                       set w-zk-media-url 
                           to j-string:>new(upload-position)
                       set w-j-fileoutput 
                           to j-fileoutput:>new(w-zk-media-url
                                          :>concat("/")
                                          :>concat(w-zk-media-name));;
                       w-j-fileoutput:>write(w-zk-media:>getByteData)
                       w-j-fileoutput:>close
                       display message '"'w-zk-media-name '" UPLOADED'
                    end-if
                 catch exception
                    exception-object:>printStackTrace
                 end-try
              end-if
           end-if
           .

       EXPORT-LISTBOX-TO-EXCEL.
           accept excel-position from environment "excel.prefix" 
           string excel-position     delimited by trailing space
                  "/isCOBOLLISTBOX.xlsx"   delimited by size
                  into excel-position

           modify lb1 export-file-name excel-position
           modify lb1 export-file-format = "xlxs".
           modify lb1 action action-export.

           accept excel-position from environment "excel.js.prefix"
           string excel-position  delimited by trailing space
                  "/isCOBOLLISTBOX.xlsx" delimited by size
                 into excel-position
           call "WD2$REDIRECT" using excel-position, "_blank"
                              giving return-code.

       EXPORT-GRID-TO-EXCEL.
           accept excel-position from environment "excel.prefix" 
           string excel-position     delimited by trailing space
                  "/isCOBOLGRID.xlsx"   delimited by size
                  into excel-position

           modify gd1 export-file-name excel-position
           modify gd1 export-file-format = "xlxs".
           modify gd1 action action-export.

           accept excel-position from environment "excel.js.prefix"
           string excel-position  delimited by trailing space
                  "/isCOBOLGRID.xlsx" delimited by size
                 into excel-position
           call "WD2$REDIRECT" using excel-position, "_blank"
                              giving return-code.

       SHOW-PICKER-RGB.
           set picker-color to jb-colorbox:>callMethod("getValue").

           move function hex2dec(function upper-case(red-val)) 
                                                           to red-disp.
           move function hex2dec(function upper-case(green-val)) 
                                                           to green-disp
           move function hex2dec(function upper-case(blue-val)) 
                                                           to blue-disp.

           modify ef-red     value red-disp
           modify ef-green   value green-disp
           modify ef-blue    value blue-disp
           compute buffer-bk = (red-disp * 65536 + 
                                green-disp * 256 + 
                                blue-disp) * -1
           modify LB-RESULT background-color buffer-bk.

       SHOW-ERROR.
           IF RETURN-CODE = 10
              DISPLAY MESSAGE "Error: NO MORE RECORDS"
           ELSE
              DISPLAY MESSAGE "Error: " RETURN-CODE
           END-IF 
           .

       PAGED-GRID-EVENT.
           evaluate event-type
           when msg-paged-first 
                move 0 to pagedIdx
           when msg-paged-last
                move 21 to pagedIdx
           when msg-paged-prevpage
           when msg-paged-nextpage 
                continue
           when msg-paged-prev
                perform event-data-2 times
                   subtract 1 from pagedIdx
                   if pagedIdx < 1 
                      set event-action to event-action-fail
                      exit perform
                   end-if
                end-perform
                if event-action not = event-action-fail
                   modify gd3 insertion-index 2
                   modify gd3 record-to-add rec-paged(pagedIdx)
                end-if
           when msg-paged-next
                perform event-data-2 times
                   add 1 to pagedIdx
                   if pagedIdx > max-paged-element
                      set event-action to event-action-fail
                      exit perform
                   end-if
                end-perform
                if event-action not = event-action-fail
                   modify gd3 record-to-add rec-paged(pagedIdx)
                end-if
           end-evaluate
           .

       GD3-FIRST-PAGE-PAGED.
           move 6 to pagedIdx
           modify gd3 mass-update 1
           perform varying i from 1 by 1 until i > pagedIdx
              modify gd3 record-to-add rec-paged(i)
           end-perform
           modify gd3 mass-update 0
           .

       ACCORDION-EVENT.
           if event-type = cmd-tabchanged
              inquire amenu value menu-page
              move menu-page to idx
              initialize  vis-pages 
              move 1 to vis(idx)
              evaluate idx-prev
              when 1  display page1
              when 2  display page2
              when 3  display page3
              when 4  display page4
              when 5  display page5
              when 6  display page6
              when 7  display page7 
              when 8  display page8 
              when 9  display page9 
              when 10 display page10 
              when 11 display page11
              end-evaluate
              evaluate idx
              when 1  display page1
              when 2  display page2
              when 3  display page3
              when 4  display page4
              when 5  display page5
              when 6  display page6
              when 7  display page7 
              when 8  display page8 
              when 9  display page9 
              when 10 display page10 
              when 11 display page11
              end-evaluate
              move idx to idx-prev
              perform LOAD-SNIPPET
           end-if.
              