/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.EventDispatchUtils;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorListener;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorSaveEvent;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditor;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import java.io.InputStream;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JHTMLEditorTinyMCE
implements JHTMLEditor.JHTMLEditorImplementation {
    private static final String PACKAGE_PREFIX = "/tiny_mce/";
    private static final String EDITOR_INSTANCE = "HTMLeditor1";
    private final JHTMLEditor htmlEditor;
    private final String customOptions;
    private final String customHTMLHeaders;
    private static final String LS = Utils.LINE_SEPARATOR;
    private volatile Object tempResult;

    public JHTMLEditorTinyMCE(JHTMLEditor htmlEditor, Map<Object, Object> optionMap) {
        if (this.getClass().getResource("/tiny_mce/tiny_mce.js") == null) {
            throw new IllegalStateException("The TinyMCE distribution is missing from the classpath!");
        }
        this.htmlEditor = htmlEditor;
        Map customOptionsMap = (Map)optionMap.get("TinyMCE Options");
        if (customOptionsMap != null) {
            StringBuilder sb = new StringBuilder();
            for (String key : customOptionsMap.keySet()) {
                String value = (String)customOptionsMap.get(key);
                if (value == null || value.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(String.valueOf(',') + LS);
                }
                sb.append("        " + key + ": " + value);
            }
            this.customOptions = sb.length() > 0 ? sb.toString() : null;
        } else {
            this.customOptions = null;
        }
        this.customHTMLHeaders = (String)optionMap.get("TinyMCE Custom HTML Headers");
        htmlEditor.getWebBrowser().addWebBrowserListener(new WebBrowserAdapter(){

            public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
                e.setDialogWindow(true);
            }
        });
    }

    @Override
    public WebServer.WebServerContent getWebServerContent(final WebServer.HTTPRequest httpRequest, final String resourcePath, int instanceID) {
        if ("index.html".equals(resourcePath)) {
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    int index = resourcePath.lastIndexOf(46);
                    return 2.getDefaultMimeType(index == -1 ? null : resourcePath.substring(index));
                }

                public InputStream getInputStream() {
                    String content = "<html xmlns=\"http://www.w3.org/1999/xhtml\">" + LS + "  <head>" + LS + "    <title></title>" + LS + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>" + LS + "    <style type=\"text/css\">" + LS + "      body, form {margin: 0; padding: 0; overflow: auto;}" + LS + "    </style>" + LS + (JHTMLEditorTinyMCE.this.customHTMLHeaders != null ? String.valueOf(JHTMLEditorTinyMCE.this.customHTMLHeaders) + LS : "") + "    <script type=\"text/javascript\" src=\"tiny_mce.js\"></script>" + LS + "    <script type=\"text/javascript\">" + LS + "      function debug (text) {" + LS + "        document.getElementById ('debug').innerHTML = text;" + LS + "      }" + LS + "      var sendCommand = " + "sendNSCommand" + ";" + LS + "      var htmlContent;" + LS + "      var htmlDirtyTracker;" + LS + "      var isDirtyTrackingActive = true;" + LS + "      function JH_checkDirty() {" + LS + "        var inst = tinyMCE.get ('" + JHTMLEditorTinyMCE.EDITOR_INSTANCE + "');" + LS + "        if(htmlContent == null) {" + LS + "          try {" + LS + "            htmlContent = inst.getContent();" + LS + "          } catch(e) {" + LS + "          }" + LS + "          htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "        } else {" + LS + "          try {" + LS + "            var newHtmlContent = inst.getContent();" + LS + "            if(newHtmlContent != htmlContent) {" + LS + "              htmlContent = null;" + LS + "              htmlDirtyTracker = null;" + LS + "              sendCommand('[Chrriis]JH_setDirty');" + LS + "            } else {" + LS + "              htmlContent = newHtmlContent;" + LS + "              htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "            }" + LS + "          } catch(e) {" + LS + "            htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "          }" + LS + "        }" + LS + "      }" + LS + "      function JH_clearDirtyIndicator() {" + LS + "        if(htmlDirtyTracker) {" + LS + "          clearTimeout(htmlDirtyTracker);" + LS + "        }" + LS + "        htmlContent = null;" + LS + "        if(isDirtyTrackingActive) {" + LS + "          htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "        }" + LS + "      }" + LS + "      function JH_setDirtyTrackingActive(isActive) {" + LS + "        isDirtyTrackingActive = isActive;" + LS + "        JH_clearDirtyIndicator();" + LS + "      }" + LS + "      function JH_setData (html) {" + LS + "        tinyMCE.get ('" + JHTMLEditorTinyMCE.EDITOR_INSTANCE + "').setContent (decodeURIComponent (html));" + LS + "        JH_clearDirtyIndicator();" + LS + "      }" + LS + "      function JH_sendData () {" + LS + "        tinyMCE.get ('" + JHTMLEditorTinyMCE.EDITOR_INSTANCE + "').save ();" + LS + "        document.jhtml_form.action = 'jhtml_sendData';" + LS + "        document.jhtml_form.submit ();" + LS + "      }" + LS + "      function JH_doSave () {" + LS + "        tinyMCE.get ('" + JHTMLEditorTinyMCE.EDITOR_INSTANCE + "').save ();" + LS + "        document.jhtml_form.action = 'jhtml_save';" + LS + "        document.jhtml_form.submit ();" + LS + "        return false;" + LS + "      }" + LS + "      var opts = {" + LS + "        mode: 'exact'," + LS + "        elements: '" + JHTMLEditorTinyMCE.EDITOR_INSTANCE + "'," + LS + "        theme: 'advanced'," + LS + "        save_onsavecallback : 'JH_doSave'," + LS + "        setup: function (ed) {" + LS + "          ed.onInit.add (function (ed) {" + LS + "            sendCommand ('[Chrriis]JH_setLoaded');" + LS + "          })" + LS + "        }" + LS + "      };" + LS + (JHTMLEditorTinyMCE.this.customOptions != null ? "      var addOpts = {" + LS + JHTMLEditorTinyMCE.this.customOptions + LS + "      };" + LS + "      for (var x in addOpts) {" + LS + "        opts[x] = addOpts[x];" + LS + "      }" + LS : "") + "      tinyMCE.init (opts);" + LS + "      JH_clearDirtyIndicator();" + LS + "    </script>" + LS + "  </head>" + LS + "  <body>" + LS + "    <div id=\"debug\"></div>" + LS + "    <iframe style=\"display:none;\" name=\"j_iframe\"></iframe>" + LS + "    <form name=\"jhtml_form\" method=\"POST\" target=\"j_iframe\">" + LS + "      <textarea name=\"" + JHTMLEditorTinyMCE.EDITOR_INSTANCE + "\" id=\"" + JHTMLEditorTinyMCE.EDITOR_INSTANCE + "\" style=\"width:100%;height:100%\"></textarea>" + LS + "    </form>" + LS + "  </body>" + LS + "</html>" + LS;
                    return 2.getInputStream((String)content);
                }
            };
        }
        if ("jhtml_save".equals(resourcePath)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String html = JHTMLEditor.convertLinksToLocal((String)httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(JHTMLEditorTinyMCE.EDITOR_INSTANCE));
                    HTMLEditorSaveEvent e = null;
                    HTMLEditorListener[] hTMLEditorListenerArray = JHTMLEditorTinyMCE.this.htmlEditor.getHTMLEditorListeners();
                    int n = hTMLEditorListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HTMLEditorListener listener = hTMLEditorListenerArray[n2];
                        if (e == null) {
                            e = new HTMLEditorSaveEvent(JHTMLEditorTinyMCE.this.htmlEditor, html);
                        }
                        listener.saveHTML(e);
                        ++n2;
                    }
                }
            });
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Save successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 4.getInputStream((String)content);
                }
            };
        }
        if ("jhtml_sendData".equals(resourcePath)) {
            String data = (String)httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(EDITOR_INSTANCE);
            this.tempResult = data;
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Send data successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 5.getInputStream((String)content);
                }
            };
        }
        return WebServer.getDefaultWebServer().getURLContent(WebServer.getDefaultWebServer().getClassPathResourceURL(JHTMLEditor.class.getName(), PACKAGE_PREFIX + resourcePath));
    }

    @Override
    public void clearDirtyIndicator() {
        this.htmlEditor.getWebBrowser().executeJavascript("JH_clearDirtyIndicator();");
    }

    @Override
    public void setDirtyTrackingActive(boolean isDirtyTrackingActive) {
        this.htmlEditor.getWebBrowser().executeJavascript("JH_setDirtyTrackingActive(" + isDirtyTrackingActive + ");");
    }

    @Override
    public String getHTMLContent() {
        JWebBrowser webBrowser = this.htmlEditor.getWebBrowser();
        if (!webBrowser.isNativePeerInitialized()) {
            return "";
        }
        this.tempResult = this;
        webBrowser.executeJavascript("JH_sendData();");
        int i = 0;
        while (i < 20) {
            EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                public boolean getValue() {
                    return JHTMLEditorTinyMCE.this.tempResult != JHTMLEditorTinyMCE.this;
                }
            }, 50);
            if (this.tempResult != this) {
                return (String)this.tempResult;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setHTMLContent(String html) {
        JWebBrowser webBrowser = this.htmlEditor.getWebBrowser();
        NativeComponent nativeComponent = webBrowser.getNativeComponent();
        boolean isEnabled = nativeComponent.isEnabled();
        nativeComponent.setEnabled(false);
        new Message().syncSend(true);
        webBrowser.executeJavascript("JH_setData('" + Utils.encodeURL((String)html) + "');");
        new Message().syncSend(true);
        nativeComponent.setEnabled(isEnabled);
    }
}

