/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components.core;

import chrriis.dj.nativeswing.swtimpl.components.JFileDialog;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeFileDialog;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.core.NativeModalDialogHandler;
import java.awt.Component;
import java.io.Serializable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

class NativeFileDialog
implements INativeFileDialog {
    private Data data = new Data();

    NativeFileDialog() {
    }

    public void show(Component component) {
        new NativeModalDialogHandler(){

            protected void processResult(Object result) {
                NativeFileDialog.this.data = (Data)result;
            }
        }.showModalDialog(component, new CMN_openFileDialog(), this.data);
    }

    public String getSelectedFileName() {
        String[] selectedFileNames = this.getSelectedFileNames();
        return selectedFileNames.length >= 1 ? selectedFileNames[0] : null;
    }

    public String[] getSelectedFileNames() {
        if (this.data.selectedFileNames == null) {
            return new String[0];
        }
        String[] selectedFileNames = new String[this.data.selectedFileNames.length];
        System.arraycopy(this.data.selectedFileNames, 0, selectedFileNames, 0, selectedFileNames.length);
        return selectedFileNames;
    }

    public void setSelectedFileName(String selectedFileName) {
        this.data.selectedFileNames = new String[]{selectedFileName};
    }

    public JFileDialog.SelectionMode getSelectionMode() {
        return this.data.isMulti ? JFileDialog.SelectionMode.MULTIPLE_SELECTION : JFileDialog.SelectionMode.SINGLE_SELECTION;
    }

    public void setSelectionMode(JFileDialog.SelectionMode selectionMode) {
        this.data.isMulti = selectionMode == JFileDialog.SelectionMode.MULTIPLE_SELECTION;
    }

    public JFileDialog.DialogType getDialogType() {
        return this.data.isSave ? JFileDialog.DialogType.SAVE_DIALOG_TYPE : JFileDialog.DialogType.OPEN_DIALOG_TYPE;
    }

    public void setDialogType(JFileDialog.DialogType dialogType) {
        this.data.isSave = dialogType == JFileDialog.DialogType.SAVE_DIALOG_TYPE;
    }

    public void setConfirmedOverwrite(boolean isConfirmedOverwrite) {
        this.data.isConfirmedOverwrite = isConfirmedOverwrite;
    }

    public boolean isConfirmedOverwrite() {
        return this.data.isConfirmedOverwrite;
    }

    public String getParentDirectory() {
        return this.data.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.data.parentDirectory = parentDirectory;
    }

    public void setExtensionFilters(String[] extensionFilters, String[] extensionFiltersNames, int selectedExtensionFilterIndex) {
        if (extensionFiltersNames != null && (extensionFilters == null || extensionFilters.length != extensionFiltersNames.length)) {
            throw new IllegalArgumentException("Filter descriptions can only be defined when filter extensions are defined, and the two arrays must have the same size!");
        }
        this.data.extensionFilters = extensionFilters;
        this.data.extensionFiltersNames = extensionFiltersNames;
        this.data.selectedExtensionFilterIndex = selectedExtensionFilterIndex;
    }

    public String[] getExtensionFilters() {
        return this.data.extensionFilters;
    }

    public String[] getExtensionFiltersNames() {
        return this.data.extensionFiltersNames;
    }

    public int getSelectedExtensionFilterIndex() {
        return this.data.selectedExtensionFilterIndex;
    }

    public void setTitle(String title) {
        this.data.title = title;
    }

    public String getTitle() {
        return this.data.title;
    }

    private static class CMN_openFileDialog
    extends ControlCommandMessage {
        private CMN_openFileDialog() {
        }

        public Object run(Object[] args) {
            Data data = (Data)args[0];
            Control control = this.getControl();
            if (control.isDisposed()) {
                return data;
            }
            int style = 0;
            if (data.isSave) {
                style |= 0x2000;
            }
            if (data.isMulti) {
                style |= 2;
            }
            FileDialog fileDialog = new FileDialog(control.getShell(), style);
            if (data.title != null) {
                fileDialog.setText(data.title);
            }
            fileDialog.setOverwrite(data.isConfirmedOverwrite);
            if (data.parentDirectory != null) {
                fileDialog.setFilterPath(data.parentDirectory);
            }
            if (data.selectedFileNames != null && data.selectedFileNames.length == 1) {
                fileDialog.setFileName(data.selectedFileNames[0]);
            }
            if (data.extensionFilters != null) {
                fileDialog.setFilterExtensions(data.extensionFilters);
                fileDialog.setFilterNames(data.extensionFiltersNames);
                fileDialog.setFilterIndex(data.selectedExtensionFilterIndex);
            }
            fileDialog.open();
            data.selectedFileNames = fileDialog.getFileNames();
            data.selectedExtensionFilterIndex = fileDialog.getFilterIndex();
            data.parentDirectory = fileDialog.getFilterPath();
            if (data.parentDirectory.length() == 0) {
                data.parentDirectory = null;
            }
            return data;
        }
    }

    private static class Data
    implements Serializable {
        public String title;
        public boolean isSave;
        public boolean isMulti;
        public boolean isConfirmedOverwrite;
        public String[] selectedFileNames;
        public String[] extensionFiltersNames;
        public String[] extensionFilters;
        public int selectedExtensionFilterIndex;
        public String parentDirectory;

        private Data() {
        }
    }
}

