/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.thin.base.screen.jcalendarbutton;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jbundle.thin.base.screen.jcalendarbutton.JCalendarPopup;

public class JCalendarButton
extends JButton
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String LANGUAGE_PARAM = "language";
    String dateParam = "date";
    Date targetDate = null;
    String languageString = null;

    public JCalendarButton() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            ImageIcon icon = new ImageIcon(cl.getResource("images/buttons/Calendar.gif"));
            this.setIcon(icon);
        }
        catch (Exception ex) {
            this.setText("change");
        }
        this.setName("JCalendarButton");
        this.setMargin(JCalendarPopup.NO_INSETS);
        this.setOpaque(false);
        this.addActionListener(this);
    }

    public JCalendarButton(Date dateTarget) {
        this();
        this.init(null, dateTarget, null);
    }

    public JCalendarButton(String strDateParam, Date dateTarget) {
        this();
        this.init(strDateParam, dateTarget, null);
    }

    public JCalendarButton(String strDateParam, Date dateTarget, String strLanguage) {
        this();
        this.init(strDateParam, dateTarget, strLanguage);
    }

    public void init(String strDateParam, Date dateTarget, String strLanguage) {
        if (strDateParam == null) {
            strDateParam = "date";
        }
        this.dateParam = strDateParam;
        this.targetDate = dateTarget;
        this.languageString = strLanguage;
    }

    public Date getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(Date dateTarget) {
        this.targetDate = dateTarget;
    }

    public String getDateParam() {
        return this.dateParam;
    }

    public void setDateParam(String newParam) {
        this.dateParam = newParam;
    }

    public String getLanguage() {
        return this.languageString;
    }

    public void setLanguage(String languageString) {
        this.languageString = languageString;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this) {
            Date dateTarget = this.getTargetDate();
            JCalendarPopup popup = JCalendarPopup.createCalendarPopup(this.getDateParam(), dateTarget, this, this.languageString);
            popup.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        if (this.dateParam.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof Date) {
            this.targetDate = (Date)evt.getNewValue();
        }
        if (LANGUAGE_PARAM.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof String) {
            this.languageString = (String)evt.getNewValue();
        }
    }
}

