/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.thin.base.screen.jcalendarbutton;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jbundle.thin.base.screen.jcalendarbutton.JCalendarButton;

public class JCalendarPopup
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String DATE_PARAM = "date";
    protected String dateParam = "date";
    public static Border ROLLOVER_BORDER = new LineBorder(Color.GRAY, 1);
    public static Border SELECTED_BORDER = new LineBorder(Color.BLUE, 1);
    public static Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    public static final long KMS_IN_A_DAY = 86400000L;
    protected Date targetDate = null;
    protected Date targetPanelDate = null;
    protected Date selectedDate = null;
    protected Date nowDate = null;
    protected boolean firstTime = true;
    protected int targetComponent = 0;
    protected Calendar calendar = Calendar.getInstance();
    protected StringBuffer stringBuffer = new StringBuffer();
    protected DateFormat dateFormat = DateFormat.getDateInstance(0);
    private JPanel monthPanel;
    private JButton previousMonthButton;
    private JLabel monthLabel;
    private JButton nextMonthButton;
    private JPanel yearPanel;
    private JButton previousYearButton;
    private JLabel yearLabel;
    private JButton nextYearButton;
    private JPanel panelDays;
    protected boolean transferFocus = true;
    public static final String CALENDAR_ICON = "Calendar";
    public static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private Border oldBorder = EMPTY_BORDER;

    public JCalendarPopup() {
    }

    public JCalendarPopup(Date date) {
        this();
        this.init(null, date, null);
    }

    public JCalendarPopup(String strDateParam, Date date) {
        this();
        this.init(strDateParam, date, null);
    }

    public JCalendarPopup(String strDateParam, Date date, String strLanguage) {
        this();
        this.init(strDateParam, date, strLanguage);
    }

    public void init(String strDateParam, Date dateTarget, String strLanguage) {
        Locale locale;
        if (strDateParam != null) {
            this.dateParam = strDateParam;
        }
        this.initComponents();
        this.setName("JCalendarPopup");
        this.nowDate = new Date();
        if (dateTarget == null) {
            dateTarget = this.nowDate;
        }
        this.selectedDate = dateTarget;
        if (strLanguage != null && (locale = new Locale(strLanguage, "")) != null) {
            this.calendar = Calendar.getInstance(locale);
            this.dateFormat = DateFormat.getDateInstance(0, locale);
        }
        this.calendar.setTime(dateTarget);
        this.calendar.set(11, 12);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.targetDate = this.calendar.getTime();
        this.layoutCalendar(this.targetDate);
        if (dateTarget == this.nowDate) {
            this.selectedDate = this.targetDate;
        }
    }

    public void layoutCalendar(Date dateTarget) {
        this.calendar.setTime(dateTarget);
        this.calendar.set(11, 12);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.targetPanelDate = this.calendar.getTime();
        this.calendar.set(5, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        Date dateFirstOfMonth = this.calendar.getTime();
        this.calendar.setTime(dateFirstOfMonth);
        this.calendar.add(2, 1);
        this.calendar.add(5, -1);
        this.calendar.set(11, 23);
        this.calendar.set(12, 59);
        this.calendar.set(13, 59);
        this.calendar.set(14, 999);
        Date dateLastOfMonth = this.calendar.getTime();
        Date dateCalendarFirstDate = this.getFirstDateInCalendar(dateFirstOfMonth);
        Date dateCalendar = new Date(dateCalendarFirstDate.getTime());
        this.targetComponent = (int)((this.targetDate.getTime() - dateCalendarFirstDate.getTime()) / 86400000L);
        if (this.targetComponent < 0) {
            --this.targetComponent;
        }
        String strYear = this.getDateString(dateTarget, 1);
        String strMonth = this.getDateString(dateTarget, 2);
        this.monthLabel.setText(strMonth);
        this.yearLabel.setText(strYear);
        int iDayOfWeekComponent = 0;
        for (int iDayComponent = 7; iDayComponent < this.panelDays.getComponentCount(); ++iDayComponent) {
            if (iDayOfWeekComponent < 7) {
                JLabel labelDayOfWeek = (JLabel)this.panelDays.getComponent(iDayOfWeekComponent);
                String strWeek = this.getDateString(dateCalendar, 9);
                if (strWeek != null && strWeek.length() > 0) {
                    labelDayOfWeek.setText(strWeek.substring(0, 1));
                } else {
                    labelDayOfWeek.setText(Integer.toString(iDayOfWeekComponent));
                }
            }
            JLabel labelDay = (JLabel)this.panelDays.getComponent(iDayComponent);
            String strDay = this.getDateString(dateCalendar, 3);
            labelDay.setText(strDay);
            if (dateCalendar.before(dateFirstOfMonth) || dateCalendar.after(dateLastOfMonth)) {
                labelDay.setForeground(Color.GRAY);
            } else {
                labelDay.setForeground(Color.BLACK);
            }
            labelDay.setBackground(this.panelDays.getBackground());
            if (this.targetComponent == iDayComponent - 7) {
                labelDay.setBorder(SELECTED_BORDER);
            } else {
                labelDay.setBorder(EMPTY_BORDER);
            }
            this.calendar.setTime(dateCalendar);
            this.calendar.add(5, 1);
            dateCalendar = this.calendar.getTime();
            if (this.firstTime) {
                labelDay.addMouseListener(this);
                labelDay.setName(Integer.toString(iDayComponent - 7));
            }
            ++iDayOfWeekComponent;
        }
        this.firstTime = false;
    }

    private void initComponents() {
        JLabel label;
        int i;
        ImageIcon icon;
        ClassLoader cl = this.getClass().getClassLoader();
        this.setLayout(new BoxLayout(this, 1));
        this.monthPanel = new JPanel();
        this.monthPanel.setName("monthPanel");
        this.monthPanel.setLayout(new BoxLayout(this.monthPanel, 0));
        this.previousMonthButton = new JButton();
        this.previousMonthButton.setName("previousMonthButton");
        this.monthLabel = new JLabel();
        this.monthLabel.setName("monthLabel");
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Back.gif"));
            this.previousMonthButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.previousMonthButton.setText("<");
        }
        this.previousMonthButton.setMargin(new Insets(2, 2, 2, 2));
        this.previousMonthButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.prevMonthActionPerformed(evt);
            }
        });
        this.monthPanel.add(this.previousMonthButton);
        this.monthPanel.add(Box.createHorizontalGlue());
        this.monthLabel.setText("month");
        this.monthLabel.setHorizontalAlignment(0);
        this.monthPanel.add(this.monthLabel);
        this.nextMonthButton = new JButton();
        this.nextMonthButton.setName("nextMonthButton");
        this.nextMonthButton.setAlignmentX(1.0f);
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Forward.gif"));
            this.nextMonthButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.nextMonthButton.setText(">");
        }
        this.nextMonthButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextMonthButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.nextMonthActionPerformed(evt);
            }
        });
        this.monthPanel.add(Box.createHorizontalGlue());
        this.monthPanel.add(this.nextMonthButton);
        this.add(this.monthPanel);
        this.yearPanel = new JPanel();
        this.yearPanel.setName("yearPanel");
        this.yearPanel.setLayout(new BoxLayout(this.yearPanel, 0));
        this.previousYearButton = new JButton();
        this.previousYearButton.setName("previousYearButton");
        this.yearLabel = new JLabel();
        this.yearLabel.setName("yearLabel");
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Back.gif"));
            this.previousYearButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.previousYearButton.setText("<");
        }
        this.previousYearButton.setMargin(new Insets(2, 2, 2, 2));
        this.previousYearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.prevYearActionPerformed(evt);
            }
        });
        this.yearPanel.add(this.previousYearButton);
        this.yearPanel.add(Box.createHorizontalGlue());
        this.yearLabel.setText("Year");
        this.yearLabel.setHorizontalAlignment(0);
        this.yearPanel.add(this.yearLabel);
        this.yearPanel.add(Box.createHorizontalGlue());
        this.nextYearButton = new JButton();
        this.nextYearButton.setName("nextYearButton");
        this.nextYearButton.setAlignmentX(1.0f);
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Forward.gif"));
            this.nextYearButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.nextYearButton.setText(">");
        }
        this.nextYearButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextYearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.nextYearActionPerformed(evt);
            }
        });
        this.yearPanel.add(this.nextYearButton);
        this.add(this.yearPanel);
        this.panelDays = new JPanel();
        this.panelDays.setName("panelDays");
        this.panelDays.setLayout(new GridLayout(7, 7));
        for (i = 1; i <= 7; ++i) {
            label = new JLabel();
            label.setText(Integer.toString(i));
            label.setHorizontalAlignment(0);
            this.panelDays.add(label);
        }
        for (i = 1; i <= 42; ++i) {
            label = new JLabel();
            label.setBorder(EMPTY_BORDER);
            label.setHorizontalAlignment(0);
            this.panelDays.add(label);
        }
        this.add(this.panelDays);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    private void nextMonthActionPerformed(ActionEvent evt) {
        this.calendar.setTime(this.targetPanelDate);
        this.calendar.add(2, 1);
        this.calendar.set(11, 12);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.targetPanelDate = this.calendar.getTime();
        this.layoutCalendar(this.targetPanelDate);
    }

    private void prevMonthActionPerformed(ActionEvent evt) {
        this.calendar.setTime(this.targetPanelDate);
        this.calendar.add(2, -1);
        this.calendar.set(11, 12);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.targetPanelDate = this.calendar.getTime();
        this.layoutCalendar(this.targetPanelDate);
    }

    private void nextYearActionPerformed(ActionEvent evt) {
        this.calendar.setTime(this.targetPanelDate);
        this.calendar.add(1, 1);
        this.calendar.set(11, 12);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.targetPanelDate = this.calendar.getTime();
        this.layoutCalendar(this.targetPanelDate);
    }

    private void prevYearActionPerformed(ActionEvent evt) {
        this.calendar.setTime(this.targetPanelDate);
        this.calendar.add(1, -1);
        this.calendar.set(11, 12);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.targetPanelDate = this.calendar.getTime();
        this.layoutCalendar(this.targetPanelDate);
    }

    public Date getFirstDateInCalendar(Date dateTarget) {
        int iFirstDayOfWeek = this.calendar.getFirstDayOfWeek();
        this.calendar.setTime(dateTarget);
        int iTargetDayOfWeek = this.calendar.get(7);
        int iOffset = -Math.abs(iTargetDayOfWeek - iFirstDayOfWeek);
        this.calendar.add(5, iOffset);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    public String getDateString(Date dateTarget, int iDateFormat) {
        this.stringBuffer.setLength(0);
        FieldPosition fieldPosition = new FieldPosition(iDateFormat);
        String string = null;
        string = this.dateFormat.format(dateTarget, this.stringBuffer, fieldPosition).toString();
        int iBegin = fieldPosition.getBeginIndex();
        int iEnd = fieldPosition.getEndIndex();
        string = string.substring(iBegin, iEnd);
        return string;
    }

    public void mouseClicked(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
        int iOffsetDay = Integer.parseInt(button.getName());
        iOffsetDay -= this.targetComponent;
        this.calendar.setTime(this.selectedDate);
        int hour = this.calendar.get(11);
        int minute = this.calendar.get(12);
        int second = this.calendar.get(13);
        int ms = this.calendar.get(14);
        this.calendar.setTime(this.targetDate);
        this.calendar.add(5, iOffsetDay);
        if (hour == 0 && minute == 0 && second == 0 && ms == 0) {
            hour = 12;
        }
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        this.calendar.set(14, ms);
        Date date = this.calendar.getTime();
        JPopupMenu popupMenu = this.getJPopupMenu();
        if (popupMenu != null) {
            Component invoker = popupMenu.getInvoker();
            this.getParent().remove(this);
            Container container = popupMenu.getParent();
            popupMenu.setVisible(false);
            container.remove(popupMenu);
            if (invoker != null && this.transferFocus) {
                invoker.transferFocus();
            }
        }
        Date oldDate = this.selectedDate;
        if (this.selectedDate == this.targetDate) {
            oldDate = null;
        }
        this.firePropertyChange(this.dateParam, oldDate, date);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
        this.oldBorder = button.getBorder();
        button.setBorder(ROLLOVER_BORDER);
    }

    public void mouseExited(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
        button.setBorder(this.oldBorder);
    }

    private JPopupMenu getJPopupMenu() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JPopupMenu)) continue;
            return (JPopupMenu)parent;
        }
        return null;
    }

    public static JCalendarPopup createCalendarPopup(Date dateTarget, Component button) {
        return JCalendarPopup.createCalendarPopup(null, dateTarget, button, null);
    }

    public static JCalendarPopup createCalendarPopup(String strDateParam, Date dateTarget, Component button) {
        return JCalendarPopup.createCalendarPopup(null, dateTarget, button, null);
    }

    public static JCalendarPopup createCalendarPopup(String strDateParam, Date dateTarget, Component button, String strLanguage) {
        JPopupMenu popup;
        JPopupMenu c = popup = new JPopupMenu();
        c.setLayout(new BorderLayout());
        JCalendarPopup calendar = new JCalendarPopup(strDateParam, dateTarget, strLanguage);
        c.add((Component)calendar, "Center");
        popup.show(button, button.getBounds().width, 0);
        return calendar;
    }

    public static JButton createCalendarButton(String strDateParam, Date dateTarget) {
        JCalendarButton button = new JCalendarButton(strDateParam, dateTarget);
        button.setMargin(NO_INSETS);
        button.setOpaque(false);
        return button;
    }

    public void setTransferFocus(boolean bTransferFocus) {
        this.transferFocus = bTransferFocus;
    }
}

