/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.thin.base.screen.jcalendarbutton;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jbundle.thin.base.screen.jcalendarbutton.JCalendarPopup;
import org.jbundle.thin.base.screen.jcalendarbutton.JTimePopup;

public class JTimeButton
extends JButton
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String LANGUAGE_PARAM = "language";
    String timeParam = "date";
    Date targetTime = null;
    String languageString = null;

    public JTimeButton() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            ImageIcon icon = new ImageIcon(cl.getResource("images/buttons/Time.gif"));
            this.setIcon(icon);
        }
        catch (Exception ex) {
            this.setText("change");
        }
        this.setMargin(JCalendarPopup.NO_INSETS);
        this.setOpaque(false);
        this.addActionListener(this);
    }

    public JTimeButton(Date timeTarget) {
        this();
        this.init(null, timeTarget, null);
    }

    public JTimeButton(String strDateParam, Date timeTarget) {
        this();
        this.init(strDateParam, timeTarget, null);
    }

    public JTimeButton(String strDateParam, Date timeTarget, String strLanguage) {
        this();
        this.init(strDateParam, timeTarget, strLanguage);
    }

    public void init(String param, Date time, String language) {
        if (param == null) {
            param = "date";
        }
        this.timeParam = param;
        this.targetTime = time;
        this.languageString = language;
        this.setName("JTimeButton");
    }

    public void setTargetDate(Date time) {
        this.targetTime = time;
    }

    public Date getTargetDate() {
        return this.targetTime;
    }

    public String getTimeParam() {
        return this.timeParam;
    }

    public void setTimeParam(String timeParam) {
        this.timeParam = timeParam;
    }

    public String getLanguage() {
        return this.languageString;
    }

    public void setLanguage(String languageString) {
        this.languageString = languageString;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this) {
            Date dateTarget = this.getTargetDate();
            JTimePopup popup = JTimePopup.createTimePopup(this.getTimeParam(), dateTarget, this, this.languageString);
            popup.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        if (this.timeParam.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof Date) {
            this.targetTime = (Date)evt.getNewValue();
        }
        if (LANGUAGE_PARAM.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof String) {
            this.languageString = (String)evt.getNewValue();
        }
    }
}

