/*
 * Decompiled with CFR 0.152.
 */
package faircom.rtg;

import faircom.rtg.CtreeFile;
import faircom.rtg.CtreeStatus;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CtreeEnv {
    private static short ENV_NOTCONNECTED = (short)-1;
    private static short ENV_OK = 0;
    private static short INITSRV_INVALID = 0;
    private static short INITSRV_NO = 1;
    private static short INITSRV_YES = (short)2;
    private static int VERSION_BASE = 4;
    private static int VERSION_INITSRV = 8;
    private static int VERSION_NEXTAVAILABLE = 16;
    private static int VERSION_ALL = VERSION_INITSRV;
    private static short loaded = 0;
    private static Object lock1 = new Object();
    private static int jversion = VERSION_BASE | VERSION_ALL;
    private static int dllversion = 0;
    private static String dllname = "mtclient";
    private Logger LOGGER = null;
    private Level LoggerLevel = Level.FINEST;
    private static short explicit_initsrv = INITSRV_INVALID;
    private short envStatus = ENV_NOTCONNECTED;
    private long thrdid = -1L;
    private long confenv = -1L;
    private ReentrantLock locker = null;
    private WeakHashMap<CtreeFile, Long> fileHash = null;
    private Object fileHashLock = null;
    private HashSet<Long> PendingClose = null;
    private Object PendingCloseLock = null;

    private static native short ct_LibType();

    private static native long ct_init(long var0);

    private static native void ct_exit(long var0, int var2);

    private static native int ct_exitsrv();

    private static native int ct_initsrv();

    private static native void ct_sync(long var0, int var2);

    private static native int ct_remove(long var0, String var2);

    private static native int ct_rename(long var0, String var2, String var3);

    private static native int ct_version(long var0, byte[] var2, byte[] var3, byte[] var4, int var5, int[] var6);

    private static native int ct_copy(long var0, String var2, String var3);

    private static native int ct_begin(long var0);

    private static native int ct_commit(long var0, int var2);

    private static native int ct_rollback(long var0);

    private static native int ct_recover(long var0);

    private static native int ct_make(long var0, String var2, String var3, String var4, String var5, String var6, byte[] var7, byte var8);

    private static native long ct_open(long var0, String var2, int var3, String var4, byte var5);

    private static native int ct_sqllink(long var0, String var2, String var3, String var4, String var5, String var6, byte var7, String var8);

    private static native long ct_config(int var0, long var1, long var3, String var5, String var6, String var7, String var8, String var9);

    private static native long ct_config2(int var0, long var1, long var3, String[] var5);

    private static native int ct_intfversion(int var0);

    private static native long ct_lockerid(long var0);

    private static native long ct_logons(long var0);

    private String whoami() {
        return "jt:" + Thread.currentThread().getId() + " ct:" + this.thrdid + " cl:" + this;
    }

    public CtreeEnv() throws Exception {
        this._CtreeEnv(null, Level.FINEST, null);
    }

    public CtreeEnv(Logger log, Level loglevel, String nativelibrary) throws Exception {
        this._CtreeEnv(log, loglevel, nativelibrary);
    }

    public CtreeEnv(Logger log, Level loglevel) throws Exception {
        this._CtreeEnv(log, loglevel, null);
    }

    public CtreeEnv(String nativelibrary) throws Exception {
        this._CtreeEnv(null, Level.FINEST, nativelibrary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _CtreeEnv(Logger log, Level loglevel, String nativelibrary) throws Exception {
        Object object;
        this.LOGGER = log;
        this.LoggerLevel = loglevel;
        if (loaded == 0) {
            object = lock1;
            synchronized (object) {
                if (this.LOGGER != null) {
                    this.LOGGER.log(this.LoggerLevel, this.whoami() + " full constructor");
                }
                if (loaded == 0) {
                    try {
                        dllversion = CtreeEnv.ct_intfversion(jversion);
                    }
                    catch (UnsatisfiedLinkError err) {
                        try {
                            if (nativelibrary == null) {
                                nativelibrary = dllname;
                            }
                            System.loadLibrary(nativelibrary);
                            dllversion = CtreeEnv.ct_intfversion(jversion);
                        }
                        catch (Exception err2) {
                            throw new Exception("native library not loaded");
                        }
                    }
                    if (dllversion == -1 || dllversion < VERSION_BASE) {
                        throw new Exception("native library not compatible j:" + jversion + " n:" + dllversion);
                    }
                    loaded = CtreeEnv.ct_LibType();
                }
            }
        }
        if (loaded != 0) {
            object = lock1;
            synchronized (object) {
                if (explicit_initsrv == INITSRV_INVALID) {
                    int rv;
                    if (this.LOGGER != null) {
                        this.LOGGER.log(this.LoggerLevel, this.whoami() + " threading init");
                    }
                    if ((rv = CtreeEnv.ct_initsrv()) == 0) {
                        if (loaded == 2) {
                            throw new Exception("c-tree server initialization failed " + CtreeEnv.ct_get_f_errno(-1L) + ":" + CtreeEnv.ct_get_f_int_errno(-1L) + ":" + CtreeEnv.ct_get_f_int2_errno(-1L));
                        }
                        if ((dllversion & VERSION_INITSRV) != 0) {
                            throw new Exception("c-tree threading initialization failed " + CtreeEnv.ct_get_f_errno(-1L) + ":" + CtreeEnv.ct_get_f_int_errno(-1L) + ":" + CtreeEnv.ct_get_f_int2_errno(-1L));
                        }
                        if (this.LOGGER != null) {
                            this.LOGGER.log(this.LoggerLevel, this.whoami() + " threading init - failed, falling back to implicit initialization");
                        }
                        explicit_initsrv = INITSRV_NO;
                    } else {
                        if (loaded == 2) {
                            Runtime.getRuntime().addShutdownHook(new Thread("CtreeEnv-RTGsrvShutdownHook"){

                                @Override
                                public void run() {
                                    CtreeEnv.ForceBoundShutdown();
                                }
                            });
                        }
                        explicit_initsrv = INITSRV_YES;
                    }
                }
            }
        }
        this.locker = new ReentrantLock(false);
        if (this.LOGGER != null) {
            this.LOGGER.log(this.LoggerLevel, this.whoami() + " constructor done");
        }
    }

    protected void finalize() {
        assert (this.fileHash == null || this.fileHash.size() == 0);
        assert (this.PendingClose == null || this.PendingClose.size() == 0);
        if (this.envStatus != ENV_NOTCONNECTED) {
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            CtreeEnv.ct_exit(this.thrdid, 1);
            this.thrdid = -1L;
            this.envStatus = ENV_NOTCONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void ForceBoundShutdown() {
        Object object = lock1;
        synchronized (object) {
            if (explicit_initsrv == INITSRV_YES) {
                CtreeEnv.ct_exitsrv();
                explicit_initsrv = INITSRV_INVALID;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long config(int op, long item, String p1, String p2, String p3, String p4, String p5, CtreeStatus status) {
        this.locker.lock();
        try {
            long rv;
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " op:" + op + " it:" + item + " p1:" + p1 + " p2:" + p2 + " p3:" + p3 + " p4:" + p4 + " p5:" + p5);
            }
            if (this.confenv == -1L) {
                this.confenv = rv = CtreeEnv.ct_config(op, 0L, item, p1, p2, p3, p4, p5);
            } else {
                rv = CtreeEnv.ct_config(op, this.confenv, item, p1, p2, p3, p4, p5);
            }
            if (op == 8 && rv >= 0L) {
                this.confenv = -1L;
            }
            if (rv == -1L) {
                this.setStatus(status);
            } else {
                this.setStatus(status, (short)0);
            }
            long l = rv;
            return l;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long config(int op, long item, String[] args, CtreeStatus status) {
        this.locker.lock();
        try {
            long rv;
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " op:" + op + " it:" + item + " args:" + args);
            }
            if (this.confenv == -1L) {
                this.confenv = rv = CtreeEnv.ct_config2(op, 0L, item, args);
            } else {
                rv = CtreeEnv.ct_config2(op, this.confenv, item, args);
            }
            if (op == 8 && rv >= 0L) {
                this.confenv = -1L;
            }
            if (rv == -1L) {
                this.setStatus(status);
            } else {
                this.setStatus(status, (short)0);
            }
            long l = rv;
            return l;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(CtreeStatus status) {
        this.locker.lock();
        try {
            long rv = 0L;
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " init begin");
            }
            if (this.envStatus != ENV_NOTCONNECTED) {
                this.setStatus(status, (short)98);
                boolean bl = false;
                return bl;
            }
            rv = this.confenv == -1L ? CtreeEnv.ct_init(0L) : CtreeEnv.ct_init(this.confenv);
            if (rv == -1L) {
                status.setStatus(CtreeEnv.ct_get_f_errno(this.thrdid), CtreeEnv.ct_get_f_int_errno(this.thrdid), CtreeEnv.ct_get_f_int2_errno(this.thrdid), null);
                boolean bl = false;
                return bl;
            }
            if (rv == -2L) {
                this.setStatus(status, (short)97);
                boolean bl = false;
                return bl;
            }
            if (rv == -3L) {
                this.setStatus(status, (short)96);
                boolean bl = false;
                return bl;
            }
            this.thrdid = rv;
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " init succeeded");
            }
            this.setStatus(status, (short)0);
            this.envStatus = ENV_OK;
            if (this.fileHash == null) {
                this.fileHash = new WeakHashMap(10);
                this.fileHashLock = new Object();
            }
            if (this.PendingCloseLock == null) {
                this.PendingClose = new HashSet(5);
                this.PendingCloseLock = new Object();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openFiles() {
        if (this.fileHash != null) {
            Object object = this.fileHashLock;
            synchronized (object) {
                return this.fileHash.size();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ClosePending(boolean atexit) {
        assert (atexit || this.locker.isHeldByCurrentThread());
        if (this.envStatus == ENV_NOTCONNECTED) {
            return;
        }
        Object object = this.PendingCloseLock;
        synchronized (object) {
            if (this.PendingClose.size() != 0) {
                if (this.LOGGER != null) {
                    this.LOGGER.log(this.LoggerLevel, this.whoami() + " 'pending close' file close");
                }
                for (long fh : this.PendingClose) {
                    if (fh == -1L) continue;
                    CtreeEnv.ct_close(this.thrdid, fh);
                }
                this.PendingClose.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exit() {
        this.locker.lock();
        try {
            if (this.envStatus == ENV_NOTCONNECTED) {
                if (this.LOGGER != null) {
                    this.LOGGER.log(this.LoggerLevel, this.whoami() + " nothing to do");
                }
                boolean bl = true;
                return bl;
            }
            this.envStatus = ENV_NOTCONNECTED;
        }
        finally {
            this.locker.unlock();
        }
        Object object = this.fileHashLock;
        synchronized (object) {
            if (this.fileHash.size() != 0) {
                if (this.LOGGER != null) {
                    this.LOGGER.log(this.LoggerLevel, this.whoami() + " pending file close");
                }
                CtreeFile hdl2 = null;
                for (CtreeFile hdl2 : this.fileHash.keySet()) {
                    long fh = hdl2.detachFile();
                    if (fh == -1L) continue;
                    CtreeEnv.ct_close(this.thrdid, fh);
                }
                this.fileHash.clear();
            }
        }
        this.ClosePending(true);
        this.locker.lock();
        try {
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            CtreeEnv.ct_exit(this.thrdid, 1);
            this.confenv = -1L;
            this.thrdid = -1L;
            boolean bl = true;
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(int all_files, CtreeStatus status) {
        this.locker.lock();
        try {
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " all_files:" + all_files);
            }
            CtreeEnv.ct_sync(this.thrdid, all_files);
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " name:" + name);
            }
            if ((rv = CtreeEnv.ct_remove(this.thrdid, name)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String fromname, String toname, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " from:" + fromname + " to:" + toname);
            }
            if ((rv = CtreeEnv.ct_rename(this.thrdid, fromname, toname)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean version(byte[] name, byte[] file_version, byte[] intVersion, int system_run, int[] pExpDate, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            if ((rv = CtreeEnv.ct_version(this.thrdid, name, file_version, null, system_run, pExpDate)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            String buildDate = String.format("-%02d%02d%02d", 24, 1, 9);
            String Version2 = "3.0.2.1113" + buildDate;
            byte[] tmp = Version2.getBytes();
            int tmp_len = tmp.length;
            System.arraycopy(tmp, 0, intVersion, 0, tmp_len);
            intVersion[tmp_len] = 0;
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean make(String name, String comment, String p_parms, String l_parms, String keys, byte[] trans, byte signconv, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " name:" + name + " comment:" + comment + " p_parms:" + p_parms + " l_parms:" + l_parms + " keys:" + keys);
            }
            if ((rv = CtreeEnv.ct_make(this.thrdid, name, comment, p_parms, l_parms, keys, trans, signconv)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtreeFile open(String name, int mode, String l_parms, byte signconv, CtreeStatus status) {
        this.locker.lock();
        try {
            Object object;
            long fileHandle = -1L;
            CtreeFile rv = null;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                CtreeFile ctreeFile = null;
                return ctreeFile;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " name:" + name + " mode:" + mode + " l_parms:" + l_parms + " signconv:" + signconv);
            }
            if ((fileHandle = CtreeEnv.ct_open(this.thrdid, name, mode, l_parms, signconv)) != 0L) {
                rv = new CtreeFile(this, fileHandle);
                this.setStatus(status, (short)0);
                object = this.fileHashLock;
                synchronized (object) {
                    this.fileHash.put(rv, 1L);
                }
            } else {
                this.setStatus(status);
            }
            object = rv;
            return object;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy(String fromname, String toname, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fromname:" + fromname + " toname:" + toname);
            }
            if ((rv = CtreeEnv.ct_copy(this.thrdid, fromname, toname)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean begin(CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            if ((rv = CtreeEnv.ct_begin(this.thrdid)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(int par, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + par);
            }
            if ((rv = CtreeEnv.ct_commit(this.thrdid, par)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollback(CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            if ((rv = CtreeEnv.ct_rollback(this.thrdid)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover(CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            if ((rv = CtreeEnv.ct_recover(this.thrdid)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sqllink(String filname, String dbname, String symname, String adminpw, String owner, byte grant, String prefix, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + filname + " dbname:" + dbname + " symname:" + symname + " adminpw:" + adminpw + " owner:" + owner + " grant:" + grant + " prefix:" + prefix);
            }
            if ((rv = CtreeEnv.ct_sqllink(this.thrdid, filname, dbname, symname, adminpw, owner, grant, prefix)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lockerId(CtreeStatus status) {
        this.locker.lock();
        try {
            long rv = 0L;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                long l = 0L;
                return l;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            this.setStatus(status, (short)0);
            long l = rv = CtreeEnv.ct_lockerid(this.thrdid);
            return l;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long logons(CtreeStatus status) {
        this.locker.lock();
        try {
            long rv = 0L;
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                long l = 0L;
                return l;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami());
            }
            this.setStatus(status, (short)0);
            long l = rv = CtreeEnv.ct_logons(this.thrdid);
            return l;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    private static native int ct_close(long var0, long var2);

    private static native int ct_read(long var0, long var2, byte[] var4, int var5, int var6, short var7);

    private static native int ct_next(long var0, long var2, byte[] var4, int var5, short var6);

    private static native int ct_previous(long var0, long var2, byte[] var4, int var5, short var6);

    private static native int ct_start(long var0, long var2, byte[] var4, int var5, int var6, int var7, int var8);

    private static native int ct_write(long var0, long var2, byte[] var4, int var5, int var6, short var7);

    private static native int ct_rewrite(long var0, long var2, byte[] var4, int var5, int var6, short var7);

    private static native int ct_delete(long var0, long var2, byte[] var4, int var5);

    private static native int ct_unlock(long var0, long var2);

    private static native int ct_info(long var0, long var2, int var4, byte[] var5);

    private static native int ct_sqlinfo(long var0, long var2, String var4, byte var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean close(CtreeFile file, long fileHandle, CtreeStatus status, boolean lazy) {
        boolean locked = false;
        if (file == null) {
            this.setStatus(status, (short)2);
            return false;
        }
        if (fileHandle == -1L) {
            this.setStatus(status, (short)2);
            return false;
        }
        try {
            if (lazy) {
                locked = this.locker.tryLock(1L, TimeUnit.MILLISECONDS);
            } else {
                this.locker.lock();
                locked = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locked) {
            try {
                int rv = 0;
                if (this.envStatus == ENV_NOTCONNECTED) {
                    this.setStatus(status, (short)99);
                    boolean bl = false;
                    return bl;
                }
                if (this.LOGGER != null) {
                    this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle);
                }
                rv = CtreeEnv.ct_close(this.thrdid, fileHandle);
                Object object = this.fileHashLock;
                synchronized (object) {
                    this.fileHash.remove(file);
                }
                if (rv == 0) {
                    this.setStatus(status);
                    boolean bl = false;
                    return bl;
                }
                this.setStatus(status, (short)0);
                boolean bl = true;
                return bl;
            }
            finally {
                this.locker.unlock();
            }
        }
        if (this.LOGGER != null) {
            this.LOGGER.log(this.LoggerLevel, this.whoami() + " adding to Pending Close fileHandle:" + fileHandle);
        }
        Object object = this.PendingCloseLock;
        synchronized (object) {
            this.PendingClose.add(fileHandle);
        }
        try {
            locked = this.locker.tryLock();
            if (locked) {
                this.ClosePending(false);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (locked) {
                this.locker.unlock();
            }
        }
        this.setStatus(status, (short)0);
        return true;
    }

    protected void lockEnv() {
        this.locker.lock();
    }

    protected void unLockEnv() {
        this.locker.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int hasPendingClose() {
        Object object = this.PendingCloseLock;
        synchronized (object) {
            return this.PendingClose.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(long fileHandle, byte[] record, int start, int keynum, short f_no_lock, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                int n = 0;
                return n;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                int n = 0;
                return n;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " record:[...] start:" + start + " keynum:" + keynum + " f_no_lock:" + f_no_lock);
            }
            if ((rv = CtreeEnv.ct_read(this.thrdid, fileHandle, record, start, keynum, f_no_lock)) == 0) {
                this.setStatus(status);
                int n = 0;
                return n;
            }
            this.setStatus(status, (short)0);
            int n = rv;
            return n;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int next(long fileHandle, byte[] record, int start, short f_no_lock, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                int n = 0;
                return n;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                int n = 0;
                return n;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " record:[...] start:" + start + " f_no_lock:" + f_no_lock);
            }
            if ((rv = CtreeEnv.ct_next(this.thrdid, fileHandle, record, start, f_no_lock)) == 0) {
                this.setStatus(status);
                int n = 0;
                return n;
            }
            this.setStatus(status, (short)0);
            int n = rv;
            return n;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int previous(long fileHandle, byte[] record, int start, short f_no_lock, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                int n = 0;
                return n;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                int n = 0;
                return n;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " record:[...] start:" + start + " f_no_lock:" + f_no_lock);
            }
            if ((rv = CtreeEnv.ct_previous(this.thrdid, fileHandle, record, start, f_no_lock)) == 0) {
                this.setStatus(status);
                int n = 0;
                return n;
            }
            this.setStatus(status, (short)0);
            int n = rv;
            return n;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean start(long fileHandle, byte[] record, int start, int keynum, int keysize, int mode, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                boolean bl = false;
                return bl;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " record:[...] start:" + start + " keynum:" + keynum + " keysize:" + keysize);
            }
            if ((rv = CtreeEnv.ct_start(this.thrdid, fileHandle, record, start, keynum, keysize, mode)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean write(long fileHandle, byte[] record, int start, int size, short f_no_lock, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                boolean bl = false;
                return bl;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " record:[...] start:" + start + " size:" + size + " f_no_lock:" + f_no_lock);
            }
            if ((rv = CtreeEnv.ct_write(this.thrdid, fileHandle, record, start, size, f_no_lock)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rewrite(long fileHandle, byte[] record, int start, int size, short f_no_lock, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                boolean bl = false;
                return bl;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " record:[...] start:" + start + " size:" + size + " f_no_lock:" + f_no_lock);
            }
            if ((rv = CtreeEnv.ct_rewrite(this.thrdid, fileHandle, record, start, size, f_no_lock)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delete(long fileHandle, byte[] record, int start, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                boolean bl = false;
                return bl;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " record:[...] start:" + start);
            }
            if ((rv = CtreeEnv.ct_delete(this.thrdid, fileHandle, record, start)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unlock(long fileHandle, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                boolean bl = false;
                return bl;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle);
            }
            if ((rv = CtreeEnv.ct_unlock(this.thrdid, fileHandle)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean info(long fileHandle, int mode, byte[] result, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                boolean bl = false;
                return bl;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " mode:" + mode + " result:[...]");
            }
            if ((rv = CtreeEnv.ct_info(this.thrdid, fileHandle, mode, result)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sqlinfo(long fileHandle, String iss, byte sign, CtreeStatus status) {
        this.locker.lock();
        try {
            int rv = 0;
            if (fileHandle == -1L) {
                this.setStatus(status, (short)2);
                boolean bl = false;
                return bl;
            }
            if (this.envStatus < ENV_OK) {
                this.setStatus(status, (short)99);
                boolean bl = false;
                return bl;
            }
            if (this.LOGGER != null) {
                this.LOGGER.log(this.LoggerLevel, this.whoami() + " fileHandle:" + fileHandle + " iss:[...] sing:" + sign);
            }
            if ((rv = CtreeEnv.ct_sqlinfo(this.thrdid, fileHandle, iss, sign)) == 0) {
                this.setStatus(status);
                boolean bl = false;
                return bl;
            }
            this.setStatus(status, (short)0);
            boolean bl = true;
            return bl;
        }
        finally {
            this.ClosePending(false);
            this.locker.unlock();
        }
    }

    private static native short ct_get_f_errno(long var0);

    private static native long ct_get_f_int_errno(long var0);

    private static native long ct_get_f_int2_errno(long var0);

    private void setStatus(CtreeStatus st) {
        if (this.LOGGER != null) {
            this.LOGGER.log(this.LoggerLevel, this.whoami());
        }
        if (st != null) {
            if (this.envStatus == ENV_NOTCONNECTED) {
                st.setStatus((short)99);
            } else {
                st.setStatus(CtreeEnv.ct_get_f_errno(this.thrdid), CtreeEnv.ct_get_f_int_errno(this.thrdid), CtreeEnv.ct_get_f_int2_errno(this.thrdid), null);
            }
        }
    }

    private void setStatus(CtreeStatus st, short err) {
        if (this.LOGGER != null) {
            this.LOGGER.log(this.LoggerLevel, this.whoami() + " err:" + err);
        }
        if (st != null) {
            st.setStatus(err);
        }
    }
}

