/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow;

import java.util.LinkedHashMap;
import java.util.Map;

public class ActiveXDescriptor {
    private final String clsid;
    private final String displayName;
    protected Map<Integer, String> eventNames;
    protected Map<String, Integer> eventIds;
    protected String[] propertyNames;

    public ActiveXDescriptor(String clsid, String displayName) {
        this.clsid = clsid;
        this.displayName = displayName;
    }

    public String getClsid() {
        return this.clsid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected int[] getEventIdsArray() {
        return new int[0];
    }

    protected String[] getEventNamesArray() {
        return new String[0];
    }

    protected String[] getPropertyNamesArray() {
        return new String[0];
    }

    private void loadEvents() {
        int[] eIds = this.getEventIdsArray();
        String[] eNames = this.getEventNamesArray();
        this.eventIds = new LinkedHashMap<String, Integer>();
        this.eventNames = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < eIds.length; ++i) {
            this.eventIds.put(eNames[i], eIds[i]);
            this.eventNames.put(eIds[i], eNames[i]);
        }
    }

    public int getEventId(String eventName) {
        Integer id;
        if (this.eventIds == null) {
            this.loadEvents();
        }
        return (id = this.eventIds.get(eventName)) != null ? id : 0;
    }

    public int[] getEventIds() {
        if (this.eventIds == null) {
            this.loadEvents();
        }
        int[] eIds = new int[this.eventIds.size()];
        int i = 0;
        for (Integer id : this.eventIds.values()) {
            eIds[i++] = id;
        }
        return eIds;
    }

    public String[] getEventNames() {
        if (this.eventNames == null) {
            this.loadEvents();
        }
        return this.eventNames.values().toArray(new String[this.eventNames.size()]);
    }

    public String[] getPropertyNames() {
        if (this.propertyNames == null) {
            this.propertyNames = this.getPropertyNamesArray();
        }
        return this.propertyNames;
    }

    public String toString() {
        return "clsid: '" + this.clsid + "', display name: '" + this.displayName + "'";
    }
}

