/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow;

import com.veryant.wow.WowSystem;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WowCsProperty {
    public static final String PREFIX = "iscobol.";
    public static final String LAYOUT_MANAGER = "iscobol.gui.layout_manager";
    public static final String WINDOWS_MODALITY = "iscobol.gui.windows_modality";
    private static final Set<String> vProps;
    private Map<String, String> serverProperties = new HashMap<String, String>();
    private PropertyChangeSupport changeListeners = new PropertyChangeSupport(this.serverProperties);

    public static boolean is(String key) {
        return vProps.contains(key);
    }

    public static Set<String> getPropertyNames() {
        return vProps;
    }

    public void set(String key, String value) {
        if (WowCsProperty.is(key)) {
            String old = this.serverProperties.put(key, value);
            this.changeListeners.firePropertyChange(key, old, value);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.changeListeners.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.changeListeners.removePropertyChangeListener(l);
        }
    }

    public String get(String key, String aDefault) {
        String Return = this.serverProperties.get(key);
        if (Return == null) {
            Return = aDefault;
        }
        return Return;
    }

    public boolean get(String key, boolean aDefault) {
        String str = this.get(key, null);
        if (str == null) {
            return aDefault;
        }
        return WowSystem.getRtn().isTrue(str);
    }

    public int get(String key, int aDefault) {
        String str = this.get(key, null);
        if (str != null) {
            try {
                aDefault = Integer.parseInt(str.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    public char get(String key, char aDefault) {
        String str = this.get(key, null);
        if (str == null || str.length() == 0) {
            return aDefault;
        }
        return str.charAt(0);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(LAYOUT_MANAGER);
        set.add(WINDOWS_MODALITY);
        vProps = Collections.unmodifiableSet(set);
    }
}

