/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeImpl;
import com.iscobol.rts.UserHandles;
import com.veryant.wow.WowCsProperty;
import com.veryant.wow.gui.Widget;
import com.veryant.wow.gui.WowGuiFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class WowSystem
implements PropertyChangeListener {
    public static final String WOW_VERSION = "1.0.0";
    private static final float screenRes = 96.0f;
    private static final Map<String, Integer> acceleratorKeys;
    private static RuntimeImpl rtn;
    private WowGuiFactory wowGuiFactory;
    private static Map<Class, Map<String, PropertyDescriptor>> propertyDescriptors;

    static RuntimeImpl getRtn() {
        if (rtn == null) {
            rtn = new RuntimeImpl();
        }
        return rtn;
    }

    private WowSystem() {
        WowSystem.getRtn().addPropertyChangeListener((PropertyChangeListener)this);
        try {
            this.wowGuiFactory = (WowGuiFactory)ScreenUtility.getGuiFactory().getFactoryExtension("com.veryant.wow.gui.client.WowGuiFactoryImpl");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String propName : WowCsProperty.getPropertyNames()) {
                String propValue = WowSystem.getRtn().getProperty(propName, null);
                if (propValue == null) continue;
                map.put(propName, propValue);
            }
            if (!map.isEmpty()) {
                String[] propNames = new String[map.size()];
                String[] propValues = new String[map.size()];
                int i = 0;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String propName;
                    propNames[i] = propName = (String)iterator.next();
                    propValues[i++] = (String)map.get(propName);
                }
                this.wowGuiFactory.setCsProperties(propNames, propValues);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static WowSystem get() {
        WowSystem Return = (WowSystem)IscobolSystem.get(WowSystem.class);
        if (Return == null) {
            Return = new WowSystem();
            IscobolSystem.set(WowSystem.class, (Object)Return);
        }
        return Return;
    }

    public static WowGuiFactory getWowGuiFactory() {
        return WowSystem.get().wowGuiFactory;
    }

    public static String getJavaPropertyName(String name) {
        return name.toLowerCase().replace('-', '_');
    }

    public static PropertyDescriptor getPropertyDescriptor(Class cls, String propName) {
        Map<String, PropertyDescriptor> map = propertyDescriptors.get(cls);
        if (map == null) {
            map = new HashMap<String, PropertyDescriptor>();
            try {
                for (PropertyDescriptor pd : Introspector.getBeanInfo(cls).getPropertyDescriptors()) {
                    map.put(pd.getName(), pd);
                }
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            propertyDescriptors.put(cls, map);
        }
        return map.get(WowSystem.getJavaPropertyName(propName));
    }

    public static String convertGetValue(Object getValue, Class type) {
        if (type == null) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return (Boolean)getValue != false ? "1" : "0";
        }
        if (getValue != null) {
            return getValue.toString();
        }
        return "";
    }

    public static Object convertValue(String stringValue, Class type) {
        if (type == null) {
            return null;
        }
        if (type == String.class) {
            return stringValue;
        }
        if (type == Boolean.TYPE) {
            return "1".equals(stringValue);
        }
        if (type == Byte.TYPE) {
            return Byte.valueOf(stringValue);
        }
        if (type == Short.TYPE) {
            return Short.valueOf(stringValue);
        }
        if (type == Integer.TYPE) {
            return Integer.valueOf(stringValue);
        }
        if (type == Long.TYPE) {
            return Long.valueOf(stringValue);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(stringValue);
        }
        if (type == Double.TYPE) {
            return Double.valueOf(stringValue);
        }
        if (type == Character.TYPE) {
            if (stringValue.length() > 0) {
                return Character.valueOf(stringValue.charAt(0));
            }
            throw new IllegalArgumentException(stringValue);
        }
        throw new IllegalArgumentException(stringValue);
    }

    public static Widget findWidget(int widgetId, int[] h) {
        int count = UserHandles.getIdCount();
        h[0] = UserHandles.getFirstId();
        while (h[0] < count) {
            Object tmp = UserHandles.getId((int)h[0]);
            if (tmp instanceof Widget && ((Widget)tmp).getClientId() == widgetId) {
                return (Widget)tmp;
            }
            h[0] = h[0] + 1;
        }
        h[0] = 0;
        return null;
    }

    public static boolean freeWidget(int widgetId) {
        int count = UserHandles.getIdCount();
        for (int h = UserHandles.getFirstId(); h < count; ++h) {
            Object tmp = UserHandles.getId((int)h);
            if (!(tmp instanceof Widget) || ((Widget)tmp).getClientId() != widgetId) continue;
            UserHandles.free((int)h);
            return true;
        }
        return false;
    }

    public static boolean isTrue(String param, int idx) {
        if (idx < param.length()) {
            char c = param.charAt(idx);
            return c == 'y' || c == 'Y';
        }
        return false;
    }

    public static int getInt(String param) {
        return (int)WowSystem.getDouble(param);
    }

    public static double getDouble(String param) {
        return param != null ? Double.parseDouble(param.trim().replace(',', '.')) : 0.0;
    }

    public static String rtrim(String s) {
        int idx;
        if (s == null) {
            return s;
        }
        for (idx = s.length() - 1; idx >= 0 && s.charAt(idx) == ' '; --idx) {
        }
        if (++idx < s.length()) {
            if (idx == 0) {
                return "";
            }
            return s.substring(0, idx);
        }
        return s;
    }

    private static String quote(String s) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb0 = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': {
                    if (sb0.length() > 0) {
                        sb.append(Pattern.quote(sb0.toString()));
                    }
                    sb.append(".*");
                    sb0 = new StringBuilder();
                    continue block3;
                }
                default: {
                    sb0.append(c);
                }
            }
        }
        if (sb0.length() > 0) {
            sb.append(Pattern.quote(sb0.toString()));
        }
        return sb.toString();
    }

    public static String[] getFiles(String path, String attrs) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Object> files = new ArrayList<Object>();
        boolean exclusive = WowSystem.isTrue(attrs, 8);
        boolean archive = WowSystem.isTrue(attrs, 5);
        boolean directory = WowSystem.isTrue(attrs, 4);
        boolean drives = WowSystem.isTrue(attrs, 7);
        boolean hidden = WowSystem.isTrue(attrs, 2);
        boolean readonly = WowSystem.isTrue(attrs, 1);
        boolean readwrite = WowSystem.isTrue(attrs, 0);
        File f = new File(path);
        File p = f.getParentFile();
        if (p == null) {
            p = new File(".");
        }
        String regex = WowSystem.quote(f.getName().toLowerCase());
        File[] fs = p.listFiles();
        if (fs != null) {
            for (File f0 : fs) {
                if (!f0.getName().toLowerCase().matches(regex)) continue;
                files.add(f0);
            }
        }
        for (File file : files) {
            if (!(!exclusive || archive && WowSystem.isArchive(file) || directory && file.isDirectory() || drives && WowSystem.isDrive(file) || hidden && file.isHidden() || readonly && file.isFile() && file.canRead() && !file.canWrite()) && (!readwrite || !file.isFile() || !file.canRead() || !file.canWrite())) continue;
            result.add(file.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean isArchive(File f) {
        String n;
        return f.isFile() && ((n = f.getName().toLowerCase()).endsWith(".zip") || n.endsWith(".jar") || n.endsWith(".tar") || n.endsWith(".rar") || n.endsWith(".tgz") || n.endsWith(".gzip"));
    }

    private static boolean isDrive(File f) {
        String n = f.getPath();
        return n.length() == 2 && Character.isLetter(n.charAt(0)) && n.charAt(1) == ':';
    }

    public static Color parseColor(String str) {
        if (str == null) {
            return null;
        }
        try {
            int c = Integer.parseInt(str);
            return WowSystem.parseColor(c);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Color parseColor(int c) {
        int r = c & 0xFF;
        int g = c >>> 8 & 0xFF;
        int b = c >>> 16 & 0xFF;
        return new Color(r, g, b);
    }

    public static Font getFont(String name, float size, boolean bold, boolean italic, boolean underline, boolean strikethrough) {
        HashMap<TextAttribute, Object> attrs = new HashMap<TextAttribute, Object>();
        attrs.put(TextAttribute.FAMILY, name);
        float sz = size * 96.0f / 72.0f;
        attrs.put(TextAttribute.SIZE, new Float(sz));
        if (bold) {
            attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (italic) {
            attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (underline) {
            attrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (strikethrough) {
            attrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(attrs);
    }

    public static Border getBorder(boolean border, boolean clientEdge, boolean staticEdge, boolean modalFrame, Color color) {
        if (clientEdge) {
            if (staticEdge) {
                if (modalFrame) {
                    return BorderFactory.createCompoundBorder(WowSystem.getClientEdgeBorder(color), BorderFactory.createCompoundBorder(WowSystem.getStaticEdgeBorder(color), WowSystem.getModalFrameBorder(color)));
                }
                return BorderFactory.createCompoundBorder(WowSystem.getClientEdgeBorder(color), WowSystem.getStaticEdgeBorder(color));
            }
            if (modalFrame) {
                return BorderFactory.createCompoundBorder(WowSystem.getClientEdgeBorder(color), WowSystem.getModalFrameBorder(color));
            }
            return WowSystem.getClientEdgeBorder(color);
        }
        if (staticEdge) {
            if (modalFrame) {
                return BorderFactory.createCompoundBorder(WowSystem.getStaticEdgeBorder(color), WowSystem.getModalFrameBorder(color));
            }
            return WowSystem.getStaticEdgeBorder(color);
        }
        if (modalFrame) {
            return WowSystem.getModalFrameBorder(color);
        }
        if (border) {
            return WowSystem.getLineBorder();
        }
        return null;
    }

    public static Border getClientEdgeBorder(Color color) {
        return BorderFactory.createBevelBorder(1, color.brighter().brighter(), color.brighter(), color.darker().darker(), color.darker());
    }

    public static Border getStaticEdgeBorder(Color color) {
        return BorderFactory.createBevelBorder(1, color.brighter(), color.darker());
    }

    public static Border getModalFrameBorder(Color color) {
        return BorderFactory.createMatteBorder(3, 3, 3, 3, color.brighter());
    }

    public static Border getLineBorder() {
        return BorderFactory.createEtchedBorder();
    }

    public static String[] getCaption(String text) {
        StringBuilder sb = new StringBuilder();
        String mnemonic = null;
        String mnemonicIndex = null;
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '&') {
                if (i >= c.length - 1) continue;
                if (c[++i] != '&') {
                    mnemonic = ("" + c[i]).toUpperCase();
                    mnemonicIndex = "" + (i - 1);
                }
                sb.append(c[i]);
                continue;
            }
            sb.append(c[i]);
        }
        return new String[]{sb.toString(), mnemonic, mnemonicIndex};
    }

    public static boolean addAccelerator(JComponent cmp, Action a, String actionMapKey, char mnemonic, String accelerator) {
        ActionMap actionMap = cmp.getActionMap();
        InputMap inputMap = cmp.getInputMap(2);
        actionMap.remove(actionMapKey);
        KeyStroke[] kss = inputMap.keys();
        if (kss != null) {
            for (KeyStroke ks : kss) {
                if (!inputMap.get(ks).equals(actionMapKey)) continue;
                inputMap.remove(ks);
                break;
            }
        }
        if (accelerator != null) {
            if (mnemonic > '\u0000' && ("Alt+" + mnemonic).equals(accelerator)) {
                return true;
            }
            KeyStroke ks = WowSystem.getKeyStroke(accelerator);
            if (ks == null) {
                return false;
            }
            actionMap.put(actionMapKey, a);
            inputMap.put(ks, actionMapKey);
        }
        return true;
    }

    public static boolean addAccelerator(JMenuItem item, String accelerator) {
        item.setAccelerator(null);
        if (accelerator != null) {
            char mnemonic = (char)item.getMnemonic();
            if (mnemonic > '\u0000' && ("Alt+" + mnemonic).equals(accelerator)) {
                return true;
            }
            KeyStroke ks = WowSystem.getKeyStroke(accelerator);
            if (ks == null) {
                return false;
            }
            item.setAccelerator(ks);
        }
        return true;
    }

    public static KeyStroke getKeyStroke(String accelerator) {
        Integer keyCode;
        String key = accelerator;
        int idx = accelerator.lastIndexOf(43);
        if (idx >= 0) {
            key = accelerator.substring(idx + 1);
        }
        if ((keyCode = acceleratorKeys.get(key)) == null) {
            return null;
        }
        int modifiers = 0;
        if (accelerator.indexOf("Alt") >= 0) {
            modifiers |= 8;
        }
        if (accelerator.indexOf("Ctrl") >= 0) {
            modifiers |= 2;
        }
        if (accelerator.indexOf("Shift") >= 0) {
            modifiers |= 1;
        }
        return KeyStroke.getKeyStroke(keyCode, modifiers);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (WowCsProperty.is(evt.getPropertyName())) {
            String newValue = evt.getNewValue() != null ? evt.getNewValue().toString() : "";
            try {
                WowSystem.getWowGuiFactory().setCsProperty(evt.getPropertyName(), newValue);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> int[] binarySearch(List<T> table, T obj, boolean ascending, Comparator<T> cprt) {
        int leftIndex = 0;
        int rightIndex = table.size() - 1;
        int index = leftIndex + (rightIndex - leftIndex) / 2;
        while (leftIndex <= rightIndex) {
            int c = WowSystem.compare(table.get(index), obj, ascending, cprt);
            if (c == 0) {
                return new int[]{index, index};
            }
            if (c > 0) {
                rightIndex = index - 1;
            } else {
                leftIndex = index + 1;
            }
            index = leftIndex + (rightIndex - leftIndex) / 2;
        }
        return new int[]{-1, index};
    }

    public static <T> void mergeSort(List<T> a, boolean ascendant, Comparator<T> c) {
        Vector tmpArray = new Vector(a.size());
        tmpArray.setSize(a.size());
        WowSystem.mergeSort(a, tmpArray, 0, a.size() - 1, ascendant, c);
    }

    private static <T> void mergeSort(List<T> a, List<T> tmpArray, int left, int right, boolean ascendant, Comparator<T> c) {
        if (left < right) {
            int center = (left + right) / 2;
            WowSystem.mergeSort(a, tmpArray, left, center, ascendant, c);
            WowSystem.mergeSort(a, tmpArray, center + 1, right, ascendant, c);
            WowSystem.merge(a, tmpArray, left, center + 1, right, ascendant, c);
        }
    }

    private static <T> void merge(List<T> a, List<T> tmpArray, int leftPos, int rightPos, int rightEnd, boolean ascendant, Comparator<T> c) {
        int leftEnd = rightPos - 1;
        int tmpPos = leftPos;
        int numElements = rightEnd - leftPos + 1;
        while (leftPos <= leftEnd && rightPos <= rightEnd) {
            if (WowSystem.compare(a.get(rightPos), a.get(leftPos), ascendant, c) >= 0) {
                tmpArray.set(tmpPos++, a.get(leftPos++));
                continue;
            }
            tmpArray.set(tmpPos++, a.get(rightPos++));
        }
        while (leftPos <= leftEnd) {
            tmpArray.set(tmpPos++, a.get(leftPos++));
        }
        while (rightPos <= rightEnd) {
            tmpArray.set(tmpPos++, a.get(rightPos++));
        }
        int i = 0;
        while (i < numElements) {
            a.set(rightEnd, tmpArray.get(rightEnd));
            ++i;
            --rightEnd;
        }
    }

    public static <T> int compare(T o1, T o2, boolean ascendant, Comparator<T> c) {
        if (c != null) {
            if (ascendant) {
                return c.compare(o1, o2);
            }
            return c.compare(o2, o1);
        }
        if (ascendant) {
            return ((Comparable)o1).compareTo(o2);
        }
        return ((Comparable)o2).compareTo(o1);
    }

    public static Image getImage(String imageFileName) {
        Image Return = null;
        byte[] b = WowSystem.getStream(imageFileName);
        if (b != null) {
            Return = WowSystem.getImage(b);
        }
        return Return;
    }

    public static Image getImage(byte[] b) {
        return IsguiUtility.createImage((byte[])b, (int[])new int[]{0}, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStream(String fileName) {
        byte[] Return = null;
        FileInputStream is = null;
        try {
            File file = new File(fileName);
            if (!file.exists() && !file.isAbsolute()) {
                StringTokenizer stn = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
                while (stn.hasMoreTokens() && !(file = new File(stn.nextToken() + File.separator + fileName)).exists()) {
                }
            }
            if (file.exists()) {
                is = new FileInputStream(file);
                Return = new byte[is.available()];
                is.read(Return);
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Return;
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("A", 65);
        map.put("B", 66);
        map.put("C", 67);
        map.put("D", 68);
        map.put("E", 69);
        map.put("F", 70);
        map.put("G", 71);
        map.put("H", 72);
        map.put("I", 73);
        map.put("J", 74);
        map.put("K", 75);
        map.put("L", 76);
        map.put("M", 77);
        map.put("N", 78);
        map.put("O", 79);
        map.put("P", 80);
        map.put("Q", 81);
        map.put("R", 82);
        map.put("S", 83);
        map.put("T", 84);
        map.put("U", 85);
        map.put("V", 86);
        map.put("W", 87);
        map.put("X", 88);
        map.put("Y", 89);
        map.put("Z", 90);
        map.put("0", 48);
        map.put("1", 49);
        map.put("2", 50);
        map.put("3", 51);
        map.put("4", 52);
        map.put("5", 53);
        map.put("6", 54);
        map.put("7", 55);
        map.put("8", 56);
        map.put("9", 57);
        map.put("Y", 89);
        map.put("Z", 90);
        map.put("F1", 112);
        map.put("F2", 113);
        map.put("F3", 114);
        map.put("F4", 115);
        map.put("F5", 116);
        map.put("F6", 117);
        map.put("F7", 118);
        map.put("F8", 119);
        map.put("F9", 120);
        map.put("F10", 121);
        map.put("F11", 122);
        map.put("F12", 123);
        map.put("Ins", 155);
        map.put("Canc", 3);
        map.put("Del", 127);
        map.put("Bksp", 8);
        map.put("Escape", 27);
        map.put("Space", 32);
        acceleratorKeys = Collections.unmodifiableMap(map);
        propertyDescriptors = new HashMap<Class, Map<String, PropertyDescriptor>>();
    }
}

