/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui;

import java.awt.MouseInfo;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;

public class KeyTable {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_UP = 1;
    public static final int STATE_DOWN = 2;
    public static final int STATE_TOGGLED = 4;
    public static final int KEY_LBUTTON = 1;
    public static final int KEY_RBUTTON = 2;
    public static final int KEY_CANCEL = 3;
    public static final int KEY_MBUTTON = 4;
    public static final int KEY_BACK = 8;
    public static final int KEY_TAB = 9;
    public static final int KEY_CLEAR = 12;
    public static final int KEY_RETURN = 13;
    public static final int KEY_SHIFT = 16;
    public static final int KEY_CONTROL = 17;
    public static final int KEY_MENU = 18;
    public static final int KEY_PAUSE = 19;
    public static final int KEY_CAPITAL = 20;
    public static final int KEY_ESCAPE = 27;
    public static final int KEY_SPACE = 32;
    public static final int KEY_PRIOR = 33;
    public static final int KEY_NEXT = 34;
    public static final int KEY_END = 35;
    public static final int KEY_HOME = 36;
    public static final int KEY_LEFT = 37;
    public static final int KEY_UP = 38;
    public static final int KEY_RIGHT = 39;
    public static final int KEY_DOWN = 40;
    public static final int KEY_SELECT = 41;
    public static final int KEY_PRINT = 42;
    public static final int KEY_EXECUTE = 43;
    public static final int KEY_SNAPSHOT = 44;
    public static final int KEY_INSERT = 45;
    public static final int KEY_DELETE = 46;
    public static final int KEY_HELP = 47;
    public static final int KEY_NUMPAD0 = 96;
    public static final int KEY_NUMPAD1 = 97;
    public static final int KEY_NUMPAD2 = 98;
    public static final int KEY_NUMPAD3 = 99;
    public static final int KEY_NUMPAD4 = 100;
    public static final int KEY_NUMPAD5 = 101;
    public static final int KEY_NUMPAD6 = 102;
    public static final int KEY_NUMPAD7 = 103;
    public static final int KEY_NUMPAD8 = 104;
    public static final int KEY_NUMPAD9 = 105;
    public static final int KEY_MULTIPLY = 106;
    public static final int KEY_ADD = 107;
    public static final int KEY_SEPARATOR = 108;
    public static final int KEY_SUBTRACT = 109;
    public static final int KEY_DECIMAL = 110;
    public static final int KEY_DIVIDE = 111;
    public static final int KEY_F1 = 112;
    public static final int KEY_F2 = 113;
    public static final int KEY_F3 = 114;
    public static final int KEY_F4 = 115;
    public static final int KEY_F5 = 116;
    public static final int KEY_F6 = 117;
    public static final int KEY_F7 = 118;
    public static final int KEY_F8 = 119;
    public static final int KEY_F9 = 120;
    public static final int KEY_F10 = 121;
    public static final int KEY_F11 = 122;
    public static final int KEY_F12 = 123;
    public static final int KEY_F13 = 124;
    public static final int KEY_F14 = 125;
    public static final int KEY_F15 = 126;
    public static final int KEY_F16 = 127;
    public static final int KEY_F17 = 128;
    public static final int KEY_F18 = 129;
    public static final int KEY_F19 = 130;
    public static final int KEY_F20 = 131;
    public static final int KEY_F21 = 132;
    public static final int KEY_F22 = 133;
    public static final int KEY_F23 = 134;
    public static final int KEY_F24 = 135;
    public static final int KEY_NUMLOCK = 144;
    public static final int KEY_SCROLL = 145;
    private final Map<Integer, Integer> keyStates = new HashMap<Integer, Integer>();

    public int getKeyState(int keyCode) {
        Integer i = this.keyStates.get(keyCode);
        return i != null ? i : 0;
    }

    public void setKeyState(int keyCode, int keyState) {
        this.keyStates.put(keyCode, keyState);
    }

    public int setKeyState(int keyStateCode) {
        int keyState = keyStateCode >>> 16;
        int keyCode = keyStateCode & 0xFFFF;
        this.setKeyState(keyCode, keyState);
        return keyCode;
    }

    public static int getKeyState(KeyEvent e) {
        int keyState = 0;
        int keyCode = 0;
        switch (e.getID()) {
            case 401: {
                keyState = 2;
                break;
            }
            case 402: {
                keyState = 1;
            }
        }
        if (Character.isDigit(e.getKeyChar())) {
            keyCode = e.getKeyChar();
        } else if (Character.isLetter(e.getKeyChar())) {
            keyCode = Character.toUpperCase(e.getKeyChar());
        } else {
            switch (e.getKeyCode()) {
                case 10: {
                    keyCode = 13;
                    break;
                }
                case 155: {
                    keyCode = 45;
                    break;
                }
                case 154: {
                    keyCode = 44;
                    break;
                }
                case 127: {
                    keyCode = 46;
                    break;
                }
                case 156: {
                    keyCode = 47;
                    break;
                }
                case 61440: {
                    keyCode = 124;
                    break;
                }
                case 61441: {
                    keyCode = 125;
                    break;
                }
                case 61442: {
                    keyCode = 126;
                    break;
                }
                case 61443: {
                    keyCode = 127;
                    break;
                }
                case 61444: {
                    keyCode = 128;
                    break;
                }
                case 61445: {
                    keyCode = 129;
                    break;
                }
                case 61446: {
                    keyCode = 130;
                    break;
                }
                case 61447: {
                    keyCode = 131;
                    break;
                }
                case 61448: {
                    keyCode = 132;
                    break;
                }
                case 61449: {
                    keyCode = 133;
                    break;
                }
                case 61450: {
                    keyCode = 134;
                    break;
                }
                case 61451: {
                    keyCode = 135;
                    break;
                }
                case 20: 
                case 144: 
                case 145: {
                    if (Toolkit.getDefaultToolkit().getLockingKeyState(e.getKeyCode())) {
                        keyState |= 4;
                    }
                }
                default: {
                    keyCode = e.getKeyCode();
                }
            }
        }
        if (keyCode != 0) {
            return (keyState << 16) + keyCode;
        }
        return 0;
    }

    public static int getKeyState(MouseEvent e) {
        int keyState = 0;
        int keyCode = 0;
        switch (e.getID()) {
            case 501: {
                keyState = 2;
                break;
            }
            case 502: {
                keyState = 1;
            }
        }
        switch (e.getButton()) {
            case 1: {
                keyCode = 1;
                break;
            }
            case 2: {
                if (MouseInfo.getNumberOfButtons() > 2) {
                    keyCode = 4;
                    break;
                }
                keyCode = 2;
                break;
            }
            case 3: {
                keyCode = 2;
            }
        }
        if (keyCode != 0 && keyState != 0) {
            return (keyState << 16) + keyCode;
        }
        return 0;
    }
}

