/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.WowSystem;
import com.veryant.wow.gui.client.Bordered;
import com.veryant.wow.gui.client.Initializable;
import com.veryant.wow.gui.client.RemoteFocusableComponent;
import com.veryant.wow.gui.client.WowButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.border.Border;

public abstract class RemoteButtonComponent
extends RemoteFocusableComponent
implements Initializable,
Bordered {
    private String accelerator;
    protected String caption;
    private String initialCaption;
    private boolean border;
    private boolean clientedge;
    private boolean modalframe;
    private boolean staticedge;
    private boolean pushed;
    private ActionListener al;

    @Override
    public boolean isBorder() {
        return this.border;
    }

    @Override
    public boolean isClientedge() {
        return this.clientedge;
    }

    @Override
    public boolean isModalframe() {
        return this.modalframe;
    }

    @Override
    public boolean isStaticedge() {
        return this.staticedge;
    }

    public void setBorder(boolean border) {
        this.border = border;
        this.updateBorder();
    }

    public void setClientedge(boolean clientedge) {
        this.clientedge = clientedge;
        this.updateBorder();
    }

    public void setModalframe(boolean modalframe) {
        this.modalframe = modalframe;
        this.updateBorder();
    }

    public void setStaticedge(boolean staticedge) {
        this.staticedge = staticedge;
        this.updateBorder();
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(String accelerator) {
        this.accelerator = accelerator;
        final AbstractButton btn = (AbstractButton)this.getGUIComponent();
        WowSystem.addAccelerator(btn, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btn.requestFocus();
                RemoteButtonComponent.this.handleMousePressed();
                btn.doClick();
            }
        }, "wowAction", (char)btn.getMnemonic(), accelerator);
    }

    public String getCaption() {
        return this.caption;
    }

    public String getText() {
        return this.getCaption();
    }

    public void setText(String caption) {
        this.setCaption(caption);
    }

    public void setCaption(String caption) {
        this.caption = caption;
        String[] ss = WowSystem.getCaption(caption);
        WowButton btn = (WowButton)((Object)this.getGUIComponent());
        btn.setText(ss[0]);
        if (ss[1] != null) {
            btn.setMnemonic(ss[1].charAt(0));
            if (this.accelerator == null) {
                this.setAccelerator("Alt+" + ss[1]);
            }
        } else {
            btn.setMnemonic('\u0000');
        }
    }

    public boolean isPushed() {
        return this.pushed;
    }

    @Override
    public void setInitialized() {
        this.initialCaption = this.caption;
    }

    @Override
    protected void updateBorder() {
        Border b = this.getSwingBorder();
        this.getGUIComponent().setBorder(b != null ? b : ((WowButton)((Object)this.getGUIComponent())).getDefaultBorder());
    }

    @Override
    public void initialize() {
        this.setCaption(this.initialCaption);
    }

    @Override
    protected void handleMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.pushEvent(8, 0);
        }
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteButtonComponent.this.pushEvent(1, 0);
            }
        };
        ((WowButton)((Object)this.getGUIComponent())).addActionListener(this.al);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.al != null && this.getGUIComponent() != null) {
            ((WowButton)((Object)this.getGUIComponent())).removeActionListener(this.al);
        }
    }
}

