/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.RemoteListComponent;
import com.veryant.wow.gui.client.WowComboBox;
import com.veryant.wow.gui.client.WowComboBoxEvent;
import com.veryant.wow.gui.client.WowComboBoxListener;
import com.veryant.wow.gui.client.WowPopupListener;
import com.veryant.wow.gui.client.WowTextListener;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class RemoteComboBox
extends RemoteListComponent
implements WowComboBoxListener {
    private final int[] runCounter = new int[1];
    private WowTextListener textlistener;
    private WowPopupListener popuplistener;
    private boolean popupListenerEnabled = true;
    private boolean autohscroll;
    private int style;
    private boolean oemconvert;
    private int maxtext;
    private final Timer timer;
    private Vector<Runnable> runnables = new Vector();

    public RemoteComboBox() {
        this.timer = new Timer(100, e -> SwingUtilities.invokeLater(() -> {
            Vector<Runnable> vector = this.runnables;
            synchronized (vector) {
                if (!this.runnables.isEmpty()) {
                    WowComboBox.ComboBoxComponent cc = this.getComboBox().getComboBoxComponent();
                    boolean b = cc.isPopupVisible();
                    int selIdx = cc.getSelectedIndex();
                    for (Runnable run : this.runnables) {
                        run.run();
                    }
                    this.runnables.clear();
                    cc.setSelectedIndex(selIdx);
                    if (b) {
                        this.popupListenerEnabled = false;
                        cc.setPopupVisible(false);
                        cc.setPopupVisible(true);
                        this.popupListenerEnabled = true;
                    }
                }
            }
        }));
        this.timer.setRepeats(false);
    }

    @Override
    public void dispose() {
        super.dispose();
        WowComboBox cb = this.getComboBox();
        if (cb != null) {
            if (this.textlistener != null) {
                cb.removeWowTextListeners(this.textlistener);
            }
            if (this.popuplistener != null) {
                cb.removePopupMenuListeners(this.popuplistener);
            }
            cb.removeWowComboBoxListener(this);
        }
    }

    public boolean isOemconvert() {
        return this.oemconvert;
    }

    public void setOemconvert(boolean oemconvert) {
        this.oemconvert = oemconvert;
    }

    public int getMaxtext() {
        return this.maxtext;
    }

    public void setMaxtext(int maxtext) {
        this.maxtext = maxtext;
        this.getComboBox().setMaxText(maxtext);
    }

    public boolean isAutohscroll() {
        return this.autohscroll;
    }

    public int getStyle() {
        return this.style;
    }

    public void setAutohscroll(boolean autohscroll) {
        this.autohscroll = autohscroll;
        this.getComboBox().setAutoHScroll(autohscroll);
    }

    public void setStyle(int style) {
        this.style = style;
        this.getComboBox().setStyle(style);
    }

    @Override
    protected JComponent createGUIComponent() {
        return new WowComboBox();
    }

    @Override
    public int getRemoteWidgetType() {
        return 9;
    }

    private WowComboBox getComboBox() {
        return (WowComboBox)this.getGUIComponent();
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getComboBox().addWowComboBoxListener(this);
        this.textlistener = new WowTextListener(){

            @Override
            public void textChanged() {
                RemoteComboBox.this.pushEvent(27, 0);
            }

            @Override
            public void inputTerminated(String str) {
            }

            @Override
            public void mouseClickedOnScroll(boolean vorh) {
            }
        };
        this.getComboBox().addWowTextListener(this.textlistener);
        this.popuplistener = () -> {
            if (this.popupListenerEnabled) {
                this.pushEvent(26, 0);
            }
        };
        this.getComboBox().addPopupMenuListener(this.popuplistener);
    }

    @Override
    protected void handleMouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.pushEvent(8, 0);
        }
    }

    public Rectangle getDropDownRectangle() {
        return new Rectangle();
    }

    public boolean isPopupvisible() {
        return this.getComboBox().isPopupVisible();
    }

    public void setPopupvisible(boolean v) {
        this.getComboBox().setPopupVisible(v);
    }

    public int getEditSelectionStart() {
        return this.getComboBox().getEditSelectionStart();
    }

    public int getEditSelectionEnd() {
        return this.getComboBox().getEditSelectionEnd();
    }

    public void setEditSelection(int start, int end) {
        this.getComboBox().setEditSelection(start, end);
    }

    public int getItemheight(int idx) {
        return 0;
    }

    public void setItemheight(int height) {
    }

    @Override
    protected void intAddItem(int idx, String item) {
        Runnable run = () -> this.getComboBox().intAddItem(idx, item);
        this.invokeLater(run);
    }

    @Override
    protected void intRemoveItem(int idx) {
        Runnable run = () -> this.getComboBox().intRemoveItem(idx);
        this.invokeLater(run);
    }

    @Override
    protected void intRemoveAllItems() {
        Runnable run = () -> this.getComboBox().intRemoveAllItems();
        this.invokeLater(run);
    }

    public void clearSelection() {
        Runnable run = () -> this.getComboBox().clearSelection();
        this.invokeLater(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeLater(Runnable run) {
        boolean popupVis = this.getComboBox().isPopupVisible();
        RunnableWrapper runw = new RunnableWrapper(run);
        Object object = this.runCounter;
        synchronized (this.runCounter) {
            this.runCounter[0] = this.runCounter[0] + 1;
            // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
            if (popupVis) {
                Vector<Runnable> vector = this.runnables;
                object = vector;
                synchronized (vector) {
                    this.runnables.addElement(runw);
                    this.timer.restart();
                    // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
                }
            } else {
                SwingUtilities.invokeLater(runw);
            }
            return;
        }
    }

    public void copy() {
        this.getComboBox().copy();
    }

    public void cut() {
        this.getComboBox().cut();
    }

    public void paste() {
        this.getComboBox().paste();
    }

    public String getText() {
        this.checkRunCounter();
        return this.getComboBox().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRunCounter() {
        int[] nArray = this.runCounter;
        synchronized (this.runCounter) {
            while (this.runCounter[0] > 0) {
                try {
                    this.runCounter.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setSeltext(String text) {
        super.setSeltext(text);
        Runnable run = () -> this.getComboBox().setText(text);
        this.invokeLater(run);
    }

    public void setText(String text) {
        Runnable run = () -> this.getComboBox().setText(text);
        this.invokeLater(run);
    }

    @Override
    public int getCursel() {
        this.checkRunCounter();
        return this.getComboBox().getCursel();
    }

    @Override
    public void setCursel(int idx) {
        this.setCursel(idx, true);
    }

    public void setCursel(int idx, boolean showSelection) {
        super.setCursel(idx);
        Runnable run = () -> this.getComboBox().setCursel(idx, showSelection);
        this.invokeLater(run);
    }

    @Override
    public String getSeltext() {
        this.checkRunCounter();
        return this.getComboBox().getSeltext();
    }

    @Override
    public void selectionChanged(WowComboBoxEvent cbe) {
        this.pushEvent(1, 3);
    }

    protected int intGetSelectionIndex() {
        return 0;
    }

    @Override
    public String getLayoutDataKey() {
        return "combobox";
    }

    @Override
    public void handleFocusGained(boolean fireEvent) {
        super.handleFocusGained(fireEvent);
        this.getComboBox().handleFocusGained();
    }

    @Override
    public void handleFocusLost() {
        super.handleFocusLost();
        this.getComboBox().handleFocusLost();
    }

    private class RunnableWrapper
    implements Runnable {
        private final Runnable run;

        RunnableWrapper(Runnable r) {
            this.run = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.run.run();
            int[] nArray = RemoteComboBox.this.runCounter;
            synchronized (nArray) {
                if (RemoteComboBox.this.runCounter[0] > 0) {
                    int[] nArray2 = RemoteComboBox.this.runCounter;
                    nArray2[0] = nArray2[0] - 1;
                }
                RemoteComboBox.this.runCounter.notifyAll();
            }
        }
    }
}

