/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.toedter.calendar.JCalendar;
import com.veryant.wow.WowSystem;
import com.veryant.wow.gui.client.Bordered;
import com.veryant.wow.gui.client.RemoteFocusableComponent;
import com.veryant.wow.gui.client.WowDateChooser;
import java.awt.Color;
import java.awt.Font;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class RemoteDateComponent
extends RemoteFocusableComponent
implements Bordered,
ChangeListener {
    private boolean border;
    private boolean clientedge;
    private boolean modalframe;
    private boolean staticedge;
    private boolean leftscrollbar;
    protected int mccolorindex;
    protected String mccolor;

    public String getRange() {
        JCalendar cal = this.getDateChooser().getJCalendar();
        return RemoteDateComponent.date2String(cal.getMinSelectableDate()) + "," + RemoteDateComponent.date2String(cal.getMaxSelectableDate());
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getDateChooser().setListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.pushEvent(9, 0);
    }

    protected static String date2String(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        StringBuilder sb = new StringBuilder();
        sb.append(cal.get(1));
        sb.append(',');
        sb.append(cal.get(2) + 1);
        sb.append(',');
        sb.append(cal.get(7));
        sb.append(',');
        sb.append(cal.get(5));
        sb.append(',');
        sb.append(cal.get(11));
        sb.append(',');
        sb.append(cal.get(12));
        sb.append(',');
        sb.append(cal.get(13));
        sb.append(',');
        sb.append(cal.get(14));
        return sb.toString();
    }

    protected static Date string2Date(String s) {
        Calendar cal = Calendar.getInstance();
        String[] ss = s.split("\\,");
        switch (ss.length) {
            case 8: {
                try {
                    cal.set(14, Integer.parseInt(ss[7]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 7: {
                try {
                    cal.set(13, Integer.parseInt(ss[6]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 6: {
                try {
                    cal.set(12, Integer.parseInt(ss[5]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 5: {
                try {
                    cal.set(11, Integer.parseInt(ss[4]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 4: {
                try {
                    cal.set(5, Integer.parseInt(ss[3]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 2: 
            case 3: {
                try {
                    cal.set(2, Integer.parseInt(ss[1]) - 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 1: {
                try {
                    cal.set(1, Integer.parseInt(ss[0]));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return cal.getTime();
    }

    public abstract String getFormat();

    @Override
    public boolean isBorder() {
        return this.border;
    }

    @Override
    public boolean isClientedge() {
        return this.clientedge;
    }

    @Override
    public boolean isModalframe() {
        return this.modalframe;
    }

    @Override
    public boolean isStaticedge() {
        return this.staticedge;
    }

    public boolean isLeftscrollbar() {
        return this.leftscrollbar;
    }

    public int getMccolorindex() {
        return this.mccolorindex;
    }

    public String getMccolor() {
        return this.mccolor;
    }

    public void setBorder(boolean border) {
        this.border = border;
        this.updateBorder();
    }

    public void setClientedge(boolean clientedge) {
        this.clientedge = clientedge;
        this.updateBorder();
    }

    public void setModalframe(boolean modalframe) {
        this.modalframe = modalframe;
        this.updateBorder();
    }

    public void setStaticedge(boolean staticedge) {
        this.staticedge = staticedge;
        this.updateBorder();
    }

    public void setLeftscrollbar(boolean leftscrollbar) {
        this.leftscrollbar = leftscrollbar;
    }

    public void setMccolorindex(int mccolorindex) {
        this.mccolorindex = mccolorindex;
    }

    protected WowDateChooser getDateChooser() {
        return (WowDateChooser)((Object)this.getGUIComponent());
    }

    public void setMccolor(String mccolor) {
        this.mccolor = mccolor;
        Color c = WowSystem.parseColor(mccolor);
        switch (this.mccolorindex) {
            case 0: {
                this.getDateChooser().setCalendarDecorationBackground(c);
                break;
            }
            case 1: {
                this.getDateChooser().setCalendarDayChooserForeground(c);
                break;
            }
            case 2: {
                this.getDateChooser().setCalendarMonthYearChooserBackground(c);
                break;
            }
            case 3: {
                this.getDateChooser().setCalendarMonthYearChooserForeground(c);
                break;
            }
            case 4: {
                this.getDateChooser().setCalendarDayChooserBackground(c);
                break;
            }
            case 5: {
                this.getDateChooser().setCalendarWeekDayForeground(c);
                break;
            }
            case 6: {
                this.getDateChooser().setCalendarSundayForeground(c);
            }
        }
    }

    public static void setCalendarDecorationBackground(JCalendar cal, Color c) {
        cal.setDecorationBackgroundColor(c);
    }

    public static void setCalendarDayChooserBackground(JCalendar cal, Color c) {
        cal.getDayChooser().getDayPanel().setBackground(c);
    }

    public static void setCalendarDayChooserForeground(JCalendar cal, Color c) {
        cal.getDayChooser().setForeground(c);
    }

    public static void setCalendarDayChooserFont(JCalendar cal, Font f) {
        cal.getDayChooser().setFont(f);
    }

    public static void setCalendarMonthYearChooserBackground(JCalendar cal, Color c) {
        cal.getMonthChooser().getComboBox().setBackground(c);
        ((JSpinner)cal.getYearChooser().getSpinner()).getEditor().setBackground(c);
    }

    public static void setCalendarMonthYearChooserForeground(JCalendar cal, Color c) {
        cal.getMonthChooser().getComboBox().setForeground(c);
        ((JSpinner)cal.getYearChooser().getSpinner()).getEditor().setForeground(c);
    }

    public static void setCalendarMonthYearChooserFont(JCalendar cal, Font f) {
        cal.getMonthChooser().getComboBox().setFont(f);
        cal.getYearChooser().setFont(f);
    }

    public static void setCalendarWeekDayForeground(JCalendar cal, Color c) {
        cal.setWeekdayForeground(c);
    }

    public static void setCalendarSundayForeground(JCalendar cal, Color c) {
        cal.setSundayForeground(c);
    }

    public static Color getCalendarDecorationBackground(JCalendar cal) {
        return cal.getDecorationBackgroundColor();
    }

    public static Color getCalendarDayChooserBackground(JCalendar cal) {
        return cal.getDayChooser().getDayPanel().getBackground();
    }

    public static Color getCalendarDayChooserForeground(JCalendar cal) {
        return cal.getDayChooser().getForeground();
    }

    public static Font getCalendarDayChooserFont(JCalendar cal) {
        return cal.getDayChooser().getFont();
    }

    public static Color getCalendarMonthYearChooserBackground(JCalendar cal) {
        return cal.getMonthChooser().getComboBox().getBackground();
    }

    public static Color getCalendarMonthYearChooserForeground(JCalendar cal) {
        return cal.getMonthChooser().getComboBox().getForeground();
    }

    public static Font getCalendarMonthYearChooserFont(JCalendar cal) {
        return cal.getMonthChooser().getComboBox().getFont();
    }

    public static Color getCalendarWeekDayForeground(JCalendar cal) {
        return cal.getWeekdayForeground();
    }

    public static Color getCalendarSundayForeground(JCalendar cal) {
        return cal.getSundayForeground();
    }
}

