/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.Bordered3D;
import com.veryant.wow.gui.client.Initializable;
import com.veryant.wow.gui.client.RemoteFocusableComponent;
import com.veryant.wow.gui.client.WowEditBox;
import com.veryant.wow.gui.client.WowTextListener;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RemoteEditBox
extends RemoteFocusableComponent
implements Initializable,
Bordered3D {
    private WowTextListener textlistener;
    private boolean _3d;
    private int alignment;
    private boolean autohscroll = true;
    private boolean autovscroll;
    private boolean border;
    private boolean clientedge;
    private boolean modalframe;
    private boolean staticedge;
    private int _case;
    private boolean leftscrollbar;
    private int maxchars;
    private boolean multiline;
    private boolean nohidesel;
    private boolean numeric;
    private int numericdecdigits;
    private int numericintdigits;
    private boolean numericsign = true;
    private boolean oemconvert;
    private boolean password;
    private String passwordchar;
    private boolean readonly;
    private int scrollbars;
    private boolean selectallongotfocus;
    private String text;
    private String initialText;
    private boolean wantpopupmenu;
    private boolean wantreturn;
    private boolean fmtlines;
    private boolean modify;
    private Rectangle clientarea;
    private String tabstops;

    @Override
    public boolean is3d() {
        return this._3d;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean isAutohscroll() {
        return this.autohscroll;
    }

    public boolean isAutovscroll() {
        return this.autovscroll;
    }

    @Override
    public boolean isBorder() {
        return this.border;
    }

    @Override
    public boolean isClientedge() {
        return this.clientedge;
    }

    @Override
    public boolean isModalframe() {
        return this.modalframe;
    }

    @Override
    public boolean isStaticedge() {
        return this.staticedge;
    }

    public int getCase() {
        return this._case;
    }

    public boolean isLeftscrollbar() {
        return this.leftscrollbar;
    }

    public int getMaxchars() {
        return this.maxchars;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isNohidesel() {
        return this.nohidesel;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public int getNumericdecdigits() {
        return this.numericdecdigits;
    }

    public int getNumericintdigits() {
        return this.numericintdigits;
    }

    public boolean isNumericsign() {
        return this.numericsign;
    }

    public boolean isOemconvert() {
        return this.oemconvert;
    }

    public boolean isPassword() {
        return this.password;
    }

    public String getPasswordchar() {
        return this.passwordchar;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public int getScrollbars() {
        return this.scrollbars;
    }

    public boolean isSelectallongotfocus() {
        return this.selectallongotfocus;
    }

    public String getText() {
        String[] Return = new String[1];
        WowEditBox ed = this.getEditBox();
        if (ed != null) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    Return[0] = ed.getText();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                Return[0] = this.text;
            }
        } else {
            Return[0] = this.text;
        }
        return Return[0];
    }

    public boolean isWantpopupmenu() {
        return this.wantpopupmenu;
    }

    public boolean isWantreturn() {
        return this.wantreturn;
    }

    public void set3d(boolean _3d) {
        this._3d = _3d;
        this.updateBorder();
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.getEditBox().setHorizontalAlignment(alignment);
    }

    public void setAutohscroll(boolean autohscroll) {
        this.autohscroll = autohscroll;
        this.getEditBox().setHScrollEnabled(autohscroll);
    }

    public void setAutovscroll(boolean autovscroll) {
        this.autovscroll = autovscroll;
        this.getEditBox().setVScrollEnabled(autovscroll);
    }

    public void setBorder(boolean border) {
        this.border = border;
        this.updateBorder();
    }

    public void setClientedge(boolean clientedge) {
        this.clientedge = clientedge;
        this.updateBorder();
    }

    public void setModalframe(boolean modalframe) {
        this.modalframe = modalframe;
        this.updateBorder();
    }

    public void setStaticedge(boolean staticedge) {
        this.staticedge = staticedge;
        this.updateBorder();
    }

    public void setCase(int _case) {
        this._case = _case;
        this.getEditBox().setCase(_case);
    }

    public void setLeftscrollbar(boolean leftscrollbar) {
        this.leftscrollbar = leftscrollbar;
        if (this.multiline) {
            this.getEditBox().setLeftscrollbar(leftscrollbar);
        }
    }

    public void setMaxchars(int maxchars) {
        this.maxchars = maxchars;
        this.getEditBox().setMaxchars(maxchars);
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
        this.getEditBox().setMultiline(multiline);
        if (multiline && this.leftscrollbar) {
            this.getEditBox().setLeftscrollbar(this.leftscrollbar);
        }
    }

    public void setNohidesel(boolean nohidesel) {
        this.nohidesel = nohidesel;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
        this.getEditBox().setNumeric(numeric);
    }

    public void setNumericdecdigits(int numericdecdigits) {
        this.numericdecdigits = numericdecdigits;
        this.getEditBox().setNumericdecdigits(numericdecdigits);
    }

    public void setNumericintdigits(int numericintdigits) {
        this.numericintdigits = numericintdigits;
        this.getEditBox().setNumericintdigits(numericintdigits);
    }

    public void setNumericsign(boolean numericsign) {
        this.numericsign = numericsign;
        this.getEditBox().setNumericsign(numericsign);
    }

    public void setOemconvert(boolean oemconvert) {
        this.oemconvert = oemconvert;
    }

    public void setPassword(boolean password) {
        this.password = password;
        this.getEditBox().setPassword(password);
    }

    private WowEditBox getEditBox() {
        return (WowEditBox)this.getGUIComponent();
    }

    public void setPasswordchar(String passwordchar) {
        this.passwordchar = passwordchar;
        this.getEditBox().setPasswordChar(passwordchar);
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.getEditBox().setReadonly(readonly);
    }

    public void setScrollbars(int scrollbars) {
        this.scrollbars = scrollbars;
        this.getEditBox().setScrollbars(scrollbars);
    }

    public void setSelectallongotfocus(boolean selectallongotfocus) {
        this.selectallongotfocus = selectallongotfocus;
        this.getEditBox().setSelectallongotfocus(selectallongotfocus);
    }

    public void setText(String text) {
        this.text = text;
        WowEditBox eb = (WowEditBox)this.getGUIComponent();
        SwingUtilities.invokeLater(() -> {
            eb.setNumeric(false);
            eb.setMaxchars(0);
            eb.setText(this.text);
            eb.setNumeric(this.numeric);
            eb.setMaxchars(this.maxchars);
        });
    }

    public void setWantpopupmenu(boolean wantpopupmenu) {
        this.wantpopupmenu = wantpopupmenu;
    }

    public void setWantreturn(boolean wantreturn) {
        this.wantreturn = wantreturn;
        this.getEditBox().setWantreturn(wantreturn);
    }

    @Override
    protected JComponent createGUIComponent() {
        return new WowEditBox();
    }

    @Override
    public int getRemoteWidgetType() {
        return 3;
    }

    public boolean canUndo() {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).canUndo();
        }
        return false;
    }

    public void emptyUndoBuffer() {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).undoEnd();
        }
    }

    public boolean isFmtlines() {
        return this.fmtlines;
    }

    public void setFmtlines(boolean fmtlines) {
        this.fmtlines = fmtlines;
    }

    public int getFirstVisibleLineIndex() {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getFirstVisibleLineIndex();
        }
        return 0;
    }

    public String getLine(int idx) {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getLine(idx);
        }
        return null;
    }

    public int getLineLength(int offs) {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getLineLength(offs);
        }
        return 0;
    }

    public int getLineCount() {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getLineCount();
        }
        return 0;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setModify(boolean modify) {
        this.modify = modify;
    }

    public Rectangle getClientarea() {
        Rectangle Return = this.clientarea;
        if (this.getGUIComponent() != null) {
            Return = ((WowEditBox)this.getGUIComponent()).getClientArea();
        }
        return Return;
    }

    public void setClientarea(Rectangle clientarea) {
        this.clientarea = clientarea;
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).setClientArea(clientarea);
        }
    }

    public int getSelectionStart() {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getSelectionStart();
        }
        return 0;
    }

    public int getSelectionEnd() {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getSelectionEnd();
        }
        return 0;
    }

    public int getLineOfOffset(int offs) {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getLineOfOffset(offs);
        }
        return 0;
    }

    public int getLineOffset(int linenum) {
        if (this.getGUIComponent() != null) {
            return ((WowEditBox)this.getGUIComponent()).getLineOffset(linenum);
        }
        return 0;
    }

    public void scroll(int scrollLines, int scrollColumns) {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).scroll(scrollLines, scrollColumns);
        }
    }

    public void replaceSelection(String newText) {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).replaceSelection(newText);
        }
    }

    public void selectAll() {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).selectAll();
        }
    }

    public void setSelection(int start, int end) {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).select(start, end);
        }
    }

    public String getTabstops() {
        return this.tabstops;
    }

    public void setTabstops(String tabstops) {
        this.tabstops = tabstops;
    }

    public void undo() {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).undo();
        }
    }

    public void clearSelection() {
        if (this.getGUIComponent() != null && ((WowEditBox)this.getGUIComponent()).getSelectedText().length() > 0) {
            ((WowEditBox)this.getGUIComponent()).select(0, 0);
        }
    }

    public void copy() {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).copy();
        }
    }

    public void cut() {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).cut();
        }
    }

    public void paste() {
        if (this.getGUIComponent() != null) {
            ((WowEditBox)this.getGUIComponent()).paste();
        }
    }

    @Override
    public void setInitialized() {
        this.initialText = this.text;
    }

    @Override
    public void initialize() {
        this.setText(this.initialText);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.textlistener != null && this.getGUIComponent() != null) {
            this.getEditBox().removeTextListeners(this.textlistener);
        }
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.textlistener = new WowTextListener(){

            @Override
            public void textChanged() {
                RemoteEditBox.this.setModify(true);
                RemoteEditBox.this.pushEvent(9, 0);
            }

            @Override
            public void inputTerminated(String str) {
                RemoteEditBox.this.pushEvent(12, 0);
            }

            @Override
            public void mouseClickedOnScroll(boolean vorh) {
                if (vorh) {
                    RemoteEditBox.this.pushEvent(11, 0);
                } else {
                    RemoteEditBox.this.pushEvent(10, 0);
                }
            }
        };
        ((WowEditBox)this.getGUIComponent()).addWowTextListener(this.textlistener);
    }

    @Override
    public String getLayoutDataKey() {
        return this.multiline ? "mleditbox" : "editbox";
    }
}

