/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.KeyTable;
import com.veryant.wow.gui.client.Focusable;
import com.veryant.wow.gui.client.RemoteForm;
import com.veryant.wow.gui.client.RemoteStandardComponent;
import com.veryant.wow.gui.client.WowComposite;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class RemoteFocusableComponent
extends RemoteStandardComponent
implements Focusable {
    private boolean tabstop = true;
    private int lastPressedKeyCode = 0;
    private KeyListener kl;
    private FocusListener fl;

    @Override
    public boolean isTabstop() {
        return this.tabstop;
    }

    @Override
    public void setTabstop(boolean tabstop) {
        this.tabstop = tabstop;
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.addKeyListener();
    }

    public void addKeyListener() {
        JComponent c = this.getGUIComponent();
        this.kl = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                RemoteFocusableComponent.this.handleKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RemoteFocusableComponent.this.handleKeyReleased(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                RemoteFocusableComponent.this.handleKeyTyped(e);
            }
        };
        c.addKeyListener(this.kl);
        RemoteFocusableComponent.addKeyEventDispatcher(c, this);
    }

    protected void handleKeyPressed(KeyEvent e) {
        this.lastPressedKeyCode = e.getKeyCode();
        this.pushEvent(37, KeyTable.getKeyState(e));
    }

    protected void handleKeyReleased(KeyEvent e) {
        this.pushEvent(39, KeyTable.getKeyState(e));
    }

    protected void handleKeyTyped(KeyEvent e) {
        e.setKeyCode(this.lastPressedKeyCode);
        this.lastPressedKeyCode = 0;
        this.pushEvent(38, KeyTable.getKeyState(e));
    }

    @Override
    protected void handleMousePressed(MouseEvent e) {
        super.handleMousePressed(e);
        this.handleMousePressed();
    }

    protected void handleMousePressed() {
        Focusable focusOwner;
        if (this.isEnabled() && (focusOwner = this.getParentForm().getFocusOwner()) != this) {
            if (focusOwner != null) {
                focusOwner.handleFocusLost();
            }
            this.handleFocusGained(true);
        }
    }

    @Override
    public void handleFocusGained(boolean fireEvent) {
        RemoteForm parentForm = this.getParentForm();
        parentForm.setAsActiveWindow();
        parentForm.setAsFocusedWindow();
        parentForm.setFocusOwner(this);
        if (fireEvent) {
            this.pushEvent(50, 0);
        }
    }

    @Override
    public void handleFocusLost() {
        this.pushEvent(51, 0);
    }

    @Override
    public void dispose() {
        super.dispose();
        JComponent c = this.getGUIComponent();
        if (c != null) {
            if (this.kl != null) {
                c.removeKeyListener(this.kl);
            }
            if (this.fl != null) {
                c.removeFocusListener(this.fl);
            }
            RemoteFocusableComponent.removeKeyEventDispatcher(c);
        }
    }

    @Override
    public void requestFocus() {
        RemoteForm parentForm = this.getParentForm();
        Focusable focusOwner = parentForm.getFocusOwner();
        if (focusOwner != this) {
            Component c = this.getGUIComponent();
            if (c instanceof WowComposite) {
                c = ((WowComposite)((Object)c)).getFocusOwner();
            }
            ((Component)c).requestFocusInWindow();
            if (focusOwner != null) {
                focusOwner.handleFocusLost();
            }
            this.handleFocusGained(true);
        }
    }
}

