/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.ImageLoader;
import com.iscobol.gui.client.KeyboardBuffer;
import com.veryant.wow.WowSystem;
import com.veryant.wow.gui.KeyTable;
import com.veryant.wow.gui.client.Focusable;
import com.veryant.wow.gui.client.RemoteComponent;
import com.veryant.wow.gui.client.RemoteContainer;
import com.veryant.wow.gui.client.RemoteMenu;
import com.veryant.wow.gui.client.RemoteStatusBar;
import com.veryant.wow.gui.client.RemoteToolBar;
import com.veryant.wow.gui.client.RemoteWidget;
import com.veryant.wow.gui.client.WowForm;
import com.veryant.wow.gui.client.WowGuiFactoryImpl;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;

public class RemoteForm
extends RemoteWidget
implements RemoteContainer {
    public static final int CHILD_STYLE = 0;
    public static final int POPUP_STYLE = 1;
    public static final int OVERLAPPED_STYLE = 2;
    public static final int MIXED_3D = 0;
    public static final int ALL_3D = 1;
    public static final int NO_3D = 2;
    public static final int LM_DEFAULT = -1;
    public static final int LM_NONE = 0;
    public static final int LM_SCALE = 1;
    public static final int LM_ZOOM = 2;
    private static final Cursor DEFAULT_CURSOR;
    private static final Cursor CROSS_CURSOR;
    private static final Cursor IBEAM_CURSOR;
    private static final Cursor WAIT_CURSOR;
    private static final Cursor SIZENESW_CURSOR;
    private static final Cursor SIZENWSE_CURSOR;
    private static final Cursor SIZENS_CURSOR;
    private static final Cursor SIZEWE_CURSOR;
    private static final Cursor NO_CURSOR;
    private static final Cursor APPSTARTING_CURSOR;
    private static final String[] CURSOR_NAMES;
    private static final ImageLoader externalLoader;
    private int _3d;
    private boolean alloweventfilter;
    private String backcolor;
    private String forecolor;
    private int top = -1;
    private int left = -1;
    private int height;
    private int width;
    private String name;
    private String bitmap;
    private int bitmapmode;
    private int border;
    private boolean caption = true;
    private int centered;
    private boolean clipcontrols;
    private boolean clipsiblings;
    private int cursor;
    private boolean dialogmotion = true;
    private boolean enabled = true;
    private boolean fireEnableEvent;
    private String icon;
    private boolean keypreview;
    private boolean maxbutton = true;
    private boolean minbutton = true;
    private boolean modal;
    private boolean noredraw;
    private int scrollbars;
    private int showstate;
    private int style = 2;
    private int syskeymode;
    private boolean systemmenu = true;
    private String tag;
    private String title;
    private boolean toolwindow;
    private boolean visible = true;
    private boolean fireShowEvent;
    private String version;
    private boolean wsdefinition = true;
    private List<Image> iconImages;
    private int iconImageId = -1;
    private int layoutmanager = -1;
    private Vector<RemoteComponent> components = new Vector();
    private Vector<RemoteForm> children = new Vector();
    private RemoteToolBar topToolBar;
    private RemoteToolBar bottomToolBar;
    private RemoteStatusBar statusBar;
    private RemoteMenu menu;
    private RemoteForm ownerForm;
    protected WowGuiFactoryImpl wgf;
    protected WowForm mainWindow;
    protected Focusable focusOwner;
    private ButtonGroup buttonGroup = new ButtonGroup();

    public RemoteForm(WowGuiFactoryImpl wgf, RemoteForm ownerForm) {
        this.wgf = wgf;
        this.ownerForm = ownerForm;
        if (ownerForm != null) {
            ownerForm.children.addElement(this);
        }
    }

    public RemoteForm[] getChildForms() {
        return this.children.toArray(new RemoteForm[this.children.size()]);
    }

    public int get3d() {
        return this._3d;
    }

    public boolean isAlloweventfilter() {
        return this.alloweventfilter;
    }

    public String getBackcolor() {
        return this.backcolor;
    }

    public String getForecolor() {
        return this.forecolor;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String getName() {
        return this.name;
    }

    public String getBitmap() {
        return this.bitmap;
    }

    public int getBitmapmode() {
        return this.bitmapmode;
    }

    public int getBorder() {
        return this.border;
    }

    public boolean isCaption() {
        return this.caption;
    }

    public int getCentered() {
        return this.centered;
    }

    public boolean isClipcontrols() {
        return this.clipcontrols;
    }

    public boolean isClipsiblings() {
        return this.clipsiblings;
    }

    public String getCursor() {
        return CURSOR_NAMES[this.cursor >= 0 && this.cursor < CURSOR_NAMES.length ? this.cursor : 0];
    }

    public boolean isDialogmotion() {
        return this.dialogmotion;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isKeypreview() {
        return this.keypreview;
    }

    public boolean isMaxbutton() {
        return this.maxbutton;
    }

    public boolean isMinbutton() {
        return this.minbutton;
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean isNoredraw() {
        return this.noredraw;
    }

    public int getScrollbars() {
        return this.scrollbars;
    }

    public int getShowstate() {
        return this.showstate;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSyskeymode() {
        return this.syskeymode;
    }

    public boolean isSystemmenu() {
        return this.systemmenu;
    }

    public String getTag() {
        return this.tag;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isToolwindow() {
        return this.toolwindow;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isWsdefinition() {
        return this.wsdefinition;
    }

    public void set3d(int _3d) {
        this._3d = _3d;
    }

    public void setAlloweventfilter(boolean alloweventfilter) {
        this.alloweventfilter = alloweventfilter;
    }

    public void setBackcolor(String backcolor) {
        this.backcolor = backcolor;
        if (this.mainWindow != null) {
            this.mainWindow.setBackground(WowSystem.parseColor(backcolor));
        }
    }

    public void setForecolor(String forecolor) {
        this.forecolor = forecolor;
    }

    public void setTop(int top) {
        this.top = top;
        this.setLocation(this.left, top, this.centered);
    }

    public void setLeft(int left) {
        this.left = left;
        this.setLocation(left, this.top, this.centered);
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.width > 0) {
            this.setSize(this.width, height);
        }
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.height > 0) {
            this.setSize(width, this.height);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBitmap(String bitmap) {
        this.bitmap = bitmap;
    }

    public void setBitmapmode(int bitmapmode) {
        this.bitmapmode = bitmapmode;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public void setCaption(boolean caption) {
        this.caption = caption;
    }

    public void setCentered(int centered) {
        this.centered = centered;
        this.setLocation(this.left, this.top, centered);
    }

    public void setClipcontrols(boolean clipcontrols) {
        this.clipcontrols = clipcontrols;
    }

    public void setClipsiblings(boolean clipsiblings) {
        this.clipsiblings = clipsiblings;
    }

    public void setCursor(String cursor) {
        int c = 0;
        for (int i = 0; i < CURSOR_NAMES.length; ++i) {
            if (!CURSOR_NAMES[i].equals(cursor)) continue;
            c = i;
            break;
        }
        this.setCursor(c);
    }

    void setCursor(int cursor) {
        Window w;
        this.cursor = cursor;
        if (this.mainWindow != null && (w = this.mainWindow.getWindow()) != null) {
            switch (this.cursor) {
                case 11: {
                    w.setCursor(APPSTARTING_CURSOR);
                    break;
                }
                case 3: {
                    w.setCursor(CROSS_CURSOR);
                    break;
                }
                case 1: {
                    w.setCursor(IBEAM_CURSOR);
                    break;
                }
                case 10: {
                    w.setCursor(NO_CURSOR);
                    break;
                }
                case 6: {
                    w.setCursor(SIZENESW_CURSOR);
                    break;
                }
                case 5: {
                    w.setCursor(SIZENWSE_CURSOR);
                    break;
                }
                case 8: {
                    w.setCursor(SIZENS_CURSOR);
                    break;
                }
                case 7: {
                    w.setCursor(SIZEWE_CURSOR);
                    break;
                }
                case 2: {
                    w.setCursor(WAIT_CURSOR);
                    break;
                }
                default: {
                    w.setCursor(DEFAULT_CURSOR);
                }
            }
        }
    }

    public void setDialogmotion(boolean dialogmotion) {
        this.dialogmotion = dialogmotion;
        if (this.mainWindow != null) {
            this.mainWindow.setTraversalKeysEnabled(dialogmotion);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.fireEnableEvent) {
            this.pushEvent(35, 0);
        } else {
            this.fireEnableEvent = true;
        }
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.iconImages = icon != null ? this.createIconImages(icon) : null;
        this.setIconImages(this.iconImages);
    }

    private List createIconImages(String fileName) {
        ArrayList<Image> Return = null;
        if (externalLoader != null) {
            Return = externalLoader.loadIcons(new File(fileName));
        }
        if (Return == null) {
            try {
                Image im = WowGuiFactoryImpl.getImage(fileName);
                if (im != null) {
                    ArrayList<Image> list = new ArrayList<Image>();
                    list.add(im);
                    Return = list;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Return;
    }

    public void setKeypreview(boolean keypreview) {
        this.keypreview = keypreview;
    }

    public void setMaxbutton(boolean maxbutton) {
        this.maxbutton = maxbutton;
    }

    public void setMinbutton(boolean minbutton) {
        this.minbutton = minbutton;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setNoredraw(boolean noredraw) {
        this.noredraw = noredraw;
    }

    public void setScrollbars(int scrollbars) {
        this.scrollbars = scrollbars;
    }

    public void setShowstate(int showstate) {
        this.showstate = showstate;
        if (this.mainWindow != null) {
            this.mainWindow.setState(showstate);
        }
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setSyskeymode(int syskeymode) {
        this.syskeymode = syskeymode;
    }

    public void setSystemmenu(boolean systemmenu) {
        this.systemmenu = systemmenu;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.mainWindow != null) {
            this.mainWindow.setTitle(title);
        }
    }

    public void setToolwindow(boolean toolwindow) {
        this.toolwindow = toolwindow;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.intSetVisible();
        }
    }

    public int getLayoutmanager() {
        return this.layoutmanager;
    }

    protected int getNoDefaultLayoutManager() {
        int lm = this.layoutmanager;
        if (lm == -1) {
            String s = this.wgf.getWowCsProperty().get("iscobol.gui.layout_manager", null);
            lm = "LM-ZOOM".equalsIgnoreCase(s) ? 2 : ("LM-SCALE".equalsIgnoreCase(s) ? 1 : 0);
        }
        return lm;
    }

    public void setLayoutmanager(int layoutmanager) {
        this.layoutmanager = layoutmanager;
    }

    private void intSetVisible() {
        if (this.mainWindow != null) {
            if (this.visible && this.fireShowEvent) {
                this.pushEvent(48, 0);
            }
            this.mainWindow.setVisible(this.visible);
        }
    }

    public void setWsdefinition(boolean wsdefinition) {
        this.wsdefinition = wsdefinition;
    }

    protected static void removeFromParent(RemoteComponent c) {
        RemoteContainer par = c.getParentContainer();
        if (par != null) {
            par.removeComponent(c);
        }
    }

    protected static void removeFromParent(RemoteToolBar tb) {
        RemoteForm par;
        if (tb != null && (par = (RemoteForm)tb.getParent()) != null) {
            if (par.getTopToolBar() == tb) {
                par.setTopToolBar(null);
            } else if (par.getBottomToolBar() == tb) {
                par.setBottomToolBar(null);
            }
        }
    }

    protected static void removeFromParent(RemoteStatusBar sb) {
        RemoteForm par;
        if (sb != null && (par = (RemoteForm)sb.getParent()) != null) {
            par.setStatusBar(null);
        }
    }

    @Override
    public RemoteComponent getComponentAt(int i) {
        return this.components.elementAt(i);
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public void addComponent(RemoteComponent c) {
        RemoteForm.removeFromParent(c);
        this.components.addElement(c);
        c.setParent(this);
    }

    @Override
    public void addComponent(int idx, RemoteComponent c) {
        RemoteForm.removeFromParent(c);
        if (idx < 0 || idx >= this.components.size()) {
            this.components.add(c);
        } else {
            this.components.add(idx, c);
        }
        c.setParent(this);
    }

    @Override
    public void removeComponent(RemoteComponent c) {
        this.components.removeElement(c);
        c.setParent(null);
    }

    @Override
    public void removeAllComponents() {
        while (!this.components.isEmpty()) {
            this.removeComponent(this.components.elementAt(0));
        }
    }

    @Override
    public int indexOfComponent(RemoteComponent c) {
        return this.components.indexOf(c);
    }

    public RemoteToolBar getTopToolBar() {
        return this.topToolBar;
    }

    public void setTopToolBar(RemoteToolBar topToolBar) {
        RemoteForm.removeFromParent(topToolBar);
        this.topToolBar = topToolBar;
        if (topToolBar != null) {
            topToolBar.setParent(this);
        }
    }

    public RemoteToolBar getBottomToolBar() {
        return this.bottomToolBar;
    }

    public void setBottomToolBar(RemoteToolBar bottomToolBar) {
        RemoteForm.removeFromParent(bottomToolBar);
        this.bottomToolBar = bottomToolBar;
        if (bottomToolBar != null) {
            bottomToolBar.setParent(this);
        }
    }

    public RemoteStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(RemoteStatusBar statusBar) {
        RemoteForm.removeFromParent(statusBar);
        this.statusBar = statusBar;
        if (statusBar != null) {
            statusBar.setParent(this);
        }
    }

    public RemoteMenu getMenu() {
        return this.menu;
    }

    public void setMenu(RemoteMenu menu) {
        if (this.menu != null) {
            this.menu.setParent(null);
        }
        if (menu != null) {
            menu.setParent(this);
        }
        this.menu = menu;
    }

    @Override
    public int getRemoteWidgetType() {
        return 1;
    }

    public void show() {
        boolean firstTime;
        boolean bl = firstTime = this.mainWindow == null;
        if (firstTime) {
            this.createWindow();
            this.pushEvent(49, 0);
        }
        this.fireShowEvent = true;
        this.intSetVisible();
        if (firstTime) {
            this.mainWindow.getWindow().addComponentListener(new ComponentAdapter(){
                Dimension oldDim;
                {
                    this.oldDim = RemoteForm.this.mainWindow.getWindow().getSize();
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    this.oldDim = RemoteForm.this.mainWindow.getWindow().getSize();
                    if (!this.oldDim.equals(this.oldDim)) {
                        Dimension d = RemoteForm.this.mainWindow.getPanel().getSize();
                        RemoteForm.this.width = d.width;
                        RemoteForm.this.height = d.height;
                        RemoteForm.this.pushEvent(49, 0);
                    }
                }
            });
        }
    }

    private void createWindow() {
        this.mainWindow = new WowForm(this, this.ownerForm != null ? this.ownerForm.getMainWindow() : null);
        WindowAdapter wListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RemoteForm.this.pushEvent(33, 0);
                KeyboardBuffer.setBufferOn();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                RemoteForm.this.setAsFocusedWindow();
                RemoteForm.this.pushEvent(36, 0);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                RemoteForm.this.pushEvent(46, 0);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                RemoteForm.this.setAsActiveWindow();
                RemoteForm.this.pushEvent(32, 0);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                RemoteForm.this.pushEvent(32, 0);
            }
        };
        this.mainWindow.getWindow().addWindowListener(wListener);
        this.mainWindow.getWindow().addWindowFocusListener(wListener);
        this.mainWindow.getPanel().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent evt) {
                RemoteForm.this.pushEvent(38, evt.getKeyCode());
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                RemoteForm.this.pushEvent(39, KeyTable.getKeyState(evt));
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                RemoteForm.this.pushEvent(37, KeyTable.getKeyState(evt));
            }
        });
        RemoteForm.addKeyEventDispatcher(this.mainWindow.getPanel(), this);
        MouseAdapter mlistener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int k = KeyTable.getKeyState(e);
                RemoteForm.this.pushEvent(2, k);
                switch (e.getButton()) {
                    case 1: {
                        RemoteForm.this.pushEvent(40, k);
                        break;
                    }
                    case 2: {
                        RemoteForm.this.pushEvent(42, k);
                        break;
                    }
                    case 3: {
                        RemoteForm.this.pushEvent(44, k);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int k = KeyTable.getKeyState(e);
                RemoteForm.this.pushEvent(4, k);
                switch (e.getButton()) {
                    case 1: {
                        RemoteForm.this.pushEvent(41, k);
                        break;
                    }
                    case 2: {
                        RemoteForm.this.pushEvent(43, k);
                        break;
                    }
                    case 3: {
                        RemoteForm.this.pushEvent(45, k);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                RemoteForm.this.pushEvent(3, 0);
            }
        };
        this.mainWindow.getPanel().addMouseListener(mlistener);
        this.mainWindow.getPanel().addMouseMotionListener(mlistener);
        this.mainWindow.setTraversalKeysEnabled(this.dialogmotion);
        if (this.cursor > 0) {
            this.setCursor(this.cursor);
        }
        this.pushEvent(34, 0);
    }

    @Override
    public void dispose() {
        RemoteForm parentForm = (RemoteForm)this.getParent();
        if (parentForm != null) {
            parentForm.children.removeElement(this);
        }
        RemoteForm.removeKeyEventDispatcher(this.mainWindow.getPanel());
    }

    public void setLocation(int x, int y, int c) {
        if (this.mainWindow != null) {
            this.mainWindow.setLocation(x, y, c);
        }
    }

    public void setSize(float cols, float lines) {
        if (this.mainWindow != null) {
            this.mainWindow.setSize((int)cols, (int)lines);
        }
    }

    public WowForm getMainWindow() {
        return this.mainWindow;
    }

    public void setAsActiveWindow() {
        this.wgf.setAsActiveWindow(this);
    }

    public void setAsFocusedWindow() {
        this.wgf.setAsFocusedWindow(this);
    }

    public Focusable getFocusOwner() {
        return this.focusOwner;
    }

    public void setFocusOwner(Focusable focusOwner) {
        this.focusOwner = focusOwner;
    }

    public Focusable getFocusPrevious() {
        return this.mainWindow != null && this.focusOwner != null ? (Focusable)((Object)this.mainWindow.getPreviousFocusableComponent((RemoteComponent)((Object)this.focusOwner))) : null;
    }

    public Focusable getFocusNext() {
        return this.mainWindow != null && this.focusOwner != null ? (Focusable)((Object)this.mainWindow.getNextFocusableComponent((RemoteComponent)((Object)this.focusOwner))) : null;
    }

    public List<Image> getIconImages() {
        return this.iconImages;
    }

    public int getIconImageId() {
        return this.iconImageId;
    }

    public void setIconImages(List<Image> iconImages) {
        this.iconImages = iconImages;
        if (this.mainWindow != null) {
            this.mainWindow.setIconImages(iconImages);
        }
    }

    public void setIconImageId(int iconImageId) {
        this.iconImageId = iconImageId;
    }

    public void activate() {
        if (this.mainWindow != null) {
            this.mainWindow.setFocus();
        }
    }

    public void requestFocus() {
        if (this.mainWindow != null) {
            this.mainWindow.setFocus();
        }
    }

    @Override
    public Container getGUIContainer() {
        return this.mainWindow.getPanel();
    }

    @Override
    public RemoteForm getParentForm() {
        return this;
    }

    @Override
    public ButtonGroup getButtonGroup(boolean createNew) {
        ButtonGroup Return = this.buttonGroup;
        if (createNew) {
            this.buttonGroup = new ButtonGroup();
        }
        return Return;
    }

    public RemoteForm getOwnerForm() {
        return this.ownerForm;
    }

    static {
        ImageLoader il;
        Cursor c;
        DEFAULT_CURSOR = new Cursor(0);
        CROSS_CURSOR = new Cursor(1);
        IBEAM_CURSOR = new Cursor(2);
        WAIT_CURSOR = new Cursor(3);
        SIZENESW_CURSOR = new Cursor(4);
        SIZENWSE_CURSOR = new Cursor(5);
        SIZENS_CURSOR = new Cursor(8);
        SIZEWE_CURSOR = new Cursor(10);
        APPSTARTING_CURSOR = WAIT_CURSOR;
        CURSOR_NAMES = new String[]{"ARROW", "IBEAM", "WAIT", "CROSS", "UPARROW", "SIZENWSE", "SIZENESW", "SIZEWE", "SIZENS", "SIZEALL", "NO", "APPSTARTING", "HELP"};
        try {
            c = Cursor.getSystemCustomCursor("Invalid.32x32");
        }
        catch (Exception e) {
            c = DEFAULT_CURSOR;
        }
        NO_CURSOR = c;
        try {
            il = (ImageLoader)Class.forName("com.iscobol.misc.image.Image4JLoader").newInstance();
        }
        catch (Throwable t) {
            il = null;
        }
        externalLoader = il;
    }
}

