/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.RemoteListComponent;
import com.veryant.wow.gui.client.WowListBox;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RemoteListBox
extends RemoteListComponent {
    private int columnwidth;
    private boolean extendedsel;
    private boolean multiplesel;
    private boolean standard = true;
    private String tabstops;
    private boolean usetabstops;
    private boolean wantkeyboard;
    private boolean noredraw;
    private ListSelectionListener selListener;
    private int[] lastSelection = new int[0];
    private boolean keyPressed;
    private boolean mouseDragged;

    @Override
    public void addListeners() {
        super.addListeners();
        this.selListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RemoteListBox.this.keyPressed) {
                    RemoteListBox.this.fireSelchangeEvent(false);
                }
            }
        };
        this.getListBox().getList().addListSelectionListener(this.selListener);
    }

    private void fireSelchangeEvent(boolean mouseClick) {
        int[] currSel = this.getListBox().getSelectionIndices();
        boolean selChange = false;
        if (currSel.length != this.lastSelection.length) {
            selChange = true;
        } else {
            for (int i = 0; i < this.lastSelection.length; ++i) {
                if (currSel[i] == this.lastSelection[i]) continue;
                selChange = true;
                break;
            }
        }
        if (selChange) {
            this.pushEvent(1, 3);
            this.lastSelection = currSel;
        } else if (mouseClick) {
            this.pushEvent(1, 3);
        }
    }

    public int getColumnwidth() {
        return this.columnwidth;
    }

    public boolean isExtendedsel() {
        return this.extendedsel;
    }

    public boolean isMultiplesel() {
        return this.multiplesel;
    }

    public boolean isSinglesel() {
        return !this.multiplesel && !this.extendedsel;
    }

    public boolean isStandard() {
        return this.standard;
    }

    public String getTabstops() {
        return this.tabstops;
    }

    public boolean isUsetabstops() {
        return this.usetabstops;
    }

    public boolean isWantkeyboard() {
        return this.wantkeyboard;
    }

    public void setColumnwidth(int columnwidth) {
        this.columnwidth = columnwidth;
    }

    public void setExtendedsel(boolean extendedsel) {
        this.extendedsel = extendedsel;
        this.getListBox().setExtendedsel(extendedsel);
    }

    public void setMultiplesel(boolean multiplesel) {
        this.multiplesel = multiplesel;
        this.getListBox().setMultiplesel(multiplesel);
    }

    public void setStandard(boolean standard) {
        this.standard = standard;
    }

    public void setTabstops(String tabstops) {
        this.tabstops = tabstops;
    }

    public void setUsetabstops(boolean usetabstops) {
        this.usetabstops = usetabstops;
    }

    public void setWantkeyboard(boolean wantkeyboard) {
        this.wantkeyboard = wantkeyboard;
    }

    @Override
    protected JComponent createGUIComponent() {
        return new WowListBox();
    }

    @Override
    public int getRemoteWidgetType() {
        return 8;
    }

    @Override
    protected void intAddItem(int idx, String item) {
        this.getListBox().getList().removeListSelectionListener(this.selListener);
        this.getListBox().intAddItem(idx, item);
        this.getListBox().getList().addListSelectionListener(this.selListener);
    }

    @Override
    protected void intRemoveItem(int idx) {
        this.getListBox().getList().removeListSelectionListener(this.selListener);
        this.getListBox().intRemoveItem(idx);
        this.getListBox().getList().addListSelectionListener(this.selListener);
    }

    @Override
    protected void intRemoveAllItems() {
        this.getListBox().getList().removeListSelectionListener(this.selListener);
        this.getListBox().intRemoveAllItems();
        this.getListBox().getList().addListSelectionListener(this.selListener);
    }

    public void setHorizontalextent(int ext) {
    }

    public int getHorizontalextent() {
        return 0;
    }

    public int getTopindex() {
        return this.getListBox().getTopindex();
    }

    public void setTopindex(int idx) {
        this.getListBox().setTopindex(idx);
    }

    public int getItemheight() {
        return this.getListBox().getItemheight();
    }

    public void setItemheight(int height) {
        this.getListBox().setItemheight(height);
    }

    public Rectangle getItemBounds(int idx) {
        return this.getListBox().getItemBounds(idx);
    }

    public boolean isItemSelected(int idx) {
        return this.getListBox().isItemSelected(idx);
    }

    public int getSelectionCount() {
        return this.getListBox().getSelectionCount();
    }

    public int[] getSelectionIndices() {
        return this.getListBox().getSelectionIndices();
    }

    public void setItemsSelected(int startIdx, int endIdx, boolean selected) {
        this.getListBox().getList().removeListSelectionListener(this.selListener);
        this.getListBox().setItemSelected(startIdx, endIdx, selected);
        this.getListBox().getList().addListSelectionListener(this.selListener);
    }

    public void setItemSelected(int idx, boolean selected) {
        this.getListBox().getList().removeListSelectionListener(this.selListener);
        this.getListBox().setItemSelected(idx, selected);
        this.getListBox().getList().addListSelectionListener(this.selListener);
    }

    private WowListBox getListBox() {
        return (WowListBox)this.getGUIComponent();
    }

    @Override
    public int getCursel() {
        return this.getListBox().getCursel();
    }

    @Override
    public void setCursel(int cursel) {
        this.setCursel(cursel, true);
    }

    public void setCursel(int cursel, boolean ensureVisible) {
        super.setCursel(cursel);
        WowListBox lb = this.getListBox();
        lb.getList().removeListSelectionListener(this.selListener);
        lb.setCursel(cursel);
        if (ensureVisible) {
            lb.ensureVisible(cursel);
            lb.getList().repaint();
        }
        lb.getList().addListSelectionListener(this.selListener);
    }

    public void setCaretIndex(int idx) {
        WowListBox lb = this.getListBox();
        lb.ensureVisible(idx);
    }

    @Override
    public String getSeltext() {
        return this.getListBox().getSeltext();
    }

    @Override
    public void setSeltext(String text) {
        this.getListBox().getList().removeListSelectionListener(this.selListener);
        this.getListBox().setSeltext(text);
        this.getListBox().getList().addListSelectionListener(this.selListener);
        super.setSeltext(this.getSeltext());
    }

    @Override
    public boolean isNoredraw() {
        return this.noredraw;
    }

    @Override
    public void setNoredraw(boolean noredraw) {
        this.noredraw = noredraw;
    }

    @Override
    protected void handleKeyPressed(KeyEvent e) {
        this.keyPressed = true;
        super.handleKeyPressed(e);
    }

    @Override
    protected void handleKeyReleased(KeyEvent e) {
        this.keyPressed = false;
        super.handleKeyReleased(e);
    }

    @Override
    protected void handleMouseClicked(MouseEvent e) {
        this.fireSelchangeEvent(true);
        if (e.getClickCount() >= 2) {
            this.pushEvent(8, 0);
        }
    }

    @Override
    protected void handleMouseDragged(MouseEvent e) {
        this.mouseDragged = true;
    }

    @Override
    protected void handleMouseReleased(MouseEvent e) {
        if (this.mouseDragged) {
            this.fireSelchangeEvent(true);
            this.mouseDragged = false;
        }
    }

    @Override
    public String getLayoutDataKey() {
        return "listbox";
    }

    @Override
    protected boolean isSorted() {
        return this.isSort() || this.isStandard();
    }
}

