/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.RemoteFontComponent;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.ZoomLayout;
import com.veryant.wow.WowSystem;
import com.veryant.wow.gui.KeyTable;
import com.veryant.wow.gui.client.RemoteComponent;
import com.veryant.wow.gui.client.WowForm;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.IOException;

public abstract class RemoteStandardComponent
extends RemoteComponent {
    private boolean enabled = true;
    private boolean group;
    private String tag;
    private boolean tooltipenabled;
    private String tooltiptext;
    private String fontname;
    private int fontsize;
    private boolean fontbold;
    private boolean fontitalic;
    private boolean fontstrikethru;
    private boolean fontunderline;
    private boolean transparent;
    private boolean rightalignedtext;
    private boolean righttoleftreading;
    private boolean noredraw;
    private RemoteFontComponent font;
    protected MouseAdapter ml;

    public boolean isNoredraw() {
        return this.noredraw;
    }

    public void setNoredraw(boolean noredraw) {
        this.noredraw = noredraw;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isRightalignedtext() {
        return this.rightalignedtext;
    }

    public boolean isRighttoleftreading() {
        return this.righttoleftreading;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setRightalignedtext(boolean rightalignedtext) {
        this.rightalignedtext = rightalignedtext;
    }

    public void setRighttoleftreading(boolean righttoleftreading) {
        this.righttoleftreading = righttoleftreading;
    }

    public String getFontname() {
        return this.fontname;
    }

    public int getFontsize() {
        return this.fontsize;
    }

    public boolean isFontbold() {
        return this.fontbold;
    }

    public boolean isFontitalic() {
        return this.fontitalic;
    }

    public boolean isFontstrikethru() {
        return this.fontstrikethru;
    }

    public boolean isFontunderline() {
        return this.fontunderline;
    }

    public void setFontname(String fontname) {
        this.fontname = fontname;
        this.updateFont();
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
        this.updateFont();
    }

    public void setFontbold(boolean fontbold) {
        this.fontbold = fontbold;
        this.updateFont();
    }

    public void setFontitalic(boolean fontitalic) {
        this.fontitalic = fontitalic;
        this.updateFont();
    }

    public void setFontstrikethru(boolean fontstrikethru) {
        this.fontstrikethru = fontstrikethru;
        this.updateFont();
    }

    public void setFontunderline(boolean fontunderline) {
        this.fontunderline = fontunderline;
        this.updateFont();
    }

    public boolean isTooltipenabled() {
        return this.tooltipenabled;
    }

    public String getTooltiptext() {
        return this.tooltiptext;
    }

    public void setTooltipenabled(boolean tooltipenabled) {
        this.tooltipenabled = tooltipenabled;
        this.getGUIComponent().setToolTipText(tooltipenabled ? this.tooltiptext : null);
    }

    public void setTooltiptext(String tooltiptext) {
        this.tooltiptext = tooltiptext;
        if (this.isTooltipenabled()) {
            this.getGUIComponent().setToolTipText(tooltiptext);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            if (this.upDown != null) {
                this.enabled = enabled;
            } else {
                Boolean oldVal = this.enabled;
                Boolean newVal = enabled;
                this.enabled = enabled;
                this.firePropertyChange("enabled", oldVal, newVal);
            }
            this.getGUIComponent().setEnabled(enabled);
        }
    }

    public boolean isGroup() {
        return this.group;
    }

    public String getTag() {
        return this.tag;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.addMouseListener();
    }

    public void addMouseListener() {
        this.ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RemoteStandardComponent.this.handleMousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                RemoteStandardComponent.this.handleMouseClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RemoteStandardComponent.this.handleMouseReleased(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                RemoteStandardComponent.this.handleMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                RemoteStandardComponent.this.handleMouseDragged(e);
            }
        };
        this.getGUIComponent().addMouseListener(this.ml);
        this.getGUIComponent().addMouseMotionListener(this.ml);
    }

    protected void handleMousePressed(MouseEvent e) {
        this.pushEvent(2, KeyTable.getKeyState(e));
    }

    protected void handleMouseClicked(MouseEvent e) {
        int evt = e.getClickCount() < 2 ? 1 : 8;
        this.pushEvent(evt, 0);
    }

    protected void handleMouseReleased(MouseEvent e) {
        this.pushEvent(4, KeyTable.getKeyState(e));
    }

    protected void handleMouseMoved(MouseEvent e) {
        this.pushEvent(3, 0);
    }

    protected void handleMouseDragged(MouseEvent e) {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeMouseListener();
    }

    public void removeMouseListener() {
        if (this.ml != null && this.getGUIComponent() != null) {
            this.getGUIComponent().removeMouseListener(this.ml);
            this.getGUIComponent().removeMouseMotionListener(this.ml);
        }
    }

    public RemoteFontComponent getFont() {
        return this.font;
    }

    public void setFont(RemoteFontComponent font) {
        if (font != null) {
            this.font = font;
            try {
                this.fontname = this.font.getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.fontsize = this.font.getSize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.fontbold = this.font.isBold() || this.checkFontAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.fontitalic = this.font.isItalic() || this.checkFontAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.fontstrikethru = this.checkFontAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.fontunderline = this.checkFontAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.updateFont();
        }
    }

    protected void updateFont() {
        this.getGUIComponent().setFont(WowSystem.getFont(this.fontname, this.fontsize, this.fontbold, this.fontitalic, this.fontunderline, this.fontstrikethru));
        this.doZoomLayout();
    }

    protected void doZoomLayout() {
        ZoomLayout.ZoomLayoutData ld;
        Container par = this.guiComponent.getParent();
        ZoomLayout zl = null;
        if (par != null) {
            IscobolLayout isl;
            if (par.getLayout() instanceof ZoomLayout) {
                zl = (ZoomLayout)par.getLayout();
            } else if (par.getLayout() instanceof WowForm.IscobolLayoutProvider && (isl = ((WowForm.IscobolLayoutProvider)((Object)par.getLayout())).getIscobolLayout()) instanceof ZoomLayout) {
                zl = (ZoomLayout)isl;
            }
        }
        if (zl != null && (ld = (ZoomLayout.ZoomLayoutData)zl.getLayoutData((Component)this.guiComponent)) != null) {
            ld.setOrigFont(this.guiComponent.getFont());
            par.doLayout();
        }
    }

    private boolean checkFontAttribute(TextAttribute attrName, Object attrValue) throws IOException {
        return this.font.getAttributes() != null && this.font.getAttributes().get(attrName) == attrValue;
    }
}

