/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.WowSystem;
import com.veryant.wow.gui.client.Bordered;
import com.veryant.wow.gui.client.RemoteComponent;
import com.veryant.wow.gui.client.RemoteContainer;
import com.veryant.wow.gui.client.RemoteFocusableComponent;
import com.veryant.wow.gui.client.RemoteForm;
import com.veryant.wow.gui.client.WowTabControl;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

public class RemoteTabControl
extends RemoteFocusableComponent
implements Bordered,
WowTabControl.WowTabControlListener {
    private Vector<TabPage> pages = new Vector();
    private String accelerator;
    private Map<Integer, String> acceleratorMap = new HashMap<Integer, String>();
    private boolean buttons;
    private boolean border;
    private boolean clientedge;
    private boolean modalframe;
    private boolean staticedge;
    private int curtab;
    private boolean fixedwidth;
    private boolean forcelabelleft;
    private int getfocus;
    private boolean multiline;
    private boolean raggedright;
    private boolean right;
    private boolean tabenabled;
    private int tabs;
    private String tabtext;
    private boolean vertical;
    private boolean initialized;

    void setInitialized() {
        this.initialized = true;
        this.curtab = 0;
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public boolean isButtons() {
        return this.buttons;
    }

    @Override
    public boolean isBorder() {
        return this.border;
    }

    @Override
    public boolean isClientedge() {
        return this.clientedge;
    }

    @Override
    public boolean isModalframe() {
        return this.modalframe;
    }

    @Override
    public boolean isStaticedge() {
        return this.staticedge;
    }

    public int getCurtab() {
        return this.curtab;
    }

    public boolean isFixedwidth() {
        return this.fixedwidth;
    }

    public boolean isForcelabelleft() {
        return this.forcelabelleft;
    }

    public int getGetfocus() {
        return this.getfocus;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isRaggedright() {
        return this.raggedright;
    }

    public boolean isRight() {
        return this.right;
    }

    public boolean isTabenabled() {
        return this.tabenabled;
    }

    public int getTabs() {
        return this.tabs;
    }

    public String getTabtext() {
        return this.tabtext;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setAccelerator(String accelerator) {
        this.accelerator = accelerator;
        if (this.check()) {
            final int idx = this.curtab;
            WowSystem.addAccelerator(this.getGUIComponent(), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoteTabControl.this.getTabControl().requestFocus();
                    RemoteTabControl.this.getTabControl().setSelectedIndex(idx);
                }
            }, "wowTabAction" + idx, (char)this.getTabControl().getMnemonicAt(this.curtab), accelerator);
        }
    }

    public void setButtons(boolean buttons) {
        this.buttons = buttons;
    }

    public void setBorder(boolean border) {
        this.border = border;
        this.updateBorder();
    }

    public void setClientedge(boolean clientedge) {
        this.clientedge = clientedge;
        this.updateBorder();
    }

    public void setModalframe(boolean modalframe) {
        this.modalframe = modalframe;
        this.updateBorder();
    }

    public void setStaticedge(boolean staticedge) {
        this.staticedge = staticedge;
        this.updateBorder();
    }

    public void setCurtab(int curtab) {
        if (this.curtab != curtab) {
            if (this.initialized && this.check()) {
                this.intSetCurtab(curtab);
                WowTabControl tc = this.getTabControl();
                tc.setListener(null);
                tc.setSelectedIndex(this.curtab);
                tc.setListener(this);
            } else {
                this.curtab = curtab;
            }
        }
    }

    private void intSetCurtab(int curtab) {
        Integer oldVal = this.curtab;
        this.curtab = curtab;
        Integer newVal = this.curtab;
        this.firePropertyChange("curtab", oldVal, newVal);
    }

    public void setFixedwidth(boolean fixedwidth) {
        this.fixedwidth = fixedwidth;
    }

    public void setForcelabelleft(boolean forcelabelleft) {
        this.forcelabelleft = forcelabelleft;
    }

    public void setGetfocus(int getfocus) {
        this.getfocus = getfocus;
    }

    public void setMultiline(boolean multiline) {
        boolean oldVal = this.multiline;
        this.multiline = multiline;
        this.getTabControl().setTabLayoutPolicy(multiline ? 0 : 1);
        this.firePropertyChange("multiline", oldVal, multiline);
    }

    public void setRaggedright(boolean raggedright) {
        this.raggedright = raggedright;
    }

    public void setRight(boolean right) {
        boolean oldVal = this.right;
        this.right = right;
        this.setTabPlacement();
        this.firePropertyChange("right", oldVal, right);
    }

    private void setTabPlacement() {
        int tp = this.vertical ? (this.right ? 4 : 2) : (this.right ? 3 : 1);
        this.getTabControl().setTabPlacement(tp);
    }

    public void setTabenabled(boolean tabenabled) {
        this.tabenabled = tabenabled;
        if (this.check()) {
            this.getTabControl().setEnabledAt(this.curtab, tabenabled);
        }
    }

    private boolean check() {
        if (this.curtab >= 0 && this.curtab < this.tabs) {
            this.getTabControl().setTabCount(this.tabs);
            return true;
        }
        return false;
    }

    public void setTabs(int tabs) {
        int oldVal = this.tabs;
        this.tabs = tabs;
        int d = tabs - this.pages.size();
        if (d > 0) {
            for (int i = 0; i < d; ++i) {
                this.pages.addElement(new TabPage(this));
            }
        }
        this.getTabControl().setTabCount(tabs);
        this.firePropertyChange("tabs", oldVal, tabs);
    }

    public void setTabtext(String tabtext) {
        this.tabtext = tabtext;
        if (this.check()) {
            this.setTabtext(tabtext, this.curtab);
        }
    }

    private void setTabtext(String tabtext, int index) {
        WowTabControl tab = this.getTabControl();
        String old = tab.getTitleAt(index);
        String[] ss = WowSystem.getCaption(tabtext);
        tab.setTitleAt(index, ss[0]);
        if (ss[1] != null) {
            tab.setMnemonicAt(index, ss[1].charAt(0));
            if (this.acceleratorMap.get(index) == null) {
                String accelerator = "Alt+" + ss[1];
                this.setAccelerator(accelerator);
                this.acceleratorMap.put(index, accelerator);
            }
        } else {
            tab.setMnemonicAt(index, 0);
        }
        this.firePropertyChange("tabtext", old, tabtext);
    }

    public void setVertical(boolean vertical) {
        boolean oldVal = this.vertical;
        this.vertical = vertical;
        this.setTabPlacement();
        this.firePropertyChange("vertical", oldVal, vertical);
    }

    protected TabPage getPageAt(int idx) {
        return this.pages.elementAt(idx);
    }

    protected TabPage getCurrPage() {
        int d = this.curtab - this.pages.size();
        if (d >= 0) {
            for (int i = 0; i <= d; ++i) {
                this.pages.addElement(new TabPage(this));
            }
        }
        return this.pages.elementAt(this.curtab);
    }

    public int getSelectedTab() {
        return this.getTabControl().getSelectedIndex();
    }

    @Override
    protected JComponent createGUIComponent() {
        return new WowTabControl();
    }

    protected WowTabControl getTabControl() {
        return (WowTabControl)this.getGUIComponent();
    }

    @Override
    public int getRemoteWidgetType() {
        return 12;
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getTabControl().setListener(this);
    }

    @Override
    public void tabWillChange(WowTabControl.WowTabControlEvent evt) {
        this.curtab = evt.tabIndex;
        this.pushEvent(25, this.curtab);
    }

    @Override
    public void tabChanged(WowTabControl.WowTabControlEvent evt) {
        this.requestFocus();
        this.intSetCurtab(this.getTabControl().getSelectedIndex());
        this.pushEvent(24, evt.tabIndex);
    }

    @Override
    public void setIndexProp(String propName, int index, String propValue) {
        if ("tabtext".equals(propName = WowSystem.getJavaPropertyName(propName)) && index >= 0 && index < this.tabs) {
            this.setTabtext(propValue, index);
        }
    }

    @Override
    public String getIndexProp(String propName, int index) {
        if ("tabtext".equals(propName = WowSystem.getJavaPropertyName(propName)) && index >= 0 && index < this.tabs) {
            return this.getTabControl().getTitleAt(index);
        }
        return null;
    }

    @Override
    public String getLayoutDataKey() {
        return "tabcontrol";
    }

    static class TabPage
    implements RemoteContainer {
        private Vector<RemoteComponent> components = new Vector();
        private final RemoteTabControl parent;
        private ButtonGroup buttonGroup = new ButtonGroup();

        public TabPage(RemoteTabControl p) {
            this.parent = p;
        }

        @Override
        public ButtonGroup getButtonGroup(boolean createNew) {
            ButtonGroup Return = this.buttonGroup;
            if (createNew) {
                this.buttonGroup = new ButtonGroup();
            }
            return Return;
        }

        @Override
        public RemoteComponent getComponentAt(int i) {
            return this.components.elementAt(i);
        }

        @Override
        public int getComponentCount() {
            return this.components.size();
        }

        @Override
        public void addComponent(RemoteComponent c) {
            RemoteForm.removeFromParent(c);
            this.components.addElement(c);
            c.setParent(this.parent);
            c.setParentContainer(this);
        }

        @Override
        public void addComponent(int idx, RemoteComponent c) {
            RemoteForm.removeFromParent(c);
            if (idx < 0 || idx >= this.components.size()) {
                this.components.add(c);
            } else {
                this.components.add(idx, c);
            }
            c.setParent(this.parent);
            c.setParentContainer(this);
        }

        @Override
        public void removeComponent(RemoteComponent c) {
            this.components.removeElement(c);
            c.setParent(null);
        }

        @Override
        public void removeAllComponents() {
            while (!this.components.isEmpty()) {
                this.removeComponent(this.components.elementAt(0));
            }
        }

        @Override
        public int indexOfComponent(RemoteComponent c) {
            return this.components.indexOf(c);
        }

        @Override
        public Container getGUIContainer() {
            int idx = this.parent.pages.indexOf(this);
            return (Container)this.parent.getTabControl().getComponentAt(idx);
        }
    }
}

