/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.WowSystem;
import com.veryant.wow.gui.Event;
import com.veryant.wow.gui.KeyTable;
import com.veryant.wow.gui.client.RemoteForm;
import com.veryant.wow.gui.client.WowGuiFactoryImpl;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class RemoteWidget {
    private static Map<Component, RemoteWidget> keyEventDispatchers = Collections.synchronizedMap(new HashMap());
    private int remoteWidgetId = -1;
    private Set<Integer> eventList;
    private RemoteWidget parent;
    private PropertyChangeSupport changeListeners = new PropertyChangeSupport(this);
    protected int tabindex;
    protected int z_order;

    public static void addKeyEventDispatcher(Component c, RemoteWidget ed) {
        keyEventDispatchers.put(c, ed);
    }

    public static void removeKeyEventDispatcher(Component c) {
        keyEventDispatchers.remove(c);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeListeners.removePropertyChangeListener(l);
    }

    public void setEventlist(String list) {
        this.eventList = new LinkedHashSet<Integer>();
        if ((list = list.trim()).length() > 0) {
            for (String s : list.split("\\,")) {
                this.eventList.add(Integer.valueOf(s));
            }
        }
    }

    public String getEventlist() {
        if (this.eventList != null) {
            StringBuilder sb = new StringBuilder();
            for (Integer i : this.eventList) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(i);
            }
            return sb.toString();
        }
        return null;
    }

    public int getRemoteWidgetId() {
        return this.remoteWidgetId;
    }

    public void setRemoteWidgetId(int remoteWidgetId) {
        this.remoteWidgetId = remoteWidgetId;
    }

    public final boolean isRequiredHandling(int eventId) {
        return this.eventList == null || this.eventList.contains(eventId);
    }

    public abstract int getRemoteWidgetType();

    public abstract void dispose();

    public final void pushEvent(int eventId, int eventData) {
        this.pushEvent(eventId, eventData, null);
    }

    public final void pushEvent(int eventId, int eventData, String[] eventParameters) {
        RemoteForm parentForm = this.getParentForm();
        if (parentForm != null) {
            if (this.isRequiredHandling(eventId)) {
                WowGuiFactoryImpl.pushEvent(new Event(parentForm.getRemoteWidgetId(), eventId, this.getRemoteWidgetId(), eventData, eventParameters));
            } else if (Event.isKeyStateEvent(eventId)) {
                Event e = new Event(parentForm.getRemoteWidgetId(), eventId, this.getRemoteWidgetId(), eventData, eventParameters);
                e.setDiscarded(true);
                WowGuiFactoryImpl.pushEvent(e);
            }
        }
    }

    public RemoteWidget getParent() {
        return this.parent;
    }

    public void setParent(RemoteWidget parent) {
        this.parent = parent;
    }

    public RemoteForm getParentForm() {
        RemoteWidget p;
        for (p = this.getParent(); p != null && !(p instanceof RemoteForm); p = p.getParent()) {
        }
        return (RemoteForm)p;
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.changeListeners.firePropertyChange(propName, oldValue, newValue);
    }

    public String getIndexProp(String propName, int index) {
        return null;
    }

    public String getProp(String propName) {
        PropertyDescriptor pd = WowSystem.getPropertyDescriptor(this.getClass(), propName);
        if (pd != null && pd.getReadMethod() != null) {
            try {
                Object value = pd.getReadMethod().invoke((Object)this, new Object[0]);
                return WowSystem.convertGetValue(value, pd.getPropertyType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setIndexProp(String propName, int index, String propValue) {
    }

    public void setProp(String propName, String propValue) {
        PropertyDescriptor pd = WowSystem.getPropertyDescriptor(this.getClass(), propName);
        if (pd != null && pd.getWriteMethod() != null) {
            Object value = propValue != null ? WowSystem.convertValue(propValue, pd.getPropertyType()) : null;
            try {
                pd.getWriteMethod().invoke((Object)this, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getTabindex() {
        return this.tabindex;
    }

    public int getZ_order() {
        return this.z_order;
    }

    public void setTabindex(int tabindex) {
        this.tabindex = tabindex;
    }

    public void setZ_order(int z_order) {
        this.z_order = z_order;
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() != 9) {
                    return false;
                }
                RemoteWidget dispatcher = null;
                for (Component c = e.getComponent(); dispatcher == null && c != null; c = c.getParent()) {
                    dispatcher = (RemoteWidget)keyEventDispatchers.get(c);
                }
                if (dispatcher != null) {
                    switch (e.getID()) {
                        case 401: {
                            dispatcher.pushEvent(37, KeyTable.getKeyState(e));
                            break;
                        }
                        case 402: {
                            dispatcher.pushEvent(39, KeyTable.getKeyState(e));
                            break;
                        }
                        case 400: {
                            dispatcher.pushEvent(38, KeyTable.getKeyState(e));
                        }
                    }
                }
                return false;
            }
        });
    }
}

