/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.IsguiUtility;
import com.veryant.wow.WowSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.EventListener;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class WowActiveX
extends JComponent {
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private WowActiveXListener listener;

    public WowActiveXListener getListener() {
        return this.listener;
    }

    public void setListener(WowActiveXListener listener) {
        this.listener = listener;
    }

    protected void fireEvent(WowActiveXEvent event) {
        if (this.listener != null) {
            this.listener.activeXEvent(event);
        }
    }

    private static boolean checkIndexes(Class[] pts, int len) {
        for (int i = 0; i < len; ++i) {
            if (pts[i] == Integer.TYPE || pts[i] == Short.TYPE) continue;
            return false;
        }
        return true;
    }

    private Method findSetIndexMethod(String propName, int indexCount, Class paramType) {
        String methodName = "set_" + propName;
        for (Method m : this.getClass().getMethods()) {
            Class[] pt;
            if (!m.getName().equalsIgnoreCase(methodName) || m.getReturnType() != Void.TYPE || (pt = m.getParameterTypes()).length != indexCount + 1 || paramType != null && paramType != pt[indexCount] || !WowActiveX.checkIndexes(pt, pt.length - 1)) continue;
            return m;
        }
        return null;
    }

    private static void getIndexes(Object[] params, Class[] pt, int[] idxs) {
        for (int i = 0; i < idxs.length; ++i) {
            params[i] = pt[i] == Integer.TYPE ? (Number)idxs[i] : (Number)((short)idxs[i]);
        }
    }

    public void setIndexProp(String propName, String value, int[] idxs) {
        Method setInMethod = this.findSetIndexMethod(propName, idxs.length, null);
        if (setInMethod != null) {
            Class[] pt = setInMethod.getParameterTypes();
            Object[] params = new Object[pt.length];
            WowActiveX.getIndexes(params, pt, idxs);
            params[idxs.length] = this.convertValue(value, pt[idxs.length]);
            try {
                setInMethod.invoke((Object)this, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public <T> void setIndexProp(String propName, T value, int[] idxs, Class<T> type) {
        Method setInMethod = this.findSetIndexMethod(propName, idxs.length, type);
        if (setInMethod != null) {
            Class[] pt = setInMethod.getParameterTypes();
            Object[] params = new Object[pt.length];
            WowActiveX.getIndexes(params, pt, idxs);
            params[idxs.length] = value;
            try {
                setInMethod.invoke((Object)this, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Method findGetIndexMethod(String propName, int indexCount, Class retType) {
        String methodName = "get_" + propName;
        for (Method m : this.getClass().getMethods()) {
            Class[] pt;
            if (!m.getName().equalsIgnoreCase(methodName) || (pt = m.getParameterTypes()).length != indexCount || !WowActiveX.checkIndexes(pt, pt.length) || !(retType != null ? retType == m.getReturnType() : m.getReturnType() != Void.TYPE)) continue;
            return m;
        }
        return null;
    }

    public String getIndexProp(String propName, int[] idxs) {
        Method getInMethod = this.findGetIndexMethod(propName, idxs.length, null);
        if (getInMethod != null) {
            Class[] pt = getInMethod.getParameterTypes();
            Object[] params = new Object[pt.length];
            WowActiveX.getIndexes(params, pt, idxs);
            try {
                Object ret = getInMethod.invoke((Object)this, params);
                return WowSystem.convertGetValue(ret, getInMethod.getReturnType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public <T> T getIndexProp(String propName, int[] idxs, Class<T> type) throws PropertyNotFoundException {
        Method getInMethod = this.findGetIndexMethod(propName, idxs.length, type);
        if (getInMethod != null) {
            Class[] pt = getInMethod.getParameterTypes();
            Object[] params = new Object[pt.length];
            WowActiveX.getIndexes(params, pt, idxs);
            try {
                return (T)getInMethod.invoke((Object)this, params);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new PropertyNotFoundException(propName);
    }

    public String getProp(String propName) throws PropertyNotFoundException {
        Method getMethod = this.findGetMethod(propName, null);
        if (getMethod != null) {
            try {
                Object ret = getMethod.invoke((Object)this, new Object[0]);
                return ret != null ? ret.toString() : "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        throw new PropertyNotFoundException(propName);
    }

    public <T> T getProp(String propName, Class<T> type) throws PropertyNotFoundException {
        Method getMethod = this.findGetMethod(propName, type);
        if (getMethod != null) {
            try {
                return (T)getMethod.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new PropertyNotFoundException(propName);
    }

    public void setProp(String propName, String propValue) throws PropertyNotFoundException {
        Method setMethod = this.findSetMethod(propName, null);
        if (setMethod != null) {
            try {
                setMethod.invoke((Object)this, this.convertValue(propValue, setMethod.getParameterTypes()[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public <T> void setProp(String propName, T propValue, Class<T> type) throws PropertyNotFoundException {
        Method setMethod = this.findSetMethod(propName, type);
        if (setMethod != null) {
            try {
                setMethod.invoke((Object)this, propValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String executeMethod(String methodName, String[] args) throws MethodNotFoundException {
        for (Method m : this.getClass().getMethods()) {
            Class<?>[] pt;
            if (!m.getName().equalsIgnoreCase(methodName) || (pt = m.getParameterTypes()).length != args.length) continue;
            Object[] params = new Object[args.length];
            try {
                for (int i = 0; i < params.length; ++i) {
                    params[i] = this.convertValue(args[i], pt[i]);
                }
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            try {
                Object ret = m.invoke((Object)this, params);
                return ret != null ? ret.toString() : "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        throw new MethodNotFoundException(methodName, args);
    }

    private Method findSetMethod(String propName, Class paramType) {
        String methodName = "set" + propName;
        for (Method m : this.getClass().getMethods()) {
            Class<?>[] pt;
            if (!m.getName().equalsIgnoreCase(methodName) || (pt = m.getParameterTypes()).length != 1 || paramType != null && paramType != pt[0]) continue;
            return m;
        }
        return null;
    }

    private Method findGetMethod(String propName, Class retType) {
        Method getMethod = null;
        String methodName = "get" + propName;
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().equalsIgnoreCase(methodName) || m.getParameterTypes().length != 0) continue;
            if (retType != null) {
                if (retType != m.getReturnType()) continue;
                getMethod = m;
                break;
            }
            if (m.getReturnType() == Void.TYPE) continue;
            getMethod = m;
            break;
        }
        if (getMethod == null) {
            for (Method m : this.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase(propName) || m.getParameterTypes().length != 0 || m.getReturnType() == Void.TYPE) continue;
                getMethod = m;
                break;
            }
        }
        return getMethod;
    }

    private Object convertValue(String stringValue, Class type) {
        if (type == String.class) {
            return stringValue;
        }
        if (type == Character.TYPE) {
            if (stringValue.length() > 0) {
                return Character.valueOf(stringValue.charAt(0));
            }
            throw new IllegalArgumentException(stringValue);
        }
        if (type == Boolean.TYPE) {
            if ("1".equals(stringValue)) {
                return Boolean.TRUE;
            }
            return new Boolean(stringValue);
        }
        if (type == Byte.TYPE) {
            return (byte)Math.round(Double.parseDouble(stringValue));
        }
        if (type == Short.TYPE) {
            return (short)Math.round(Double.parseDouble(stringValue));
        }
        if (type == Integer.TYPE) {
            return (int)Math.round(Double.parseDouble(stringValue));
        }
        if (type == Long.TYPE) {
            return Math.round(Double.parseDouble(stringValue));
        }
        if (type == Float.TYPE) {
            return Float.valueOf((float)Double.parseDouble(stringValue));
        }
        if (type == Double.TYPE) {
            return Double.valueOf(stringValue);
        }
        if (type == Color.class) {
            return WowSystem.parseColor(stringValue);
        }
        if (type == Image.class) {
            Image im = WowSystem.getImage(stringValue);
            if (im == null) {
                im = WowActiveX.getImage(stringValue);
            }
            return im;
        }
        if (type == Font.class) {
            Font f = this.getFont();
            if (stringValue != null) {
                StringTokenizer stn = new StringTokenizer(stringValue, "/");
                try {
                    String name = stn.nextToken();
                    int style = Integer.parseInt(stn.nextToken());
                    boolean bold = (style & 1) == 1;
                    boolean italic = (style & 2) == 2;
                    boolean strikethrough = (style & 4) == 4;
                    boolean underline = (style & 8) == 8;
                    float size = Float.parseFloat(stn.nextToken());
                    f = WowSystem.getFont(name, size, bold, italic, underline, strikethrough);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return f;
        }
        if (type == LocalDateTime.class) {
            TemporalAccessor ta = dtf.parse(stringValue);
            return LocalDateTime.of(ta.get(ChronoField.YEAR), ta.get(ChronoField.MONTH_OF_YEAR), ta.get(ChronoField.DAY_OF_MONTH), 0, 0);
        }
        throw new IllegalArgumentException(stringValue);
    }

    private static Image getImage(String b64) {
        try {
            Base64.Decoder dec = Base64.getDecoder();
            byte[] b = dec.decode(b64);
            return IsguiUtility.createImage((byte[])b, (int[])new int[]{0}, (boolean)true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void dispose() {
    }

    public static class MethodNotFoundException
    extends Exception {
        private static String msg(String methodName, String[] args) {
            String m = methodName;
            m = m + "(";
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    m = m + ",";
                }
                m = m + args[i];
            }
            m = m + ")";
            return m;
        }

        public MethodNotFoundException(String methodName, String[] args) {
            super(MethodNotFoundException.msg(methodName, args));
        }
    }

    public static class PropertyNotFoundException
    extends Exception {
        public PropertyNotFoundException(String propName) {
            super(propName);
        }
    }

    public static class WowActiveXEvent
    extends EventObject {
        int eventId;
        String[] parameters;

        public WowActiveXEvent(Object source, int eventId) {
            this(source, eventId, null);
        }

        public WowActiveXEvent(Object source, int eventId, String[] parameters) {
            super(source);
            this.eventId = eventId;
            this.parameters = parameters;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        public int getEventId() {
            return this.eventId;
        }
    }

    public static interface WowActiveXListener
    extends EventListener {
        public void activeXEvent(WowActiveXEvent var1);
    }
}

