/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.WowGuiFactoryImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WowAnimation
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String mediaFile;
    private Class jfxAnimationClass;
    private final JComponent jfxAnimation;
    private WowAnimationListener listener;

    public WowAnimation() {
        JComponent jc;
        try {
            this.jfxAnimationClass = Class.forName("com.iscobol.gui.client.fx.JFXAnimation");
            jc = (JComponent)this.jfxAnimationClass.newInstance();
            Class<?> cb = Class.forName("com.iscobol.gui.client.fx.JFXAnimation$Callback");
            Object callback = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cb}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("start")) {
                        if (WowAnimation.this.listener != null) {
                            WowAnimation.this.listener.start(new WowAnimationEvent(WowAnimation.this));
                        }
                    } else if (method.getName().equals("stop") && WowAnimation.this.listener != null) {
                        WowAnimation.this.listener.stop(new WowAnimationEvent(WowAnimation.this));
                    }
                    return null;
                }
            });
            this.jfxAnimationClass.getMethod("setCallback", cb).invoke((Object)jc, callback);
        }
        catch (Throwable t) {
            t.printStackTrace();
            jc = new JLabel();
        }
        this.jfxAnimation = jc;
        this.setLayout(new BorderLayout());
        this.add((Component)this.jfxAnimation, "Center");
    }

    public void setListener(WowAnimationListener listener) {
        this.listener = listener;
    }

    public void setMediaFile(String mediaFile) {
        if (mediaFile != null && !mediaFile.equals(this.mediaFile)) {
            this.mediaFile = mediaFile;
            this.createPlayer();
        }
    }

    public void setAutoPlay(boolean ap) {
        try {
            this.jfxAnimationClass.getMethod("setAutoPlay", Boolean.TYPE).invoke((Object)this.jfxAnimation, ap);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.jfxAnimation != null) {
            try {
                this.jfxAnimationClass.getMethod("setBackground", Color.class).invoke((Object)this.jfxAnimation, c);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void createPlayer() {
        byte[] b = WowGuiFactoryImpl.getResource(this.mediaFile);
        if (b != null) {
            try {
                this.jfxAnimationClass.getMethod("setMediaFile", String.class, byte[].class).invoke((Object)this.jfxAnimation, this.mediaFile, b);
                this.jfxAnimationClass.getMethod("createPlayer", new Class[0]).invoke((Object)this.jfxAnimation, new Object[0]);
                this.doLayout();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void setPlay(boolean play) {
        try {
            this.jfxAnimationClass.getMethod("setPlay", Boolean.TYPE).invoke((Object)this.jfxAnimation, play);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void play(int repeatCount, int lastFrame, int firstFrame) {
        try {
            this.jfxAnimationClass.getMethod("play", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)this.jfxAnimation, repeatCount, lastFrame, firstFrame);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.jfxAnimationClass.getMethod("stop", new Class[0]).invoke((Object)this.jfxAnimation, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class WowAnimationEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        WowAnimationEvent(Object source) {
            super(source);
        }
    }

    static interface WowAnimationListener
    extends EventListener {
        public void start(WowAnimationEvent var1);

        public void stop(WowAnimationEvent var1);
    }
}

