/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.IsguiUtility;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class WowBitmap
extends JComponent {
    public static final int ORIGINAL_SIZE_IMAGE = 0;
    public static final int STRETCH_IMAGE = 1;
    public static final int TILE_IMAGE = 2;
    private Image image;
    private BufferedImage scaledImage;
    private BufferedImage tiledImage;
    private int xOffs;
    private int yOffs;
    private int imageMode = 0;

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bds = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(bds.x, bds.y, bds.width, bds.height);
        bds.x += this.xOffs;
        bds.y += this.yOffs;
        bds.width -= this.xOffs;
        bds.height -= this.yOffs;
        if (this.image != null) {
            switch (this.imageMode) {
                default: {
                    g.drawImage(this.image, bds.x, bds.y, null);
                    break;
                }
                case 1: {
                    g.drawImage(this.getScaledImage(bds.width, bds.height), bds.x, bds.y, null);
                    break;
                }
                case 2: {
                    Rectangle bigr = new Rectangle(0, 0, this.image.getWidth(null), this.image.getHeight(null));
                    g2d.setPaint(new TexturePaint(this.getTiledImage(), bigr));
                    g.fillRect(bds.x, bds.y, bds.width, bds.height);
                }
            }
        }
    }

    private BufferedImage getScaledImage(int width, int height) {
        if (this.scaledImage == null) {
            this.scaledImage = IsguiUtility.scale((Image)this.image, (double)width, (double)height, (int)0, (int)0);
        }
        return this.scaledImage;
    }

    private BufferedImage getTiledImage() {
        if (this.tiledImage == null) {
            BufferedImage bimage = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
            Graphics2D bGr = bimage.createGraphics();
            bGr.drawImage(this.image, 0, 0, null);
            bGr.dispose();
            this.tiledImage = bimage;
        }
        return this.tiledImage;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.scaledImage = null;
        super.setBounds(x, y, width, height);
    }

    public void setImage(Image image) {
        this.image = image;
        this.scaledImage = null;
        this.tiledImage = null;
        this.repaint();
    }

    public void setXOffs(int xo) {
        this.xOffs = xo;
        this.scaledImage = null;
        this.repaint();
    }

    public void setYOffs(int yo) {
        this.yOffs = yo;
        this.scaledImage = null;
        this.repaint();
    }

    public void setImageMode(int mode) {
        this.imageMode = mode;
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }
}

