/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.WowComboBoxEvent;
import com.veryant.wow.gui.client.WowComboBoxListener;
import com.veryant.wow.gui.client.WowComposite;
import com.veryant.wow.gui.client.WowPopupListener;
import com.veryant.wow.gui.client.WowTextListener;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class WowComboBox
extends JComponent
implements WowComposite,
ScrollPaneConstants {
    private static final int SIMPLE = 0;
    private static final int DD_COMBO = 1;
    private static final int DD_LIST = 2;
    private static final float DEFAULT_INSETS = 0.4f;
    private int style;
    private ComboBoxComponent comboComponent;
    private boolean autoHScroll = true;
    private Color background;
    private Color foreground;
    private Font font;
    private boolean enabled = true;
    private boolean visible = true;
    private int maxText;
    private Vector<WowComboBoxListener> comboboxlisteners = new Vector();
    private boolean fireEditChange = true;
    private Vector<WowTextListener> textlisteners = new Vector();
    private Vector<WowPopupListener> popuplisteners = new Vector();
    private MyDocument textdocument;
    private int w;
    private int h;
    private FontMetrics fm;
    private boolean isFocused;
    private KeyListener keyListener;
    private KeyListener keyListenerProxy = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
            if (WowComboBox.this.keyListener != null) {
                WowComboBox.this.keyListener.keyTyped(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (WowComboBox.this.keyListener != null) {
                WowComboBox.this.keyListener.keyReleased(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (WowComboBox.this.keyListener != null) {
                WowComboBox.this.keyListener.keyPressed(e);
            }
        }
    };
    private FocusListener focusListener;
    private FocusListener focusListenerProxy = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            for (Component c = e.getOppositeComponent(); c != null; c = c.getParent()) {
                if (c != WowComboBox.this) continue;
                return;
            }
            if (WowComboBox.this.focusListener != null) {
                WowComboBox.this.focusListener.focusLost(e);
            }
            WowComboBox.this.handleFocusLost();
            WowComboBox.this.isFocused = false;
        }

        @Override
        public void focusGained(FocusEvent e) {
            for (Component c = e.getOppositeComponent(); c != null; c = c.getParent()) {
                if (c != WowComboBox.this) continue;
                return;
            }
            if (WowComboBox.this.focusListener != null) {
                WowComboBox.this.focusListener.focusGained(e);
            }
            WowComboBox.this.handleFocusGained();
            WowComboBox.this.isFocused = true;
        }
    };
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private MouseAdapter mouseListenerProxy = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (WowComboBox.this.mouseListener != null) {
                WowComboBox.this.mouseListener.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (WowComboBox.this.style == 2) {
                WowComboBox.this.comboComponent.getFocusOwner().requestFocus();
            }
            if (WowComboBox.this.mouseListener != null) {
                WowComboBox.this.mouseListener.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (WowComboBox.this.mouseListener != null) {
                WowComboBox.this.mouseListener.mouseReleased(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (WowComboBox.this.mouseMotionListener != null) {
                WowComboBox.this.mouseMotionListener.mouseMoved(e);
            }
        }
    };

    public ComboBoxComponent getComboBoxComponent() {
        return this.comboComponent;
    }

    @Override
    public Component getFocusOwner() {
        return this.comboComponent.getFocusOwner();
    }

    public WowComboBox() {
        this.setLayout(new GridLayout(0, 1));
        this.setStyle(this.style);
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, ml);
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, ml);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener ml) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, ml);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener ml) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, ml);
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, kl);
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, kl);
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, fl);
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, fl);
    }

    public void setStyle(int style) {
        ComboBoxComponent oldcc = null;
        if (this.comboComponent == null || this.style != style) {
            this.style = style;
            oldcc = this.comboComponent;
            if (style == 0) {
                this.comboComponent = new SimpleComboBox(this);
            } else if (style == 1) {
                this.comboComponent = new ClassicComboBox(this, true);
            } else if (style == 2) {
                this.comboComponent = new ClassicComboBox(this, false);
            }
            this.comboComponent.addListeners(style);
            if (oldcc != null) {
                for (Component c : oldcc.GetComponents()) {
                    c.removeFocusListener(this.focusListenerProxy);
                    c.removeMouseListener(this.mouseListenerProxy);
                    c.removeMouseMotionListener(this.mouseListenerProxy);
                    c.removeKeyListener(this.keyListenerProxy);
                }
                oldcc.copyTo(this.comboComponent);
            }
            this.removeAll();
            this.add((JComponent)((Object)this.comboComponent));
            this.comboComponent.setBackground(this.background);
            this.comboComponent.setForeground(this.foreground);
            if (this.font != null) {
                this.comboComponent.setFont(this.font);
            }
            this.comboComponent.setEnabled(this.enabled);
            this.comboComponent.setVisible(this.visible);
            for (Component c : this.comboComponent.GetComponents()) {
                c.addFocusListener(this.focusListenerProxy);
                c.addMouseListener(this.mouseListenerProxy);
                c.addMouseMotionListener(this.mouseListenerProxy);
                c.addKeyListener(this.keyListenerProxy);
            }
        }
        if (oldcc != null && this.w > 0 && this.h > 0) {
            this.setSize(this.w, this.h);
        }
        oldcc = null;
    }

    public void setPopupVisible(boolean v) {
        this.comboComponent.setPopupVisible(v);
    }

    public boolean isPopupVisible() {
        return this.comboComponent.isPopupVisible();
    }

    public void intAddItem(int idx, String item) {
        this.comboComponent.intAddItem(idx, item);
    }

    @Override
    public Color getBackground() {
        return this.background != null ? this.background : super.getBackground();
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        if (this.comboComponent != null) {
            this.comboComponent.setBackground(bg);
        }
    }

    @Override
    public Color getForeground() {
        return this.foreground != null ? this.foreground : super.getForeground();
    }

    @Override
    public void setForeground(Color f) {
        this.foreground = f;
        if (this.comboComponent != null) {
            this.comboComponent.setForeground(f);
        }
    }

    @Override
    public void setEnabled(boolean e) {
        this.enabled = e;
        if (this.comboComponent != null) {
            this.comboComponent.setEnabled(e);
        }
    }

    @Override
    public void setVisible(boolean v) {
        this.visible = v;
        if (this.comboComponent != null) {
            this.comboComponent.setVisible(v);
        }
    }

    public int getCursel() {
        if (this.comboComponent != null) {
            return this.comboComponent.getCursel();
        }
        return -1;
    }

    public void setCursel(int idx, boolean showSel) {
        if (this.comboComponent != null) {
            this.comboComponent.setCursel(idx, showSel);
        }
    }

    public String getSeltext() {
        String Return = " ";
        if (this.comboComponent != null) {
            Return = this.comboComponent.getSeltext();
        }
        return Return;
    }

    public void intRemoveItem(int idx) {
        if (this.comboComponent != null) {
            this.comboComponent.intRemoveItem(idx);
        }
    }

    public void intRemoveAllItems() {
        if (this.comboComponent != null) {
            this.comboComponent.intRemoveAllItems();
        }
    }

    public void clearSelection() {
        if (this.comboComponent != null) {
            this.comboComponent.clearSelection();
        }
    }

    public int getEditSelectionStart() {
        return this.comboComponent.getEditSelectionStart();
    }

    public int getEditSelectionEnd() {
        return this.comboComponent.getEditSelectionEnd();
    }

    public void setEditSelection(int start, int end) {
        this.comboComponent.setEditSelection(start, end);
    }

    public void setMaxText(int maxtext) {
        this.maxText = maxtext;
    }

    private String check(JTextComponent txt, String str) {
        int strLen = str.length();
        if (strLen == 0) {
            return str;
        }
        int len = txt.getDocument().getLength();
        if ((str = this.checkMaxtext(str, len, strLen)) == null) {
            return null;
        }
        return str;
    }

    private String checkMaxtext(String str, int len, int strLen) {
        int diff;
        int maxText = this.getMaxText();
        if (maxText > 0 && (diff = len + strLen - maxText) > 0) {
            if (diff < strLen) {
                str = str.substring(0, strLen - diff);
            } else {
                return null;
            }
        }
        return str;
    }

    public String getText() {
        return this.comboComponent.getText();
    }

    private int getIndexOfExactItem(Object[] items, String str) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().equals(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfExactItemIgnoreCase(Object[] items, String str) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().equalsIgnoreCase(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfItemStartingWith(Object[] items, String str) {
        str = str.toLowerCase();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().toLowerCase().startsWith(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfItem(Object[] items, String str) {
        int i = this.getIndexOfExactItem(items, str);
        if (i >= 0 || str.length() == 0) {
            return i;
        }
        i = this.getIndexOfExactItemIgnoreCase(items, str);
        if (i >= 0) {
            return i;
        }
        return this.getIndexOfItemStartingWith(items, str);
    }

    private int intsetSelectedItem(String s) {
        Object[] items = this.comboComponent.getItems();
        int index = this.getIndexOfItem(items, s);
        if (index != this.getCursel()) {
            this.comboComponent.setSelectedIndex(index);
        }
        return index;
    }

    public void setText(String t) {
        int mt = this.maxText;
        this.maxText = 0;
        int idx = this.intsetSelectedItem(t);
        if (idx < 0) {
            this.comboComponent.setText(t);
        }
        this.maxText = mt;
    }

    public void copy() {
        this.comboComponent.copy();
    }

    public void cut() {
        this.comboComponent.cut();
    }

    public void paste() {
        this.comboComponent.paste();
    }

    private void intPaste(JTextComponent jtxt) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(this);
        try {
            String clipString = (String)clipData.getTransferData(DataFlavor.stringFlavor);
            if (jtxt.getSelectionStart() != jtxt.getSelectionEnd()) {
                jtxt.replaceSelection(clipString);
            } else {
                jtxt.getDocument().insertString(jtxt.getCaretPosition(), clipString, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addWowComboBoxListener(WowComboBoxListener cbl) {
        this.comboboxlisteners.add(cbl);
    }

    public void removeWowComboBoxListener(WowComboBoxListener cbl) {
        this.comboboxlisteners.remove(cbl);
    }

    private DocumentListener createDocumentListener() {
        DocumentListener documentListener = new DocumentListener(){

            private void handleEvent(DocumentEvent e, int cp, boolean isinsert) {
                if (!WowComboBox.this.textlisteners.isEmpty()) {
                    WowComboBox.this.fireTextValueChanged();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleEvent(e, e.getOffset() + e.getLength(), true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleEvent(e, Math.max(0, e.getOffset() - e.getLength() + 1), false);
            }
        };
        return documentListener;
    }

    public void addWowTextListener(WowTextListener tl) {
        if (!this.textlisteners.contains(tl)) {
            this.textlisteners.addElement(tl);
        }
    }

    public void removeWowTextListeners(WowTextListener tl) {
        if (this.textlisteners.contains(tl)) {
            this.textlisteners.removeElement(tl);
        }
    }

    public void addPopupMenuListener(WowPopupListener tl) {
        if (!this.popuplisteners.contains(tl)) {
            this.popuplisteners.addElement(tl);
        }
    }

    public void removePopupMenuListeners(WowPopupListener tl) {
        if (this.popuplisteners.contains(tl)) {
            this.popuplisteners.removeElement(tl);
        }
    }

    public void fireTextValueChanged() {
        if (this.fireEditChange) {
            for (WowTextListener l : this.textlisteners) {
                l.textChanged();
            }
        }
    }

    public void fireSelectionChanged(WowComboBoxEvent cbe) {
        for (WowComboBoxListener l : this.comboboxlisteners) {
            l.selectionChanged(cbe);
        }
    }

    public void firePopupEvent(WowComboBoxEvent cbe) {
        for (WowPopupListener l : this.popuplisteners) {
            l.popupVisible();
        }
    }

    @Override
    public void setFont(Font f) {
        this.font = f;
        if (this.font != null && this.comboComponent != null) {
            this.comboComponent.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        return this.font != null ? this.font : super.getFont();
    }

    @Override
    public void setSize(int width, int height) {
        this.w = width;
        this.h = height;
        if (this.comboComponent != null) {
            this.comboComponent.setSize(width, height);
        }
        if (this.fm != null) {
            if (this.style == 0) {
                super.setSize(width, height);
            } else {
                super.setSize(width, (int)(1.4f * (float)this.fm.getHeight()));
            }
        }
    }

    public int getComboHeight() {
        if (this.fm != null) {
            return (int)(1.4f * (float)this.fm.getHeight());
        }
        return this.getSize().height;
    }

    private boolean disableTextListeners() {
        boolean b = this.fireEditChange;
        this.fireEditChange = false;
        return b;
    }

    private void setTextListenersEnabled(boolean b) {
        this.fireEditChange = b;
    }

    void handleFocusGained() {
        this.comboComponent.handleFocusGained();
    }

    void handleFocusLost() {
        this.comboComponent.handleFocusLost();
    }

    public void setAutoHScroll(boolean autoHScroll) {
        this.autoHScroll = autoHScroll;
    }

    private int computeAHS() {
        JComponent c;
        switch (this.style) {
            default: {
                c = ((SimpleComboBox)this.comboComponent).textfield;
                break;
            }
            case 2: {
                c = ((LabelEditor)((ClassicComboBox)this.comboComponent).getEditor()).label;
                break;
            }
            case 1: {
                c = ((ClassicComboBox)this.comboComponent).getTextComponent();
            }
        }
        int size = c.getSize().width;
        float charWidth = (float)this.getFontMetrics(this.getFont()).stringWidth("0123456789") / 10.0f;
        return (int)Math.floor((float)size / charWidth);
    }

    private int getMaxText() {
        if (this.maxText > 0) {
            if (!this.autoHScroll) {
                return Math.min(this.maxText, this.computeAHS());
            }
            return this.maxText;
        }
        if (!this.autoHScroll) {
            return this.computeAHS();
        }
        return 0;
    }

    private class ClassicComboBox
    extends JComboBox
    implements ComboBoxComponent,
    PopupMenuListener,
    ItemListener {
        WowComboBox parent;
        int lastSelIdx = -1;
        boolean fireClick = true;
        boolean showSel = true;
        private LabelEditor labelEditor;
        private boolean editable;
        private boolean hasFocus;

        public ClassicComboBox(WowComboBox parent, boolean editable) {
            this.parent = parent;
            this.editable = editable;
            super.setEditable(true);
            if (editable) {
                this.setModel(new DefaultComboBoxModel(){

                    @Override
                    public void setSelectedItem(Object anObject) {
                        int mt = WowComboBox.this.maxText;
                        WowComboBox.this.maxText = 0;
                        super.setSelectedItem(anObject);
                        WowComboBox.this.maxText = mt;
                    }
                });
            } else {
                this.labelEditor = new LabelEditor(this);
                this.setEditor(this.labelEditor);
                this.labelEditor.label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (ClassicComboBox.this.isPopupVisible()) {
                            ClassicComboBox.this.hidePopup();
                        } else {
                            ClassicComboBox.this.showPopup();
                        }
                    }
                });
            }
            this.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (c instanceof JLabel) {
                        JLabel label = (JLabel)c;
                        label.setOpaque(true);
                        if (!isSelected) {
                            label.setForeground(ClassicComboBox.this.getForeground());
                            label.setBackground(ClassicComboBox.this.getBackground());
                        }
                    }
                    return c;
                }
            });
        }

        @Override
        public void setText(String t) {
            if (this.editable) {
                this.getEditor().setItem(t);
            }
        }

        @Override
        public void handleFocusGained() {
            this.hasFocus = true;
            if (this.labelEditor != null) {
                this.labelEditor.selectAll();
            } else {
                this.getTextComponent().selectAll();
            }
        }

        @Override
        public void handleFocusLost() {
            this.hasFocus = false;
            if (this.labelEditor != null) {
                this.labelEditor.clearSelection();
            } else {
                this.getTextComponent().select(-1, -1);
                this.getTextComponent().setCaretPosition(0);
            }
        }

        @Override
        public void addListeners(int newstyle) {
            this.addPopupMenuListener(this);
            this.addItemListener(this);
            if (newstyle == 1) {
                JTextComponent tc = this.getTextComponent();
                WowComboBox.this.textdocument = new MyDocument(this.parent, tc);
                tc.setDocument(WowComboBox.this.textdocument);
                tc.getDocument().addDocumentListener(WowComboBox.this.createDocumentListener());
            }
        }

        private JTextComponent getTextComponent() {
            return (JTextComponent)this.getEditor().getEditorComponent();
        }

        boolean disableItemListener() {
            boolean b = this.fireClick;
            this.fireClick = false;
            return b;
        }

        void setItemListenerEnabled(boolean b) {
            this.fireClick = b;
        }

        @Override
        public Component[] GetComponents() {
            Component[] cs;
            ArrayList<Component> l = new ArrayList<Component>();
            l.add(this);
            if (this.editable) {
                JTextComponent tf = this.getTextComponent();
                if (tf != null) {
                    l.add(tf);
                }
            } else {
                l.add(((LabelEditor)this.getEditor()).getEditorComponent());
            }
            for (Component c : cs = super.getComponents()) {
                if (!(c instanceof JButton)) continue;
                l.add(c);
                break;
            }
            return l.toArray(new Component[l.size()]);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            boolean b = WowComboBox.this.disableTextListeners();
            super.setSelectedItem(anObject);
            WowComboBox.this.setTextListenersEnabled(b);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            WowComboBoxEvent cbe = new WowComboBoxEvent(this);
            WowComboBox.this.firePopupEvent(cbe);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public Component getFocusOwner() {
            return this.getEditor().getEditorComponent();
        }

        @Override
        public void intAddItem(int idx, String item) {
            boolean b1 = this.disableItemListener();
            boolean b2 = WowComboBox.this.disableTextListeners();
            if (idx >= 0 && idx < this.getItemCount()) {
                super.insertItemAt(item, idx);
            } else {
                super.addItem(item);
            }
            this.setItemListenerEnabled(b1);
            WowComboBox.this.setTextListenersEnabled(b2);
        }

        @Override
        public void copyTo(ComboBoxComponent newcc) {
            boolean b1 = this.disableItemListener();
            boolean b2 = WowComboBox.this.disableTextListeners();
            int numelem = super.getItemCount();
            for (int i = 0; i < numelem; ++i) {
                newcc.intAddItem(i, (String)super.getItemAt(i));
            }
            this.setItemListenerEnabled(b1);
            WowComboBox.this.setTextListenersEnabled(b2);
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            if (f != null) {
                if (this.labelEditor != null) {
                    this.labelEditor.label.setFont(f);
                }
                WowComboBox.this.fm = this.getFontMetrics(f);
                super.setSize(this.getWidth(), (int)(1.4f * (float)WowComboBox.this.fm.getHeight()));
            }
        }

        @Override
        public void setSize(int width, int height) {
            if (WowComboBox.this.fm != null) {
                int h = (int)(1.4f * (float)WowComboBox.this.fm.getHeight());
                super.setSize(width, h);
            }
        }

        @Override
        public int getCursel() {
            return super.getSelectedIndex();
        }

        @Override
        public void setCursel(int idx, boolean showSel) {
            if (idx < this.getItemCount()) {
                boolean b1 = this.disableItemListener();
                boolean b2 = WowComboBox.this.disableTextListeners();
                this.showSel = showSel;
                if (idx < 0) {
                    super.setSelectedItem(null);
                } else {
                    super.setSelectedIndex(idx);
                }
                if (!this.hasFocus && this.editable) {
                    this.getTextComponent().setCaretPosition(0);
                }
                this.setItemListenerEnabled(b1);
                WowComboBox.this.setTextListenersEnabled(b2);
            }
        }

        @Override
        public String getSeltext() {
            String Return = " ";
            if (super.getSelectedIndex() >= 0) {
                Return = (String)super.getSelectedItem();
            }
            return Return;
        }

        @Override
        public void intRemoveItem(int idx) {
            boolean b1 = this.disableItemListener();
            boolean b2 = WowComboBox.this.disableTextListeners();
            super.removeItemAt(idx);
            this.setItemListenerEnabled(b1);
            WowComboBox.this.setTextListenersEnabled(b2);
        }

        @Override
        public void intRemoveAllItems() {
            boolean b1 = this.disableItemListener();
            boolean b2 = WowComboBox.this.disableTextListeners();
            super.removeAllItems();
            this.setItemListenerEnabled(b1);
            WowComboBox.this.setTextListenersEnabled(b2);
        }

        @Override
        public void clearSelection() {
            boolean b1 = this.disableItemListener();
            boolean b2 = WowComboBox.this.disableTextListeners();
            super.setSelectedIndex(-1);
            this.setItemListenerEnabled(b1);
            WowComboBox.this.setTextListenersEnabled(b2);
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.labelEditor != null) {
                this.labelEditor.label.setBackground(c);
            }
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            if (this.labelEditor != null) {
                this.labelEditor.label.setForeground(c);
            }
        }

        @Override
        public int getEditSelectionStart() {
            return this.labelEditor != null ? -1 : this.getTextComponent().getSelectionStart();
        }

        @Override
        public int getEditSelectionEnd() {
            return this.labelEditor != null ? -1 : this.getTextComponent().getSelectionEnd();
        }

        @Override
        public void setEditSelection(int start, int end) {
            if (this.labelEditor == null) {
                this.getTextComponent().select(start, end);
            }
        }

        @Override
        public String[] getItems() {
            String[] Return;
            int cbsize = -1;
            cbsize = this.getItemCount();
            if (cbsize > 0) {
                Return = new String[cbsize];
                for (int i = 0; i < cbsize; ++i) {
                    Return[i] = (String)this.getItemAt(i);
                }
            } else {
                Return = new String[]{};
            }
            return Return;
        }

        @Override
        public String getText() {
            String Return = "";
            Return = this.labelEditor == null ? this.getTextComponent().getText() : this.getSeltext();
            return Return;
        }

        @Override
        public void copy() {
            if (this.labelEditor == null) {
                this.getTextComponent().copy();
            }
        }

        @Override
        public void cut() {
            if (this.labelEditor == null) {
                this.getTextComponent().cut();
            }
        }

        @Override
        public void paste() {
            if (this.labelEditor == null) {
                this.parent.intPaste(this.getTextComponent());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int selIdx = this.getSelectedIndex();
            if (this.fireClick) {
                if (!this.showSel) {
                    this.showSel = true;
                    if (this.labelEditor != null) {
                        this.labelEditor.selectAll();
                    }
                }
                if (this.lastSelIdx != selIdx) {
                    WowComboBoxEvent cbe = new WowComboBoxEvent(this);
                    WowComboBox.this.fireSelectionChanged(cbe);
                    this.lastSelIdx = selIdx;
                }
            }
        }

        boolean isFocused() {
            return this.parent.isFocused;
        }
    }

    private static class LabelEditor
    implements ComboBoxEditor {
        private JLabel label;
        Object item;
        private final Color selBackground = UIManager.getColor("ComboBox.selectionBackground");
        private final Color selForeground = UIManager.getColor("ComboBox.selectionForeground");
        private final ClassicComboBox ccb;

        LabelEditor(ClassicComboBox ccb) {
            this.ccb = ccb;
            this.label = new JLabel();
            this.label.setOpaque(true);
        }

        @Override
        public void setItem(Object anObject) {
            this.item = anObject;
            FontMetrics fm = this.label.getFontMetrics(this.label.getFont());
            String text = "";
            if (anObject != null) {
                text = anObject.toString();
            }
            int width = this.label.getSize().width;
            while (fm.stringWidth(text) > width && text.length() > 0) {
                text = text.substring(0, text.length() - 1);
            }
            this.label.setText(text);
            if (anObject != null && this.ccb.isFocused()) {
                this.selectAll();
            } else {
                this.clearSelection();
            }
        }

        @Override
        public void selectAll() {
            if (this.ccb.showSel) {
                if (this.selBackground != null) {
                    this.label.setBackground(this.selBackground);
                }
                if (this.selForeground != null) {
                    this.label.setForeground(this.selForeground);
                }
            } else {
                this.clearSelection();
                this.ccb.showSel = true;
            }
        }

        void clearSelection() {
            this.label.setBackground(this.ccb.getBackground());
            this.label.setForeground(this.ccb.getForeground());
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Object getItem() {
            return this.item;
        }

        @Override
        public Component getEditorComponent() {
            return this.label;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }
    }

    private class SimpleComboBox
    extends JPanel
    implements ComboBoxComponent,
    ListSelectionListener {
        WowComboBox parent;
        JTextField textfield;
        JList listbox;
        JScrollPane comboScrollPane;
        DefaultListModel listmodel;

        public SimpleComboBox(WowComboBox parent) {
            super.setLayout(new BorderLayout());
            this.parent = parent;
            this.textfield = new JTextField();
            WowComboBox.this.textdocument = new MyDocument(parent, this.textfield);
            this.textfield.setDocument(WowComboBox.this.textdocument);
            this.listmodel = new DefaultListModel();
            this.listbox = new JList(this.listmodel);
            this.comboScrollPane = new JScrollPane(this.listbox, 20, 30);
            this.add((Component)this.textfield, "North");
            this.add((Component)this.comboScrollPane, "Center");
            this.doLayout();
        }

        @Override
        public Component[] GetComponents() {
            return new Component[]{this.textfield, this.listbox};
        }

        @Override
        public void addListeners(int newstyle) {
            this.textfield.getDocument().addDocumentListener(WowComboBox.this.createDocumentListener());
            this.listbox.addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.textfield.setText((String)this.listbox.getSelectedValue());
                WowComboBoxEvent cbe = new WowComboBoxEvent(this);
                WowComboBox.this.fireSelectionChanged(cbe);
            }
        }

        @Override
        public void setPopupVisible(boolean v) {
        }

        @Override
        public boolean isPopupVisible() {
            return true;
        }

        @Override
        public void setEditable(boolean e) {
        }

        @Override
        public Component getFocusOwner() {
            return this.textfield;
        }

        @Override
        public void intAddItem(int idx, String item) {
            if (idx >= 0 && idx < this.listmodel.getSize()) {
                this.listmodel.add(idx, item);
            } else {
                this.listmodel.addElement(item);
            }
        }

        @Override
        public void copyTo(ComboBoxComponent newcc) {
            int i = 0;
            Enumeration en = this.listmodel.elements();
            while (en.hasMoreElements()) {
                newcc.intAddItem(i++, (String)en.nextElement());
            }
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.textfield != null) {
                this.textfield.setBackground(bg);
                this.listbox.setBackground(bg);
            }
        }

        @Override
        public void setForeground(Color f) {
            super.setForeground(f);
            if (this.textfield != null) {
                this.textfield.setForeground(f);
                this.listbox.setForeground(f);
            }
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            if (f != null) {
                WowComboBox.this.fm = this.getFontMetrics(f);
            }
            if (this.textfield != null) {
                this.textfield.setFont(f);
                this.listbox.setFont(f);
                if (WowComboBox.this.fm != null) {
                    this.textfield.setPreferredSize(new Dimension(this.textfield.getWidth(), (int)(1.4f * (float)WowComboBox.this.fm.getHeight())));
                }
            }
        }

        @Override
        public void setSize(int width, int height) {
            super.setSize(width, height);
            if (this.textfield != null && WowComboBox.this.fm != null) {
                this.textfield.setPreferredSize(new Dimension(this.textfield.getWidth(), (int)(1.4f * (float)WowComboBox.this.fm.getHeight())));
            }
        }

        @Override
        public void setEnabled(boolean e) {
            super.setEnabled(e);
            if (this.textfield != null) {
                this.textfield.setEnabled(e);
                this.listbox.setEnabled(e);
            }
        }

        @Override
        public void setVisible(boolean v) {
            super.setVisible(v);
            if (this.textfield != null) {
                this.textfield.setVisible(v);
                this.listbox.setVisible(v);
                this.comboScrollPane.setVisible(v);
            }
        }

        @Override
        public int getCursel() {
            return this.listbox.getSelectedIndex();
        }

        @Override
        public String getSeltext() {
            String Return = " ";
            if (this.listbox.getSelectedIndex() >= 0) {
                Return = (String)this.listbox.getSelectedValue();
            }
            return Return;
        }

        @Override
        public void setCursel(int idx, boolean showSel) {
            this.listbox.setSelectedIndex(idx);
        }

        @Override
        public void intRemoveItem(int idx) {
            this.listmodel.remove(idx);
        }

        @Override
        public void intRemoveAllItems() {
            this.listmodel.removeAllElements();
        }

        @Override
        public void clearSelection() {
            this.listbox.getSelectionModel().clearSelection();
        }

        @Override
        public int getEditSelectionStart() {
            return this.textfield.getSelectionStart();
        }

        @Override
        public int getEditSelectionEnd() {
            return this.textfield.getSelectionStart();
        }

        @Override
        public void setEditSelection(int start, int end) {
            this.textfield.select(start, end);
        }

        @Override
        public void setSelectedIndex(int i) {
            this.listbox.setSelectedIndex(i);
        }

        @Override
        public String[] getItems() {
            String[] Return;
            ListModel lm = this.listbox.getModel();
            int lmsize = -1;
            if (lm != null && (lmsize = lm.getSize()) > 0) {
                Return = new String[lmsize];
                for (int i = 0; i < lmsize; ++i) {
                    Return[i] = (String)lm.getElementAt(i);
                }
            } else {
                Return = new String[]{};
            }
            return Return;
        }

        @Override
        public String getText() {
            String Return = this.textfield.getText();
            if (Return == null) {
                Return = "";
            }
            return Return;
        }

        @Override
        public void copy() {
            this.textfield.copy();
        }

        @Override
        public void cut() {
            if (this.textfield.isEditable()) {
                this.textfield.cut();
            }
        }

        @Override
        public void paste() {
            this.parent.intPaste(this.textfield);
        }

        @Override
        public int getSelectedIndex() {
            return this.listbox.getSelectedIndex();
        }

        @Override
        public void setText(String t) {
            this.textfield.setText(t);
        }
    }

    private static class MyDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        WowComboBox parent;
        JTextComponent jtxt;

        MyDocument(WowComboBox parent, JTextComponent jtxt) {
            this.parent = parent;
            this.jtxt = jtxt;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.parent != null) {
                this.myinsertString(offs, str, a);
            } else {
                super.insertString(offs, str, a);
            }
        }

        private void myinsertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if ((str = this.parent.check(this.jtxt, str)) != null) {
                super.insertString(offs, str, a);
            }
        }
    }

    public static interface ComboBoxComponent {
        public void setPopupVisible(boolean var1);

        public boolean isPopupVisible();

        public void setEditable(boolean var1);

        public Component getFocusOwner();

        public void intAddItem(int var1, String var2);

        public void intRemoveItem(int var1);

        public void intRemoveAllItems();

        public void copyTo(ComboBoxComponent var1);

        public void setBackground(Color var1);

        public void setForeground(Color var1);

        public void setFont(Font var1);

        public void setEnabled(boolean var1);

        public void setVisible(boolean var1);

        public int getCursel();

        public void setCursel(int var1, boolean var2);

        public String getSeltext();

        public String getText();

        public void clearSelection();

        public void addListeners(int var1);

        public int getEditSelectionStart();

        public int getEditSelectionEnd();

        public void setEditSelection(int var1, int var2);

        public void setSelectedIndex(int var1);

        public String[] getItems();

        public void copy();

        public void cut();

        public void paste();

        public void setSize(int var1, int var2);

        public Component[] GetComponents();

        public int getSelectedIndex();

        public void setText(String var1);

        default public void handleFocusGained() {
        }

        default public void handleFocusLost() {
        }
    }
}

