/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.IsguiUtility;
import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JMonthChooser;
import com.toedter.calendar.JSpinnerDateEditor;
import com.toedter.calendar.JTextFieldDateEditor;
import com.veryant.wow.gui.client.RemoteDateComponent;
import com.veryant.wow.gui.client.WowComposite;
import com.veryant.wow.gui.client.WowDateChooser;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WowDateTimePicker
extends JPanel
implements WowComposite,
WowDateChooser {
    public static final int STYLE_NONE = 0;
    public static final int STYLE_SHORT_CENTURY = 1;
    public static final int STYLE_LONG = 2;
    public static final int STYLE_TIME = 3;
    private JDateChooser dateChooser;
    private JCheckBox showNoneCb;
    private boolean showNone;
    private boolean spinner;
    private String format = WowDateTimePicker.getDefaultCenturyDateFormat();
    private KeyListener keyListener;
    private ChangeListener listener;
    private int formatStyle;
    private Color monthYearForeground;
    private boolean rightAlign;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (WowDateTimePicker.this.monthYearForeground != null) {
                ((JSpinner)WowDateTimePicker.this.getJCalendar().getYearChooser().getSpinner()).getEditor().setForeground(WowDateTimePicker.this.monthYearForeground);
            }
            if (!WowDateTimePicker.this.showNoneCb.isSelected()) {
                WowDateTimePicker.this.showNoneCb.setSelected(true);
                WowDateTimePicker.this.intSetShowNoneChecked(true);
            }
            if (WowDateTimePicker.this.listener != null) {
                WowDateTimePicker.this.listener.stateChanged(new ChangeEvent(WowDateTimePicker.this));
            }
        }
    };

    public WowDateTimePicker() {
        this.setLayout(new BorderLayout());
        this.setSpinner(false);
        this.showNoneCb = new JCheckBox();
        this.showNoneCb.setSelected(true);
        this.showNoneCb.setFocusable(false);
        this.showNoneCb.addActionListener(e -> this.intSetShowNoneChecked(this.showNoneCb.isSelected()));
    }

    private void intSetShowNoneChecked(boolean newVal) {
        boolean en = newVal && this.dateChooser.isEnabled();
        this.showNoneCb.setFocusable(!newVal);
        ((JComponent)this.dateChooser.getDateEditor()).setEnabled(en);
        this.dateChooser.getCalendarButton().setEnabled(en);
        if (this.keyListener != null) {
            if (newVal) {
                this.showNoneCb.removeKeyListener(this.keyListener);
            } else {
                this.showNoneCb.addKeyListener(this.keyListener);
            }
        }
        if (!newVal && this.getTextComponent().isFocusOwner()) {
            this.showNoneCb.requestFocus();
        } else if (newVal && this.showNoneCb.isFocusOwner()) {
            this.dateChooser.requestFocus();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.dateChooser != null) {
            this.dateChooser.setEnabled(b);
            this.showNoneCb.setEnabled(b);
        }
    }

    private String getFormat() {
        switch (this.formatStyle) {
            default: {
                return this.format;
            }
            case 1: {
                return WowDateTimePicker.getDefaultCenturyDateFormat();
            }
            case 2: {
                return IsguiUtility.getDefaultLongDateFormat();
            }
            case 3: 
        }
        return IsguiUtility.getDefaultTimeDateFormat();
    }

    private boolean isSpinner() {
        return this.formatStyle == 3 ? true : this.spinner;
    }

    public void setFormatStyle(int style) {
        String oldFormat = this.getFormat();
        boolean oldSpinner = this.isSpinner();
        this.formatStyle = style;
        String newFormat = this.getFormat();
        boolean newSpinner = this.isSpinner();
        if (oldSpinner != newSpinner || !oldFormat.equals(newFormat)) {
            this.intSetSpinner(newSpinner);
        }
        this.dateChooser.getCalendarButton().setVisible(this.formatStyle != 3);
    }

    public void setFormat(String format) {
        String oldFormat = this.getFormat();
        this.format = format;
        String newFormat = this.getFormat();
        if (!this.checkDateFormat(format)) {
            this.format = WowDateTimePicker.getDefaultCenturyDateFormat();
        }
        if (!oldFormat.equals(newFormat)) {
            this.intSetSpinner(this.isSpinner());
        }
    }

    private boolean checkDateFormat(String pattern) {
        try {
            new SimpleDateFormat(pattern);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setSpinner(boolean sp) {
        boolean oldSpinner = this.spinner;
        this.spinner = sp;
        if (this.dateChooser == null || oldSpinner != this.spinner && this.formatStyle != 3) {
            this.intSetSpinner(this.spinner);
        }
    }

    private JFormattedTextField getTextComponent() {
        if (this.isSpinner()) {
            JSpinnerDateEditor editor = (JSpinnerDateEditor)this.dateChooser.getDateEditor();
            return ((JSpinner.DateEditor)editor.getEditor()).getTextField();
        }
        return (JTextFieldDateEditor)this.dateChooser.getDateEditor();
    }

    private void intSetSpinner(boolean sp) {
        JDateChooser oldDC = this.dateChooser;
        if (oldDC != null) {
            this.remove((Component)oldDC);
            oldDC.cleanup();
            oldDC.removePropertyChangeListener("date", this.propertyChangeListener);
        }
        if (sp) {
            this.dateChooser = new JDateChooser((IDateEditor)new JSpinnerDateEditor());
            this.dateChooser.setDateFormatString(this.getFormat());
        } else {
            this.dateChooser = new JDateChooser(this.getFormat(), IsguiUtility.createMaskFromDatePattern((String)this.getFormat(), (char)'#', (boolean)true), ' ');
        }
        if (oldDC != null) {
            this.copyAttributes(oldDC);
        } else {
            this.setDate(Calendar.getInstance().getTime());
        }
        this.add((Component)this.dateChooser, "Center");
        this.doLayout();
        this.dateChooser.addPropertyChangeListener("date", this.propertyChangeListener);
        this.dateChooser.getCalendarButton().addActionListener(e -> {
            JMonthChooser jmc = this.dateChooser.getJCalendar().getMonthChooser();
            Component cb = jmc.getComboBox();
            FontMetrics fm = cb.getFontMetrics(cb.getFont());
            Dimension d = jmc.getPreferredSize();
            d.height = fm.getHeight() + 9;
            jmc.setPreferredSize(d);
        });
    }

    public Date getDate() {
        return this.dateChooser.getDate();
    }

    public void setDate(Date d) {
        this.dateChooser.setDate(d);
    }

    private void copyAttributes(JDateChooser from) {
        if (this.keyListener != null) {
            from.removeKeyListener(this.keyListener);
            this.dateChooser.addKeyListener(this.keyListener);
        }
        this.dateChooser.setDate(from.getDate());
        this.dateChooser.setFont(from.getFont());
        this.dateChooser.setBackground(from.getBackground());
        this.dateChooser.setForeground(from.getForeground());
        RemoteDateComponent.setCalendarDecorationBackground(this.getJCalendar(), RemoteDateComponent.getCalendarDecorationBackground(from.getJCalendar()));
        RemoteDateComponent.setCalendarDayChooserForeground(this.getJCalendar(), RemoteDateComponent.getCalendarDayChooserForeground(from.getJCalendar()));
        RemoteDateComponent.setCalendarDayChooserBackground(this.getJCalendar(), RemoteDateComponent.getCalendarDayChooserBackground(from.getJCalendar()));
        RemoteDateComponent.setCalendarDayChooserFont(this.getJCalendar(), RemoteDateComponent.getCalendarDayChooserFont(from.getJCalendar()));
        RemoteDateComponent.setCalendarMonthYearChooserForeground(this.getJCalendar(), RemoteDateComponent.getCalendarMonthYearChooserForeground(from.getJCalendar()));
        RemoteDateComponent.setCalendarMonthYearChooserBackground(this.getJCalendar(), RemoteDateComponent.getCalendarMonthYearChooserBackground(from.getJCalendar()));
        RemoteDateComponent.setCalendarMonthYearChooserFont(this.getJCalendar(), RemoteDateComponent.getCalendarMonthYearChooserFont(from.getJCalendar()));
        RemoteDateComponent.setCalendarWeekDayForeground(this.getJCalendar(), RemoteDateComponent.getCalendarWeekDayForeground(from.getJCalendar()));
        this.setRightAlignedText(this.rightAlign);
    }

    public void setShowNone(boolean b) {
        if (this.showNone != b) {
            this.showNone = b;
            if (b) {
                this.add((Component)this.showNoneCb, "West");
            } else {
                this.remove(this.showNoneCb);
            }
            this.doLayout();
        }
    }

    @Override
    public JCalendar getJCalendar() {
        return this.dateChooser.getJCalendar();
    }

    public JDateChooser getJDateChooser() {
        return this.dateChooser;
    }

    @Override
    public Component getFocusOwner() {
        return this.dateChooser;
    }

    @Override
    public void requestFocus() {
        this.dateChooser.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.dateChooser.requestFocusInWindow();
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        if (this.dateChooser != null) {
            if (this.keyListener != null) {
                this.dateChooser.removeKeyListener(this.keyListener);
                this.showNoneCb.removeKeyListener(this.keyListener);
            }
            this.keyListener = AWTEventMulticaster.add(this.keyListener, kl);
            this.dateChooser.addKeyListener(this.keyListener);
            this.showNoneCb.addKeyListener(this.keyListener);
        } else {
            super.addKeyListener(kl);
        }
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        if (this.dateChooser != null) {
            if (this.keyListener != null) {
                this.dateChooser.removeKeyListener(this.keyListener);
                this.showNoneCb.removeKeyListener(this.keyListener);
                this.keyListener = AWTEventMulticaster.remove(this.keyListener, kl);
                if (this.keyListener != null) {
                    this.dateChooser.addKeyListener(this.keyListener);
                    this.showNoneCb.addKeyListener(this.keyListener);
                }
            }
        } else {
            super.removeKeyListener(kl);
        }
    }

    @Override
    public void setFont(Font f) {
        if (this.dateChooser != null) {
            this.dateChooser.setFont(f);
            ((JComponent)this.dateChooser.getDateEditor()).setFont(f);
        } else {
            super.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        return this.dateChooser != null ? ((JComponent)this.dateChooser.getDateEditor()).getFont() : super.getFont();
    }

    @Override
    public void setCalendarDecorationBackground(Color c) {
        RemoteDateComponent.setCalendarDecorationBackground(this.getJCalendar(), c);
    }

    @Override
    public void setCalendarDayChooserBackground(Color c) {
        RemoteDateComponent.setCalendarDayChooserBackground(this.getJCalendar(), c);
    }

    @Override
    public void setCalendarDayChooserForeground(Color c) {
        RemoteDateComponent.setCalendarDayChooserForeground(this.getJCalendar(), c);
    }

    @Override
    public void setCalendarMonthYearChooserBackground(Color c) {
        RemoteDateComponent.setCalendarMonthYearChooserBackground(this.getJCalendar(), c);
    }

    @Override
    public void setCalendarMonthYearChooserForeground(Color c) {
        this.monthYearForeground = c;
        RemoteDateComponent.setCalendarMonthYearChooserForeground(this.getJCalendar(), c);
    }

    @Override
    public void setCalendarWeekDayForeground(Color c) {
        RemoteDateComponent.setCalendarWeekDayForeground(this.getJCalendar(), c);
    }

    @Override
    public void setCalendarDayChooserFont(Font f) {
        RemoteDateComponent.setCalendarDayChooserFont(this.getJCalendar(), f);
    }

    @Override
    public void setCalendarMonthYearChooserFont(Font f) {
        RemoteDateComponent.setCalendarMonthYearChooserFont(this.getJCalendar(), f);
    }

    public String getText() {
        return this.getTextComponent().getText();
    }

    public void setRightAlignedText(boolean b) {
        this.rightAlign = b;
        this.getTextComponent().setHorizontalAlignment(b ? 4 : 2);
    }

    @Override
    public void setListener(ChangeListener cl) {
        this.listener = cl;
    }

    @Override
    public void setCalendarSundayForeground(Color c) {
        RemoteDateComponent.setCalendarSundayForeground(this.getJCalendar(), c);
    }

    static String getDefaultCenturyDateFormat() {
        DateFormat df = DateFormat.getDateInstance(3);
        if (df instanceof SimpleDateFormat) {
            String ptn = ((SimpleDateFormat)df).toPattern();
            return ptn.replaceAll("\\byy\\b", "yyyy").replaceAll("\\by\\b", "yyyy").replaceAll("\\bd\\b", "dd").replaceAll("\\bM\\b", "MM");
        }
        return "dd/MM/yyyy";
    }
}

