/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.WowComposite;
import com.veryant.wow.gui.client.WowTextListener;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class WowEditBox
extends JComponent
implements WowComposite {
    private static final int MIXED_CASE = 0;
    private static final int LOWER_CASE = 1;
    private static final int UPPER_CASE = 2;
    private static final int SCROLLBARS_NONE = 0;
    private static final int SCROLLBARS_VERTICAL = 1;
    private static final int SCROLLBARS_HORIZONTAL = 2;
    private static final int SCROLLBARS_BOTH = 3;
    private static String eol = System.getProperty("line.separator", "\n");
    private final UndoManager undoManager = new UndoManager();
    private Vector textListeners = new Vector();
    private boolean multiline;
    private boolean password;
    private boolean hscrollEnabled = true;
    private boolean vscrollEnabled;
    private boolean leftscrollbar;
    private int _case;
    private int alignment = 2;
    public int maxchars;
    private MyDocument textDocument;
    private boolean numeric;
    private int numericintdigits = 9;
    private int numericdecdigits = 2;
    private boolean numericsign = true;
    private boolean wantreturn;
    private boolean selectallongotfocus;
    private int scrollbars;
    protected JTextComponent textComponent;
    protected JScrollPane textScrollPane;
    protected JScrollBar vscroll;
    protected JScrollBar hscroll;
    protected JPanel textPanel;
    private Color background;
    private Color foreground;
    private Font font;
    private KeyListener keyListener;
    private KeyListener keyListenerProxy = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
            if (WowEditBox.this.keyListener != null) {
                WowEditBox.this.keyListener.keyTyped(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (WowEditBox.this.keyListener != null) {
                WowEditBox.this.keyListener.keyReleased(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (WowEditBox.this.keyListener != null) {
                WowEditBox.this.keyListener.keyPressed(e);
            }
        }
    };
    private FocusListener focusListener;
    private FocusListener focusListenerProxy = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            if (WowEditBox.this.focusListener != null) {
                WowEditBox.this.focusListener.focusLost(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (WowEditBox.this.focusListener != null) {
                WowEditBox.this.focusListener.focusGained(e);
            }
        }
    };
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private MouseAdapter mouseListenerProxy = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (WowEditBox.this.mouseListener != null) {
                WowEditBox.this.mouseListener.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (WowEditBox.this.mouseListener != null) {
                WowEditBox.this.mouseListener.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (WowEditBox.this.mouseListener != null) {
                WowEditBox.this.mouseListener.mouseReleased(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (WowEditBox.this.mouseMotionListener != null) {
                WowEditBox.this.mouseMotionListener.mouseMoved(e);
            }
        }
    };

    @Override
    public Component getFocusOwner() {
        return this.textComponent;
    }

    private DocumentListener createDocumentListener() {
        DocumentListener documentListener = new DocumentListener(){

            private void handleEvent(DocumentEvent e, int cp, boolean isinsert) {
                if (!WowEditBox.this.textListeners.isEmpty()) {
                    WowEditBox.this.fireTextValueChanged();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleEvent(e, e.getOffset() + e.getLength(), true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleEvent(e, Math.max(0, e.getOffset() - e.getLength() + 1), false);
            }
        };
        return documentListener;
    }

    private static boolean isDigit(char c, boolean numericsign, int numericdecdigits) {
        return Character.isDigit(c) || numericsign && (c == '-' || c == '+') || numericdecdigits > 0 && (c == '.' || c == ',');
    }

    public WowEditBox() {
        this.setLayout(new GridLayout(0, 1));
        this.setMultiline();
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, ml);
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, ml);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener ml) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, ml);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener ml) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, ml);
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, kl);
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, kl);
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, fl);
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, fl);
    }

    public void setHScrollEnabled(boolean b) {
        this.hscrollEnabled = b;
        if (this.textComponent instanceof MyTextArea && (this.scrollbars == 0 || this.scrollbars == 1)) {
            ((MyTextArea)this.textComponent).setLineWrap(!b);
            ((MyTextArea)this.textComponent).setWrapStyleWord(!b);
        }
    }

    public void setVScrollEnabled(boolean b) {
        this.vscrollEnabled = b;
    }

    public void setMultiline(boolean b) {
        if (this.multiline != b) {
            this.multiline = b;
            this.setMultiline();
        }
    }

    private void setMultiline() {
        this.removeAll();
        JTextComponent oldTc = this.textComponent;
        if (this.multiline) {
            this.textComponent = new MyTextArea();
            this.textComponent.setBorder(null);
            this.textComponent.setName(this.getName());
            this.textDocument = new MyDocument(this);
            this.textComponent.setDocument(this.textDocument);
            this.textComponent.getDocument().addDocumentListener(this.createDocumentListener());
            this.textScrollPane = new JScrollPane(this.textComponent);
            this.textScrollPane.setBorder(null);
            this.setScrollbars(this.scrollbars);
            if (this.vscrollEnabled && (this.vscroll = this.textScrollPane.getVerticalScrollBar()) != null) {
                this.vscroll.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        WowEditBox.this.fireMouseClickedOnScroll(true);
                    }
                });
            }
            if (this.hscrollEnabled && (this.hscroll = this.textScrollPane.getVerticalScrollBar()) != null) {
                this.hscroll.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        WowEditBox.this.fireMouseClickedOnScroll(false);
                    }
                });
            }
            this.add(this.textScrollPane);
            if (this.background != null) {
                this.textComponent.setBackground(this.background);
            }
            if (this.foreground != null) {
                this.textComponent.setForeground(this.foreground);
            }
            if (this.font != null) {
                this.textComponent.setFont(this.font);
            }
        } else {
            this.textComponent = new MyTextField();
            this.textComponent.setBorder(null);
            this.textComponent.setName(this.getName());
            this.textDocument = new MyDocument(this);
            this.textComponent.setDocument(this.textDocument);
            this.textComponent.getDocument().addDocumentListener(this.createDocumentListener());
            this.add(this.textComponent);
            if (this.background != null) {
                this.textComponent.setBackground(this.background);
            }
            if (this.foreground != null) {
                this.textComponent.setForeground(this.foreground);
            }
            if (this.font != null) {
                this.textComponent.setFont(this.font);
            }
        }
        this.copyAttrs(oldTc);
    }

    private void copyAttrs(JTextComponent oldTc) {
        if (oldTc != null) {
            this.textComponent.setText(oldTc.getText());
            this.textComponent.setEnabled(oldTc.isEnabled());
            this.textComponent.setEditable(oldTc.isEditable());
            this.textComponent.setVisible(oldTc.isVisible());
            oldTc.removeFocusListener(this.focusListenerProxy);
            oldTc.removeKeyListener(this.keyListenerProxy);
            oldTc.removeMouseListener(this.mouseListenerProxy);
            oldTc.removeMouseMotionListener(this.mouseListenerProxy);
        }
        this.textComponent.addKeyListener(this.keyListenerProxy);
        this.textComponent.addFocusListener(this.focusListenerProxy);
        this.textComponent.addMouseListener(this.mouseListenerProxy);
        this.textComponent.addMouseMotionListener(this.mouseListenerProxy);
    }

    public void setPassword(boolean b) {
        if (this.password != b) {
            this.password = b;
            this.setPassword();
        }
    }

    private void setPassword() {
        this.removeAll();
        if (this.password) {
            JTextComponent oldTc = this.textComponent;
            this.textComponent = new MyPasswordField();
            this.textComponent.setBorder(null);
            this.textComponent.setName(this.getName());
            this.textDocument = new MyDocument(this);
            this.textComponent.setDocument(this.textDocument);
            this.textComponent.getDocument().addDocumentListener(this.createDocumentListener());
            this.add(this.textComponent);
            if (this.background != null) {
                this.textComponent.setBackground(this.background);
            }
            if (this.foreground != null) {
                this.textComponent.setForeground(this.foreground);
            }
            if (this.font != null) {
                this.textComponent.setFont(this.font);
            }
            this.copyAttrs(oldTc);
        } else {
            this.setMultiline();
        }
    }

    public void setText(String text) {
        if (text != null && text.length() > 0) {
            if (this._case == 2) {
                text = text.toUpperCase();
            } else if (this._case == 1) {
                text = text.toLowerCase();
            }
        }
        this.textComponent.setText(text);
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean Return = this.textComponent.requestFocusInWindow();
        if (this.selectallongotfocus) {
            this.textComponent.selectAll();
        }
        return Return;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.background = bg;
        if (this.textScrollPane != null) {
            this.textScrollPane.setBackground(bg);
        }
        if (this.textComponent != null) {
            this.textComponent.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color f) {
        super.setForeground(f);
        this.foreground = f;
        if (this.textComponent != null) {
            this.textComponent.setForeground(f);
        }
    }

    public String getText() {
        return this.textComponent.getText();
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.textScrollPane != null) {
            this.textScrollPane.repaint();
        }
        if (this.textComponent != null) {
            this.textComponent.repaint();
        }
    }

    @Override
    public void setFont(Font f) {
        this.font = f;
        if (this.textComponent == null) {
            super.setFont(f);
        } else if (this.textComponent != null) {
            this.textComponent.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        return this.font != null ? this.font : super.getFont();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.textScrollPane != null) {
            this.textScrollPane.doLayout();
        }
        if (this.textComponent != null) {
            this.textComponent.doLayout();
        }
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.textComponent.setEnabled(e);
        if (this.textScrollPane != null) {
            this.textScrollPane.setEnabled(e);
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        this.textComponent.setVisible(v);
        if (this.textScrollPane != null) {
            this.textScrollPane.setVisible(v);
        }
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == 0 || alignment == 1) {
            this.alignment = 2;
        } else if (alignment == 2) {
            this.alignment = 0;
        } else if (alignment == 3) {
            this.alignment = 4;
        }
        ((JTextField)this.textComponent).setHorizontalAlignment(this.alignment);
    }

    public void setPasswordChar(String passwordchar) {
        if (passwordchar != null && passwordchar.length() > 0 && this.textComponent != null && this.textComponent instanceof JPasswordField) {
            ((JPasswordField)this.textComponent).setEchoChar(passwordchar.charAt(0));
        }
    }

    public void setLeftscrollbar(boolean leftscrollbar) {
        if (this.leftscrollbar != leftscrollbar) {
            if (leftscrollbar) {
                this.textScrollPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            } else {
                this.textScrollPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        }
        this.leftscrollbar = leftscrollbar;
    }

    public void setCase(int _case) {
        this._case = _case;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public void setNumericintdigits(int numericintdigits) {
        this.numericintdigits = numericintdigits;
    }

    public void setNumericdecdigits(int numericdecdigits) {
        this.numericdecdigits = numericdecdigits;
    }

    public void setNumericsign(boolean numericsign) {
        this.numericsign = numericsign;
    }

    public void setMaxchars(int maxchars) {
        this.maxchars = maxchars;
    }

    public void setWantreturn(boolean wantreturn) {
        this.wantreturn = wantreturn;
    }

    public void setReadonly(boolean readonly) {
        SwingUtilities.invokeLater(() -> this.textComponent.setEditable(!readonly));
    }

    public void setSelectallongotfocus(boolean selectallongotfocus) {
        this.selectallongotfocus = selectallongotfocus;
    }

    public void copy() {
        this.textComponent.copy();
    }

    public void cut() {
        if (this.textComponent.isEditable()) {
            this.textComponent.cut();
        }
    }

    public void paste() {
        this.intPaste();
    }

    private void intPaste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(this);
        try {
            String clipString = (String)clipData.getTransferData(DataFlavor.stringFlavor);
            if (this.hasSelection()) {
                this.textComponent.replaceSelection(clipString);
            } else {
                this.textComponent.getDocument().insertString(this.textComponent.getCaretPosition(), clipString, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cue) {
                System.err.println(cue);
            }
        }
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public void undoEnd() {
        this.undoManager.end();
    }

    public void setScrollbars(int scrollbars) {
        this.scrollbars = scrollbars;
        if (this.textScrollPane != null) {
            boolean wrap;
            switch (scrollbars) {
                default: {
                    this.textScrollPane.setHorizontalScrollBarPolicy(31);
                    this.textScrollPane.setVerticalScrollBarPolicy(21);
                    wrap = !this.hscrollEnabled;
                    break;
                }
                case 1: {
                    this.textScrollPane.setHorizontalScrollBarPolicy(31);
                    this.textScrollPane.setVerticalScrollBarPolicy(22);
                    wrap = !this.hscrollEnabled;
                    break;
                }
                case 2: {
                    this.textScrollPane.setHorizontalScrollBarPolicy(32);
                    this.textScrollPane.setVerticalScrollBarPolicy(21);
                    wrap = false;
                    break;
                }
                case 3: {
                    this.textScrollPane.setHorizontalScrollBarPolicy(32);
                    this.textScrollPane.setVerticalScrollBarPolicy(22);
                    wrap = false;
                }
            }
            ((MyTextArea)this.textComponent).setLineWrap(wrap);
            ((MyTextArea)this.textComponent).setWrapStyleWord(wrap);
        }
    }

    private boolean checkNumeric(char c, int offs) {
        StringBuilder sb = new StringBuilder(this.textComponent.getText());
        sb.insert(offs, c);
        String str = sb.toString();
        if (str != null && str.length() > 0 && this.numeric && (this.numericintdigits > 0 || this.numericdecdigits > 0 || this.numericsign)) {
            String regex = "";
            if (this.numericsign) {
                regex = "[+-]?";
            }
            regex = regex + "\\d{0," + this.numericintdigits + "}([\\.\\,]\\d{0," + this.numericdecdigits + "})?$";
            return str.matches(regex);
        }
        return true;
    }

    private String checkMaxchars(String str, int len, int strLen) {
        int diff;
        if (this.maxchars > 0 && (diff = len + strLen - this.maxchars) > 0) {
            if (diff < strLen) {
                str = str.substring(0, strLen - diff);
            } else {
                this.fireMaxCharsEvent(str);
                return null;
            }
        }
        return str;
    }

    public void addWowTextListener(WowTextListener tl) {
        if (!this.textListeners.contains(tl)) {
            this.textListeners.addElement(tl);
        }
    }

    public void removeTextListeners(WowTextListener tl) {
        if (this.textListeners.contains(tl)) {
            this.textListeners.removeElement(tl);
        }
    }

    public void fireTextValueChanged() {
        Enumeration en = this.textListeners.elements();
        while (en.hasMoreElements()) {
            ((WowTextListener)en.nextElement()).textChanged();
        }
    }

    public void fireMaxCharsEvent(String str) {
        Enumeration en = this.textListeners.elements();
        while (en.hasMoreElements()) {
            ((WowTextListener)en.nextElement()).inputTerminated(str);
        }
    }

    public void fireMouseClickedOnScroll(boolean vorh) {
        Enumeration en = this.textListeners.elements();
        while (en.hasMoreElements()) {
            ((WowTextListener)en.nextElement()).mouseClickedOnScroll(vorh);
        }
    }

    public String getSelectedText() {
        if (!this.hasSelection()) {
            return "";
        }
        String Return = this.textComponent.getSelectedText();
        if (Return != null) {
            return Return;
        }
        return "";
    }

    public int getSelectionStart() {
        return this.textComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textComponent.getSelectionEnd();
    }

    public boolean hasSelection() {
        return this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd();
    }

    public void selectAll() {
        this.textComponent.selectAll();
    }

    public void select(int begin, int end) {
        this.textComponent.select(begin, end);
    }

    public void replaceSelection(String content) {
        if (content.equals("\n") && !this.wantreturn) {
            return;
        }
        if (!this.hasSelection()) {
            return;
        }
        try {
            this.textComponent.replaceSelection(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLineCount() {
        int Return = 0;
        Return = this.multiline ? ((MyTextArea)this.textComponent).getLineCount() : 1;
        return Return;
    }

    public int getLineOfOffset(int offs) {
        int Return = -1;
        try {
            if (this.multiline && offs > 0) {
                Return = ((MyTextArea)this.textComponent).getLineOfOffset(offs);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return Return;
    }

    public int getLineOffset(int linenum) {
        int Return = -1;
        try {
            if (this.multiline && linenum > 0 && linenum < this.getLineCount()) {
                Return = ((MyTextArea)this.textComponent).getLineStartOffset(linenum);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return Return;
    }

    public int getLineLength(int offs) {
        String linetext;
        int Return = 0;
        if (this.multiline && offs >= 0 && offs >= 0 && (linetext = this.getLine(offs)) != null) {
            Return = linetext.length();
        }
        return Return;
    }

    public String getLine(int idx) {
        String Return = null;
        if (this.multiline && idx < this.getLineCount()) {
            try {
                Document doc = ((MyTextArea)this.textComponent).getDocument();
                Element root = doc.getDefaultRootElement();
                Element element = root.getElement(idx);
                int start = element.getStartOffset();
                int end = element.getEndOffset();
                Return = doc.getText(start, end - start);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
        return Return;
    }

    public int getFirstVisibleLineIndex() {
        int Return = 0;
        if (this.multiline && this.font != null) {
            int y1 = ((MyTextArea)this.textComponent).getVisibleRect().y;
            int lineHeight = ((MyTextArea)this.textComponent).getFontMetrics(this.font).getHeight();
            Return = (int)Math.ceil((double)y1 / (double)lineHeight);
        }
        return Return;
    }

    public void setClientArea(Rectangle clientarea) {
        if (this.multiline) {
            ((MyTextArea)this.textComponent).setBounds(clientarea);
        }
    }

    public Rectangle getClientArea() {
        Rectangle Return = null;
        if (this.multiline) {
            Return = ((MyTextArea)this.textComponent).getBounds();
        }
        if (Return == null) {
            Return = new Rectangle();
        }
        return Return;
    }

    public void scroll(int scrollLines, int scrollColumns) {
        if (this.multiline && scrollLines >= 0 && scrollColumns >= 0 && this.alignment == 2) {
            int offsetstart;
            String textline;
            if (scrollLines > this.getLineCount()) {
                scrollLines = this.getLineCount();
            }
            if ((textline = this.getLine(scrollLines)) != null) {
                if (scrollColumns > textline.length()) {
                    scrollColumns = textline.length();
                }
            } else {
                scrollLines = 0;
                scrollColumns = 0;
            }
            if ((offsetstart = this.getLineOffset(scrollLines)) >= 0) {
                offsetstart += scrollColumns;
                try {
                    Rectangle rect = ((MyTextArea)this.textComponent).modelToView(offsetstart);
                    ((MyTextArea)this.textComponent).scrollRectToVisible(rect);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private static class MyDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        WowEditBox parent;

        MyDocument(WowEditBox parent) {
            this.parent = parent;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.parent != null) {
                this.myinsertString(offs, str, a);
            } else {
                super.insertString(offs, str, a);
            }
        }

        private void myinsertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.parent.numeric && !WowEditBox.isDigit(str.charAt(0), this.parent.numericsign, this.parent.numericdecdigits)) {
                try {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                catch (HeadlessException _ex) {
                    System.err.println(_ex);
                }
            }
            str = ((EditBoxComponent)((Object)this.parent.textComponent)).check(str, offs);
            if (this.parent.multiline && !eol.equals("\n")) {
                String tmptxt = this.parent.textComponent.getText();
                if (offs - 1 >= 0 && tmptxt.lastIndexOf(eol) == offs - 1) {
                    --offs;
                }
            }
            if (str == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            switch (this.parent._case) {
                default: {
                    break;
                }
                case 2: {
                    str = str.toUpperCase();
                    break;
                }
                case 1: {
                    str = str.toLowerCase();
                }
            }
            super.insertString(offs, str, a);
            if (str.equals("\n")) {
                super.remove(offs, str.length());
                super.insertString(offs, str, a);
            }
        }
    }

    private class MyTextArea
    extends JTextArea
    implements EditBoxComponent {
        private MyTextArea() {
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (WowEditBox.this.hscrollEnabled || WowEditBox.this.scrollbars == 2 || WowEditBox.this.scrollbars == 3) {
                return super.getScrollableTracksViewportWidth();
            }
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (WowEditBox.this.vscrollEnabled || WowEditBox.this.scrollbars == 1 || WowEditBox.this.scrollbars == 3) {
                return super.getScrollableTracksViewportHeight();
            }
            return true;
        }

        @Override
        public String check(String str, int offs) {
            int strLen = str.length();
            if (strLen == 0) {
                return str;
            }
            char c = str.charAt(0);
            if (c == '\n' && !WowEditBox.this.wantreturn) {
                return null;
            }
            if (WowEditBox.this.numeric && !Character.isDigit(c) && c != '\n') {
                return null;
            }
            if (!WowEditBox.this.checkNumeric(c, offs)) {
                return null;
            }
            int len = this.getDocument().getLength();
            if ((str = WowEditBox.this.checkMaxchars(str, len, strLen)) == null) {
                return null;
            }
            return str;
        }
    }

    private class MyPasswordField
    extends JPasswordField
    implements EditBoxComponent {
        private MyPasswordField() {
        }

        @Override
        public String check(String str, int offs) {
            int len = this.getDocument().getLength();
            int strLen = str.length();
            if (strLen == 0) {
                return str;
            }
            char c = str.charAt(0);
            if (WowEditBox.this.numeric && !WowEditBox.isDigit(c, WowEditBox.this.numericsign, WowEditBox.this.numericdecdigits)) {
                return null;
            }
            if (!WowEditBox.this.checkNumeric(c, offs)) {
                return null;
            }
            if ((str = WowEditBox.this.checkMaxchars(str, len, strLen)) == null) {
                return null;
            }
            return str;
        }
    }

    private class MyTextField
    extends JTextField
    implements EditBoxComponent {
        private MyTextField() {
        }

        @Override
        public String check(String str, int offs) {
            int strLen = str.length();
            if (strLen == 0) {
                return str;
            }
            int len = this.getDocument().getLength();
            char c = str.charAt(0);
            if (WowEditBox.this.numeric && !WowEditBox.isDigit(c, WowEditBox.this.numericsign, WowEditBox.this.numericdecdigits)) {
                return null;
            }
            if (!WowEditBox.this.checkNumeric(c, offs)) {
                return null;
            }
            if ((str = WowEditBox.this.checkMaxchars(str, len, strLen)) == null) {
                return null;
            }
            return str;
        }
    }

    private static interface EditBoxComponent {
        public String check(String var1, int var2);
    }
}

