/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.RemoteFontComponent;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.RemoteInvocationHandler;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rmi.util.MethodTable;
import com.iscobol.rts.ArrayTable;
import com.iscobol.rts.Factory;
import com.iscobol.rts.RtsUtil;
import com.veryant.wow.WowCsProperty;
import com.veryant.wow.WowSystem;
import com.veryant.wow.gui.Event;
import com.veryant.wow.gui.KeyTable;
import com.veryant.wow.gui.Widget;
import com.veryant.wow.gui.WowGuiFactory;
import com.veryant.wow.gui.client.Focusable;
import com.veryant.wow.gui.client.Initializable;
import com.veryant.wow.gui.client.RemoteActiveX;
import com.veryant.wow.gui.client.RemoteAnimation;
import com.veryant.wow.gui.client.RemoteBitmap;
import com.veryant.wow.gui.client.RemoteButtonComponent;
import com.veryant.wow.gui.client.RemoteCheckBox;
import com.veryant.wow.gui.client.RemoteComboBox;
import com.veryant.wow.gui.client.RemoteCommandButton;
import com.veryant.wow.gui.client.RemoteComponent;
import com.veryant.wow.gui.client.RemoteContainer;
import com.veryant.wow.gui.client.RemoteDateTimePicker;
import com.veryant.wow.gui.client.RemoteEditBox;
import com.veryant.wow.gui.client.RemoteEllipse;
import com.veryant.wow.gui.client.RemoteForm;
import com.veryant.wow.gui.client.RemoteGroupBox;
import com.veryant.wow.gui.client.RemoteHorizontalScroll;
import com.veryant.wow.gui.client.RemoteLine;
import com.veryant.wow.gui.client.RemoteListBox;
import com.veryant.wow.gui.client.RemoteListComponent;
import com.veryant.wow.gui.client.RemoteMenu;
import com.veryant.wow.gui.client.RemoteMonthCalendar;
import com.veryant.wow.gui.client.RemoteOptionButton;
import com.veryant.wow.gui.client.RemoteProgressBar;
import com.veryant.wow.gui.client.RemoteRectangle;
import com.veryant.wow.gui.client.RemoteRoundedRectangle;
import com.veryant.wow.gui.client.RemoteScrollBar;
import com.veryant.wow.gui.client.RemoteStandardComponent;
import com.veryant.wow.gui.client.RemoteStaticText;
import com.veryant.wow.gui.client.RemoteStatusBar;
import com.veryant.wow.gui.client.RemoteTabControl;
import com.veryant.wow.gui.client.RemoteTimer;
import com.veryant.wow.gui.client.RemoteToggleButtonComponent;
import com.veryant.wow.gui.client.RemoteToolBar;
import com.veryant.wow.gui.client.RemoteTrackBar;
import com.veryant.wow.gui.client.RemoteUpDown;
import com.veryant.wow.gui.client.RemoteVerticalScroll;
import com.veryant.wow.gui.client.RemoteWidget;
import com.veryant.wow.gui.client.WowActiveX;
import com.veryant.wow.gui.client.WowMessageBox;
import com.veryant.wow.rmi.RmiDesc;
import com.veryant.wow.rmi.RmiDescList;
import com.veryant.wow.rmi.WowInvocationHandler;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WowGuiFactoryImpl
extends UnicastRemoteObject
implements WowGuiFactory {
    private static ArrayTable objectIds = new ArrayTable();
    private static List<Event> eventList = new ArrayList<Event>();
    private static Map<Integer, Event> lastWidgetEvents = new HashMap<Integer, Event>();
    private static Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private static Map<String, Image[]> imageCache = new HashMap<String, Image[]>();
    private static final KeyTable keyTable = new KeyTable();
    private Logger guilog;
    private AbstractGuiFactoryImpl guiFactory;
    private Image brokenImage;
    private RemoteForm activeWindow;
    private RemoteForm focusedWindow;
    private boolean stripTrailing = true;
    private WowCsProperty csProperty = new WowCsProperty();
    private int waitCursorCounter;
    private List<RemoteForm> windowList = new ArrayList<RemoteForm>();

    public WowGuiFactoryImpl() {
        this(null);
    }

    public WowGuiFactoryImpl(GuiFactory gf) {
        this.guiFactory = (AbstractGuiFactoryImpl)gf;
        this.guilog = LoggerFactory.get((int)512);
    }

    public WowCsProperty getWowCsProperty() {
        return this.csProperty;
    }

    public Logger getGuiLog() {
        return this.guilog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushEvent(Event event) {
        List<Event> list = eventList;
        synchronized (list) {
            eventList.add(event);
            eventList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event popEvent() {
        Event Return = null;
        List<Event> list = eventList;
        synchronized (list) {
            do {
                if (eventList.isEmpty()) {
                    try {
                        eventList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (eventList.isEmpty()) {
                    Return = null;
                    continue;
                }
                Return = eventList.remove(0);
                if (!Return.isKeyStateEvent()) continue;
                int keyCode = keyTable.setKeyState(Return.getEventData());
                Return.setEventData(keyCode);
            } while (Return != null && Return.isDiscarded());
        }
        lastWidgetEvents.put(Return.getWidgetId(), Return);
        return Return;
    }

    @Override
    public void discardEvents() throws IOException {
        this.discardEvents(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardEvents(int eventId) throws IOException {
        List<Event> list = eventList;
        synchronized (list) {
            if (eventId != 0) {
                int i = 0;
                while (i < eventList.size()) {
                    Event e = eventList.get(i);
                    if (e.getEventId() == eventId) {
                        eventList.remove(i);
                        continue;
                    }
                    ++i;
                }
            } else {
                eventList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peekMessage() throws IOException {
        int Return;
        List<Event> list = eventList;
        synchronized (list) {
            Return = eventList.size();
        }
        return Return;
    }

    public static int setId(Object obj) {
        return objectIds.put(obj);
    }

    public static Object getId(int oi) {
        try {
            return objectIds.get(oi);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static void delId(int oi) {
        try {
            objectIds.remove(oi);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public Widget[] createWindow(String formDefinition, int windowStyle, int parentWindow) throws IOException {
        RemoteForm form = this.createForm(formDefinition, windowStyle, parentWindow);
        ArrayList<Widget> result = new ArrayList<Widget>();
        result.add(this.createWidget(form));
        if (form.getTopToolBar() != null) {
            result.add(this.createWidget(form.getTopToolBar()));
        }
        if (form.getBottomToolBar() != null) {
            result.add(this.createWidget(form.getBottomToolBar()));
        }
        if (form.getStatusBar() != null) {
            result.add(this.createWidget(form.getStatusBar()));
        }
        if (form.getMenu() != null) {
            this.addWidgets(result, form.getMenu());
        }
        this.addWidgets(result, form);
        form.show();
        this.windowList.add(form);
        return result.toArray(new Widget[result.size()]);
    }

    private Widget createWidget(RemoteWidget rw) {
        rw.setRemoteWidgetId(WowGuiFactoryImpl.setId(rw));
        return new Widget(rw);
    }

    private void addWidgets(List<Widget> result, RemoteMenu rm) {
        result.add(this.createWidget(rm));
        for (int i = 0; i < rm.getMenuCount(); ++i) {
            if (rm.getMenuAt(i).getMenuCount() <= 0) continue;
            this.addWidgets(result, rm.getMenuAt(i));
        }
    }

    private void addWidgets(List<Widget> result, RemoteContainer cnt) {
        for (int i = 0; i < cnt.getComponentCount(); ++i) {
            RemoteComponent c = cnt.getComponentAt(i);
            result.add(this.createWidget(c));
            if (c instanceof RemoteTabControl) {
                RemoteTabControl rtc = (RemoteTabControl)c;
                for (int j = 0; j < rtc.getTabs(); ++j) {
                    this.addWidgets(result, rtc.getPageAt(j));
                }
                continue;
            }
            if (!(c instanceof RemoteContainer)) continue;
            this.addWidgets(result, (RemoteContainer)((Object)c));
        }
    }

    public RemoteForm createForm(String formDefinition, int windowStyle, int parentWindow) throws IOException {
        try {
            Element formElem = this.openXml(formDefinition);
            if ("form".equals(formElem.getTagName())) {
                RemoteForm form = new RemoteForm(this, (RemoteForm)WowGuiFactoryImpl.getId(parentWindow));
                ElementIterator ei = new ElementIterator(formElem);
                Element propsElem = ei.next();
                if (propsElem != null && "properties".equals(propsElem.getTagName())) {
                    this.setProperties(propsElem, form);
                }
                Element cmpElem = ei.next();
                while (cmpElem != null) {
                    if ("ttoolbar".equals(cmpElem.getTagName())) {
                        form.setTopToolBar(this.createToolBar(cmpElem));
                    } else if ("btoolbar".equals(cmpElem.getTagName())) {
                        form.setBottomToolBar(this.createToolBar(cmpElem));
                    } else if ("statusbar".equals(cmpElem.getTagName())) {
                        form.setStatusBar(this.createStatusBar(cmpElem));
                    } else if ("menu".equals(cmpElem.getTagName())) {
                        form.setMenu(this.createMenu(cmpElem));
                    } else {
                        form.addComponent(this.createComponent(cmpElem));
                    }
                    cmpElem = ei.next();
                }
                return form;
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return null;
    }

    private RemoteMenu createMenu(Element mElem) throws Exception {
        RemoteMenu menu = new RemoteMenu();
        ElementIterator ei = new ElementIterator(mElem);
        Element e = ei.next();
        while (e != null) {
            if ("properties".equals(e.getTagName())) {
                this.setProperties(e, menu);
            } else if ("menu".equals(e.getTagName())) {
                menu.addMenu(this.createMenu(e));
            }
            e = ei.next();
        }
        return menu;
    }

    private RemoteStatusBar createStatusBar(Element sbElem) throws Exception {
        RemoteStatusBar sb = new RemoteStatusBar();
        this.setProperties(sbElem, sb);
        return sb;
    }

    private RemoteToolBar createToolBar(Element tbElem) throws Exception {
        RemoteToolBar tb = new RemoteToolBar();
        this.setProperties(tbElem, tb);
        return tb;
    }

    private RemoteComponent createComponent(Element cmpElem) throws Exception {
        RemoteComponent cmp = null;
        if ("animation".equals(cmpElem.getTagName())) {
            cmp = new RemoteAnimation();
        } else if ("bitmap".equals(cmpElem.getTagName())) {
            cmp = new RemoteBitmap();
        } else if ("monthcalendar".equals(cmpElem.getTagName())) {
            cmp = new RemoteMonthCalendar();
        } else if ("checkbox".equals(cmpElem.getTagName())) {
            cmp = new RemoteCheckBox();
        } else if ("combobox".equals(cmpElem.getTagName())) {
            cmp = new RemoteComboBox();
        } else if ("datetimepicker".equals(cmpElem.getTagName())) {
            cmp = new RemoteDateTimePicker();
        } else if ("ellipse".equals(cmpElem.getTagName())) {
            cmp = new RemoteEllipse();
        } else if ("editbox".equals(cmpElem.getTagName())) {
            cmp = new RemoteEditBox();
        } else if ("groupbox".equals(cmpElem.getTagName())) {
            cmp = new RemoteGroupBox();
        } else if ("hscrollbar".equals(cmpElem.getTagName())) {
            cmp = new RemoteHorizontalScroll();
        } else if ("vscrollbar".equals(cmpElem.getTagName())) {
            cmp = new RemoteVerticalScroll();
        } else if ("statictext".equals(cmpElem.getTagName())) {
            cmp = new RemoteStaticText();
        } else if ("line".equals(cmpElem.getTagName())) {
            cmp = new RemoteLine();
        } else if ("listbox".equals(cmpElem.getTagName())) {
            cmp = new RemoteListBox();
        } else if ("progressbar".equals(cmpElem.getTagName())) {
            cmp = new RemoteProgressBar();
        } else if ("commandbutton".equals(cmpElem.getTagName())) {
            cmp = new RemoteCommandButton();
        } else if ("optionbutton".equals(cmpElem.getTagName())) {
            cmp = new RemoteOptionButton();
        } else if ("rectangle".equals(cmpElem.getTagName())) {
            cmp = new RemoteRectangle();
        } else if ("rrectangle".equals(cmpElem.getTagName())) {
            cmp = new RemoteRoundedRectangle();
        } else if ("trackbar".equals(cmpElem.getTagName())) {
            cmp = new RemoteTrackBar();
        } else if ("tabcontrol".equals(cmpElem.getTagName())) {
            cmp = new RemoteTabControl();
        } else if ("timer".equals(cmpElem.getTagName())) {
            cmp = new RemoteTimer();
        } else if ("updown".equals(cmpElem.getTagName())) {
            cmp = new RemoteUpDown();
        } else if ("activex".equals(cmpElem.getTagName())) {
            cmp = new RemoteActiveX(cmpElem.getAttribute("classname"));
        } else {
            throw new IllegalArgumentException(cmpElem.getTagName());
        }
        if (cmp instanceof RemoteTabControl) {
            ElementIterator ei = new ElementIterator(cmpElem);
            RemoteTabControl rtc = (RemoteTabControl)cmp;
            Element propsElem = ei.next();
            if (propsElem != null && "properties".equals(propsElem.getTagName())) {
                this.setProperties(propsElem, cmp);
            }
            Element pageElem = ei.next();
            while (pageElem != null) {
                if ("tabpage".equals(pageElem.getTagName())) {
                    ElementIterator ei2 = new ElementIterator(pageElem);
                    propsElem = ei2.next();
                    if (propsElem != null && "properties".equals(propsElem.getTagName())) {
                        this.setProperties(propsElem, cmp);
                    }
                    Element cmpElem2 = ei2.next();
                    while (cmpElem2 != null) {
                        rtc.getCurrPage().addComponent(this.createComponent(cmpElem2));
                        cmpElem2 = ei2.next();
                    }
                } else {
                    throw new IllegalArgumentException(cmpElem.getTagName());
                }
                pageElem = ei.next();
            }
            rtc.setInitialized();
        } else if (cmp instanceof RemoteContainer) {
            ElementIterator ei = new ElementIterator(cmpElem);
            RemoteContainer rcnt = (RemoteContainer)((Object)cmp);
            Element propsElem = ei.next();
            if (propsElem != null && "properties".equals(propsElem.getTagName())) {
                this.setProperties(propsElem, cmp);
            }
            Element cmpElem2 = ei.next();
            while (cmpElem2 != null) {
                rcnt.addComponent(this.createComponent(cmpElem2));
                cmpElem2 = ei.next();
            }
        } else {
            this.setProperties(cmpElem, cmp);
        }
        return cmp;
    }

    private void setProperties(Element propsElem, RemoteWidget target) throws Exception {
        ElementIterator ei = new ElementIterator(propsElem);
        Element p = ei.next();
        while (p != null) {
            PropertyDescriptor pd;
            String propName = p.getTagName();
            if (propName.charAt(0) == '_') {
                propName = propName.substring(1);
            }
            if ((pd = WowSystem.getPropertyDescriptor(target.getClass(), propName)) != null) {
                int i;
                String value = this.stripTrailing(p.getTextContent());
                String typeAttr = p.getAttribute("type");
                if ("u".equals(typeAttr)) {
                    StringBuilder sb = new StringBuilder();
                    for (i = 0; i < value.length(); i += 4) {
                        sb.append((char)Integer.parseInt(value.substring(i, i + 4), 16));
                    }
                    value = sb.toString();
                } else if ("h".equals(typeAttr)) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    for (i = 0; i < value.length(); i += 2) {
                        baos.write(Integer.parseInt(value.substring(i, i + 2), 16));
                    }
                    baos.close();
                    value = new String(baos.toByteArray());
                }
                pd.getWriteMethod().invoke((Object)target, WowSystem.convertValue(value, pd.getPropertyType()));
            }
            p = ei.next();
        }
        if (target instanceof Initializable) {
            ((Initializable)((Object)target)).setInitialized();
        }
    }

    private Element openXml(String xml) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = RtsUtil.newDocumentBuilderFactory();
        DocumentBuilder dBuilder = dbf.newDocumentBuilder();
        Document doc = dBuilder.parse(new InputSource(new StringReader(xml)));
        return doc.getDocumentElement();
    }

    @Override
    public int[] destroyWindow(int id) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(id);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (obj instanceof RemoteForm) {
            RemoteForm form = (RemoteForm)obj;
            for (RemoteForm c : form.getChildForms()) {
                ids.add(this.destroyWidget(c));
            }
            if (form.getTopToolBar() != null) {
                ids.add(this.destroyWidget(form.getTopToolBar()));
            }
            if (form.getBottomToolBar() != null) {
                ids.add(this.destroyWidget(form.getBottomToolBar()));
            }
            if (form.getStatusBar() != null) {
                ids.add(this.destroyWidget(form.getStatusBar()));
            }
            if (form.getMenu() != null) {
                ids.add(this.destroyWidget(form.getMenu()));
            }
            this.destroyContainer(form, ids);
            ids.add(this.destroyWidget(form));
            form.getMainWindow().dispose();
            this.windowList.remove(form);
        }
        int[] Return = new int[ids.size()];
        for (int i = 0; i < Return.length; ++i) {
            Return[i] = (Integer)ids.get(i);
        }
        return Return;
    }

    private void destroyContainer(RemoteContainer rc, List<Integer> ids) {
        for (int i = 0; i < rc.getComponentCount(); ++i) {
            RemoteComponent cmp = rc.getComponentAt(i);
            if (cmp instanceof RemoteTabControl) {
                RemoteTabControl rtc = (RemoteTabControl)cmp;
                for (int p = 0; p < rtc.getTabs(); ++p) {
                    this.destroyContainer(rtc.getPageAt(p), ids);
                }
            } else if (cmp instanceof RemoteContainer) {
                this.destroyContainer((RemoteContainer)((Object)cmp), ids);
            }
            ids.add(this.destroyWidget(cmp));
        }
    }

    private int destroyWidget(RemoteWidget rw) {
        int id = rw.getRemoteWidgetId();
        rw.dispose();
        WowGuiFactoryImpl.delId(id);
        return id;
    }

    @Override
    public Event getMessage() throws IOException {
        Event e;
        while (!this.checkFocusOwner(e = WowGuiFactoryImpl.popEvent())) {
        }
        return e;
    }

    private boolean checkFocusOwner(Event e) {
        if (e != null && e.getEventId() == 1 && e.getEventData() != 3) {
            Object c = WowGuiFactoryImpl.getId(e.getWidgetId());
            Focusable fo = this.getFocusOwnerComponent();
            return fo == null || fo == c || !(c instanceof Focusable);
        }
        return true;
    }

    @Override
    public String getIndexProp(int id, String propName, int index) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        if (target instanceof RemoteWidget) {
            RemoteWidget rw = (RemoteWidget)target;
            return rw.getIndexProp(propName, index);
        }
        return null;
    }

    @Override
    public String[] getProp(int[] id, String[] propNames) throws IOException {
        String[] propValues = new String[propNames.length];
        for (int i = 0; i < id.length; ++i) {
            propValues[i] = this.getProp(id[i], new String[]{propNames[i]})[0];
        }
        return propValues;
    }

    @Override
    public String[] getProp(int id, String[] propNames) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        String[] propValues = new String[propNames.length];
        if (target instanceof RemoteWidget) {
            RemoteWidget rw = (RemoteWidget)target;
            for (int i = 0; i < propNames.length; ++i) {
                propValues[i] = rw.getProp(propNames[i]);
            }
        }
        return propValues;
    }

    @Override
    public void setProp(int[] id, String[] propNames, String[] propValues) throws IOException {
        for (int i = 0; i < id.length; ++i) {
            this.setProp(id[i], new String[]{propNames[i]}, new String[]{propValues[i]});
        }
    }

    @Override
    public void setProp(int id, String[] propNames, String[] propValues) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        if (target instanceof RemoteWidget) {
            RemoteWidget rw = (RemoteWidget)target;
            for (int i = 0; i < propNames.length; ++i) {
                rw.setProp(propNames[i], this.stripTrailing(propValues[i]));
            }
        }
    }

    @Override
    public void setIndexProp(int id, String propName, String propValue, int index) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        if (target instanceof RemoteWidget) {
            RemoteWidget rw = (RemoteWidget)target;
            rw.setIndexProp(propName, index, this.stripTrailing(propValue));
        }
    }

    public Dimension _getScreenSize() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (HeadlessException he) {
            return null;
        }
    }

    public Insets _getScreenInsets() {
        try {
            return Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        }
        catch (HeadlessException ex) {
            return null;
        }
    }

    @Override
    public int checkMenuItem(int menuClientId, int menuId, boolean checked, boolean byPosition) throws IOException {
        Object target = WowGuiFactoryImpl.getId(menuClientId);
        if (!(target instanceof RemoteMenu)) {
            return -1;
        }
        RemoteMenu item = this.findMenuItem((RemoteMenu)target, menuId, byPosition);
        if (item != null) {
            int Return = item.isChecked() ? 1 : 0;
            item.setChecked(checked);
            return Return;
        }
        return -1;
    }

    @Override
    public int[] deleteMenu(int menuClientId, int menuId, boolean byPosition) throws IOException {
        Object target = WowGuiFactoryImpl.getId(menuClientId);
        if (!(target instanceof RemoteMenu)) {
            return null;
        }
        RemoteMenu menu = (RemoteMenu)target;
        RemoteMenu item = this.findMenuItem(menu, menuId, byPosition);
        if (item != null) {
            menu.removeMenu(item);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            if (item.getRemoteWidgetId() >= 0) {
                this.destroyMenu(ids, item);
                int[] Return = new int[ids.size()];
                for (int i = 0; i < Return.length; ++i) {
                    Return[i] = (Integer)ids.get(i);
                }
                return Return;
            }
            return new int[]{-1};
        }
        return new int[0];
    }

    private void destroyMenu(List<Integer> ids, RemoteMenu menu) {
        ids.add(this.destroyWidget(menu));
        for (int i = 0; i < menu.getMenuCount(); ++i) {
            if (menu.getMenuAt(i).getRemoteWidgetId() < 0) continue;
            this.destroyMenu(ids, menu.getMenuAt(i));
        }
    }

    private RemoteMenu findMenuItem(RemoteMenu menu, int menuId, boolean byPosition) {
        RemoteMenu item = null;
        if (byPosition) {
            if (menuId < menu.getMenuCount()) {
                item = menu.getMenuAt(menuId);
            }
        } else {
            for (int i = 0; i < menu.getMenuCount() && item == null; ++i) {
                if (menu.getMenuAt(i).getMenuid() != menuId) continue;
                item = menu.getMenuAt(i);
            }
        }
        return item;
    }

    @Override
    public void drawMenuBar(int windowId) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(windowId);
        if (obj instanceof RemoteForm) {
            // empty if block
        }
    }

    @Override
    public int enableMenuItem(int menuClientId, int menuId, int enableState, boolean byPosition) throws IOException {
        Object target = WowGuiFactoryImpl.getId(menuClientId);
        if (!(target instanceof RemoteMenu)) {
            return -1;
        }
        RemoteMenu item = this.findMenuItem((RemoteMenu)target, menuId, byPosition);
        if (item != null) {
            int Return = item.isEnabled() ? 1 : 0;
            item.setEnabled(enableState == 0);
            item.setGrayed(enableState == 2);
            return Return;
        }
        return -1;
    }

    @Override
    public int getMenu(int windowId) throws IOException {
        Object target = WowGuiFactoryImpl.getId(windowId);
        if (target instanceof RemoteForm) {
            RemoteMenu menu = ((RemoteForm)target).getMenu();
            return menu != null ? menu.getRemoteWidgetId() : -1;
        }
        return -1;
    }

    @Override
    public int getSubMenu(int menuId, int pos) throws IOException {
        RemoteMenu menu;
        Object target = WowGuiFactoryImpl.getId(menuId);
        if (target instanceof RemoteMenu && pos < (menu = (RemoteMenu)target).getMenuCount()) {
            return menu.getMenuAt(pos).getRemoteWidgetId();
        }
        return -1;
    }

    private Image getBrokenImage() {
        if (this.brokenImage == null) {
            this.brokenImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("broken.png"));
        }
        return this.brokenImage;
    }

    protected Image getLocalImage(int imageId) {
        if (this.guiFactory == null) {
            return null;
        }
        Image Return = null;
        LocalImage lim = null;
        try {
            lim = (LocalImage)this.guiFactory.getClient().getId(imageId);
        }
        catch (ClassCastException cce) {
            lim = null;
        }
        if (lim != null) {
            Return = lim.getImage();
        } else if (imageId > 0) {
            Return = this.getBrokenImage();
        }
        return Return;
    }

    @Override
    public int modifyMenu(int menuClientId, int menuId, boolean byPosition, String item, int menuAppearance, boolean checked, int enableState, int menuBreak, boolean separator, boolean popup) throws IOException {
        Object target = WowGuiFactoryImpl.getId(menuClientId);
        if (!(target instanceof RemoteMenu)) {
            return -1;
        }
        RemoteMenu menuItem = this.findMenuItem((RemoteMenu)target, menuId, byPosition);
        int ret = -1;
        if (menuItem != null) {
            menuItem.setChecked(checked);
            menuItem.setEnabled(enableState == 0);
            menuItem.setGrayed(enableState == 2);
            menuItem.setSeparator(separator);
            if (menuAppearance == 1) {
                menuItem.setImage(this.getLocalImage(WowSystem.getInt(item)));
            } else {
                menuItem.setTitle(item);
            }
            ret = popup ? menuItem.getRemoteWidgetId() : menuItem.getMenuid();
        }
        return ret;
    }

    @Override
    public int setWindowState(int windowId, int state) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(windowId);
        if (obj instanceof RemoteForm) {
            RemoteForm form = (RemoteForm)obj;
            form.setShowstate(state);
            return 1;
        }
        return 0;
    }

    @Override
    public int setWindowEnabled(int id, boolean enabled) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(id);
        int Return = 0;
        if (obj instanceof RemoteForm) {
            RemoteForm form = (RemoteForm)obj;
            if (!form.isEnabled()) {
                Return = 1;
                if (enabled) {
                    form.pushEvent(10, 0);
                }
            }
            form.setEnabled(enabled);
        } else if (obj instanceof RemoteStandardComponent) {
            RemoteStandardComponent cmp = (RemoteStandardComponent)obj;
            if (!cmp.isEnabled()) {
                Return = 1;
            }
            cmp.setEnabled(enabled);
        }
        return Return;
    }

    @Override
    public int findWindow(int[] windowIds, String className, String title) throws IOException {
        for (int i = 0; i < windowIds.length; ++i) {
            Object obj = WowGuiFactoryImpl.getId(windowIds[i]);
            if (!(obj instanceof RemoteForm) || !title.equals(((RemoteForm)obj).getTitle())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getActiveWindow() throws IOException {
        return this.activeWindow != null ? this.activeWindow.getRemoteWidgetId() : -1;
    }

    public Focusable getFocusOwnerComponent() {
        return this.focusedWindow != null ? this.focusedWindow.getFocusOwner() : null;
    }

    @Override
    public int getFocusOwner() throws IOException {
        Focusable fo = this.getFocusOwnerComponent();
        return fo != null ? fo.getRemoteWidgetId() : -1;
    }

    @Override
    public int setFocusOwner(int controlId) throws IOException {
        Focusable newFocusOwner;
        int Return = 0;
        Object obj = WowGuiFactoryImpl.getId(controlId);
        if (obj instanceof Focusable && (newFocusOwner = (Focusable)obj).isEnabled() && newFocusOwner.isVisible()) {
            newFocusOwner.requestFocus();
            if (this.focusedWindow != null && this.focusedWindow.getFocusOwner() != null) {
                Return = this.focusedWindow.getFocusOwner().getRemoteWidgetId();
            }
        }
        return Return;
    }

    public void setFocusedWindow(RemoteForm form) {
        form.requestFocus();
    }

    public void setActiveWindow(RemoteForm form) {
        form.activate();
    }

    public void setAsFocusedWindow(RemoteForm form) {
        this.focusedWindow = form;
    }

    public void setAsActiveWindow(RemoteForm form) {
        this.activeWindow = form;
    }

    @Override
    public int[] getCursorPos() throws IOException {
        Point p = MouseInfo.getPointerInfo().getLocation();
        return new int[]{p.x, p.y};
    }

    @Override
    public boolean isChild(int parentId, int childId) throws IOException {
        Object p = WowGuiFactoryImpl.getId(parentId);
        if (!(p instanceof RemoteWidget)) {
            return false;
        }
        RemoteWidget parent = (RemoteWidget)p;
        Object c = WowGuiFactoryImpl.getId(childId);
        if (!(c instanceof RemoteWidget)) {
            return false;
        }
        RemoteWidget child = (RemoteWidget)c;
        for (RemoteWidget par = child.getParent(); par != null; par = par.getParent()) {
            if (par != parent) continue;
            return true;
        }
        return false;
    }

    @Override
    public void alert(int alertLevel) throws IOException {
        String alertSound = null;
        switch (alertLevel) {
            case 0: {
                alertSound = "win.sound.asterisk";
                break;
            }
            case 1: {
                alertSound = "win.sound.exclamation";
                break;
            }
            case 2: {
                alertSound = "win.sound.hand";
                break;
            }
            case 3: {
                alertSound = "win.sound.question";
                break;
            }
            case 4: {
                alertSound = "win.sound.default";
            }
        }
        if (alertSound != null) {
            Runnable runnable = (Runnable)Toolkit.getDefaultToolkit().getDesktopProperty(alertSound);
            if (runnable != null) {
                runnable.run();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public int showMessageBox(int parentWindowId, String message, String title, int modalType, int messageType, int optionType, int defaultSelection) throws IOException {
        int sel;
        String[] labels;
        String icon;
        Window par = null;
        Object wnd = WowGuiFactoryImpl.getId(parentWindowId);
        if (wnd instanceof RemoteForm) {
            par = ((RemoteForm)wnd).getMainWindow().getWindow();
        }
        switch (messageType) {
            default: {
                icon = "Inform.gif";
                break;
            }
            case 1: {
                icon = "Warn.gif";
                break;
            }
            case 4: {
                icon = "Question.gif";
                break;
            }
            case 2: 
            case 5: {
                icon = "Error.gif";
            }
        }
        switch (optionType) {
            default: {
                labels = new String[]{Factory.getSysMsg((String)"msg_ok")};
                break;
            }
            case 1: {
                labels = new String[]{Factory.getSysMsg((String)"msg_ok"), Factory.getSysMsg((String)"msg_cancel")};
                break;
            }
            case 2: {
                labels = new String[]{Factory.getSysMsg((String)"msg_retry"), Factory.getSysMsg((String)"msg_cancel")};
                break;
            }
            case 3: {
                labels = new String[]{Factory.getSysMsg((String)"msg_yes"), Factory.getSysMsg((String)"msg_no")};
                break;
            }
            case 4: {
                labels = new String[]{Factory.getSysMsg((String)"msg_yes"), Factory.getSysMsg((String)"msg_no"), Factory.getSysMsg((String)"msg_cancel")};
                break;
            }
            case 5: {
                labels = new String[]{Factory.getSysMsg((String)"msg_abort"), Factory.getSysMsg((String)"msg_retry"), Factory.getSysMsg((String)"msg_ignore")};
            }
        }
        switch (defaultSelection) {
            default: {
                sel = 0;
                break;
            }
            case 1: {
                sel = labels.length > 1 ? 1 : 0;
                break;
            }
            case 2: {
                sel = labels.length > 2 ? 2 : 0;
            }
        }
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = labels[i].replace("&", "");
        }
        int ret = WowMessageBox.showMessageDialog(par, title, this.stripTrailing(message), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.guiFactory.getClass().getResource(icon))), labels, sel);
        this.discardEvents(1);
        switch (ret) {
            default: {
                return 2;
            }
            case 0: {
                switch (optionType) {
                    default: {
                        return 1;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: 
                    case 4: {
                        return 6;
                    }
                    case 5: 
                }
                return 3;
            }
            case 1: {
                switch (optionType) {
                    default: {
                        return 2;
                    }
                    case 3: 
                    case 4: {
                        return 7;
                    }
                    case 5: 
                }
                return 4;
            }
            case 2: 
        }
        switch (optionType) {
            default: {
                return 2;
            }
            case 5: 
        }
        return 5;
    }

    @Override
    public String sendMessage(int widgetId, int messageId, String ... params) throws IOException {
        RemoteWidget rw = (RemoteWidget)WowGuiFactoryImpl.getId(widgetId);
        if (rw == null) {
            return "0";
        }
        switch (messageId) {
            default: {
                return "0";
            }
            case 1124: {
                if (rw instanceof RemoteAnimation && params.length >= 2) {
                    return ((RemoteAnimation)rw).open(params[1]) ? "1" : "0";
                }
                return "0";
            }
            case 1125: {
                if (rw instanceof RemoteAnimation && params.length >= 3) {
                    try {
                        ((RemoteAnimation)rw).play(WowSystem.getInt(params[0]), WowSystem.getInt(params[1]), WowSystem.getInt(params[2]));
                        return "1";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return "0";
                    }
                }
                return "0";
            }
            case 1126: {
                if (rw instanceof RemoteAnimation) {
                    ((RemoteAnimation)rw).stop();
                    return "1";
                }
                return "0";
            }
            case 240: {
                if (rw instanceof RemoteToggleButtonComponent) {
                    return Integer.toString(((RemoteToggleButtonComponent)rw).getValue());
                }
                return "-1";
            }
            case 242: {
                if (rw instanceof RemoteButtonComponent) {
                    int ret = 0;
                    if (rw instanceof RemoteToggleButtonComponent && ((RemoteToggleButtonComponent)rw).getValue() > 0) {
                        ++ret;
                    }
                    if (rw.getParentForm().getFocusOwner() == rw) {
                        ret += 4;
                    }
                    if (((RemoteButtonComponent)rw).isPushed()) {
                        ret += 8;
                    }
                    return Integer.toString(ret);
                }
                return "-1";
            }
            case 241: {
                if (rw instanceof RemoteToggleButtonComponent && params.length > 0) {
                    ((RemoteToggleButtonComponent)rw).setValue(WowSystem.getInt(params[0]));
                }
                return "0";
            }
            case 243: {
                if (rw instanceof RemoteButtonComponent) {
                    // empty if block
                }
                return "0";
            }
            case 244: {
                if (rw instanceof RemoteButtonComponent && params.length > 0) {
                    if (rw instanceof RemoteCheckBox) {
                        ((RemoteCheckBox)rw).setAutocheck(WowSystem.isTrue(params[0], 38));
                        ((RemoteCheckBox)rw).setThreestate(WowSystem.isTrue(params[0], 40));
                    } else if (rw instanceof RemoteOptionButton) {
                        ((RemoteOptionButton)rw).setAutopress(WowSystem.isTrue(params[0], 44));
                    }
                }
                return "0";
            }
            case 323: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    return Integer.toString(((RemoteComboBox)rw).addItem(this.stripTrailing(params[1])));
                }
                return "-1";
            }
            case 324: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    return ((RemoteComboBox)rw).removeItemAt(WowSystem.getInt(params[0])) ? Integer.toString(((RemoteComboBox)rw).getCount()) : "-1";
                }
                return "-1";
            }
            case 325: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    RemoteComboBox cb = (RemoteComboBox)rw;
                    String[] files = WowSystem.getFiles(this.stripTrailing(params[1]), params[0]);
                    int ret = -1;
                    for (String f : files) {
                        ret = cb.addItem(f);
                    }
                    return Integer.toString(ret);
                }
                return "-1";
            }
            case 332: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    return Integer.toString(((RemoteComboBox)rw).indexOf(this.stripTrailing(params[1]), WowSystem.getInt(params[0]), false));
                }
                return "-1";
            }
            case 344: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    return Integer.toString(((RemoteComboBox)rw).indexOf(this.stripTrailing(params[1]), WowSystem.getInt(params[0]), true));
                }
                return "-1";
            }
            case 326: {
                if (rw instanceof RemoteComboBox) {
                    return Integer.toString(((RemoteComboBox)rw).getCount());
                }
                return "-1";
            }
            case 327: {
                if (rw instanceof RemoteComboBox) {
                    return Integer.toString(((RemoteComboBox)rw).getCursel());
                }
                return "-1";
            }
            case 338: {
                if (rw instanceof RemoteComboBox) {
                    return WowGuiFactoryImpl.getRectString(((RemoteComboBox)rw).getDropDownRectangle());
                }
                return "0";
            }
            case 343: {
                if (rw instanceof RemoteComboBox) {
                    return ((RemoteComboBox)rw).isPopupvisible() ? "1" : "0";
                }
                return "0";
            }
            case 320: {
                if (rw instanceof RemoteComboBox) {
                    long selStart = ((RemoteComboBox)rw).getEditSelectionStart();
                    long selEnd = ((RemoteComboBox)rw).getEditSelectionEnd();
                    long ret = selStart + (selEnd << 32);
                    return Long.toString(ret);
                }
                return "0";
            }
            case 342: {
                if (rw instanceof RemoteComboBox) {
                    return "1";
                }
                return "0";
            }
            case 340: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    return Integer.toString(((RemoteComboBox)rw).getItemheight(WowSystem.getInt(params[0])));
                }
                return "-1";
            }
            case 328: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    return ((RemoteComboBox)rw).getItemAt(WowSystem.getInt(params[0]));
                }
                return "-1";
            }
            case 329: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    String s = ((RemoteComboBox)rw).getItemAt(WowSystem.getInt(params[0]));
                    return Integer.toString(s != null ? s.length() : -1);
                }
                return "-1";
            }
            case 330: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    return Integer.toString(((RemoteComboBox)rw).addItem(WowSystem.getInt(params[0]), this.stripTrailing(params[1])));
                }
                return "-1";
            }
            case 321: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    if (((RemoteComboBox)rw).getStyle() != 2) {
                        ((RemoteComboBox)rw).setMaxtext(WowSystem.getInt(params[0]));
                        return "0";
                    }
                    return "-1";
                }
                return "-1";
            }
            case 331: {
                if (rw instanceof RemoteComboBox) {
                    ((RemoteComboBox)rw).removeAllItems();
                }
                return "0";
            }
            case 333: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    int idx = ((RemoteComboBox)rw).indexOf(this.stripTrailing(params[1]), WowSystem.getInt(params[0]), false);
                    if (idx >= 0) {
                        ((RemoteComboBox)rw).setCursel(idx, false);
                    }
                    return Integer.toString(idx);
                }
                return "-1";
            }
            case 334: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    int idx = WowSystem.getInt(params[0]);
                    if (idx >= 0 && idx < ((RemoteComboBox)rw).getCount()) {
                        ((RemoteComboBox)rw).setCursel(idx);
                        return Integer.toString(idx);
                    }
                    return "-1";
                }
                return "-1";
            }
            case 322: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    if (((RemoteComboBox)rw).getStyle() != 2) {
                        ((RemoteComboBox)rw).setEditSelection(WowSystem.getInt(params[0]), WowSystem.getInt(params[1]));
                        return "1";
                    }
                    return "-1";
                }
                return "-1";
            }
            case 341: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    return "0";
                }
                return "-1";
            }
            case 339: {
                if (rw instanceof RemoteComboBox && params.length >= 2) {
                    ((RemoteComboBox)rw).setItemheight(WowSystem.getInt(params[1]));
                    return "0";
                }
                return "-1";
            }
            case 335: {
                if (rw instanceof RemoteComboBox && params.length >= 1) {
                    ((RemoteComboBox)rw).setPopupvisible(WowSystem.getInt(params[0]) != 0);
                    return "0";
                }
                return "-1";
            }
            case 198: 
            case 772: {
                if (rw instanceof RemoteEditBox && ((RemoteEditBox)rw).canUndo()) {
                    return "1";
                }
                return "0";
            }
            case 205: {
                if (rw instanceof RemoteEditBox) {
                    ((RemoteEditBox)rw).emptyUndoBuffer();
                }
                return "0";
            }
            case 200: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    ((RemoteEditBox)rw).setFmtlines(WowSystem.getInt(params[0]) == 1);
                    return params[0];
                }
                return "0";
            }
            case 206: {
                if (rw instanceof RemoteEditBox) {
                    return Integer.toString(((RemoteEditBox)rw).getFirstVisibleLineIndex());
                }
                return "-1";
            }
            case 196: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    return ((RemoteEditBox)rw).getLine(WowSystem.getInt(params[0]));
                }
                return "";
            }
            case 186: {
                if (rw instanceof RemoteEditBox) {
                    return Integer.toString(((RemoteEditBox)rw).getLineCount());
                }
                return "1";
            }
            case 184: {
                if (rw instanceof RemoteEditBox && ((RemoteEditBox)rw).isModify()) {
                    return "1";
                }
                return "0";
            }
            case 210: {
                if (rw instanceof RemoteEditBox) {
                    return "" + ((RemoteEditBox)rw).getPasswordchar();
                }
                return "0";
            }
            case 178: {
                if (rw instanceof RemoteEditBox) {
                    return WowGuiFactoryImpl.getRectString(((RemoteEditBox)rw).getClientarea());
                }
                return "0";
            }
            case 176: {
                if (rw instanceof RemoteEditBox) {
                    long selStart = ((RemoteEditBox)rw).getSelectionStart();
                    long selEnd = ((RemoteEditBox)rw).getSelectionEnd();
                    long ret = selStart + (selEnd << 32);
                    return Long.toString(ret);
                }
                return "0";
            }
            case 197: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    ((RemoteEditBox)rw).setMaxchars(WowSystem.getInt(params[0]));
                }
                return "0";
            }
            case 201: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    return Integer.toString(((RemoteEditBox)rw).getLineOfOffset(WowSystem.getInt(params[0])));
                }
                return "-1";
            }
            case 187: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    return Integer.toString(((RemoteEditBox)rw).getLineOffset(WowSystem.getInt(params[0])));
                }
                return "-1";
            }
            case 193: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    return Integer.toString(((RemoteEditBox)rw).getLineLength(WowSystem.getInt(params[0])));
                }
                return "-1";
            }
            case 182: {
                if (rw instanceof RemoteEditBox && params.length > 1) {
                    ((RemoteEditBox)rw).scroll(WowSystem.getInt(params[0]), WowSystem.getInt(params[1]));
                    return ((RemoteEditBox)rw).isMultiline() ? "1" : "0";
                }
                return "-1";
            }
            case 194: {
                if (rw instanceof RemoteEditBox && params.length > 1) {
                    ((RemoteEditBox)rw).replaceSelection(params[1]);
                }
                return "0";
            }
            case 185: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    ((RemoteEditBox)rw).setModify(WowSystem.getInt(params[0]) == 1);
                }
                return "0";
            }
            case 204: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    ((RemoteEditBox)rw).setPasswordchar(params[0]);
                    return "1";
                }
                return "0";
            }
            case 207: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    ((RemoteEditBox)rw).setReadonly(WowSystem.getInt(params[0]) == 1);
                    return "1";
                }
                return "0";
            }
            case 179: 
            case 180: {
                if (rw instanceof RemoteEditBox && params.length > 0) {
                    ((RemoteEditBox)rw).setClientarea(WowGuiFactoryImpl.getRect(params[0]));
                }
                return "0";
            }
            case 177: {
                if (rw instanceof RemoteEditBox && params.length > 1) {
                    int start = WowSystem.getInt(params[0]);
                    int end = WowSystem.getInt(params[1]);
                    RemoteEditBox eb = (RemoteEditBox)rw;
                    if (start == 0 && end == -1) {
                        eb.selectAll();
                    } else {
                        eb.setSelection(start, end);
                    }
                    return "1";
                }
                return "0";
            }
            case 203: {
                if (rw instanceof RemoteEditBox && params.length >= 2) {
                    ((RemoteEditBox)rw).setTabstops(this.stripTrailing(params[1]));
                    return "0";
                }
                return "-1";
            }
            case 199: {
                if (rw instanceof RemoteEditBox) {
                    ((RemoteEditBox)rw).undo();
                    return "1";
                }
                return "0";
            }
            case 384: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    return Integer.toString(((RemoteListBox)rw).addItem(this.stripTrailing(params[1])));
                }
                return "-1";
            }
            case 386: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    return ((RemoteListBox)rw).removeItemAt(WowSystem.getInt(params[0])) ? Integer.toString(((RemoteListBox)rw).getCount()) : "-1";
                }
                return "-1";
            }
            case 397: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    RemoteListBox lb = (RemoteListBox)rw;
                    String[] files = WowSystem.getFiles(this.stripTrailing(params[1]), params[0]);
                    int ret = -1;
                    for (String f : files) {
                        ret = lb.addItem(f);
                    }
                    return Integer.toString(ret);
                }
                return "-1";
            }
            case 399: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    return Integer.toString(((RemoteListBox)rw).indexOf(this.stripTrailing(params[1]), WowSystem.getInt(params[0]), false));
                }
                return "-1";
            }
            case 418: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    return Integer.toString(((RemoteListBox)rw).indexOf(this.stripTrailing(params[1]), WowSystem.getInt(params[0]), true));
                }
                return "-1";
            }
            case 392: 
            case 415: {
                if (rw instanceof RemoteListBox) {
                    return Integer.toString(((RemoteListBox)rw).getCursel());
                }
                return "-1";
            }
            case 395: {
                if (rw instanceof RemoteListBox) {
                    return Integer.toString(((RemoteListBox)rw).getCount());
                }
                return "-1";
            }
            case 403: {
                if (rw instanceof RemoteListBox) {
                    return Integer.toString(((RemoteListBox)rw).getHorizontalextent());
                }
                return "-1";
            }
            case 417: {
                if (rw instanceof RemoteListBox) {
                    return Integer.toString(((RemoteListBox)rw).getItemheight());
                }
                return "-1";
            }
            case 408: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    return WowGuiFactoryImpl.getRectString(((RemoteListBox)rw).getItemBounds(WowSystem.getInt(params[0])));
                }
                return "-1";
            }
            case 391: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    return ((RemoteListBox)rw).isItemSelected(WowSystem.getInt(params[0])) ? "1" : "0";
                }
                return "-1";
            }
            case 400: {
                if (rw instanceof RemoteListBox && !((RemoteListBox)rw).isSinglesel()) {
                    return Integer.toString(((RemoteListBox)rw).getSelectionCount());
                }
                return "-1";
            }
            case 401: {
                if (rw instanceof RemoteListBox && !((RemoteListBox)rw).isSinglesel()) {
                    return WowGuiFactoryImpl.getIntArrayString(((RemoteListBox)rw).getSelectionIndices());
                }
                return "-1";
            }
            case 393: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    return ((RemoteListBox)rw).getItemAt(WowSystem.getInt(params[0]));
                }
                return "-1";
            }
            case 394: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    String s = ((RemoteListBox)rw).getItemAt(WowSystem.getInt(params[0]));
                    return Integer.toString(s != null ? s.length() : -1);
                }
                return "-1";
            }
            case 398: {
                if (rw instanceof RemoteListBox) {
                    return Integer.toString(((RemoteListBox)rw).getTopindex());
                }
                return "-1";
            }
            case 385: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    return Integer.toString(((RemoteListBox)rw).addItem(WowSystem.getInt(params[0]), this.stripTrailing(params[1])));
                }
                return "-1";
            }
            case 388: {
                if (rw instanceof RemoteListBox) {
                    ((RemoteListBox)rw).removeAllItems();
                }
                return "0";
            }
            case 396: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    int idx = ((RemoteListBox)rw).indexOf(this.stripTrailing(params[1]), WowSystem.getInt(params[0]), false);
                    if (idx >= 0) {
                        ((RemoteListBox)rw).setCursel(idx, false);
                    }
                    return Integer.toString(idx);
                }
                return "-1";
            }
            case 411: {
                if (rw instanceof RemoteListBox && params.length >= 3) {
                    ((RemoteListBox)rw).setItemsSelected(WowSystem.getInt(params[1]), WowSystem.getInt(params[2]), WowSystem.getInt(params[0]) != 0);
                    return "0";
                }
                return "-1";
            }
            case 414: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    ((RemoteListBox)rw).setCaretIndex(WowSystem.getInt(params[0]));
                    return "0";
                }
                return "-1";
            }
            case 405: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    ((RemoteListBox)rw).setColumnwidth(WowSystem.getInt(params[0]));
                    return "0";
                }
                return "-1";
            }
            case 390: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    int idx = WowSystem.getInt(params[0]);
                    if (idx >= 0 && idx < ((RemoteListBox)rw).getCount()) {
                        ((RemoteListBox)rw).setCursel(idx, false);
                        return Integer.toString(idx);
                    }
                    return "-1";
                }
                return "-1";
            }
            case 404: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    ((RemoteListBox)rw).setHorizontalextent(WowSystem.getInt(params[0]));
                    return "0";
                }
                return "-1";
            }
            case 416: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    ((RemoteListBox)rw).setItemheight(WowSystem.getInt(params[1]));
                    return "0";
                }
                return "-1";
            }
            case 389: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    ((RemoteListBox)rw).setItemSelected(WowSystem.getInt(params[1]), WowSystem.getInt(params[0]) != 0);
                    return "0";
                }
                return "-1";
            }
            case 402: {
                if (rw instanceof RemoteListBox && params.length >= 2) {
                    ((RemoteListBox)rw).setTabstops(this.stripTrailing(params[1]));
                    return "0";
                }
                return "-1";
            }
            case 407: {
                if (rw instanceof RemoteListBox && params.length >= 1) {
                    ((RemoteListBox)rw).setTopindex(WowSystem.getInt(params[0]));
                    return "0";
                }
                return "-1";
            }
            case 1027: {
                if (rw instanceof RemoteProgressBar && params.length > 0) {
                    int oldVal = ((RemoteProgressBar)rw).getValue();
                    ((RemoteProgressBar)rw).increment(WowSystem.getInt(params[0]));
                    return Integer.toString(oldVal);
                }
                return "0";
            }
            case 1026: {
                if (rw instanceof RemoteProgressBar && params.length > 0) {
                    int oldVal = ((RemoteProgressBar)rw).getValue();
                    ((RemoteProgressBar)rw).setValue(WowSystem.getInt(params[0]));
                    return Integer.toString(oldVal);
                }
                return "0";
            }
            case 1025: 
            case 1030: {
                if (rw instanceof RemoteProgressBar && params.length > 1) {
                    int oldVal = ((RemoteProgressBar)rw).getValue();
                    ((RemoteProgressBar)rw).setMaximum(WowSystem.getInt(params[0]));
                    ((RemoteProgressBar)rw).setMinimum(WowSystem.getInt(params[1]));
                    return Integer.toString(oldVal);
                }
                return "0";
            }
            case 1028: {
                if (rw instanceof RemoteProgressBar && params.length > 0) {
                    int oldVal = ((RemoteProgressBar)rw).getValue();
                    ((RemoteProgressBar)rw).setIncrement(WowSystem.getInt(params[0]));
                    return Integer.toString(oldVal);
                }
                return "0";
            }
            case 1029: {
                if (rw instanceof RemoteProgressBar) {
                    int oldVal = ((RemoteProgressBar)rw).getValue();
                    ((RemoteProgressBar)rw).increment();
                    return Integer.toString(oldVal);
                }
                return "0";
            }
            case 771: {
                if (rw instanceof RemoteEditBox) {
                    ((RemoteEditBox)rw).clearSelection();
                    return "1";
                }
                if (rw instanceof RemoteComboBox) {
                    ((RemoteComboBox)rw).clearSelection();
                    return "1";
                }
                return "0";
            }
            case 769: {
                if (rw instanceof RemoteEditBox) {
                    ((RemoteEditBox)rw).copy();
                    return "1";
                }
                if (rw instanceof RemoteComboBox) {
                    ((RemoteComboBox)rw).copy();
                    return "1";
                }
                return "0";
            }
            case 768: {
                if (rw instanceof RemoteEditBox) {
                    ((RemoteEditBox)rw).cut();
                    return "1";
                }
                if (rw instanceof RemoteComboBox) {
                    ((RemoteComboBox)rw).cut();
                    return "1";
                }
                return "0";
            }
            case 770: {
                if (rw instanceof RemoteEditBox) {
                    ((RemoteEditBox)rw).paste();
                    return "1";
                }
                if (rw instanceof RemoteComboBox) {
                    ((RemoteComboBox)rw).paste();
                    return "1";
                }
                return "0";
            }
            case 29: {
                return "1";
            }
            case 49: {
                if (rw instanceof RemoteStandardComponent) {
                    RemoteFontComponent rfc = ((RemoteStandardComponent)rw).getFont();
                    return rfc != null ? Integer.toString(rfc.getTheObjectId()) : "0";
                }
                return "0";
            }
            case 127: {
                if (rw instanceof RemoteForm) {
                    return Integer.toString(((RemoteForm)rw).getIconImageId());
                }
                return "0";
            }
            case 13: {
                int maxLen = 0;
                if (params.length > 0) {
                    maxLen = WowSystem.getInt(params[0]);
                }
                String text = WowGuiFactoryImpl.getText(rw);
                if (maxLen > 0 && maxLen < text.length()) {
                    text = text.substring(0, maxLen);
                }
                return text;
            }
            case 14: {
                return Integer.toString(WowGuiFactoryImpl.getText(rw).length());
            }
            case 40: {
                if (rw instanceof RemoteForm && params.length > 1) {
                    Focusable newCurrFocus = null;
                    int ctlId = WowSystem.getInt(params[0]);
                    if (WowSystem.getInt(params[1]) == 0) {
                        newCurrFocus = ctlId == 0 ? ((RemoteForm)rw).getFocusNext() : ((RemoteForm)rw).getFocusPrevious();
                    } else {
                        Object obj = WowGuiFactoryImpl.getId(ctlId);
                        if (obj instanceof Focusable) {
                            newCurrFocus = (Focusable)obj;
                        }
                    }
                    if (newCurrFocus != null) {
                        newCurrFocus.requestFocus();
                    }
                }
                return "0";
            }
            case 128: {
                if (rw instanceof RemoteForm && params.length > 1) {
                    int imageId = WowSystem.getInt(params[1]);
                    RemoteForm rf = (RemoteForm)rw;
                    Image iconImage = this.getLocalImage(imageId);
                    ArrayList<Image> list = new ArrayList<Image>();
                    list.add(iconImage);
                    rf.setIconImages(list);
                    rf.setIconImageId(iconImage != null ? imageId : -1);
                }
                return "0";
            }
            case 48: {
                if (rw instanceof RemoteStandardComponent && params.length > 0) {
                    RemoteFontComponent rfc = (RemoteFontComponent)this.guiFactory.getClient().getId(Integer.parseInt(params[0]));
                    ((RemoteStandardComponent)rw).setFont(rfc);
                    return "1";
                }
                return "0";
            }
            case 11: {
                if (rw instanceof RemoteStandardComponent && params.length > 0) {
                    ((RemoteStandardComponent)rw).setNoredraw(WowSystem.getInt(params[0]) != 1);
                }
                return "0";
            }
            case 12: 
        }
        if (params.length > 1) {
            WowGuiFactoryImpl.setText(rw, params[1]);
            return "1";
        }
        return "0";
    }

    private static String getText(RemoteWidget rw) {
        String text = null;
        if (rw instanceof RemoteButtonComponent) {
            text = ((RemoteButtonComponent)rw).getCaption();
        } else if (rw instanceof RemoteEditBox) {
            text = ((RemoteEditBox)rw).getText();
        } else if (rw instanceof RemoteComboBox) {
            text = ((RemoteComboBox)rw).getText();
        } else if (rw instanceof RemoteDateTimePicker) {
            text = ((RemoteDateTimePicker)rw).getText();
        } else if (rw instanceof RemoteGroupBox) {
            text = ((RemoteGroupBox)rw).getCaption();
        } else if (rw instanceof RemoteStaticText) {
            text = ((RemoteStaticText)rw).getCaption();
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    private static void setText(RemoteWidget rw, String text) {
        if (rw instanceof RemoteButtonComponent) {
            ((RemoteButtonComponent)rw).setCaption(text);
        } else if (rw instanceof RemoteEditBox) {
            ((RemoteEditBox)rw).setText(text);
        } else if (rw instanceof RemoteComboBox) {
            ((RemoteComboBox)rw).setText(text);
        } else if (rw instanceof RemoteGroupBox) {
            ((RemoteGroupBox)rw).setCaption(text);
        } else if (rw instanceof RemoteStaticText) {
            ((RemoteStaticText)rw).setCaption(text);
        }
    }

    private static String getRectString(Rectangle r) {
        return "" + r.x + ',' + r.y + ',' + (r.x + r.width) + ',' + (r.y + r.height);
    }

    private static Rectangle getRect(String rectString) {
        Rectangle r = new Rectangle();
        try {
            String[] ss = rectString.split("\\,");
            r.x = Integer.parseInt(ss[0]);
            r.y = Integer.parseInt(ss[1]);
            r.width = Integer.parseInt(ss[2]) - r.x;
            r.height = Integer.parseInt(ss[3]) - r.y;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    private static String getIntArrayString(int[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    @Override
    public int setActiveWindow(int windowId) throws IOException {
        RemoteForm lastActive = this.activeWindow;
        this.setActiveWindow((RemoteForm)WowGuiFactoryImpl.getId(windowId));
        return lastActive != null ? lastActive.getRemoteWidgetId() : 0;
    }

    @Override
    public boolean showWindow(int windowId, int showMode) throws IOException {
        RemoteForm form = (RemoteForm)WowGuiFactoryImpl.getId(windowId);
        boolean Return = form.isVisible();
        switch (showMode) {
            case 0: {
                form.setVisible(false);
                if (this.focusedWindow == form) {
                    this.focusedWindow = null;
                }
                if (this.activeWindow != form) break;
                this.activeWindow = null;
                break;
            }
            case 6: {
                form.setShowstate(2);
                if (this.activeWindow != form) break;
                this.activeWindow = null;
                break;
            }
            case 1: 
            case 9: {
                this.showForm(form, 0, true);
                break;
            }
            case 3: {
                this.showForm(form, 1, true);
                break;
            }
            case 2: {
                this.showForm(form, 2, true);
                break;
            }
            case 5: {
                this.showForm(form, -1, true);
                break;
            }
            case 7: {
                this.showForm(form, 2, false);
                break;
            }
            case 4: 
            case 8: {
                this.showForm(form, -1, false);
            }
        }
        return Return;
    }

    private void showForm(RemoteForm form, int showState, boolean activate) {
        form.setVisible(true);
        if (showState >= 0) {
            form.setShowstate(showState);
        }
        if (activate) {
            this.focusedWindow = form;
            this.activeWindow = form;
            form.activate();
        }
    }

    @Override
    public void addItem(int controlId, String item, int index) throws IOException {
        RemoteListComponent cmp = (RemoteListComponent)WowGuiFactoryImpl.getId(controlId);
        item = this.stripTrailing(item);
        if (index >= 0 && index < cmp.getCount()) {
            cmp.addItem(index, item);
        } else {
            cmp.addItem(item);
        }
    }

    @Override
    public boolean removeItem(int controlId, int index) throws IOException {
        RemoteListComponent cmp = (RemoteListComponent)WowGuiFactoryImpl.getId(controlId);
        if (index >= 0 && index < cmp.getCount()) {
            cmp.removeItemAt(index);
            return true;
        }
        return false;
    }

    @Override
    public void clear(int controlId) throws IOException {
        RemoteListComponent cmp = (RemoteListComponent)WowGuiFactoryImpl.getId(controlId);
        cmp.removeAllItems();
    }

    @Override
    public String getValue(int controlId) throws IOException {
        String Return = null;
        Object obj = WowGuiFactoryImpl.getId(controlId);
        if (obj instanceof RemoteToggleButtonComponent) {
            Return = Integer.toString(((RemoteToggleButtonComponent)obj).getValue());
        } else if (obj instanceof RemoteComboBox) {
            Return = ((RemoteComboBox)obj).getText();
        } else if (obj instanceof RemoteDateTimePicker) {
            Return = ((RemoteDateTimePicker)obj).getText();
        } else if (obj instanceof RemoteEditBox) {
            Return = ((RemoteEditBox)obj).getText();
        } else if (obj instanceof RemoteProgressBar) {
            Return = Integer.toString(((RemoteProgressBar)obj).getValue());
        } else if (obj instanceof RemoteScrollBar) {
            Return = Integer.toString(((RemoteScrollBar)obj).getValue());
        } else if (obj instanceof RemoteTrackBar) {
            Return = Integer.toString(((RemoteTrackBar)obj).getValue());
        } else if (obj instanceof RemoteUpDown) {
            Return = Integer.toString(((RemoteUpDown)obj).getValue());
        }
        return Return;
    }

    @Override
    public void setValue(int controlId, String value) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(controlId);
        if (obj instanceof RemoteToggleButtonComponent) {
            ((RemoteToggleButtonComponent)obj).setValue(WowSystem.getInt(value));
        } else if (obj instanceof RemoteComboBox) {
            ((RemoteComboBox)obj).setText(value);
        } else if (obj instanceof RemoteEditBox) {
            ((RemoteEditBox)obj).setText(value);
        } else if (obj instanceof RemoteProgressBar) {
            ((RemoteProgressBar)obj).setValue(WowSystem.getInt(value));
        } else if (obj instanceof RemoteScrollBar) {
            ((RemoteScrollBar)obj).setValue(WowSystem.getInt(value));
        } else if (obj instanceof RemoteTrackBar) {
            ((RemoteTrackBar)obj).setValue(WowSystem.getInt(value));
        } else if (obj instanceof RemoteUpDown) {
            ((RemoteUpDown)obj).setValue(WowSystem.getInt(value));
        }
    }

    @Override
    public void moveFocusNext() throws IOException {
        Focusable next;
        if (this.focusedWindow != null && (next = this.focusedWindow.getFocusNext()) != null) {
            next.requestFocus();
        }
    }

    @Override
    public void moveFocusPrevious() throws IOException {
        Focusable prev;
        if (this.focusedWindow != null && (prev = this.focusedWindow.getFocusPrevious()) != null) {
            prev.requestFocus();
        }
    }

    @Override
    public void initializeControl(int controlId) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(controlId);
        if (obj instanceof Initializable) {
            ((Initializable)obj).initialize();
        }
    }

    @Override
    public void initializeAllControls(int windowId) throws IOException {
        RemoteForm form = (RemoteForm)WowGuiFactoryImpl.getId(windowId);
        this.initializeAllControls(form);
    }

    private void initializeAllControls(RemoteContainer cnt) {
        for (int i = 0; i < cnt.getComponentCount(); ++i) {
            RemoteComponent c = cnt.getComponentAt(i);
            if (c instanceof Initializable) {
                ((Initializable)((Object)c)).initialize();
            }
            if (c instanceof RemoteTabControl) {
                RemoteTabControl rtc = (RemoteTabControl)c;
                for (int j = 0; j < rtc.getTabs(); ++j) {
                    this.initializeAllControls(rtc.getPageAt(j));
                }
                continue;
            }
            if (!(c instanceof RemoteContainer)) continue;
            this.initializeAllControls((RemoteContainer)((Object)c));
        }
    }

    private void setCursor(int type) {
        for (RemoteForm form : this.windowList) {
            form.setCursor(type);
        }
    }

    @Override
    public void setWaitCursor() throws IOException {
        ++this.waitCursorCounter;
        if (this.waitCursorCounter == 1) {
            this.setCursor(2);
        }
    }

    @Override
    public void resetWaitCursor() throws IOException {
        if (this.waitCursorCounter > 0) {
            --this.waitCursorCounter;
            if (this.waitCursorCounter == 0) {
                this.setCursor(-1);
            }
        }
    }

    @Override
    public void clearWaitCursor() throws IOException {
        if (this.waitCursorCounter > 0) {
            this.waitCursorCounter = 0;
            this.setCursor(-1);
        }
    }

    @Override
    public void setBounds(int id, int left, int top, int width, int height) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(id);
        if (obj instanceof RemoteComponent) {
            RemoteComponent cmp = (RemoteComponent)obj;
            cmp.setLeft(left);
            cmp.setTop(top);
            cmp.setWidth(width);
            cmp.setHeight(height);
        }
    }

    @Override
    public void refresh(int id) throws IOException {
        Object obj = WowGuiFactoryImpl.getId(id);
        if (obj instanceof RemoteComponent) {
            ((RemoteComponent)obj).refresh();
        }
    }

    @Override
    public void setStripTrailing(boolean b) throws IOException {
        this.stripTrailing = b;
    }

    private String stripTrailing(String str) {
        return this.stripTrailing && str != null ? Factory.rightTrim((String)str) : str;
    }

    public static byte[] getResource(String id) {
        return resources.get(id);
    }

    public static Image getImage(String imageFileName) {
        Image[] Return = imageCache.get(imageFileName);
        if (Return == null) {
            byte[] b = resources.get(imageFileName);
            Return = b != null ? new Image[]{WowSystem.getImage(b)} : new Image[]{WowSystem.getImage(imageFileName)};
            imageCache.put(imageFileName, Return);
        }
        return Return[0];
    }

    @Override
    public String axDoMethod(int id, String methodName, String[] params) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        if (target instanceof RemoteActiveX) {
            try {
                return ((RemoteActiveX)target).executeMethod(methodName, params);
            }
            catch (WowActiveX.MethodNotFoundException e) {
                throw new IOException(e.toString());
            }
        }
        return null;
    }

    @Override
    public String axGetIndexProp(int id, String propName, int[] indexes) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        if (target instanceof RemoteActiveX) {
            return ((RemoteActiveX)target).getIndexProp(propName, indexes);
        }
        return null;
    }

    @Override
    public void axSetIndexProp(int id, String propName, String propValue, int[] indexes) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        if (target instanceof RemoteActiveX) {
            ((RemoteActiveX)target).setIndexProp(propName, this.stripTrailing(propValue), indexes);
        }
    }

    @Override
    public int getKeyState(int keyCode) throws IOException {
        return keyTable.getKeyState(keyCode);
    }

    @Override
    public void setCsProperty(String name, String value) throws IOException {
        this.csProperty.set(name, value);
    }

    @Override
    public void setCsProperties(String[] names, String[] values) throws IOException {
        for (int i = 0; i < names.length; ++i) {
            this.setCsProperty(names[i], values[i]);
        }
    }

    @Override
    public String getAxClassId(int id) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        if (target instanceof RemoteActiveX) {
            return ((RemoteActiveX)target).getClsid();
        }
        return "";
    }

    @Override
    public int getWindow(int id, int relation) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        RemoteWidget found = null;
        if (target instanceof RemoteForm) {
            RemoteForm form = (RemoteForm)target;
            switch (relation) {
                case 5: {
                    found = form.getMainWindow().getLastZOrderComponent(false);
                    break;
                }
                case 4: {
                    found = form.getOwnerForm();
                }
            }
        } else if (target instanceof RemoteWidget) {
            RemoteWidget rc = (RemoteWidget)target;
            RemoteForm form = rc.getParentForm();
            switch (relation) {
                case 4: {
                    found = form;
                    break;
                }
                case 0: {
                    found = form.getMainWindow().getLastZOrderComponent(false);
                    break;
                }
                case 1: {
                    found = form.getMainWindow().getFirstZOrderComponent(false);
                    break;
                }
                case 2: {
                    found = form.getMainWindow().getPreviousZOrderComponent(rc, false);
                    break;
                }
                case 3: {
                    found = form.getMainWindow().getNextZOrderComponent(rc, false);
                }
            }
        }
        return found != null ? found.getRemoteWidgetId() : -1;
    }

    @Override
    public int getNextTabItem(int id, int startId, int direction) throws IOException {
        Object target = WowGuiFactoryImpl.getId(id);
        RemoteWidget found = null;
        if (target instanceof RemoteForm) {
            RemoteForm form = (RemoteForm)target;
            Object start = WowGuiFactoryImpl.getId(startId);
            if (start instanceof RemoteComponent) {
                RemoteComponent rc = (RemoteComponent)start;
                found = direction == 0 ? form.getMainWindow().getPreviousZOrderComponent(rc, true) : form.getMainWindow().getNextZOrderComponent(rc, true);
            } else {
                found = form.getMainWindow().getLastZOrderComponent(true);
            }
        }
        return found != null ? found.getRemoteWidgetId() : -1;
    }

    @Override
    public void loadResources(String[] ids, byte[][] streams) throws IOException {
        for (int i = 0; i < ids.length; ++i) {
            resources.put(ids[i], streams[i]);
        }
    }

    @Override
    public void disposeResources(String[] ids) throws IOException {
        for (int i = 0; i < ids.length; ++i) {
            resources.remove(ids[i]);
        }
    }

    @Override
    public String[] bindEventArguments(int id) throws IOException {
        Event e = lastWidgetEvents.get(id);
        if (e != null) {
            return e.getParameters();
        }
        return null;
    }

    @Override
    public String[] unbindEventArguments(int id) throws IOException {
        Event e = lastWidgetEvents.remove(id);
        if (e != null) {
            return e.getParameters();
        }
        return null;
    }

    protected RemoteInvocationHandler createInvocationHandler(RemoteCaller caller, Integer ref, MethodTable mt, int timeout) {
        Method m = null;
        try {
            m = WowGuiFactory.class.getMethod("sendList", RmiDescList.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new WowInvocationHandler(caller, ref, mt, timeout, m);
    }

    @Override
    public void sendList(RmiDescList list) throws IOException {
        Enumeration<RmiDesc> en = list.elements();
        while (en.hasMoreElements()) {
            RmiDesc d = en.nextElement();
            switch (d.type) {
                case 1: {
                    this.axDoMethod(d.int1, d.str1, d.a_str1);
                    break;
                }
                case 2: {
                    this.setProp(d.int1, d.a_str1, d.a_str2);
                    break;
                }
                case 3: {
                    this.setProp(d.a_int1, d.a_str1, d.a_str2);
                    break;
                }
                case 4: {
                    this.setIndexProp(d.int1, d.str1, d.str2, d.int2);
                    break;
                }
                case 5: {
                    this.axSetIndexProp(d.int1, d.str1, d.str2, d.a_int1);
                    break;
                }
                case 6: {
                    this.addItem(d.int1, d.str1, d.int2);
                    break;
                }
                case 7: {
                    this.removeItem(d.int1, d.int2);
                    break;
                }
                case 8: {
                    this.clear(d.int1);
                    break;
                }
                case 12: {
                    this.initializeControl(d.int1);
                    break;
                }
                case 13: {
                    this.initializeAllControls(d.int1);
                    break;
                }
                case 18: {
                    this.refresh(d.int1);
                    break;
                }
                case 19: {
                    this.setStripTrailing(d.int1 != 0);
                    break;
                }
                case 9: {
                    this.setValue(d.int1, d.str1);
                    break;
                }
                case 17: {
                    this.setBounds(d.a_int1[0], d.a_int1[1], d.a_int1[2], d.a_int1[3], d.a_int1[4]);
                    break;
                }
                case 20: {
                    this.setCsProperty(d.str1, d.str2);
                    break;
                }
                case 21: {
                    this.setCsProperties(d.a_str1, d.a_str2);
                    break;
                }
                case 22: {
                    this.loadResources(d.a_str1, d.a_a_byte1);
                    break;
                }
                case 23: {
                    this.disposeResources(d.a_str1);
                    break;
                }
                case 10: {
                    this.moveFocusNext();
                    break;
                }
                case 11: {
                    this.moveFocusPrevious();
                    break;
                }
                case 14: {
                    this.setWaitCursor();
                    break;
                }
                case 15: {
                    this.resetWaitCursor();
                    break;
                }
                case 16: {
                    this.clearWaitCursor();
                }
            }
        }
    }

    private static class ElementIterator {
        NodeList nl;
        int idx;
        int len;

        ElementIterator(Element e) {
            this.nl = e.getChildNodes();
            this.len = this.nl.getLength();
        }

        Element next() {
            Element Return = null;
            while (this.idx < this.len && Return == null) {
                Node n = this.nl.item(this.idx);
                if (n.getNodeType() == 1) {
                    Return = (Element)n;
                }
                ++this.idx;
            }
            return Return;
        }
    }
}

