/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.WowComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class WowListBox
extends JScrollPane
implements WowComposite {
    protected static final int DIVIDER_INSET = 1;
    public static final int UNALIGNED = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    private boolean extendedsel;
    private boolean multiplesel;
    private JList listbox = new JList();
    private DefaultListModel listmodel = new DefaultListModel();
    private FastCellRenderer renderer;
    private int itemheight;
    private FontMetrics fm;

    private void setPrototypeCellValue(Object o) {
        this.listbox.setPrototypeCellValue(o);
    }

    @Override
    public Component getFocusOwner() {
        return this.listbox;
    }

    public WowListBox() {
        this.listbox.setModel(this.listmodel);
        this.listbox.setSelectionMode(0);
        this.setViewportView(this.listbox);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.renderer = new FastCellRenderer();
        this.listbox.setCellRenderer(this.renderer);
        MouseAdapter ml = new MouseAdapter(){
            int startDragIdx = -1;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (WowListBox.this.listbox.getSelectionMode() != 0) {
                    Point p = e.getPoint();
                    if (this.startDragIdx >= 0) {
                        int endDragIdx = WowListBox.this.listbox.locationToIndex(p);
                        if (endDragIdx >= 0) {
                            WowListBox.this.listbox.setSelectionInterval(this.startDragIdx, endDragIdx);
                        }
                    } else {
                        this.startDragIdx = WowListBox.this.listbox.locationToIndex(p);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.startDragIdx >= 0) {
                    this.startDragIdx = -1;
                }
            }
        };
        this.listbox.addMouseListener(ml);
        this.listbox.addMouseMotionListener(ml);
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        if (this.listbox != null) {
            this.listbox.addKeyListener(kl);
        }
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        if (this.listbox != null) {
            this.listbox.removeKeyListener(kl);
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (this.listbox != null) {
            this.listbox.addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        if (this.listbox != null) {
            this.listbox.removeMouseListener(ml);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener ml) {
        if (this.listbox != null) {
            this.listbox.addMouseMotionListener(ml);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener ml) {
        if (this.listbox != null) {
            this.listbox.removeMouseMotionListener(ml);
        }
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        if (this.listbox != null) {
            this.listbox.addFocusListener(fl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        if (this.listbox != null) {
            this.listbox.removeFocusListener(fl);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.listbox != null) {
            this.fm = this.listbox.getFontMetrics(f);
            this.listbox.setFont(f);
            if (this.itemheight == 0) {
                this.listbox.setFixedCellHeight(this.fm.getHeight());
            }
        }
        if (this.renderer != null) {
            this.listbox.repaint();
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.listbox != null) {
            this.listbox.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.listbox != null) {
            this.listbox.setForeground(fg);
        }
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        if (this.listbox != null) {
            this.listbox.setEnabled(e);
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (this.listbox != null) {
            this.listbox.setVisible(v);
        }
    }

    public void setExtendedsel(boolean extendedsel) {
        this.extendedsel = extendedsel;
        if (this.extendedsel) {
            this.listbox.setSelectionMode(2);
        } else if (this.multiplesel) {
            this.listbox.setSelectionMode(1);
        } else {
            this.listbox.setSelectionMode(0);
        }
    }

    public void setMultiplesel(boolean multiplesel) {
        this.multiplesel = multiplesel;
        if (this.multiplesel) {
            this.listbox.setSelectionMode(1);
        } else if (this.extendedsel) {
            this.listbox.setSelectionMode(2);
        } else {
            this.listbox.setSelectionMode(0);
        }
    }

    protected void intAddItem(int idx, String item) {
        if (idx >= 0 && idx < this.listmodel.getSize()) {
            this.listmodel.add(idx, item);
        } else {
            this.listmodel.addElement(item);
        }
    }

    protected void intRemoveItem(int idx) {
        if (idx >= 0 && idx < this.listmodel.size()) {
            this.listmodel.remove(idx);
        }
    }

    protected void intRemoveAllItems() {
        this.listmodel.removeAllElements();
    }

    public void setHorizontalextent(int ext) {
    }

    public int getHorizontalextent() {
        return 0;
    }

    public int getTopindex() {
        int Return = 0;
        int y1 = this.listbox.getVisibleRect().y;
        int lineHeight = this.getRowHeight();
        Return = (int)Math.ceil((double)y1 / (double)lineHeight);
        return Return;
    }

    public void setTopindex(int idx) {
        int lineHeight = this.getRowHeight();
        int offsH = (int)Math.ceil((double)idx / (double)lineHeight);
        this.listbox.scrollRectToVisible(new Rectangle(0, offsH, 1, 1));
    }

    public int getItemheight() {
        return this.itemheight;
    }

    private int getRowHeight() {
        return this.itemheight > 0 ? this.itemheight : this.fm.getHeight();
    }

    public void setItemheight(int itemheight) {
        this.itemheight = itemheight;
        if (this.itemheight > 0) {
            this.listbox.setFixedCellHeight(this.itemheight);
        }
        if (this.renderer != null) {
            this.listbox.repaint();
        }
    }

    public Rectangle getItemBounds(int idx) {
        Component cmp;
        if (idx >= 0 && idx < this.listmodel.size() && (cmp = this.renderer.getListCellRendererComponent(this.listbox, "", idx, false, false)) != null) {
            return cmp.getBounds();
        }
        return new Rectangle();
    }

    public boolean isItemSelected(int idx) {
        return this.listbox.isSelectedIndex(idx);
    }

    public int getSelectionCount() {
        int[] sels = this.listbox.getSelectedIndices();
        if (sels != null) {
            return sels.length;
        }
        return 0;
    }

    public int[] getSelectionIndices() {
        return this.listbox.getSelectedIndices();
    }

    public int getCursel() {
        return this.listbox.getSelectedIndex();
    }

    public void setItemSelected(int startIdx, int endIdx, boolean selected) {
        TreeSet<Integer> s = new TreeSet<Integer>();
        for (int i : this.listbox.getSelectedIndices()) {
            s.add(i);
        }
        for (int i = startIdx; i <= endIdx; ++i) {
            if (selected) {
                s.add(i);
                continue;
            }
            s.remove(i);
        }
        int[] newIdxs = new int[s.size()];
        int i = 0;
        for (Integer I : s.toArray(new Integer[s.size()])) {
            newIdxs[i++] = I;
        }
        this.listbox.setSelectedIndices(newIdxs);
    }

    public void setItemSelected(int idx, boolean selected) {
        if (idx >= 0) {
            this.setItemSelected(idx, idx, selected);
        } else if (selected) {
            this.setItemSelected(0, this.listbox.getModel().getSize(), true);
        } else {
            this.listbox.setSelectedIndices(new int[0]);
        }
    }

    public void setCursel(int cursel) {
        this.listbox.setSelectedIndex(cursel);
    }

    public void ensureVisible(int idx) {
        this.listbox.ensureIndexIsVisible(idx);
    }

    private int getIndexOfExactItem(Object[] items, String str) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().equals(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfExactItemIgnoreCase(Object[] items, String str) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().equalsIgnoreCase(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfItemStartingWith(Object[] items, String str) {
        str = str.toLowerCase();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().toLowerCase().startsWith(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfItem(Object[] items, String str) {
        int i = this.getIndexOfExactItem(items, str);
        if (i >= 0) {
            return i;
        }
        i = this.getIndexOfExactItemIgnoreCase(items, str);
        if (i >= 0) {
            return i;
        }
        return this.getIndexOfItemStartingWith(items, str);
    }

    public void setSeltext(String s) {
        int index;
        String[] items = null;
        int lmsize = -1;
        if (this.listmodel != null && (lmsize = this.listmodel.getSize()) > 0) {
            items = new String[lmsize];
            for (int i = 0; i < lmsize; ++i) {
                items[i] = (String)this.listmodel.getElementAt(i);
            }
        }
        if ((index = this.getIndexOfItem(items, s)) != this.listbox.getSelectedIndex()) {
            this.listbox.setSelectedIndex(index);
        }
    }

    public String getSeltext() {
        String Return = " ";
        if (this.listbox.getSelectedIndex() >= 0) {
            Return = (String)this.listbox.getSelectedValue();
        }
        return Return;
    }

    public JList getList() {
        return this.listbox;
    }

    @Override
    public void requestFocus() {
        this.listbox.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.listbox.requestFocusInWindow();
    }

    private class FastCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private String item;
        private boolean firstPaint = true;

        private FastCellRenderer() {
        }

        @Override
        public Dimension getPreferredSize() {
            if (WowListBox.this.fm != null) {
                return new Dimension(0, WowListBox.this.getRowHeight());
            }
            return super.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            if (this.firstPaint) {
                WowListBox.this.setPrototypeCellValue(this.item);
                this.firstPaint = false;
            }
            Toolkit tlk = Toolkit.getDefaultToolkit();
            Map map = (Map)tlk.getDesktopProperty("awt.font.desktophints");
            Graphics2D g2 = (Graphics2D)g;
            if (map != null) {
                g2.addRenderingHints(map);
            }
            Font fontSave = g.getFont();
            g.setFont(WowListBox.this.listbox.getFont());
            int colWidth = WowListBox.this.getWidth() - 1 - 1;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, colWidth, WowListBox.this.getRowHeight());
            g.setColor(this.getForeground());
            g.drawString(this.item, 1, WowListBox.this.fm.getAscent());
            g.setFont(fontSave);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color fg;
            Color bg;
            if (isSelected) {
                bg = list.getSelectionBackground();
                fg = list.getSelectionForeground();
            } else {
                bg = list.getBackground();
                fg = list.getForeground();
            }
            if (!list.isEnabled()) {
                bg = bg.darker();
                fg = fg.darker();
            }
            this.setBackground(bg);
            this.setForeground(fg);
            this.item = (String)value;
            return this;
        }
    }
}

