/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WowMessageBox
extends JDialog {
    private int selection = -1;

    private WowMessageBox(Frame parent, String title, String message, Icon icon, String[] labels, int selIdx) {
        super(parent, title, true);
        this.init(message, icon, labels, selIdx);
    }

    private WowMessageBox(Dialog parent, String title, String message, Icon icon, String[] labels, int selIdx) {
        super(parent, title, true);
        this.init(message, icon, labels, selIdx);
    }

    private void init(String message, Icon icon, String[] labels, int selIdx) {
        int i;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout(10, 15));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel label = new JLabel(message, icon, 2);
        label.setIconTextGap(10);
        mainPanel.add((Component)label, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton[] buttons = new JButton[labels.length];
        Dimension prefSize = new Dimension();
        for (i = 0; i < labels.length; ++i) {
            buttons[i] = new JButton(labels[i]);
            int selValue = i;
            buttons[i].addActionListener(e -> {
                this.selection = selValue;
                this.dispose();
            });
            buttons[i].addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        WowMessageBox.this.selection = -1;
                        WowMessageBox.this.dispose();
                    }
                }
            });
            Dimension d = buttons[i].getPreferredSize();
            d.width += 7;
            d.height += 5;
            if (d.width > prefSize.width) {
                prefSize.width = d.width;
            }
            if (d.height <= prefSize.height) continue;
            prefSize.height = d.height;
        }
        for (i = 0; i < buttons.length; ++i) {
            buttons[i].setPreferredSize(prefSize);
            buttonPanel.add(buttons[i]);
        }
        mainPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)mainPanel, "Center");
        if (selIdx < 0 || selIdx >= buttons.length) {
            selIdx = 0;
        }
        final JButton selBtn = buttons[selIdx];
        selBtn.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                selBtn.requestFocusInWindow();
                selBtn.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }
        });
        this.getRootPane().setDefaultButton(selBtn);
        HashSet<KeyStroke> s = new HashSet<KeyStroke>();
        s.add(KeyStroke.getKeyStroke(9, 0));
        s.add(KeyStroke.getKeyStroke(40, 0));
        s.add(KeyStroke.getKeyStroke(39, 0));
        buttonPanel.setFocusTraversalKeys(0, s);
        s = new HashSet();
        s.add(KeyStroke.getKeyStroke(9, 64));
        s.add(KeyStroke.getKeyStroke(38, 0));
        s.add(KeyStroke.getKeyStroke(37, 0));
        buttonPanel.setFocusTraversalKeys(1, s);
    }

    public static int showMessageDialog(Window parent, String title, String message, Icon icon, String[] labels, int selIdx) {
        WowMessageBox mb = parent instanceof Frame ? new WowMessageBox((Frame)parent, title, message, icon, labels, selIdx) : (parent instanceof Dialog ? new WowMessageBox((Dialog)parent, title, message, icon, labels, selIdx) : new WowMessageBox((Frame)null, title, message, icon, labels, selIdx));
        mb.pack();
        mb.setLocationRelativeTo(mb.getOwner());
        mb.setVisible(true);
        return mb.selection;
    }
}

