/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.Timer;

public class WowScroll
extends JScrollBar {
    private boolean keyPressed;
    private Map<Integer, Timer> timers = new HashMap<Integer, Timer>();
    private int lastValue;
    private WowScrollListener listener;
    private boolean listenersAdded;
    private boolean listenerEnabled = true;
    private final boolean vertical;

    public WowScroll(boolean vertical) {
        super(vertical ? 1 : 0);
        this.vertical = vertical;
        this.setValue(0);
    }

    protected void enableListener() {
        this.listenerEnabled = true;
    }

    protected void disableListener() {
        this.listenerEnabled = false;
    }

    private void restartTimer(int keyCode) {
        Timer timer = this.timers.get(keyCode);
        if (timer == null) {
            timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WowScroll.this.listener != null) {
                        WowScroll.this.listener.endScroll(new WowScrollEvent(WowScroll.this));
                    }
                }
            });
            timer.setRepeats(false);
            this.timers.put(keyCode, timer);
            timer.start();
        } else {
            timer.restart();
        }
    }

    public WowScrollListener getListener() {
        return this.listener;
    }

    public void setListener(WowScrollListener listener) {
        this.listener = listener;
        if (this.listener != null && !this.listenersAdded) {
            this.addListeners();
            this.listenersAdded = true;
        }
    }

    private void addListeners() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 35: 
                    case 36: {
                        if (WowScroll.this.listener != null) {
                            WowScroll.this.listener.endScroll(new WowScrollEvent(WowScroll.this));
                        }
                        WowScroll.this.keyPressed = true;
                        break;
                    }
                    case 37: 
                    case 38: {
                        if (WowScroll.this.listener != null) {
                            WowScroll.this.listener.lineUp(new WowScrollEvent(WowScroll.this));
                        }
                        WowScroll.this.restartTimer(e.getKeyCode());
                        WowScroll.this.keyPressed = true;
                        break;
                    }
                    case 39: 
                    case 40: {
                        if (WowScroll.this.listener != null) {
                            WowScroll.this.listener.lineDown(new WowScrollEvent(WowScroll.this));
                        }
                        WowScroll.this.restartTimer(e.getKeyCode());
                        WowScroll.this.keyPressed = true;
                        break;
                    }
                    case 33: {
                        if (WowScroll.this.listener != null) {
                            WowScroll.this.listener.pageUp(new WowScrollEvent(WowScroll.this));
                        }
                        WowScroll.this.restartTimer(e.getKeyCode());
                        WowScroll.this.keyPressed = true;
                        break;
                    }
                    case 34: {
                        if (WowScroll.this.listener != null) {
                            WowScroll.this.listener.pageDown(new WowScrollEvent(WowScroll.this));
                        }
                        WowScroll.this.restartTimer(e.getKeyCode());
                        WowScroll.this.keyPressed = true;
                        break;
                    }
                    default: {
                        WowScroll.this.keyPressed = false;
                    }
                }
            }
        });
        this.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (WowScroll.this.listenerEnabled && (e.getValue() != WowScroll.this.lastValue || !e.getValueIsAdjusting())) {
                    if (WowScroll.this.keyPressed) {
                        WowScroll.this.keyPressed = false;
                    } else {
                        if (e.getValueIsAdjusting()) {
                            if (WowScroll.this.listener != null) {
                                WowScrollEvent we = new WowScrollEvent(WowScroll.this);
                                WowScroll.this.listener.thumbTrk(we);
                            }
                        } else if (e.getValue() == WowScroll.this.lastValue + WowScroll.this.getBlockIncrement()) {
                            if (WowScroll.this.listener != null) {
                                WowScrollEvent we = new WowScrollEvent(WowScroll.this);
                                if (WowScroll.this.vertical) {
                                    WowScroll.this.listener.pageUp(we);
                                } else {
                                    WowScroll.this.listener.pageDown(we);
                                }
                            }
                            WowScroll.this.restartTimer(33);
                        } else if (e.getValue() == WowScroll.this.lastValue - WowScroll.this.getBlockIncrement()) {
                            if (WowScroll.this.listener != null) {
                                WowScrollEvent we = new WowScrollEvent(WowScroll.this);
                                if (WowScroll.this.vertical) {
                                    WowScroll.this.listener.pageDown(we);
                                } else {
                                    WowScroll.this.listener.pageUp(we);
                                }
                            }
                            WowScroll.this.restartTimer(34);
                        } else if (e.getValue() == WowScroll.this.lastValue + WowScroll.this.getUnitIncrement()) {
                            if (WowScroll.this.listener != null) {
                                WowScrollEvent we = new WowScrollEvent(WowScroll.this);
                                if (WowScroll.this.vertical) {
                                    WowScroll.this.listener.lineUp(we);
                                } else {
                                    WowScroll.this.listener.lineDown(we);
                                }
                            }
                            WowScroll.this.restartTimer(38);
                        } else if (e.getValue() == WowScroll.this.lastValue - WowScroll.this.getUnitIncrement()) {
                            if (WowScroll.this.listener != null) {
                                WowScrollEvent we = new WowScrollEvent(WowScroll.this);
                                if (WowScroll.this.vertical) {
                                    WowScroll.this.listener.lineDown(we);
                                } else {
                                    WowScroll.this.listener.lineUp(we);
                                }
                            }
                            WowScroll.this.restartTimer(40);
                        } else if (WowScroll.this.listener != null) {
                            WowScrollEvent we = new WowScrollEvent(WowScroll.this);
                            WowScroll.this.listener.thumbPos(we);
                            WowScroll.this.listener.endScroll(we);
                        }
                        WowScroll.this.requestFocus();
                    }
                    WowScroll.this.lastValue = e.getValue();
                }
            }
        });
    }

    static class WowScrollEvent
    extends EventObject {
        WowScrollEvent(Object source) {
            super(source);
        }
    }

    static interface WowScrollListener
    extends EventListener {
        public void lineUp(WowScrollEvent var1);

        public void lineDown(WowScrollEvent var1);

        public void pageUp(WowScrollEvent var1);

        public void pageDown(WowScrollEvent var1);

        public void thumbPos(WowScrollEvent var1);

        public void thumbTrk(WowScrollEvent var1);

        public void endScroll(WowScrollEvent var1);
    }
}

