/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class WowShape
extends JComponent {
    public static final int NO_HATCH = -1;
    public static final int HORIZONTAL_HATCH = 0;
    public static final int VERTICAL_HATCH = 1;
    public static final int FORWARD_DIAGONAL_HATCH = 2;
    public static final int BACKWARD_DIAGONAL_HATCH = 3;
    public static final int CROSS_HATCH = 4;
    public static final int DIAGONAL_CROSS_HATCH = 5;
    public static final int SOLID_PEN = 0;
    public static final int DASH_PEN = 1;
    public static final int DOT_PEN = 2;
    public static final int DASHDOT_PEN = 3;
    public static final int DASHDOTDOT_PEN = 4;
    private final Map<Integer, BufferedImage> hatchImages = new HashMap<Integer, BufferedImage>();
    private boolean transparent;
    protected BasicStroke stroke = new BasicStroke(1.0f);
    private int hatchType = -1;

    public WowShape() {
        this.setFocusable(false);
    }

    private BufferedImage getHatchImage(int type) {
        Integer key = type;
        BufferedImage Return = this.hatchImages.get(key);
        if (Return == null) {
            Return = new BufferedImage(9, 9, 1);
            Graphics2D big = Return.createGraphics();
            big.setColor(Color.white);
            big.fillRect(0, 0, 9, 9);
            big.setColor(this.getBackground());
            switch (type) {
                case 0: {
                    big.drawLine(0, 4, 8, 4);
                    break;
                }
                case 1: {
                    big.drawLine(4, 0, 4, 8);
                    break;
                }
                case 2: {
                    big.drawLine(0, 0, 8, 8);
                    break;
                }
                case 3: {
                    big.drawLine(8, 0, 0, 8);
                    break;
                }
                case 4: {
                    big.drawLine(0, 4, 8, 4);
                    big.drawLine(4, 0, 4, 8);
                    break;
                }
                case 5: {
                    big.drawLine(0, 0, 8, 8);
                    big.drawLine(8, 0, 0, 8);
                }
            }
            this.hatchImages.put(key, Return);
        }
        return Return;
    }

    protected final int getLineWidth() {
        return Math.round(this.stroke.getLineWidth());
    }

    public void setPen(int style, int size) {
        switch (style) {
            default: {
                this.stroke = new BasicStroke(size);
                break;
            }
            case 1: {
                this.stroke = new BasicStroke(size, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
                break;
            }
            case 2: {
                this.stroke = new BasicStroke(size, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
                break;
            }
            case 3: {
                this.stroke = new BasicStroke(size, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
                break;
            }
            case 4: {
                this.stroke = new BasicStroke(size, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
            }
        }
        this.repaint();
    }

    public void setTransparent(boolean t) {
        this.transparent = t;
        this.repaint();
    }

    public void setHatchType(int hatch) {
        this.hatchType = hatch;
        this.repaint();
    }

    @Override
    public void setBackground(Color bkg) {
        this.hatchImages.clear();
        super.setBackground(bkg);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(this.stroke);
        g.setColor(this.getForeground());
        this.paintOutline(g, this.getOutlineArea(g.getClipBounds()));
        if (!this.transparent) {
            if (this.hatchType != -1) {
                BufferedImage bi = this.getHatchImage(this.hatchType);
                Rectangle bigr = new Rectangle(0, 0, 9, 9);
                g2d.setPaint(new TexturePaint(bi, bigr));
            } else {
                g.setColor(this.getBackground());
            }
            this.fillArea(g, this.getFillArea(g.getClipBounds()));
        }
    }

    protected Rectangle getFillArea(Rectangle clipBounds) {
        int lineWidth = this.getLineWidth();
        Rectangle r = new Rectangle(clipBounds);
        r.x += lineWidth;
        r.y += lineWidth;
        r.width -= lineWidth * 2;
        r.height -= lineWidth * 2;
        return r;
    }

    protected Rectangle getOutlineArea(Rectangle clipBounds) {
        int lineWidth = this.getLineWidth();
        int lineHalfWidth = lineWidth > 1 ? lineWidth / 2 : 0;
        Rectangle r = new Rectangle(clipBounds);
        r.x += lineHalfWidth;
        r.y += lineHalfWidth;
        r.width -= lineWidth;
        r.height -= lineWidth;
        return r;
    }

    public abstract void paintOutline(Graphics var1, Rectangle var2);

    public abstract void fillArea(Graphics var1, Rectangle var2);
}

