/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.WowSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class WowStaticText
extends JLabel {
    public static final int NO_EFFECT = 0;
    public static final int BLACK_RECTANGLE_EFFECT = 1;
    public static final int GRAY_RECTANGLE_EFFECT = 2;
    public static final int WHITE_RECTANGLE_EFFECT = 3;
    public static final int BLACK_FRAME_EFFECT = 4;
    public static final int GRAY_FRAME_EFFECT = 5;
    public static final int WHITE_FRAME_EFFECT = 6;
    public static final int INSET_EFFECT = 1;
    public static final int BAS_RELIEF_EFFECT = 2;
    public static final int OUTSET_EFFECT = 3;
    public static final int NO_ALIGN = 0;
    public static final int LEFT_ALIGN = 1;
    public static final int CENTER_ALIGN = 2;
    public static final int RIGHT_ALIGN = 3;
    private String title;
    private int hAlign;
    private int effect;
    private boolean transparent;
    private boolean right;
    private boolean displayMnemonic = true;
    private boolean wrap = true;
    private Color background;
    private Border border;
    private boolean _3d;

    public WowStaticText() {
        this.setOpaque(true);
        this.setVerticalAlignment(1);
    }

    public void setAlignment(int hAlign) {
        this.hAlign = hAlign;
        this.updateLabel();
    }

    private void updateLabel() {
        if (this.effect == 0 && this.title != null) {
            int idx = this.title.indexOf(38);
            if (this.right) {
                this.setHorizontalAlignment(4);
            } else {
                switch (this.hAlign) {
                    default: {
                        this.setHorizontalAlignment(2);
                        break;
                    }
                    case 2: {
                        this.setHorizontalAlignment(0);
                        break;
                    }
                    case 3: {
                        this.setHorizontalAlignment(4);
                    }
                }
            }
            if (this.wrap) {
                this.setDisplayedMnemonicIndex(-1);
                StringBuilder sb = new StringBuilder();
                sb.append("<html><div>");
                if (this.displayMnemonic && idx >= 0 && idx < this.title.length() - 1) {
                    if (idx > 0) {
                        sb.append(WowStaticText.escapeHtml(this.title.substring(0, idx)));
                    }
                    sb.append("<u>");
                    sb.append(this.title.charAt(idx + 1));
                    sb.append("</u>");
                    if (idx < this.title.length() - 2) {
                        sb.append(WowStaticText.escapeHtml(this.title.substring(idx + 2)));
                    }
                } else {
                    sb.append(WowStaticText.escapeHtml(this.title));
                }
                sb.append("</div></html>");
                this.setText(sb.toString());
            } else if (this.displayMnemonic && idx >= 0 && idx < this.title.length() - 1) {
                StringBuilder sb = new StringBuilder(this.title).deleteCharAt(idx);
                this.setText(sb.toString());
                this.setDisplayedMnemonicIndex(idx);
            } else {
                this.setText(this.title);
                this.setDisplayedMnemonicIndex(-1);
            }
        } else {
            this.setText("");
            this.setDisplayedMnemonicIndex(-1);
        }
    }

    private static String escapeHtml(String t) {
        char[] tChars = t.toCharArray();
        StringBuilder Return = new StringBuilder();
        block8: for (int i = 0; i < tChars.length; ++i) {
            switch (tChars[i]) {
                default: {
                    if (tChars[i] > '\u00ff') {
                        Return.append("&#" + tChars[i] + ";");
                        continue block8;
                    }
                    Return.append(tChars[i]);
                    continue block8;
                }
                case '\n': {
                    Return.append("<br>");
                    continue block8;
                }
                case '&': {
                    Return.append("&amp;");
                    continue block8;
                }
                case '<': {
                    Return.append("&lt;");
                    continue block8;
                }
                case '>': {
                    Return.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    Return.append("&quot;");
                    continue block8;
                }
                case ' ': {
                    if (i == 0 || tChars[i - 1] == ' ') {
                        Return.append("&nbsp;");
                        continue block8;
                    }
                    Return.append(' ');
                }
            }
        }
        return Return.toString();
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateLabel();
    }

    public void setEffect(int e) {
        int old = this.effect;
        this.effect = e;
        this.updateArea();
        if (this.effect != 0 && old == 0 || this.effect == 0 && old != 0) {
            this.updateLabel();
        }
    }

    private void updateArea() {
        if (this.is3D()) {
            switch (this.effect) {
                class MyBorder
                implements Border {
                    private final Color color;
                    private final boolean lowered;

                    MyBorder(Color c, boolean l) {
                        this.color = c;
                        this.lowered = l;
                    }

                    @Override
                    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                        g.setColor(this.lowered ? this.color.darker() : this.color.brighter());
                        g.drawLine(0, 0, c.getWidth() - 1, 0);
                        g.drawLine(0, 1, 0, c.getHeight() - 1);
                        g.setColor(this.lowered ? this.color.brighter() : this.color.darker());
                        g.drawLine(1, c.getHeight() - 1, c.getWidth() - 2, c.getHeight() - 1);
                        g.drawLine(c.getWidth() - 1, 1, c.getWidth() - 1, c.getHeight() - 2);
                    }

                    @Override
                    public Insets getBorderInsets(Component c) {
                        return new Insets(1, 1, 1, 1);
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return true;
                    }
                }
                default: {
                    this.noEffect();
                    break;
                }
                case 1: {
                    this.setOpaque(false);
                    MyBorder b = new MyBorder(this.getBackground(), true);
                    if (this.border != null) {
                        super.setBorder(BorderFactory.createCompoundBorder(b, this.border));
                        break;
                    }
                    super.setBorder(b);
                    break;
                }
                case 2: {
                    this.setOpaque(false);
                    Border b = WowSystem.getLineBorder();
                    if (this.border != null) {
                        super.setBorder(BorderFactory.createCompoundBorder(b, this.border));
                        break;
                    }
                    super.setBorder(b);
                    break;
                }
                case 3: {
                    this.setOpaque(false);
                    MyBorder b = new MyBorder(this.getBackground(), false);
                    if (this.border != null) {
                        super.setBorder(BorderFactory.createCompoundBorder(b, this.border));
                        break;
                    }
                    super.setBorder(b);
                    break;
                }
            }
        } else {
            switch (this.effect) {
                default: {
                    this.noEffect();
                    break;
                }
                case 1: {
                    this.setOpaque(true);
                    super.setBackground(Color.black);
                    this.updateBorder(null);
                    break;
                }
                case 2: {
                    this.setOpaque(true);
                    super.setBackground(Color.gray);
                    this.updateBorder(null);
                    break;
                }
                case 3: {
                    this.setOpaque(true);
                    super.setBackground(Color.white);
                    this.updateBorder(null);
                    break;
                }
                case 4: {
                    this.setOpaque(false);
                    this.updateBorder(Color.black);
                    break;
                }
                case 5: {
                    this.setOpaque(false);
                    this.updateBorder(Color.gray);
                    break;
                }
                case 6: {
                    this.setOpaque(false);
                    this.updateBorder(Color.white);
                }
            }
        }
    }

    private void noEffect() {
        this.setOpaque(!this.transparent);
        if (this.background != null) {
            super.setBackground(this.background);
        }
        if (this.border != null) {
            super.setBorder(this.border);
        } else {
            super.setBorder(null);
        }
    }

    private void updateBorder(Color lineColor) {
        if (lineColor != null) {
            if (this.border != null) {
                super.setBorder(BorderFactory.createCompoundBorder(this.border, BorderFactory.createLineBorder(lineColor)));
            } else {
                super.setBorder(BorderFactory.createLineBorder(lineColor));
            }
        } else if (this.border != null) {
            super.setBorder(this.border);
        } else {
            super.setBorder(null);
        }
    }

    @Override
    public void setBackground(Color c) {
        this.background = c;
        this.updateArea();
    }

    @Override
    public void setBorder(Border brd) {
        this.border = brd;
        this.updateArea();
    }

    public void setTransparent(boolean tr) {
        this.transparent = tr;
        this.updateArea();
    }

    public void setRight(boolean r) {
        this.right = r;
        this.updateLabel();
    }

    public void setDisplayMnemonic(boolean dm) {
        this.displayMnemonic = dm;
        this.updateLabel();
    }

    public void setWrap(boolean w) {
        this.wrap = w;
        this.updateLabel();
    }

    public boolean is3D() {
        return this._3d;
    }

    public void set3D(boolean _3d) {
        if (this._3d != _3d) {
            this._3d = _3d;
            this.updateArea();
        }
    }
}

