/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class WowStatusBar
extends JPanel {
    public static final int NO_BORDER = 0;
    public static final int LOWERED_BORDER = 1;
    public static final int RAISED_BORDER = 2;
    private int sectionCount;

    public WowStatusBar() {
        this.setLayout(new SBLayout());
        this.setSectionCount(1);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        int count = this.getSectionCount();
        for (int i = 0; i < count; ++i) {
            this.getLabel(i).setFont(f);
        }
        Dimension d = this.getSize();
        d.height = this.getFontMetrics(f).getHeight() + 4;
        this.setSize(d);
    }

    public void setSectionCount(int count) {
        int oldCount = this.getSectionCount();
        if (count != oldCount) {
            this.sectionCount = count;
            if (count == 0) {
                this.removeAll();
            } else {
                int i;
                int panelWidth = Math.round(this.getWidth() / count);
                if (count > oldCount) {
                    for (i = oldCount; i < count; ++i) {
                        SBLabel lbl = this.createLabel();
                        lbl.width = panelWidth;
                        this.add(lbl);
                    }
                } else {
                    for (i = count; i < oldCount; ++i) {
                        this.remove(count);
                    }
                }
                for (i = 0; i < count; ++i) {
                    this.getLabel((int)i).drawGrip = i == count - 1;
                }
                this.doLayout();
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        int count = this.getSectionCount();
        if (count > 0 && this.getLabel((int)0).width == 0) {
            int panelWidth = Math.round(width / count);
            for (int i = 0; i < count; ++i) {
                this.getLabel((int)i).width = panelWidth;
            }
            this.doLayout();
        }
    }

    public int getSectionCount() {
        return this.sectionCount;
    }

    private SBLabel createLabel() {
        SBLabel lbl = new SBLabel();
        lbl.setBorder(BorderFactory.createLoweredBevelBorder());
        lbl.setFont(this.getFont());
        return lbl;
    }

    private SBLabel getLabel(int idx) {
        return (SBLabel)this.getComponent(idx);
    }

    public void setTextAt(int idx, String text) {
        this.getLabel(idx).setText(text != null && text.length() > 0 ? text : " ");
    }

    public void setBorderAt(int idx, int borderType) {
        Border border;
        switch (borderType) {
            case 0: {
                border = null;
                break;
            }
            case 2: {
                border = BorderFactory.createRaisedBevelBorder();
                break;
            }
            default: {
                border = BorderFactory.createLoweredBevelBorder();
            }
        }
        this.getLabel(idx).setBorder(border);
    }

    public void setWidthAt(int idx, int width) {
        if (idx < this.getSectionCount() - 1) {
            SBLabel lbl = this.getLabel(idx);
            lbl.width = width;
            this.doLayout();
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame f = new JFrame("Test WowStatusBar");
        f.setResizable(true);
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.setLocationRelativeTo(null);
        f.getContentPane().setLayout(new BorderLayout());
        WowStatusBar wsb = new WowStatusBar();
        f.getContentPane().add((Component)wsb, "South");
        int count = 4;
        wsb.setSectionCount(count);
        for (int i = 0; i < count; ++i) {
            String text = i == 1 || i == 2 ? " " : "Panel " + (i + 1);
            wsb.setTextAt(i, text);
            wsb.setWidthAt(i, 100);
        }
        wsb.setBorderAt(0, 1);
        wsb.setBorderAt(1, 1);
        wsb.setBorderAt(2, 1);
        f.setVisible(true);
    }

    private class SBLayout
    implements LayoutManager {
        private SBLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return WowStatusBar.this.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            int count = WowStatusBar.this.getSectionCount();
            if (count == 1) {
                SBLabel lbl = WowStatusBar.this.getLabel(0);
                lbl.setBounds(1, 1, WowStatusBar.this.getWidth() - 2, lbl.getPreferredSize().height);
            } else {
                for (int i = 0; i < count; ++i) {
                    int x;
                    SBLabel prev;
                    SBLabel lbl = WowStatusBar.this.getLabel(i);
                    if (i == 0) {
                        lbl.setBounds(1, 1, lbl.width, lbl.getPreferredSize().height);
                        continue;
                    }
                    if (i == count - 1) {
                        prev = WowStatusBar.this.getLabel(i - 1);
                        x = prev.getLocation().x + prev.getSize().width + 1;
                        lbl.setBounds(x, 1, WowStatusBar.this.getWidth() - x - 1, lbl.getPreferredSize().height);
                        continue;
                    }
                    prev = WowStatusBar.this.getLabel(i - 1);
                    x = prev.getLocation().x + prev.getSize().width + 1;
                    lbl.setBounds(x, 1, lbl.width, lbl.getPreferredSize().height);
                }
            }
        }
    }

    private static class SBLabel
    extends JLabel {
        boolean drawGrip;
        int width;

        private SBLabel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.drawGrip) {
                g.setColor(Color.white);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 17, this.getWidth() - 17, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 16, this.getWidth() - 16, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 12, this.getWidth() - 12, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 11, this.getWidth() - 11, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 7, this.getWidth() - 7, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 6, this.getWidth() - 6, this.getHeight() - 3);
                g.setColor(Color.gray);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 5, this.getWidth() - 5, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 15, this.getWidth() - 15, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 10, this.getWidth() - 10, this.getHeight() - 3);
                g.setColor(Color.gray);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 14, this.getWidth() - 14, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 9, this.getWidth() - 9, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 3, this.getHeight() - 4, this.getWidth() - 4, this.getHeight() - 3);
            }
        }
    }
}

