/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.client.swing.TextIcon;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class WowTabControl
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private static final int MIN_TAB_SIZE = 5;
    private WowTabControlListener listener;

    public WowTabControl() {
        this.setTabLayoutPolicy(1);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (super.getTabCount() == 1) {
            super.setSelectedIndex(index);
        } else {
            if (this.listener != null) {
                this.listener.tabWillChange(new WowTabControlEvent(this, index));
            }
            super.setSelectedIndex(index);
            if (this.listener != null) {
                this.listener.tabChanged(new WowTabControlEvent(this, index));
            }
        }
    }

    public int getTabHeight() {
        if (this.getTabCount() == 0) {
            return 5;
        }
        TabbedPaneUI ui = this.getUI();
        Rectangle r = ui.getTabBounds(this, 0);
        if (r != null) {
            int Return = r.height;
            if (this.getTabLayoutPolicy() == 0) {
                Return *= ui.getTabRunCount(this);
            }
            return Return + 5;
        }
        return 5;
    }

    public int getTabWidth() {
        if (this.getTabCount() == 0) {
            return 5;
        }
        TabbedPaneUI ui = this.getUI();
        Rectangle r = ui.getTabBounds(this, 0);
        if (r != null) {
            int Return = r.width;
            if (this.getTabLayoutPolicy() == 0) {
                Return *= ui.getTabRunCount(this);
            }
            return Return + 5;
        }
        return 5;
    }

    public void setTabCount(int count) {
        block3: {
            int oldTabCount;
            block2: {
                oldTabCount = this.getTabCount();
                if (count <= oldTabCount) break block2;
                for (int i = oldTabCount; i < count; ++i) {
                    this.addTab("", this.createTabPanel());
                }
                break block3;
            }
            if (count >= oldTabCount) break block3;
            for (int i = count; i < oldTabCount; ++i) {
                this.removeTabAt(count);
            }
        }
    }

    private JComponent createTabPanel() {
        return new JPanel(null);
    }

    @Override
    public void setTitleAt(int index, String title) {
        if (this.isVertical()) {
            this.setTextIconAt(index, title, this.getIconRotation());
        } else {
            super.setTitleAt(index, title);
        }
    }

    private void setTextIconAt(int index, String title, int rotate) {
        super.setTitleAt(index, null);
        TextIcon icon = new TextIcon((Component)this, title, rotate);
        super.setIconAt(index, (Icon)icon);
        super.setDisabledIconAt(index, (Icon)icon);
    }

    private int getIconRotation() {
        return this.getTabPlacement() == 2 ? 2 : 4;
    }

    public boolean isVertical() {
        return WowTabControl.isVertical(this.getTabPlacement());
    }

    private static boolean isVertical(int tabPlacement) {
        return tabPlacement == 2 || tabPlacement == 4;
    }

    private String getLabelAt(int i, boolean vertical) {
        if (vertical) {
            TextIcon icon = (TextIcon)this.getIconAt(i);
            return icon != null ? icon.getLabel() : null;
        }
        return super.getTitleAt(i);
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
        block4: {
            boolean vertical = WowTabControl.isVertical(tabPlacement);
            int oldTabPlacement = this.getTabPlacement();
            boolean oldVertical = WowTabControl.isVertical(oldTabPlacement);
            super.setTabPlacement(tabPlacement);
            if (vertical == oldVertical && (!vertical || tabPlacement == oldTabPlacement)) break block4;
            int count = this.getTabCount();
            if (vertical) {
                int rotate = this.getIconRotation();
                for (int i = 0; i < count; ++i) {
                    this.setTextIconAt(i, this.getLabelAt(i, oldVertical), rotate);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    TextIcon icon = (TextIcon)this.getIconAt(i);
                    if (icon == null) continue;
                    super.setTitleAt(i, icon.getLabel());
                    this.setIconAt(i, null);
                    this.setDisabledIconAt(i, null);
                }
            }
        }
    }

    public WowTabControlListener getListener() {
        return this.listener;
    }

    public void setListener(WowTabControlListener listener) {
        this.listener = listener;
    }

    static class WowTabControlEvent
    extends EventObject {
        int tabIndex;

        WowTabControlEvent(Object source, int tabIndex) {
            super(source);
            this.tabIndex = tabIndex;
        }
    }

    static interface WowTabControlListener
    extends EventListener {
        public void tabWillChange(WowTabControlEvent var1);

        public void tabChanged(WowTabControlEvent var1);
    }
}

