/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.iscobol.gui.IsguiUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class WowToolBar
extends JToolBar {
    static final int STATE_NORMAL = 0;
    static final int STATE_CHECKED = 1;
    static final int STATE_PRESSED = 2;
    static final int STATE_INDETERMINATE = 3;
    static final int STYLE_BUTTON = 0;
    static final int STYLE_CHECK = 1;
    static final int STYLE_GROUP = 2;
    static final int STYLE_CHECK_GROUP = 3;
    static final int STYLE_SEPARATOR = 4;
    private int buttonCount;
    private int buttonWidth;
    private int buttonHeight;
    private int bitmapWidth = 16;
    private int bitmapHeight = 15;
    private Vector<MyButton> buttons = new Vector();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private WowToolBarListener listener;

    public WowToolBar() {
        this.setFloatable(false);
        this.setRollover(false);
        this.setLayout(new FlowLayout(3, 0, 0));
    }

    public int getButtonCount() {
        return this.buttonCount;
    }

    public void setButtonCount(int count) {
        int oldCount = this.getButtonCount();
        if (count > oldCount) {
            for (int i = oldCount; i < count; ++i) {
                JToggleButton btn = this.createButton();
                this.add(btn);
                this.buttons.addElement(new MyButton(btn));
            }
        } else if (count < oldCount) {
            for (int i = count; i < oldCount; ++i) {
                this.remove(count);
            }
        }
        this.buttons.setSize(count);
        this.buttonCount = count;
    }

    private JToggleButton createButton() {
        JToggleButton btn = new JToggleButton();
        btn.setModel(new DefaultButtonModel());
        btn.setPreferredSize(new Dimension(this.buttonWidth, this.buttonHeight));
        btn.setFont(this.getFont());
        btn.setFocusable(false);
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(3);
        btn.setVerticalAlignment(3);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setIconTextGap(0);
        btn.addActionListener(e -> {
            if (this.listener != null) {
                int buttonId = 0;
                for (int i = 0; i < this.buttons.size(); ++i) {
                    if (this.buttons.elementAt((int)i).button != btn) continue;
                    buttonId = i + 1;
                    break;
                }
                this.listener.buttonToolBarClicked(new WowToolBarEvent(btn, buttonId));
            }
        });
        return btn;
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public int getButtonHeight() {
        return this.buttonHeight;
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth = buttonWidth;
        this.updateButtonsSize();
    }

    public void setButtonHeight(int buttonHeight) {
        this.buttonHeight = buttonHeight;
        this.updateButtonsSize();
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public void setBitmapWidth(int bitmapWidth) {
        this.bitmapWidth = bitmapWidth;
        if (this.bitmapWidth > this.buttonWidth) {
            this.updateButtonsSize();
        }
        this.updateButtonsImage();
    }

    public void setBitmapHeight(int bitmapHeight) {
        this.bitmapHeight = bitmapHeight;
        if (this.bitmapHeight > this.buttonHeight) {
            this.updateButtonsSize();
        }
        this.updateButtonsImage();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        int count = this.getButtonCount();
        for (int i = 0; i < count; ++i) {
            JToggleButton btn = this.buttons.elementAt((int)i).button;
            btn.setFont(f);
        }
        this.updateButtonsSize();
    }

    public int getButtonTextHeight() {
        int Return = 0;
        int count = this.getButtonCount();
        for (int i = 0; i < count && Return == 0; ++i) {
            JToggleButton b = this.buttons.elementAt((int)i).button;
            String s = b.getText();
            if (s == null || s.length() <= 0) continue;
            Return = b.getFontMetrics(b.getFont()).getHeight() + b.getIconTextGap() + 8;
        }
        return Return;
    }

    public int getButtonTextWidth() {
        int Return = 0;
        int count = this.getButtonCount();
        int margin = 0;
        for (int i = 0; i < count; ++i) {
            JToggleButton b = this.buttons.elementAt((int)i).button;
            String s = b.getText();
            if (s == null || s.length() <= 0) continue;
            if (margin == 0 && b.getBorder() != null) {
                Insets ins = b.getBorder().getBorderInsets(b);
                margin = ins.left + ins.right;
            }
            Return = Math.max(Return, b.getFontMetrics(b.getFont()).stringWidth(s) + margin);
        }
        return Return;
    }

    private void updateButtonsSize() {
        int count = this.getButtonCount();
        int w = Math.max(Math.max(this.buttonWidth, this.bitmapWidth), this.getButtonTextWidth());
        int h = Math.max(this.buttonHeight, this.bitmapHeight + this.getButtonTextHeight());
        for (int i = 0; i < count; ++i) {
            JToggleButton btn = this.buttons.elementAt((int)i).button;
            btn.setPreferredSize(new Dimension(w, h));
        }
        this.setSize(this.getWidth(), h + 2);
    }

    private void updateButtonsImage() {
        int count = this.getButtonCount();
        for (int i = 0; i < count; ++i) {
            this.setIconAt(i);
        }
    }

    public void setImageAt(int idx, Image image) {
        this.buttons.elementAt((int)idx).image = image;
        this.setIconAt(idx);
    }

    private void setIconAt(int idx) {
        JToggleButton btn = this.buttons.elementAt((int)idx).button;
        Image im = this.buttons.elementAt((int)idx).image;
        if (im != null) {
            Image im0 = IsguiUtility.getImage((int)this.bitmapWidth, (int)this.bitmapHeight, (Image)im, (int)1);
            btn.setIcon(new ImageIcon(im0));
        } else {
            btn.setIcon(null);
        }
    }

    public void setStateAt(int idx, int state) {
        JToggleButton btn = this.buttons.elementAt((int)idx).button;
        switch (state) {
            case 1: {
                btn.getModel().setSelected(true);
                btn.getModel().setPressed(false);
                break;
            }
            case 2: {
                btn.getModel().setSelected(false);
                btn.getModel().setPressed(true);
                break;
            }
            default: {
                btn.getModel().setSelected(false);
                btn.getModel().setPressed(false);
            }
        }
    }

    public void setStyleAt(int idx, int style) {
        JToggleButton btn = this.buttons.elementAt((int)idx).button;
        Component cmp = this.getComponentAtIndex(idx);
        switch (style) {
            case 0: {
                if (cmp instanceof JToolBar.Separator) {
                    this.remove(idx);
                    this.add((Component)btn, idx);
                }
                btn.setModel(new DefaultButtonModel());
                this.buttonGroup.remove(btn);
                break;
            }
            case 1: {
                if (cmp instanceof JToolBar.Separator) {
                    this.remove(idx);
                    this.add((Component)btn, idx);
                }
                btn.setModel(new JToggleButton.ToggleButtonModel());
                this.buttonGroup.remove(btn);
                break;
            }
            case 2: 
            case 3: {
                if (cmp instanceof JToolBar.Separator) {
                    this.remove(idx);
                    this.add((Component)btn, idx);
                }
                btn.setModel(new JToggleButton.ToggleButtonModel());
                boolean found = false;
                Enumeration<AbstractButton> e = this.buttonGroup.getElements();
                while (e.hasMoreElements()) {
                    if (e.nextElement() != btn) continue;
                    found = true;
                    break;
                }
                if (found) break;
                this.buttonGroup.add(btn);
                break;
            }
            case 4: {
                if (cmp instanceof JToolBar.Separator) break;
                this.remove(idx);
                this.add((Component)new JToolBar.Separator(), idx);
            }
        }
    }

    public void setEnabledAt(int idx, boolean en) {
        this.buttons.elementAt((int)idx).button.setEnabled(en);
    }

    public void setVisibleAt(int idx, boolean v) {
        this.buttons.elementAt((int)idx).button.setVisible(v);
    }

    public void setTextAt(int idx, String text) {
        this.buttons.elementAt((int)idx).button.setText(text);
        this.updateButtonsSize();
    }

    public void setToolTipEnabledAt(int idx, boolean en) {
        MyButton myb = this.buttons.elementAt(idx);
        myb.toolTipEnabled = en;
        myb.button.setToolTipText(en ? myb.toolTipText : null);
    }

    public void setToolTipTextAt(int idx, String ttt) {
        MyButton myb = this.buttons.elementAt(idx);
        myb.toolTipText = ttt;
        if (myb.toolTipEnabled) {
            myb.button.setToolTipText(ttt);
        }
    }

    WowToolBarListener getListener() {
        return this.listener;
    }

    void setListener(WowToolBarListener listener) {
        this.listener = listener;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame f = new JFrame("Test WowToolBar");
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.setLocationRelativeTo(null);
        f.getContentPane().setLayout(new BorderLayout());
        WowToolBar wt = new WowToolBar();
        wt.setPreferredSize(new Dimension(wt.getPreferredSize().width, 100));
        int bc = 5;
        wt.setButtonCount(bc);
        wt.setButtonHeight(50);
        wt.setButtonWidth(50);
        wt.setBitmapHeight(18);
        wt.setBitmapWidth(18);
        FileInputStream is = new FileInputStream("C:\\Users\\Gianni\\Documents\\attach\\icon.png");
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        Image image = IsguiUtility.createImage((byte[])b, (int[])new int[]{0}, (boolean)true);
        for (int i = 0; i < bc; ++i) {
            wt.setTextAt(i, "Button " + (i + 1));
            if (i <= 1) continue;
            wt.setImageAt(i, image);
        }
        f.getContentPane().add((Component)wt, "North");
        f.setVisible(true);
    }

    private static class MyButton {
        Image image;
        JToggleButton button;
        String toolTipText;
        boolean toolTipEnabled;

        MyButton(JToggleButton b) {
            this.button = b;
        }
    }

    static class WowToolBarEvent
    extends EventObject {
        int buttonId;

        WowToolBarEvent(Object source, int buttonId) {
            super(source);
            this.buttonId = buttonId;
        }
    }

    static interface WowToolBarListener
    extends EventListener {
        public void buttonToolBarClicked(WowToolBarEvent var1);
    }
}

