/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WowTrackBar
extends JSlider {
    private boolean keyPressed;
    private Map<Integer, Timer> timers = new HashMap<Integer, Timer>();
    private int lastValue;
    private WowTrackBarListener listener;
    private boolean listenersAdded;
    private boolean listenerEnabled = true;

    public WowTrackBar() {
        this.setValue(0);
        this.setPaintTicks(true);
    }

    protected void enableListener() {
        this.listenerEnabled = true;
    }

    protected void disableListener() {
        this.listenerEnabled = false;
    }

    public void setVertical(boolean v) {
        if (v) {
            this.setOrientation(1);
            this.setInverted(true);
        } else {
            this.setOrientation(0);
            this.setInverted(false);
        }
    }

    private void restartTimer(int keyCode) {
        Timer timer = this.timers.get(keyCode);
        if (timer == null) {
            timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WowTrackBar.this.listener != null) {
                        WowTrackBar.this.listener.endTrack(new WowTrackBarEvent(WowTrackBar.this));
                    }
                }
            });
            timer.setRepeats(false);
            this.timers.put(keyCode, timer);
            timer.start();
        } else {
            timer.restart();
        }
    }

    public WowTrackBarListener getListener() {
        return this.listener;
    }

    public void setListener(WowTrackBarListener listener) {
        this.listener = listener;
        if (this.listener != null && !this.listenersAdded) {
            this.addListeners();
            this.listenersAdded = true;
        }
    }

    private void addListeners() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 36: {
                        if (WowTrackBar.this.listener != null) {
                            WowTrackBar.this.listener.top(new WowTrackBarEvent(WowTrackBar.this));
                        }
                        WowTrackBar.this.restartTimer(e.getKeyCode());
                        WowTrackBar.this.keyPressed = true;
                        break;
                    }
                    case 35: {
                        if (WowTrackBar.this.listener != null) {
                            WowTrackBar.this.listener.bottom(new WowTrackBarEvent(WowTrackBar.this));
                        }
                        WowTrackBar.this.restartTimer(e.getKeyCode());
                        WowTrackBar.this.keyPressed = true;
                        break;
                    }
                    case 37: 
                    case 38: {
                        if (WowTrackBar.this.listener != null) {
                            WowTrackBar.this.listener.lineUp(new WowTrackBarEvent(WowTrackBar.this));
                        }
                        WowTrackBar.this.restartTimer(e.getKeyCode());
                        WowTrackBar.this.keyPressed = true;
                        break;
                    }
                    case 39: 
                    case 40: {
                        if (WowTrackBar.this.listener != null) {
                            WowTrackBar.this.listener.lineDown(new WowTrackBarEvent(WowTrackBar.this));
                        }
                        WowTrackBar.this.restartTimer(e.getKeyCode());
                        WowTrackBar.this.keyPressed = true;
                        break;
                    }
                    case 33: {
                        if (WowTrackBar.this.listener != null) {
                            WowTrackBar.this.listener.pageUp(new WowTrackBarEvent(WowTrackBar.this));
                        }
                        WowTrackBar.this.restartTimer(e.getKeyCode());
                        WowTrackBar.this.keyPressed = true;
                        break;
                    }
                    case 34: {
                        if (WowTrackBar.this.listener != null) {
                            WowTrackBar.this.listener.pageDown(new WowTrackBarEvent(WowTrackBar.this));
                        }
                        WowTrackBar.this.restartTimer(e.getKeyCode());
                        WowTrackBar.this.keyPressed = true;
                        break;
                    }
                    default: {
                        WowTrackBar.this.keyPressed = false;
                    }
                }
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (WowTrackBar.this.listenerEnabled && (WowTrackBar.this.getValue() != WowTrackBar.this.lastValue || !WowTrackBar.this.getValueIsAdjusting())) {
                    if (WowTrackBar.this.keyPressed) {
                        WowTrackBar.this.keyPressed = false;
                    } else if (WowTrackBar.this.getValueIsAdjusting()) {
                        if (WowTrackBar.this.listener != null) {
                            WowTrackBar.this.listener.thumbTrk(new WowTrackBarEvent(WowTrackBar.this));
                        }
                    } else if (WowTrackBar.this.listener != null) {
                        WowTrackBar.this.listener.thumbPos(new WowTrackBarEvent(WowTrackBar.this));
                        WowTrackBar.this.listener.endTrack(new WowTrackBarEvent(WowTrackBar.this));
                    }
                    WowTrackBar.this.lastValue = WowTrackBar.this.getValue();
                }
            }
        });
    }

    static class WowTrackBarEvent
    extends EventObject {
        WowTrackBarEvent(Object source) {
            super(source);
        }
    }

    static interface WowTrackBarListener
    extends EventListener {
        public void lineUp(WowTrackBarEvent var1);

        public void lineDown(WowTrackBarEvent var1);

        public void pageUp(WowTrackBarEvent var1);

        public void pageDown(WowTrackBarEvent var1);

        public void top(WowTrackBarEvent var1);

        public void bottom(WowTrackBarEvent var1);

        public void thumbPos(WowTrackBarEvent var1);

        public void thumbTrk(WowTrackBarEvent var1);

        public void endTrack(WowTrackBarEvent var1);
    }
}

