/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.wow.gui.client;

import com.veryant.wow.gui.client.WowComposite;
import com.veryant.wow.gui.client.WowEditBox;
import com.veryant.wow.gui.client.WowStaticText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicArrowButton;

public class WowUpDown
extends JComponent
implements WowComposite {
    static final String ACTION_UP = "Up";
    static final String ACTION_DOWN = "Down";
    private static final char GROUP_SEPARATOR = DecimalFormatSymbols.getInstance().getGroupingSeparator();
    private static final DecimalFormat FORMAT = new DecimalFormat("#,###");
    private MyArrowButton button1;
    private MyArrowButton button2;
    private JPanel buttonPanel;
    private boolean horizontal;
    private JComponent buddy;
    private boolean buddyFocusable;
    private int minimum;
    private int maximum;
    private int value;
    private int increment;
    private boolean valueWrap;
    private boolean useArrowKeys;
    private boolean updateBuddy = true;
    private boolean addGroupSeparators = true;
    private boolean hexadecimal;
    private Map<String, Timer> timers = new HashMap<String, Timer>();
    private WowUpDownListener listener;

    public WowUpDown() {
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.button1 = new MyArrowButton(7, ACTION_UP);
        this.button2 = new MyArrowButton(3, ACTION_DOWN);
        this.setHorizontal(true);
        this.add((Component)this.buttonPanel, "Center");
    }

    public WowUpDownListener getListener() {
        return this.listener;
    }

    public void setListener(WowUpDownListener listener) {
        this.listener = listener;
    }

    private void restartTimer(String key) {
        Timer timer = this.timers.get(key);
        if (timer == null) {
            timer = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WowUpDown.this.listener != null) {
                        WowUpDown.this.listener.endScroll(new WowUpDownEvent(WowUpDown.this));
                    }
                }
            });
            timer.setRepeats(false);
            this.timers.put(key, timer);
            timer.start();
        } else {
            timer.restart();
        }
    }

    public void setHorizontal(boolean h) {
        if (this.horizontal != h || this.buttonPanel.getComponentCount() == 0) {
            this.horizontal = h;
            this.buttonPanel.removeAll();
            if (this.horizontal) {
                this.buttonPanel.setLayout(new GridLayout(1, 2));
                this.button1.setDirection(7);
                this.button1.action = ACTION_DOWN;
                this.button2.setDirection(3);
                this.button2.action = ACTION_UP;
            } else {
                this.buttonPanel.setLayout(new GridLayout(2, 1));
                this.button1.setDirection(1);
                this.button1.action = ACTION_UP;
                this.button2.setDirection(5);
                this.button2.action = ACTION_DOWN;
            }
            this.buttonPanel.add(this.button1);
            this.buttonPanel.add(this.button2);
            this.buttonPanel.doLayout();
        }
    }

    public void setBuddy(JComponent comp, int position, boolean focusable) {
        this.buddy = comp;
        this.buddyFocusable = focusable;
        this.removeAll();
        if (this.buddy != null && position > 0) {
            this.add((Component)this.buddy, "Center");
            switch (position) {
                default: {
                    this.add((Component)this.buttonPanel, "East");
                    break;
                }
                case 4: {
                    this.add((Component)this.buttonPanel, "West");
                    break;
                }
            }
        } else {
            this.add((Component)this.buttonPanel, "Center");
        }
        if (this.buddy != null && this.buddyFocusable) {
            this.getFocusOwner().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (WowUpDown.this.useArrowKeys) {
                        switch (ke.getKeyCode()) {
                            case 38: {
                                WowUpDown.this.increment();
                                WowUpDown.this.restartTimer(WowUpDown.ACTION_UP);
                                break;
                            }
                            case 40: {
                                WowUpDown.this.decrement();
                                WowUpDown.this.restartTimer(WowUpDown.ACTION_DOWN);
                            }
                        }
                    }
                }
            });
            this.button1.setFocusable(false);
            this.button2.setFocusable(false);
        } else {
            this.button1.setFocusable(true);
            this.button2.setFocusable(true);
        }
        this.doLayout();
    }

    @Override
    public Component getFocusOwner() {
        if (this.buddy != null && this.buddyFocusable) {
            if (this.buddy instanceof WowComposite) {
                return ((WowComposite)((Object)this.buddy)).getFocusOwner();
            }
            return this.buddy;
        }
        return this.button1;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public void setValueWrap(boolean w) {
        this.valueWrap = w;
    }

    public void setUseArrowKeys(boolean b) {
        this.useArrowKeys = b;
    }

    public void setUpdateBuddy(boolean updateBuddy) {
        this.updateBuddy = updateBuddy;
    }

    public void setAddGroupSeparators(boolean addGroupSeparators) {
        this.addGroupSeparators = addGroupSeparators;
    }

    public void setHexadecimal(boolean hexadecimal) {
        this.hexadecimal = hexadecimal;
    }

    private void increment() {
        this.value = this.getBuddyValue() + this.increment;
        this.valueChanged();
    }

    private void decrement() {
        this.value = this.getBuddyValue() - this.increment;
        this.valueChanged();
    }

    private int getBuddyValue() {
        int v = this.value;
        if (this.buddy != null && this.updateBuddy) {
            String text = "";
            if (this.buddy instanceof WowEditBox) {
                text = ((WowEditBox)this.buddy).getText();
            } else if (this.buddy instanceof WowStaticText) {
                text = ((WowStaticText)this.buddy).getText();
            }
            text = text.trim();
            if (this.hexadecimal) {
                try {
                    v = Integer.parseInt(text.substring(2), 16);
                }
                catch (Exception exception) {}
            } else {
                if (this.addGroupSeparators) {
                    text = text.replaceAll("\\" + GROUP_SEPARATOR, "");
                }
                try {
                    v = Integer.parseInt(text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return v;
    }

    private void setBuddyValue() {
        if (this.buddy != null && this.updateBuddy) {
            String text = this.hexadecimal ? "0x" + Integer.toHexString(this.value).toUpperCase() : (this.addGroupSeparators ? FORMAT.format(this.value) : Integer.toString(this.value));
            if (this.buddy instanceof WowEditBox) {
                ((WowEditBox)this.buddy).setText(text);
            } else if (this.buddy instanceof WowStaticText) {
                ((WowStaticText)this.buddy).setText(text);
            }
        }
        this.requestFocusInWindow();
    }

    private void valueChanged() {
        if (this.valueWrap) {
            if (this.value > this.maximum) {
                this.value = this.minimum + this.value - this.maximum;
            } else if (this.value < this.minimum) {
                this.value = this.maximum + this.value - this.minimum;
            }
        } else if (this.value > this.maximum) {
            this.value = this.maximum;
        } else if (this.value < this.minimum) {
            this.value = this.minimum;
        }
        this.setBuddyValue();
        if (this.listener != null) {
            this.listener.thumbPos(new WowUpDownEvent(this));
        }
    }

    @Override
    public void requestFocus() {
        if (this.buddy != null && this.buddyFocusable) {
            this.buddy.requestFocus();
        } else {
            this.button1.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.buddy != null && this.buddyFocusable) {
            return this.buddy.requestFocusInWindow();
        }
        return this.button1.requestFocusInWindow();
    }

    private class MyArrowButton
    extends BasicArrowButton {
        private boolean focusable;
        private String action;

        MyArrowButton(int direction, String action) {
            super(direction);
            this.setFocusable(true);
            this.action = action;
            this.addMouseListener(new MouseAdapter(){
                EventDispatcher ed;

                private void end() {
                    if (this.ed != null) {
                        this.ed.t.stop();
                        this.ed = null;
                        if (WowUpDown.this.listener != null) {
                            WowUpDown.this.listener.endScroll(new WowUpDownEvent(WowUpDown.this));
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.end();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.end();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (MyArrowButton.this.isEnabled()) {
                        this.ed = new EventDispatcher(MyArrowButton.this.action);
                    }
                }
            });
        }

        @Override
        public boolean isFocusable() {
            return this.focusable;
        }

        @Override
        public void setFocusable(boolean focusable) {
            super.setFocusable(focusable);
            this.focusable = focusable;
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private Timer t;
        private String action;

        EventDispatcher(String action) {
            this.action = action;
            this.fireEvent();
            this.t = new Timer(75, this);
            this.t.setInitialDelay(300);
            this.t.setRepeats(true);
            this.t.start();
        }

        private void fireEvent() {
            if (this.action == WowUpDown.ACTION_UP) {
                WowUpDown.this.increment();
            } else {
                WowUpDown.this.decrement();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEvent();
        }
    }

    static class WowUpDownEvent
    extends EventObject {
        WowUpDownEvent(Object source) {
            super(source);
        }
    }

    static interface WowUpDownListener
    extends EventListener {
        public void thumbPos(WowUpDownEvent var1);

        public void endScroll(WowUpDownEvent var1);
    }
}

