/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.util.Date;
import java.util.TooManyListenersException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jbundle.util.calendarpanel.CalendarPanel;
import org.jbundle.util.calendarpanel.dnd.CalendarPaneDropTargetListener;
import org.jbundle.util.calendarpanel.util.CalendarCache;
import org.jbundle.util.calendarpanel.util.JUnderlinedLabel;

public class CalendarPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected int m_iDateOffset = -1;
    protected int m_iHeightSurvey = 0;
    protected Dimension m_dimLastTime = null;
    public static final Color DATE_TEXT_COLOR = Color.black;
    public static final Color ITEM_TEXT_COLOR = Color.blue;
    public static final Color ITEM_LIGHT_TEXT_COLOR = Color.gray;
    public static final String BLANK = "";
    public static final String m_kstrTextTip = "Click to see the details, drag to change the start date";
    public static final String m_kstrStartIconTip = "Drag this icon to change the start date";
    public static final String m_kstrEndIconTip = "Drag this icon to change the end date";

    public CalendarPane() {
    }

    public CalendarPane(int iDateOffset, Border border) {
        this();
        this.init(iDateOffset, border);
    }

    public void init(int iDateOffset, Border border) {
        this.m_iDateOffset = iDateOffset;
        if (border != null) {
            this.setBorder(border);
        }
        this.setForeground(Color.black);
        this.setOpaque(false);
        DropTarget dt = new DropTarget();
        this.setDropTarget(dt);
        try {
            dt.addDropTargetListener(new CalendarPaneDropTargetListener(null));
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
        }
    }

    public void free() {
        this.setDropTarget(null);
    }

    public int surveyComponents() {
        if (this.m_dimLastTime != null && this.m_dimLastTime.width == this.getBounds().width && this.m_dimLastTime.height == this.getBounds().height) {
            return this.m_iHeightSurvey;
        }
        if (this.m_dimLastTime == null) {
            this.m_dimLastTime = new Dimension(0, 0);
        }
        this.m_dimLastTime.setSize(this.getBounds().width, this.getBounds().height);
        this.getCalendarPanel().checkPaneWidth(this.m_dimLastTime.width);
        this.m_iHeightSurvey = 0;
        int iIndex = this.getComponentCount() - 1;
        while (iIndex >= 0) {
            Component component = this.getComponent(iIndex);
            if (component instanceof JUnderlinedLabel) {
                ((JUnderlinedLabel)component).free();
            }
            --iIndex;
        }
        this.removeAll();
        this.addDateLabel();
        int iXNextMeal = 0;
        int i = 0;
        while (i < this.getCalendarPanel().getCacheCount(true)) {
            CalendarCache itemCache = this.getCalendarPanel().getCacheItem(i);
            this.addItemLabel(itemCache);
            iXNextMeal = this.addMealLabel(itemCache, itemCache.getItem().getMealDesc(this.getThisDate()), iXNextMeal);
            ++i;
        }
        return this.m_iHeightSurvey;
    }

    public void addDateLabel() {
        Rectangle rect = this.getBounds();
        Insets insets = this.getInsets();
        JLabel label = null;
        String strName = this.getDayDesc();
        label = new JLabel(strName);
        this.add(label);
        label.setForeground(DATE_TEXT_COLOR);
        if (this.getCalendarPanel().getFontMetrics() == null) {
            this.getCalendarPanel().setFontMetrics(label.getFontMetrics(label.getFont()));
        }
        int iStringWidth = this.getCalendarPanel().getFontMetrics().stringWidth(strName);
        CalendarPanel calendarPanel = this.getCalendarPanel();
        int iLabelHeight = this.getCalendarPanel().getFontMetrics().getHeight();
        if (calendarPanel.getFirstLine() > 0) {
            this.getCalendarPanel().surveyRowHeight(iLabelHeight);
        }
        label.setBounds(new Rectangle(rect.width - insets.right - iStringWidth - 1, 1 + insets.top, rect.width, iLabelHeight));
    }

    public int addMealLabel(CalendarCache itemCache, String strMeal, int iXNextMeal) {
        if (strMeal == null || strMeal.length() == 0) {
            return iXNextMeal;
        }
        Insets insets = this.getInsets();
        CalendarPanel calendarPanel = this.getCalendarPanel();
        if (!calendarPanel.isMeals()) {
            return iXNextMeal;
        }
        JLabel label = null;
        Component component = this.getComponentAt(insets.left + 1, insets.top + 1);
        if (!(component instanceof JUnderlinedLabel)) {
            if (iXNextMeal == -1) {
                iXNextMeal = 0;
            }
            label = this.addIcon(null, calendarPanel.getMealIcon(), insets.left + 1, insets.top + 1, null, null, 0, null);
            iXNextMeal += label.getWidth() + insets.left + 2;
        } else if (iXNextMeal == -1 && component != null) {
            iXNextMeal += 1 + component.getBounds().width + insets.left + 2;
            int iStringLength = this.getCalendarPanel().getFontMetrics().stringWidth(strMeal);
            int iXStart = -1;
            while (iXNextMeal < this.getBounds().width) {
                component = this.getComponentAt(iXNextMeal, insets.top + 1);
                if (component != this) {
                    iXStart = -1;
                }
                if (iXStart == -1) {
                    iXStart = iXNextMeal;
                } else if (iXNextMeal - iXStart > iStringLength) {
                    iXNextMeal = iXStart + 1;
                    break;
                }
                ++iXNextMeal;
            }
        }
        label = this.addLabel(itemCache, strMeal, iXNextMeal, 1 + insets.top, true, -1, null, null, 1011, null);
        label.setForeground(ITEM_TEXT_COLOR);
        return iXNextMeal += label.getWidth() + 1;
    }

    public void addItemLabel(CalendarCache itemCache) {
        Rectangle rect = this.getBounds();
        Insets insets = this.getInsets();
        JLabel label = null;
        long lEndDate = this.getThisDate().getTime() + 86400000L - 1L;
        if (itemCache.getItem() == null || itemCache.getItem().getStartDate() == null) {
            return;
        }
        if (itemCache.getItem().getStartDate().getTime() >= lEndDate) {
            return;
        }
        int iXStartService = this.convertDateToX(itemCache.getItem().getStartDate(), rect.width);
        Date dateEnd = itemCache.getItem().getEndDate();
        if (dateEnd == null) {
            dateEnd = itemCache.getItem().getStartDate();
        }
        int iXEndService = this.convertDateToX(dateEnd, rect.width);
        CalendarPanel calendarPanel = this.getCalendarPanel();
        String strDescription = BLANK;
        if (calendarPanel.isDescriptions()) {
            strDescription = itemCache.getItem().getDescription();
        }
        int iWidthDescription = this.getCalendarPanel().getFontMetrics().stringWidth(strDescription);
        iXStartService += insets.left;
        ImageIcon imageStart = null;
        ImageIcon imageEnd = null;
        if (calendarPanel.isIcons()) {
            Object image = itemCache.getItem().getIcon(1000);
            ImageIcon imageIcon = imageStart = image instanceof Image ? new ImageIcon((Image)image) : (ImageIcon)image;
            if (imageStart != null && imageStart.getIconWidth() < 0) {
                imageStart = null;
            }
            ImageIcon imageIcon2 = imageEnd = (image = itemCache.getItem().getIcon(1010)) instanceof Image ? new ImageIcon((Image)image) : (ImageIcon)image;
            if (imageEnd != null && imageEnd.getIconWidth() < 0) {
                imageEnd = null;
            }
        }
        int iWidthService = iXEndService - iXStartService;
        int iWidthImages = (imageStart == null ? 0 : imageStart.getIconWidth()) + (imageEnd == null ? 0 : imageEnd.getIconWidth());
        if (iWidthDescription + iWidthImages < 5 && iWidthService < 5) {
            iWidthService = 5;
        }
        int iTotalWidth = Math.max(iWidthDescription + iWidthImages, iWidthService);
        int iWidthStartDesc = Math.max(0, iWidthService - iWidthImages);
        int iLine = itemCache.getLine(null);
        if (iLine == -1) {
            iLine = itemCache.getLine(this.convertXToDate(iXStartService + iTotalWidth, rect.width));
        }
        int y = (iLine += calendarPanel.getFirstLine() - 1) * this.getCalendarPanel().getRowHeight();
        if (iXStartService + iTotalWidth < 0) {
            return;
        }
        if (iXStartService > rect.width) {
            return;
        }
        Color colorHighlight = new Color(itemCache.getItem().getHighlightColor());
        Color colorSelect = new Color(itemCache.getItem().getSelectColor());
        if (imageStart != null && iXStartService + imageStart.getIconWidth() >= 0) {
            label = this.addIcon(itemCache, imageStart, iXStartService, insets.top + y, colorHighlight, colorSelect, 1000, m_kstrStartIconTip);
            ((JUnderlinedLabel)label).setStartRound(true);
        }
        if (imageStart != null) {
            iXStartService += imageStart.getIconWidth();
        }
        if (imageStart != null && label != null) {
            int iIndex = 1001;
            while (iIndex < 1010) {
                ImageIcon icon;
                Object image = itemCache.getItem().getIcon(iIndex);
                ImageIcon imageIcon = icon = image instanceof Image ? new ImageIcon((Image)image) : (ImageIcon)image;
                if (icon != null) {
                    ((JUnderlinedLabel)label).addIcon(icon, iIndex - 1000);
                }
                ++iIndex;
            }
        }
        if (iWidthStartDesc > 0 && iXStartService + iWidthStartDesc >= 0) {
            label = this.addLabel(itemCache, strDescription, iXStartService, insets.top + y, true, iWidthStartDesc, colorHighlight, colorSelect, 1011, m_kstrTextTip);
        }
        if (iWidthStartDesc > 0) {
            iXStartService += iWidthStartDesc;
        }
        if (iXStartService <= rect.width && imageEnd != null && iXStartService + imageStart.getIconWidth() >= 0) {
            label = this.addIcon(itemCache, imageEnd, iXStartService, insets.top + y, colorHighlight, colorSelect, 1010, m_kstrEndIconTip);
        }
        if (imageEnd != null) {
            iXStartService += imageEnd.getIconWidth();
        }
        if (label != null && iXStartService <= rect.width) {
            ((JUnderlinedLabel)label).setEndRound(true);
        }
        if (iXStartService <= rect.width && iWidthDescription - iWidthStartDesc > 0) {
            label = this.addLabel(itemCache, strDescription, iXStartService, insets.top + y, true, iWidthDescription - iWidthStartDesc, null, null, 1011, m_kstrTextTip);
            label.setBorder(new EmptyBorder(new Insets(0, -iWidthStartDesc, 0, -200)));
            iXStartService += iWidthDescription - iWidthStartDesc;
        }
    }

    public void surveyThis(int iY) {
        this.m_iHeightSurvey = Math.max(this.m_iHeightSurvey, iY);
    }

    public int convertDateToX(Date date, int iPaneWidth) {
        return (int)((double)(date.getTime() - this.getThisDate().getTime()) / 8.64E7 * (double)iPaneWidth);
    }

    public Date convertXToDate(int x, int iPaneWidth) {
        return new Date((long)((double)x / (double)iPaneWidth * 8.64E7 + (double)this.getThisDate().getTime()));
    }

    public JLabel addIcon(CalendarCache itemCache, ImageIcon image, int x, int y, Color colorHighlighted, Color colorSelect, int iComponentType, String strToolTip) {
        JUnderlinedLabel label = null;
        label = new JUnderlinedLabel(itemCache, image, true, colorHighlighted, colorSelect, iComponentType, strToolTip);
        this.add(label);
        if (this.getCalendarPanel() != null) {
            label.setBackgroundImage(this.getCalendarPanel().getBackgroundImage());
        }
        label.setBorder(CalendarPanel.m_borderEmpty);
        if (image != null) {
            this.getCalendarPanel().surveyRowHeight(image.getIconHeight());
            label.setBounds(new Rectangle(x, y, image.getIconWidth(), this.getCalendarPanel().getRowHeight()));
        }
        this.surveyThis(y + this.getCalendarPanel().getRowHeight());
        return label;
    }

    public JLabel addLabel(CalendarCache itemCache, String strDesc, int x, int y, boolean bSelectable, int iStringLength, Color colorHighlighted, Color colorSelect, int iComponentType, String strToolTip) {
        JUnderlinedLabel label = null;
        if (y < 6 && colorHighlighted != null) {
            colorHighlighted = colorHighlighted.darker();
        }
        if (y < 6 && colorSelect != null) {
            colorSelect = colorSelect.darker();
        }
        label = new JUnderlinedLabel(itemCache, strDesc, bSelectable, colorHighlighted, colorSelect, iComponentType, strToolTip);
        this.add(label);
        if (this.getCalendarPanel() != null) {
            label.setBackgroundImage(this.getCalendarPanel().getBackgroundImage());
        }
        if (iStringLength == -1) {
            iStringLength = this.getCalendarPanel().getFontMetrics().stringWidth(label.getText());
        }
        label.setBorder(CalendarPanel.m_borderLabel);
        label.setBounds(new Rectangle(x, y, iStringLength, this.getCalendarPanel().getRowHeight()));
        this.surveyThis(y + this.getCalendarPanel().getRowHeight());
        return label;
    }

    public CalendarPanel getCalendarPanel() {
        return (CalendarPanel)this.getParent();
    }

    public Date getThisDate() {
        return this.getCalendarPanel().getDaysOffset(this.getCalendarPanel().getFirstDate(), this.m_iDateOffset);
    }

    public String getDayDesc() {
        return this.getCalendarPanel().getDateString(this.getThisDate(), 3);
    }

    public void select(Border newBorder) {
        Border oldBorder = this.getBorder();
        if (newBorder != null && newBorder != oldBorder) {
            this.setBorder(newBorder);
            this.repaint();
        }
    }

    public int getDateOffset() {
        return this.m_iDateOffset;
    }
}

