/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.jbundle.util.calendarpanel.CalendarPane;
import org.jbundle.util.calendarpanel.CalendarPaneLayout;
import org.jbundle.util.calendarpanel.PopupPanel;
import org.jbundle.util.calendarpanel.StatusListener;
import org.jbundle.util.calendarpanel.event.MyListSelectionEvent;
import org.jbundle.util.calendarpanel.event.MyListSelectionListener;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.CalendarModel;
import org.jbundle.util.calendarpanel.util.CalendarCache;
import org.jbundle.util.calendarpanel.util.PaneBorder;

public class CalendarPanel
extends JComponent
implements TableModelListener,
ActionListener,
PropertyChangeListener,
MyListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String DATE = "date";
    public static Border m_borderLabel = new EmptyBorder(new Insets(0, 0, 0, -200));
    public static Border m_borderEmpty = new EmptyBorder(new Insets(0, 0, 0, 0));
    public static Border m_paneBorder = new PaneBorder(1);
    public static Border m_paneSelectedBorder = new PaneBorder(0);
    public static final long KMS_IN_A_DAY = 86400000L;
    public static final int PREFERRED_HEIGHT = 75;
    public static final int PREFERRED_WIDTH = 75;
    public static final int DEFAULT_ROWS_IN_BOX = 4;
    protected boolean m_bMeals = true;
    protected boolean m_bIcons = true;
    protected boolean m_bDescriptions = true;
    protected int m_iFirstLine = 1;
    protected Dimension m_dimPaneMinimum = new Dimension(75, 75);
    protected Dimension m_dimPanePreferred = new Dimension(75, 75);
    protected int m_iLastPanelHeight = 0;
    protected int m_iRowHeight = 3;
    protected FontMetrics m_fmLabel = null;
    protected boolean m_bReSetupCalendar = false;
    protected Date m_dateFirst = null;
    protected Date m_dateLast = null;
    protected Date m_dateDefault = null;
    protected Date m_dateFirstBox = null;
    protected Calendar m_calendarLastBox = Calendar.getInstance();
    protected String m_strMonth = null;
    protected Calendar m_calendar = Calendar.getInstance();
    protected GridBagLayout m_gridbag = null;
    protected GridBagConstraints m_constraints = null;
    protected DateFormat m_df = DateFormat.getDateInstance(0);
    protected StringBuffer m_sb = new StringBuffer();
    protected CalendarModel m_model = null;
    protected Vector<CalendarCache> m_modelCache = null;
    protected ImageIcon backgroundImage = null;
    private int m_iPaneWidth = 0;
    private CalendarPaneLayout m_layoutShared = null;
    protected StatusListener statusListener = null;
    private boolean bShifted = false;
    protected Component m_popupComponent = null;
    protected Popup m_popup = null;

    public CalendarPanel() {
    }

    public CalendarPanel(CalendarModel model, boolean bBigCalendar, ImageIcon imageIcon) {
        this();
        this.init(model, bBigCalendar, imageIcon);
    }

    public void init(CalendarModel model, boolean bBigCalendar, ImageIcon backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.resetConstraints();
        this.setBigCalendar(bBigCalendar);
        this.setFont(new Font("Helvetica", 0, 14));
        this.setLayout(this.m_gridbag);
        this.setModel(model, false);
        this.setOpaque(false);
        this.m_bReSetupCalendar = true;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                CalendarPanel.this.checkForRelayout(null, null);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                CalendarPanel.this.panelMouseClicked(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 16) {
                    CalendarPanel.this.bShifted = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.getKeyCode() == 16) {
                    CalendarPanel.this.bShifted = false;
                }
            }
        });
        this.registerKeyboardAction(this, "Delete", KeyStroke.getKeyStroke(127, 0), 1);
        this.registerKeyboardAction(this, "Delete", KeyStroke.getKeyStroke(127, 2), 1);
        this.registerKeyboardAction(this, "Select all", KeyStroke.getKeyStroke(65, 2), 1);
        this.registerKeyboardAction(this, "Up", KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(this, "Down", KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(this, "Right", KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(this, "Left", KeyStroke.getKeyStroke(37, 0), 1);
    }

    public void free() {
        if (this.m_popup != null) {
            this.m_popup.hide();
        }
        this.m_popup = null;
        this.m_popupComponent = null;
        int i = this.getCacheCount(false) - 1;
        while (i >= 0) {
            CalendarCache calCache = this.getCacheItem(i);
            if (calCache != null) {
                calCache.free();
            }
            --i;
        }
        Component component = null;
        int iComp = 0;
        while (iComp < this.getComponentCount()) {
            component = this.getComponent(iComp);
            if (component instanceof CalendarPane) {
                ((CalendarPane)component).free();
            }
            ++iComp;
        }
    }

    public boolean isShifted() {
        return this.bShifted;
    }

    public void setModel(CalendarModel model, boolean bNotifyListeners) {
        this.m_model = model;
        model.addTableModelListener(this);
        model.addMySelectionListener(this);
        this.m_dateFirst = model.getStartDate();
        this.m_dateLast = model.getEndDate();
        this.m_dateFirst = model.getSelectDate();
    }

    public void setBigCalendar(boolean bBigCalendar) {
        if (bBigCalendar) {
            this.m_bMeals = true;
            this.m_bIcons = true;
            this.m_bDescriptions = true;
            this.m_iFirstLine = 1;
            this.m_dimPaneMinimum = new Dimension(75, 75);
            this.m_dimPanePreferred = new Dimension(75, 75);
        } else {
            this.m_bMeals = false;
            this.m_bIcons = false;
            this.m_bDescriptions = false;
            this.m_iFirstLine = 0;
            this.m_dimPaneMinimum = new Dimension(20, 20);
            this.m_dimPanePreferred = new Dimension(20, 20);
        }
        this.m_iRowHeight = 3;
    }

    public synchronized void setupCalendar(Date dateFirst, Date dateLast, boolean bSurveyInThread) {
        int i = 0;
        while (i < this.getCacheCount(false)) {
            CalendarCache calCache = this.getCacheItem(i);
            calCache.removeComponents();
            ++i;
        }
        int iComp = this.getComponentCount() - 1;
        while (iComp >= 0) {
            this.remove(this.getComponent(iComp));
            --iComp;
        }
        this.resetConstraints();
        SurveyWorker worker = null;
        if (bSurveyInThread && dateFirst == null && dateLast == null) {
            worker = new SurveyWorker();
            if (dateFirst == null) {
                dateFirst = new Date();
            }
            if (dateLast == null) {
                dateLast = dateFirst;
            }
        } else {
            if (dateFirst == null) {
                dateFirst = this.surveyModelDates(true);
            }
            if (dateLast == null) {
                dateLast = this.surveyModelDates(false);
            }
        }
        dateFirst = this.truncDate(dateFirst);
        dateLast = this.truncDate(dateLast);
        this.m_dateFirstBox = this.getFirstDateInCalendar(dateFirst);
        long lDaysInTour = (dateLast.getTime() - this.m_dateFirstBox.getTime()) / 86400000L + 1L;
        if (lDaysInTour < 28L) {
            this.m_calendar.setTime(this.m_dateFirstBox);
            this.m_calendar.add(5, 28);
            dateLast = this.m_calendar.getTime();
        }
        this.m_calendarLastBox.setTime(dateLast);
        this.addMonthBox(6);
        this.addDaysOfWeek();
        int iWeekCount = 1;
        int iWeek = 0;
        while (iWeek < 52) {
            this.m_calendar.setTime(this.m_dateFirstBox);
            this.m_calendar.add(5, (iWeek + 1) * 7);
            if (this.m_calendar.after(this.m_calendarLastBox)) break;
            ++iWeekCount;
            ++iWeek;
        }
        this.m_calendarLastBox.setTime(this.m_dateFirstBox);
        this.m_calendarLastBox.add(5, iWeekCount * 7);
        this.m_calendarLastBox.add(12, -1);
        iWeek = 0;
        while (iWeek < iWeekCount) {
            this.addThisWeek(iWeek);
            if (iWeek + 1 != iWeekCount) {
                this.addMonthBox(iWeek * 7 + 7 + 6);
            }
            ++iWeek;
        }
        this.addFillBox();
        if (worker != null) {
            worker.execute();
        }
    }

    public void resetConstraints() {
        if (this.m_gridbag == null) {
            this.m_gridbag = new GridBagLayout();
        }
        this.m_constraints = new GridBagConstraints();
        this.m_constraints.fill = 1;
        this.m_constraints.weightx = 1.0;
        this.m_constraints.anchor = 10;
        this.m_constraints.gridwidth = 7;
        this.m_constraints.gridwidth = 0;
    }

    public void addMonthBox(int iDayOffsetFromFirst) {
        Date dateTarget = this.getDaysOffset(this.m_dateFirstBox, iDayOffsetFromFirst);
        String strYear = this.getDateString(dateTarget, 1);
        String strMonth = this.getDateString(dateTarget, 2);
        if (strMonth.equals(this.m_strMonth)) {
            return;
        }
        this.m_strMonth = strMonth;
        this.m_constraints.fill = 1;
        this.m_constraints.weightx = 1.0;
        this.m_constraints.anchor = 10;
        this.m_constraints.gridwidth = 7;
        this.m_constraints.gridwidth = 0;
        this.makeLabel(this, String.valueOf(strMonth) + " " + strYear);
    }

    public void addDaysOfWeek() {
        this.m_constraints.fill = 1;
        this.m_constraints.weightx = 1.0;
        this.m_constraints.anchor = 10;
        this.m_constraints.gridwidth = 1;
        int iDayOfWeek = 0;
        while (iDayOfWeek < 7) {
            Date dateTarget = this.getDaysOffset(this.m_dateFirstBox, iDayOfWeek);
            String strWeek = this.getDateString(dateTarget, 9);
            if (!this.m_bDescriptions && strWeek != null && strWeek.length() > 0) {
                strWeek = strWeek.substring(0, 1);
            }
            if (iDayOfWeek == 6) {
                this.m_constraints.gridwidth = 0;
            }
            this.makeLabel(this, strWeek);
            ++iDayOfWeek;
        }
    }

    public void addThisWeek(int iWeek) {
        this.m_constraints.fill = 1;
        this.m_constraints.weightx = 1.0;
        this.m_constraints.gridwidth = 1;
        this.m_constraints.anchor = 13;
        int iDayOfWeek = 0;
        while (iDayOfWeek < 7) {
            if (iDayOfWeek == 6) {
                this.m_constraints.gridwidth = 0;
            }
            this.makePanel(iDayOfWeek + iWeek * 7);
            ++iDayOfWeek;
        }
    }

    public void addFillBox() {
        this.m_constraints.fill = 1;
        this.m_constraints.weightx = 1.0;
        this.m_constraints.weighty = 1.0;
        this.m_constraints.gridwidth = 0;
        this.m_constraints.gridheight = 0;
        JPanel newpanel = new JPanel();
        newpanel.setOpaque(false);
        newpanel.setPreferredSize(new Dimension(0, 0));
        this.m_gridbag.setConstraints(newpanel, this.m_constraints);
        this.add(newpanel);
    }

    protected JPanel makePanel(int iDayOffsetFromFirst) {
        CalendarPane newpanel = new CalendarPane(iDayOffsetFromFirst, m_paneBorder);
        if (this.m_layoutShared == null) {
            this.m_layoutShared = new CalendarPaneLayout(this);
        }
        newpanel.setLayout(this.m_layoutShared);
        this.m_gridbag.setConstraints(newpanel, this.m_constraints);
        this.add(newpanel);
        return newpanel;
    }

    protected void makeLabel(JComponent panel, String name) {
        JLabel newpanel = new JLabel(name, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        this.m_gridbag.setConstraints(newpanel, this.m_constraints);
        newpanel.setForeground(Color.black);
        newpanel.setBorder(m_paneBorder);
        panel.add(newpanel);
    }

    public Date getFirstDateInCalendar(Date dateTarget) {
        int iFirstDayOfWeek = this.m_calendar.getFirstDayOfWeek();
        this.m_calendar.setTime(dateTarget);
        int iTargetDayOfWeek = this.m_calendar.get(7);
        int iOffset = -Math.abs(iTargetDayOfWeek - iFirstDayOfWeek);
        this.m_calendar.add(5, iOffset);
        this.m_calendar.set(11, 0);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        return this.m_calendar.getTime();
    }

    public String getDateString(Date dateTarget, int iDateFormat) {
        this.m_sb.setLength(0);
        FieldPosition fieldPosition = new FieldPosition(iDateFormat);
        String string = null;
        string = this.m_df.format(dateTarget, this.m_sb, fieldPosition).toString();
        int iBegin = fieldPosition.getBeginIndex();
        int iEnd = fieldPosition.getEndIndex();
        string = string.substring(iBegin, iEnd);
        return string;
    }

    public Date getDaysOffset(Date dateTarget, int iOffsetDays) {
        this.m_calendar.setTime(dateTarget);
        this.m_calendar.add(5, iOffsetDays);
        dateTarget = this.m_calendar.getTime();
        return dateTarget;
    }

    public Date truncDate(Date date) {
        this.m_calendar.setTime(date);
        this.m_calendar.set(11, 0);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        return this.m_calendar.getTime();
    }

    public Date getFirstDate() {
        return this.m_dateFirstBox;
    }

    @Override
    public void doLayout() {
        if (this.m_bReSetupCalendar) {
            this.m_bReSetupCalendar = false;
            this.setupCalendar(this.m_dateFirst, this.m_dateLast, false);
        }
        super.doLayout();
    }

    public ImageIcon getMealIcon() {
        return this.m_model.getHeaderIcon();
    }

    public boolean isMeals() {
        return this.m_bMeals;
    }

    public boolean isIcons() {
        return this.m_bIcons;
    }

    public boolean isDescriptions() {
        return this.m_bDescriptions;
    }

    public int getFirstLine() {
        return this.m_iFirstLine;
    }

    public void panelMouseClicked(MouseEvent e) {
        Component component = this.getComponentAt(e.getPoint());
        this.selectAll(false, true);
        boolean bFocusHere = true;
        if (component instanceof CalendarPane) {
            CalendarPane pane = (CalendarPane)component;
            int iX = e.getPoint().x - component.getBounds().x;
            Date dateTarget = pane.convertXToDate(iX, component.getBounds().width);
            this.firePropertyChange(DATE, null, dateTarget);
            boolean bl = bFocusHere = !this.createPopup(e.getPoint());
        }
        if (bFocusHere) {
            this.requestFocus();
        }
    }

    public void setPopupComponent(Component popupComponent) {
        this.m_popupComponent = popupComponent;
    }

    public boolean createPopup(Point location) {
        if (this.m_popupComponent == null) {
            return false;
        }
        if (this.m_popup != null) {
            this.m_popup.hide();
        }
        CalendarPanel owner = this;
        SwingUtilities.convertPointToScreen(location, owner);
        this.fitComponentInWindow(location, this.m_popupComponent, owner);
        this.m_popup = PopupFactory.getSharedInstance().getPopup(owner, this.m_popupComponent, location.x, location.y);
        this.m_popup.show();
        this.m_popupComponent.requestFocus();
        this.m_popupComponent.addFocusListener(new HideOnLoseFocus(this.m_popup, this.m_popupComponent));
        if (this.m_popupComponent instanceof PopupPanel) {
            ((PopupPanel)((Object)this.m_popupComponent)).setPopupParent(this.m_popup);
        }
        return true;
    }

    public void fitComponentInWindow(Point location, Component component, Component owner) {
        Component top = owner;
        while (top.getParent() != null) {
            top = top.getParent();
        }
        Rectangle rect = new Rectangle(location.x, location.y, component.getWidth(), component.getHeight());
        if (rect.getWidth() == 0.0 && rect.getWidth() == 0.0) {
            rect.setSize(150, 230);
        }
        if (top.getBounds().contains(rect)) {
            return;
        }
        if ((double)location.x + rect.getWidth() > (double)(top.getX() + top.getWidth())) {
            location.x = (int)((double)(top.getX() + top.getWidth()) - rect.getWidth() - 5.0);
        }
        if ((double)location.y + rect.getHeight() > (double)(top.getY() + top.getHeight())) {
            location.y = (int)((double)(top.getY() + top.getHeight()) - rect.getHeight() - 5.0);
        }
    }

    public void selectAll(boolean bSelect, boolean bNotifyModel) {
        int iMode;
        Component component = null;
        int iComp = 0;
        while (iComp < this.getComponentCount()) {
            component = this.getComponent(iComp);
            if (component instanceof CalendarPane) {
                ((CalendarPane)component).select(m_paneBorder);
            }
            ++iComp;
        }
        int i = 0;
        while (i < this.getCacheCount(true)) {
            this.getCacheItem(i).setSelected(bSelect);
            ++i;
        }
        int n = iMode = bSelect ? 1 : 2;
        if (bNotifyModel) {
            this.getModel().fireTableRowSelected(this, -1, iMode);
        }
    }

    public void selectPane(int iNewDayoffsetPane) {
        Component component = null;
        int iComp = 0;
        while (iComp < this.getComponentCount()) {
            CalendarPane pane;
            component = this.getComponent(iComp);
            if (component instanceof CalendarPane && (pane = (CalendarPane)component).getDateOffset() == iNewDayoffsetPane) {
                this.selectAll(false, true);
                pane.select(m_paneSelectedBorder);
            }
            ++iComp;
        }
    }

    public CalendarPane getSelectedPane() {
        Component component = null;
        int iComp = 0;
        while (iComp < this.getComponentCount()) {
            component = this.getComponent(iComp);
            if (component instanceof CalendarPane && ((CalendarPane)component).getBorder() == m_paneSelectedBorder) {
                return (CalendarPane)component;
            }
            ++iComp;
        }
        return null;
    }

    public CalendarCache getSelectedItem() {
        if (this.m_modelCache == null) {
            return null;
        }
        int i = 0;
        while (i < this.getCacheCount(true)) {
            CalendarCache calCache = this.getCacheItem(i);
            if (calCache != null && calCache.isSelected()) {
                return calCache;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void selectionChanged(MyListSelectionEvent evt) {
        int iRowStart = evt.getRow();
        int iType = evt.getType();
        switch (iType) {
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 35: {
                if (iRowStart == -1) break;
                if (iType != 17) {
                    this.selectAll(false, false);
                }
                CalendarCache calCache = this.getCacheItem(iRowStart);
                boolean bSelect = true;
                if (calCache == null) break;
                calCache.setSelected(bSelect);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tableChanged(TableModelEvent event) {
        iColumn = event.getColumn();
        iRowStart = event.getFirstRow();
        iRowEnd = event.getLastRow();
        if (iRowEnd == 0x7FFFFFFF && iColumn != -1) {
            return;
        }
        iType = event.getType();
        if (iRowStart == 0 && iRowEnd == 0x7FFFFFFF && iColumn == -1 && iType == 0) {
            index = this.getCacheCount(false) - 1;
            while (index >= 0) {
                calCache = this.getCacheItem(index);
                if (calCache != null) {
                    this.m_modelCache.remove(index);
                    calCache.removeComponents();
                }
                --index;
            }
            this.m_modelCache = null;
            iRowStart = 0;
            iRowEnd = this.getCacheCount(true) - 1;
        }
        block0 : switch (iType) {
            case 0: 
            case 1: {
                dateSurveyStart = null;
                dateSurveyEnd = null;
                index = iRowStart;
                while (index <= iRowEnd) {
                    if (iType == 1 ? index != this.getCacheCount(true) : index >= this.getCacheCount(true)) break block0;
                    calCache = this.getCacheItem(index);
                    calCache.removeComponents();
                    calCache.cacheItem(this.m_model, calCache.getIndex());
                    item = calCache.getItem();
                    if (item == null) ** GOTO lbl41
                    dateItemStart = item.getStartDate();
                    if (dateItemStart == null) ** GOTO lbl57
                    if (dateSurveyStart == null || dateSurveyStart.after(dateItemStart)) {
                        dateSurveyStart = dateItemStart;
                    }
                    if ((dateItemEnd = item.getEndDate()) == null) {
                        dateItemEnd = dateItemStart;
                    }
                    if (dateItemEnd == null) ** GOTO lbl57
                    if (dateSurveyEnd == null || dateSurveyEnd.after(dateItemEnd)) {
                        dateSurveyEnd = dateItemEnd;
                    }
lbl41:
                    // 4 sources

                    iIndex = 0;
                    while (iIndex < this.getComponentCount()) {
                        component = this.getComponent(iIndex);
                        if (component instanceof CalendarPane) {
                            pane = (CalendarPane)component;
                            pane.addItemLabel(calCache);
                            pane.select(null);
                            date = this.getDaysOffset(this.getFirstDate(), pane.getDateOffset());
                            if (item != null && item.getStartDate() != null) {
                                pane.addMealLabel(calCache, item.getMealDesc(date), -1);
                            }
                        }
                        ++iIndex;
                    }
                    this.surveyPanePreferred((calCache.getLine(null) + 1) * this.getRowHeight() - 1);
                    this.checkForRelayout(dateSurveyStart, dateSurveyEnd);
lbl57:
                    // 3 sources

                    ++index;
                }
                break;
            }
            case -1: {
                if (iRowEnd >= this.getCacheCount(true)) {
                    iRowEnd = this.getCacheCount(true) - 1;
                }
                index = iRowEnd;
                while (index >= iRowStart) {
                    calCache = this.getCacheItem(index);
                    if (calCache != null) {
                        this.m_modelCache.remove(index);
                        calCache.removeComponents();
                    }
                    i = index;
                    while (i < this.m_modelCache.size()) {
                        calCache = this.getCacheItem(i);
                        if (calCache != null && calCache.getIndex() != -1) {
                            calCache.setIndex(i);
                        }
                        ++i;
                    }
                    --index;
                }
                break;
            }
        }
    }

    public int getCacheCount(boolean bCreateIfNew) {
        if (this.m_modelCache == null) {
            if (!bCreateIfNew) {
                return 0;
            }
            int iCount = this.m_model.getRowCount();
            this.m_modelCache = new Vector();
            this.m_model.removeTableModelListener(this);
            int i = 0;
            while (i < iCount) {
                CalendarCache cacheItem = this.getCacheItem(i);
                if (cacheItem == null) break;
                if (iCount + 1 == i) {
                    iCount = this.m_model.getRowCount();
                }
                ++i;
            }
            this.m_model.addTableModelListener(this);
        }
        return this.m_modelCache.size();
    }

    public CalendarCache getCacheItem(int iIndex) {
        if (this.m_modelCache == null) {
            this.m_modelCache = new Vector();
        }
        if (iIndex < this.m_modelCache.size()) {
            return this.m_modelCache.elementAt(iIndex);
        }
        if (iIndex == this.m_modelCache.size()) {
            CalendarItem item = this.m_model.getItem(iIndex);
            if (item == null) {
                return null;
            }
            CalendarCache calCache = new CalendarCache(this, this.m_model, iIndex);
            if (iIndex < this.m_modelCache.size()) {
                return this.getCacheItem(iIndex);
            }
            this.m_modelCache.addElement(calCache);
            return calCache;
        }
        int i = this.m_modelCache.size();
        while (i <= iIndex) {
            CalendarCache cacheItem = this.getCacheItem(i);
            if (cacheItem == null) break;
            if (iIndex + 1 == i) {
                iIndex = this.m_model.getRowCount();
            }
            if (i == iIndex) {
                return cacheItem;
            }
            ++i;
        }
        return null;
    }

    public int getItemIndex(CalendarCache calCache) {
        int iRowIndex = -1;
        int i = 0;
        while (i < this.getCacheCount(true)) {
            if (this.getCacheItem(i) == calCache) {
                iRowIndex = i;
            }
            ++i;
        }
        return iRowIndex;
    }

    public CalendarModel getModel() {
        return this.m_model;
    }

    public void resetAllLines() {
        if (this.m_model == null || this.m_modelCache == null) {
            return;
        }
        int i = 0;
        while (i < this.m_modelCache.size()) {
            CalendarCache calCache = this.getCacheItem(i);
            if (calCache == null) break;
            calCache.setLine(-1);
            ++i;
        }
    }

    public void checkPaneWidth(int iWidth) {
        if (this.m_iPaneWidth != iWidth) {
            this.resetAllLines();
            this.m_iPaneWidth = iWidth;
        }
    }

    public Date surveyModelDates(boolean bFirstDate) {
        Date date = null;
        Date dateCompare = null;
        if (this.m_model == null) {
            return date;
        }
        int i = 0;
        while (i < this.getCacheCount(true)) {
            CalendarCache calCache = this.getCacheItem(i);
            if (calCache == null) break;
            if (bFirstDate) {
                dateCompare = calCache.getItem().getStartDate();
                if (date == null || dateCompare.before(date)) {
                    date = dateCompare;
                }
            } else {
                dateCompare = calCache.getItem().getEndDate();
                if (dateCompare == null) {
                    dateCompare = calCache.getItem().getStartDate();
                }
                if (date == null || dateCompare.after(date)) {
                    date = dateCompare;
                }
            }
            ++i;
        }
        if (date == null) {
            date = this.m_dateDefault;
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    public FontMetrics getFontMetrics() {
        return this.m_fmLabel;
    }

    public void setFontMetrics(FontMetrics fm) {
        this.m_fmLabel = fm;
    }

    public int getRowHeight() {
        return this.m_iRowHeight;
    }

    public void surveyRowHeight(int iRowHeight) {
        this.m_iRowHeight = Math.max(this.m_iRowHeight, iRowHeight);
    }

    public void checkForRelayout(Date dateSurveyStart, Date dateSurveyEnd) {
        boolean bReLayout = false;
        if (this.m_iLastPanelHeight < this.m_dimPanePreferred.height) {
            bReLayout = true;
        }
        if (dateSurveyStart != null && dateSurveyEnd != null && this.getComponentCount() > 0) {
            Date dateLastBox = null;
            if (this.m_calendarLastBox != null) {
                dateLastBox = this.m_calendarLastBox.getTime();
            }
            if (this.m_dateFirstBox != null && dateSurveyStart.before(this.m_dateFirstBox) || dateLastBox != null && dateSurveyEnd.after(dateLastBox)) {
                this.m_bReSetupCalendar = true;
                bReLayout = true;
            }
        }
        if (bReLayout) {
            this.m_iLastPanelHeight = this.m_dimPanePreferred.height;
            this.setLayout(this.getLayout());
            this.invalidate();
            this.validate();
        }
    }

    public boolean surveyPanePreferred(int iMaxHeight) {
        if (iMaxHeight > this.m_dimPanePreferred.height) {
            this.m_dimPanePreferred.height = iMaxHeight + 5;
            return true;
        }
        return false;
    }

    public Dimension getPanePreferred() {
        return this.m_dimPanePreferred;
    }

    public Dimension getPaneMinimum() {
        return this.m_dimPaneMinimum;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String strCommand = e.getActionCommand();
        if (strCommand.equalsIgnoreCase("Delete")) {
            CalendarCache calCache = this.getSelectedItem();
            if (calCache != null) {
                int iIndex = this.getItemIndex(calCache);
                CalendarItem item = calCache.getItem();
                if (item != null) {
                    item.remove();
                }
                AbstractTableModel model = (AbstractTableModel)((Object)this.getModel());
                calCache.cacheItem(null, -1);
                model.fireTableRowsUpdated(iIndex, iIndex);
            }
        } else if (strCommand.equalsIgnoreCase("Select all")) {
            this.selectAll(true, true);
        } else {
            CalendarPane pane = this.getSelectedPane();
            Date dateTarget = null;
            if (pane != null) {
                dateTarget = pane.getThisDate();
            }
            if (dateTarget != null) {
                int iOffset = 0;
                if (strCommand.equalsIgnoreCase("Up")) {
                    iOffset = -7;
                } else if (strCommand.equalsIgnoreCase("Down")) {
                    iOffset = 7;
                } else if (strCommand.equalsIgnoreCase("Right")) {
                    iOffset = 1;
                } else if (strCommand.equalsIgnoreCase("Left")) {
                    iOffset = -1;
                }
                if (iOffset != 0) {
                    this.m_calendar.setTime(dateTarget);
                    this.m_calendar.add(5, iOffset);
                    dateTarget = this.m_calendar.getTime();
                    this.firePropertyChange(DATE, null, dateTarget);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (DATE.equalsIgnoreCase(evt.getPropertyName())) {
            Date dateTarget = (Date)evt.getNewValue();
            this.selectAll(false, true);
            if (dateTarget != null) {
                CalendarPane component = this.getComponentAtDate(dateTarget);
                if (component instanceof CalendarPane) {
                    CalendarPane pane = component;
                    pane.select(m_paneSelectedBorder);
                } else if (component == null) {
                    this.m_dateDefault = dateTarget;
                    this.checkForRelayout(dateTarget, dateTarget);
                }
            }
        }
    }

    public CalendarPane getComponentAtDate(Date dateTarget) {
        Date dateFirst = this.getFirstDate();
        int iOffset = (int)((dateTarget.getTime() - dateFirst.getTime()) / 86400000L);
        int iCount = 0;
        int iComp = 0;
        while (iComp < this.getComponentCount()) {
            Component component = this.getComponent(iComp);
            if (component instanceof CalendarPane) {
                if (iOffset == iCount) {
                    return (CalendarPane)component;
                }
                ++iCount;
            }
            ++iComp;
        }
        return null;
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setStatusText(String status) {
        if (this.statusListener != null) {
            this.statusListener.setStatusText(status);
        }
    }

    public void setStatusListener(StatusListener listener) {
        this.statusListener = listener;
    }

    class HideOnLoseFocus
    extends FocusAdapter {
        Popup m_popup = null;
        Component m_component = null;

        public HideOnLoseFocus(Popup popup, Component component) {
            this.m_popup = popup;
            this.m_component = component;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.m_component.removeFocusListener(this);
            Component comp = e.getOppositeComponent();
            while (comp != null) {
                if (comp == this.m_component) {
                    this.m_component = e.getOppositeComponent();
                    this.m_component.addFocusListener(this);
                    return;
                }
                comp = comp.getParent();
            }
            this.m_popup.hide();
        }
    }

    class SurveyWorker
    extends SwingWorker<String, Object> {
        Date dateFirst = null;
        Date dateLast = null;

        SurveyWorker() {
        }

        @Override
        public String doInBackground() {
            if (this.dateFirst == null) {
                this.dateFirst = CalendarPanel.this.surveyModelDates(true);
            }
            if (this.dateLast == null) {
                this.dateLast = CalendarPanel.this.surveyModelDates(false);
            }
            return null;
        }

        @Override
        public void done() {
            CalendarPanel.this.setupCalendar(this.dateFirst, this.dateLast, false);
            CalendarPanel.this.invalidate();
            CalendarPanel.this.validate();
            CalendarPanel.this.checkForRelayout(this.dateFirst, this.dateLast);
        }
    }
}

