/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel.dnd;

import java.util.Date;
import java.util.Map;
import org.jbundle.util.calendarpanel.CalendarPanel;
import org.jbundle.util.calendarpanel.dnd.CalendarItemProperties;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.CalendarModel;
import org.jbundle.util.calendarpanel.util.CalendarCache;

public class DetailItemProperties
extends CalendarItemProperties {
    private static final long serialVersionUID = 1L;
    public static final String SOURCE = "source";
    public static final String ACTION = "action";

    public DetailItemProperties() {
    }

    public DetailItemProperties(Map m) {
        this();
        this.init(m);
    }

    @Override
    public void init(Map<String, Object> m) {
        super.init(m);
    }

    @Override
    public boolean setTargetDate(Object source, Date dateTarget) {
        if (!(source instanceof CalendarPanel)) {
            return false;
        }
        CalendarPanel calendarPanel = (CalendarPanel)source;
        CalendarCache cacheItem = this.getSource(calendarPanel);
        if (cacheItem == null) {
            return false;
        }
        int iAction = this.getAction();
        CalendarItem item = cacheItem.getItem();
        long lTimeOld = 0L;
        Date timeOld = null;
        if (iAction == 1000) {
            timeOld = item.getStartDate();
            if (timeOld != null) {
                lTimeOld = timeOld.getTime();
            }
            dateTarget = item.setStartDate(dateTarget);
        } else if (iAction == 1011) {
            timeOld = item.getStartDate();
            if (timeOld != null) {
                lTimeOld = timeOld.getTime();
            }
            dateTarget = item.setStartDate(dateTarget);
        } else if (iAction == 1010) {
            timeOld = item.getEndDate();
            if (timeOld != null) {
                lTimeOld = timeOld.getTime();
            }
            dateTarget = item.setEndDate(dateTarget);
        }
        long lNewTime = 0L;
        if (dateTarget != null) {
            lNewTime = dateTarget.getTime();
        }
        if (lNewTime != lTimeOld) {
            CalendarModel model = cacheItem.getModel();
            int iIndex = cacheItem.getIndex();
            model.fireTableRowsUpdated(iIndex, iIndex);
            return true;
        }
        return false;
    }

    public CalendarCache getSource(CalendarPanel calendarPanel) {
        Object intSource = this.get(SOURCE);
        if (!(intSource instanceof Integer)) {
            return null;
        }
        int iSource = (Integer)intSource;
        return calendarPanel.getCacheItem(iSource);
    }

    public int getAction() {
        Object intAction = this.get(ACTION);
        if (!(intAction instanceof Integer)) {
            return -1;
        }
        int iAction = (Integer)intAction;
        return iAction;
    }

    public void setSource(CalendarCache calendarCache) {
        int iIndex = calendarCache.getIndex();
        this.put(SOURCE, new Integer(iIndex));
    }

    public void setAction(int iActionType) {
        this.put(ACTION, new Integer(iActionType));
    }
}

