/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel.model.swing;

import java.awt.Image;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import org.jbundle.util.calendarpanel.event.MyListSelectionEvent;
import org.jbundle.util.calendarpanel.event.MyListSelectionListener;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.CalendarModel;

public abstract class AbstractCalendarModel
extends AbstractTableModel
implements CalendarModel {
    private static final long serialVersionUID = 1L;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Start time";
            }
            case 2: {
                return "Description";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return true;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CalendarItem item = this.getItem(rowIndex);
        if (columnIndex == 0) {
            Object image = item.getIcon(1000);
            if (image instanceof Image) {
                return new ImageIcon((Image)image);
            }
            return image;
        }
        if (columnIndex == 1) {
            return item.getStartDate();
        }
        if (columnIndex == 2) {
            return item.getDescription();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void fireTableRowSelected(Object source, int iRowIndex, int iSelectionType) {
        this.fireMySelectionChanged(new MyListSelectionEvent(source, this, iRowIndex, iSelectionType));
    }

    @Override
    public void addMySelectionListener(EventListener l) {
        this.listenerList.add(MyListSelectionListener.class, (MyListSelectionListener)l);
    }

    @Override
    public void removeMySelectionListener(EventListener l) {
        this.listenerList.remove(MyListSelectionListener.class, (MyListSelectionListener)l);
    }

    protected void fireMySelectionChanged(MyListSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MyListSelectionListener.class && listeners[i] != event.getSource()) {
                ((MyListSelectionListener)listeners[i + 1]).selectionChanged(event);
            }
            i -= 2;
        }
    }
}

