/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel.sample.simple;

import java.util.Date;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.CalendarModel;
import org.jbundle.util.calendarpanel.sample.simple.CalendarVector;

public class CalendarProduct
implements CalendarItem {
    protected CalendarVector m_model = null;
    protected String m_description = null;
    protected Date m_startTime = null;
    protected Date m_endTime = null;
    protected Object m_iconStart = null;
    protected Object m_iconEnd = null;
    protected String m_strMeals = null;
    protected int m_colorHighlight = 0;
    protected int m_colorSelect = 0;
    protected int m_iStatus = 0;

    public CalendarProduct(CalendarModel model, Date startTime, Date endTime, String description, Object iconStart, Object iconEnd, String strMeals, int colorHighlight, int colorSelect, int iStatus) {
        this.init(model, startTime, endTime, description, iconStart, iconEnd, strMeals, colorHighlight, colorSelect, iStatus);
        this.m_strMeals = strMeals;
    }

    public void init(CalendarModel model, Date startTime, Date endTime, String description, Object iconStart, Object iconEnd, String strMeals, int colorHighlight, int colorSelect, int iStatus) {
        this.m_startTime = startTime;
        this.m_endTime = endTime;
        this.m_description = description;
        this.m_model = (CalendarVector)model;
        this.m_iconStart = iconStart;
        this.m_iconEnd = iconEnd;
        this.m_colorHighlight = colorHighlight;
        this.m_colorSelect = colorSelect;
        this.m_iStatus = iStatus;
    }

    public void free() {
        this.m_model.remove(this);
    }

    @Override
    public boolean remove() {
        boolean bSuccess = false;
        this.m_model.remove(this);
        return bSuccess;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public Date getStartDate() {
        return this.m_startTime;
    }

    @Override
    public Date getEndDate() {
        if (this.m_startTime != null && this.m_endTime != null && this.m_endTime.before(this.m_startTime)) {
            return this.m_startTime;
        }
        return this.m_endTime;
    }

    @Override
    public String getMealDesc(Date date) {
        if (!date.before(this.m_startTime) && !date.after(this.m_endTime)) {
            return this.m_strMeals;
        }
        return null;
    }

    @Override
    public Object getIcon(int iIconType) {
        if (iIconType == 1010) {
            return this.m_iconEnd;
        }
        if (iIconType == 1000) {
            return this.m_iconStart;
        }
        return null;
    }

    @Override
    public int getHighlightColor() {
        return this.m_colorHighlight;
    }

    @Override
    public int getSelectColor() {
        return this.m_colorSelect;
    }

    @Override
    public Date setStartDate(Date time) {
        if (this.m_startTime != null && this.m_endTime != null && time != null) {
            long lChange = time.getTime() - this.m_startTime.getTime();
            this.m_endTime = new Date(this.m_endTime.getTime() + lChange);
        }
        this.m_startTime = time;
        return this.m_startTime;
    }

    @Override
    public Date setEndDate(Date time) {
        this.m_endTime = time;
        return this.m_endTime;
    }

    @Override
    public void setIcon(Object icon, int iIconType) {
        if (iIconType == 1010) {
            this.m_iconEnd = icon;
        }
        if (iIconType == 1010) {
            this.m_iconStart = icon;
        }
    }

    @Override
    public Object getVisualJavaBean(int iPanelType) {
        return null;
    }

    @Override
    public int getStatus() {
        return this.m_iStatus;
    }

    @Override
    public int setStatus(int iStatus) {
        this.m_iStatus = iStatus;
        return this.m_iStatus;
    }
}

